/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.tus.utils;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class HttpChunkedEncodingInputStream
extends InputStream {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(HttpChunkedEncodingInputStream.class);
    private final InputStream in;
    private int chunkSize = 0;
    private int pos = 0;
    private boolean bof = true;
    private boolean eof = false;
    private boolean closed = false;
    private final Map<String, List<String>> trailerHeaders;

    public HttpChunkedEncodingInputStream(InputStream in, Map<String, List<String>> trailerHeaders) {
        if (in == null) {
            throw new IllegalArgumentException("InputStream parameter may not be null");
        }
        this.in = in;
        this.trailerHeaders = trailerHeaders;
    }

    public HttpChunkedEncodingInputStream(InputStream in) {
        this(in, null);
    }

    @Override
    public int read() throws IOException {
        if (this.closed) {
            throw new IOException("Attempted read from closed stream.");
        }
        if (this.eof) {
            return -1;
        }
        if (this.pos >= this.chunkSize) {
            this.nextChunk();
            if (this.eof) {
                return -1;
            }
        }
        ++this.pos;
        return this.in.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Attempted read from closed stream.");
        }
        if (this.eof) {
            return -1;
        }
        if (this.pos >= this.chunkSize) {
            this.nextChunk();
            if (this.eof) {
                return -1;
            }
        }
        int minLen = Math.min(len, this.chunkSize - this.pos);
        int count = this.in.read(b, off, minLen);
        this.pos += count;
        return count;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    private void readCRLF() throws IOException {
        int cr = this.in.read();
        int lf = this.in.read();
        if (cr != 13 || lf != 10) {
            throw new IOException("CRLF expected at end of chunk: " + cr + "/" + lf);
        }
    }

    private void nextChunk() throws IOException {
        if (!this.bof) {
            this.readCRLF();
        }
        this.chunkSize = this.getChunkSize();
        if (this.chunkSize < 0) {
            throw new IOException("Negative chunk size");
        }
        this.bof = false;
        this.pos = 0;
        if (this.chunkSize == 0) {
            this.eof = true;
            this.parseTrailerHeaders();
        }
    }

    private int getChunkSize() throws IOException {
        int result;
        String dataString = this.readChunkSizeInformation();
        int separator = dataString.indexOf(59);
        dataString = separator > 0 ? dataString.substring(0, separator).trim() : dataString.trim();
        try {
            result = Integer.parseInt(dataString.trim(), 16);
        }
        catch (NumberFormatException e) {
            throw new IOException("Bad chunk size: " + dataString);
        }
        return result;
    }

    private String readChunkSizeInformation() throws IOException {
        int b;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (ChunkSizeState state = ChunkSizeState.NORMAL; state != ChunkSizeState.END; state = state.process(this.in, baos, b)) {
            b = this.in.read();
            if (b != -1) continue;
            throw new IOException("Chunked stream ended unexpectedly");
        }
        return new String(baos.toByteArray(), StandardCharsets.US_ASCII);
    }

    private void parseTrailerHeaders() throws IOException {
        if (this.trailerHeaders != null) {
            List<Pair<String, String>> footers = this.parseHeaders(this.in);
            for (Pair<String, String> footer : footers) {
                List values = this.trailerHeaders.computeIfAbsent((String)footer.getKey(), k -> new LinkedList());
                values.add((String)footer.getValue());
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            try {
                if (!this.eof) {
                    this.exhaustInputStream();
                }
            }
            finally {
                this.eof = true;
                this.closed = true;
            }
        }
    }

    private void exhaustInputStream() throws IOException {
        byte[] buffer = new byte[1024];
        LOGGER.trace("Clearing underlying input stream, this is what was left:");
        while (this.in.read(buffer) >= 0) {
            if (!LOGGER.isTraceEnabled()) continue;
            LOGGER.trace(new String(buffer, StandardCharsets.UTF_8));
        }
    }

    private List<Pair<String, String>> parseHeaders(InputStream is) throws IOException {
        LinkedList<Pair<String, String>> headers = new LinkedList<Pair<String, String>>();
        String name = null;
        StringBuilder value = null;
        String line = this.readLine(is);
        while (StringUtils.isNotBlank((CharSequence)line)) {
            if (this.isLwsChar(line.charAt(0))) {
                if (value != null) {
                    value.append(' ');
                    value.append(line.trim());
                }
            } else {
                this.addHeaderValue(headers, name, value);
                int colon = line.indexOf(58);
                if (colon >= 0) {
                    name = line.substring(0, colon).trim();
                    value = new StringBuilder(line.substring(colon + 1).trim());
                }
            }
            line = this.readLine(is);
        }
        this.addHeaderValue(headers, name, value);
        return headers;
    }

    private void addHeaderValue(List<Pair<String, String>> headers, String name, StringBuilder value) {
        if (name != null) {
            headers.add((Pair<String, String>)Pair.of((Object)name, (Object)value.toString()));
        }
    }

    private boolean isLwsChar(char c) {
        return c == ' ' || c == '\t';
    }

    private String readLine(InputStream inputStream) throws IOException {
        byte[] rawdata = this.readRawLine(inputStream);
        if (rawdata.length == 0) {
            return null;
        }
        int len = rawdata.length;
        int offset = 0;
        if (rawdata[len - 1] == 10) {
            ++offset;
            if (len > 1 && rawdata[len - 2] == 13) {
                ++offset;
            }
        }
        return new String(rawdata, 0, len - offset, StandardCharsets.US_ASCII);
    }

    private byte[] readRawLine(InputStream inputStream) throws IOException {
        int ch;
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        while ((ch = inputStream.read()) >= 0) {
            buf.write(ch);
            if (ch != 10) continue;
            break;
        }
        return buf.toByteArray();
    }

    private static enum ChunkSizeState {
        NORMAL{

            @Override
            public ChunkSizeState process(InputStream in, ByteArrayOutputStream baos, int b) {
                ChunkSizeState newState;
                if (b == 13) {
                    newState = READ_CARRIAGE_RETURN;
                } else {
                    newState = b == 34 ? INSIDE_QUOTED_STRING : NORMAL;
                    baos.write(b);
                }
                return newState;
            }
        }
        ,
        READ_CARRIAGE_RETURN{

            @Override
            public ChunkSizeState process(InputStream in, ByteArrayOutputStream baos, int b) throws IOException {
                if (b != 10) {
                    throw new IOException("Protocol violation: Unexpected single newline character in chunk size");
                }
                return END;
            }
        }
        ,
        INSIDE_QUOTED_STRING{

            @Override
            public ChunkSizeState process(InputStream in, ByteArrayOutputStream baos, int b) throws IOException {
                ChunkSizeState newState;
                if (b == 92) {
                    int nextByte = in.read();
                    if (nextByte >= 0) {
                        baos.write(nextByte);
                    }
                    newState = INSIDE_QUOTED_STRING;
                } else {
                    newState = b == 34 ? NORMAL : INSIDE_QUOTED_STRING;
                    baos.write(b);
                }
                return newState;
            }
        }
        ,
        END{

            @Override
            public ChunkSizeState process(InputStream in, ByteArrayOutputStream baos, int b) {
                throw new UnsupportedOperationException("The END state cannot do any processing");
            }
        };


        public abstract ChunkSizeState process(InputStream var1, ByteArrayOutputStream var2, int var3) throws IOException;
    }
}

