/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.utils;

import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.securitypolicy.SymmetricKey;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class AesEncryptor {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(AesEncryptor.class);
    private static final String SALT1 = "0dfe99a2-7556-441c-9eb7-b1e8e7aa9c87";
    private static final String SALT2 = "6e9e780b-5c45-4aa9-8d07-0207334a0d88";
    private static final int PBKDF_ITERATIONS = 1000;
    SchedulerApplication schedulerApplication;

    public AesEncryptor(SchedulerApplication schedulerApplication) {
        this.schedulerApplication = schedulerApplication;
    }

    private byte[] generateSecret(int size) {
        try {
            KeyGenerator keyGen = KeyGenerator.getInstance("AES");
            keyGen.init(size);
            SecretKey secretKey = keyGen.generateKey();
            return secretKey.getEncoded();
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error("Cannot generate key", (Throwable)e);
            return null;
        }
    }

    public SymmetricKey generateNewKey() {
        return this.generateNewKey(256);
    }

    public SymmetricKey generateNewKey(int size) {
        byte[] secretBytes = this.generateSecret(size);
        String secret = Base64.getEncoder().encodeToString(secretBytes);
        SymmetricKey symmetricKey = this.computeKey(secret, size);
        return symmetricKey;
    }

    public SymmetricKey computeKey(String secret, int size) {
        try {
            SymmetricKey symmetricKey = new SymmetricKey();
            String encryptedKey = this.schedulerApplication.getEncryptor().encrypt(secret);
            symmetricKey.setId(encryptedKey);
            SecretKeyFactory skf = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA512");
            PBEKeySpec spec = new PBEKeySpec(secret.toCharArray(), SALT1.getBytes(StandardCharsets.UTF_8), 1000, size);
            SecretKey key = skf.generateSecret(spec);
            symmetricKey.setKey(Base64.getEncoder().encodeToString(key.getEncoded()));
            spec = new PBEKeySpec(secret.toCharArray(), SALT2.getBytes(StandardCharsets.UTF_8), 1000, size);
            key = skf.generateSecret(spec);
            byte[] ivBytes = new byte[16];
            System.arraycopy(key.getEncoded(), 0, ivBytes, 0, 16);
            symmetricKey.setIvSeed(Base64.getEncoder().encodeToString(ivBytes));
            return symmetricKey;
        }
        catch (IOException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            LOGGER.error("Cannot generate key", (Throwable)e);
            return null;
        }
    }

    public SymmetricKey decryptKey(String encryptedKey, int size) {
        try {
            SymmetricKey symmetricKey = new SymmetricKey();
            symmetricKey.setId(encryptedKey);
            String secret = this.schedulerApplication.getEncryptor().decrypt(encryptedKey);
            SecretKeyFactory skf = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA512");
            PBEKeySpec spec = new PBEKeySpec(secret.toCharArray(), SALT1.getBytes(StandardCharsets.UTF_8), 1000, size);
            SecretKey key = skf.generateSecret(spec);
            symmetricKey.setKey(Base64.getEncoder().encodeToString(key.getEncoded()));
            spec = new PBEKeySpec(secret.toCharArray(), SALT2.getBytes(StandardCharsets.UTF_8), 1000, size);
            key = skf.generateSecret(spec);
            byte[] ivBytes = new byte[16];
            System.arraycopy(key.getEncoded(), 0, ivBytes, 0, 16);
            symmetricKey.setIvSeed(Base64.getEncoder().encodeToString(ivBytes));
            return symmetricKey;
        }
        catch (IOException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            LOGGER.error("Cannot generate key", (Throwable)e);
            return null;
        }
    }

    public String decrypt(String ivPrefix, SymmetricKey symmetricKey, String ciphertext) {
        try {
            String unhashedIv = ivPrefix + symmetricKey.getIvSeed();
            byte[] ivHash = MessageDigest.getInstance("SHA-512").digest(unhashedIv.getBytes(StandardCharsets.UTF_8));
            byte[] iv = Arrays.copyOf(ivHash, 16);
            byte[] keyBytes = Base64.getDecoder().decode(symmetricKey.getKey());
            SecretKeySpec key = new SecretKeySpec(keyBytes, 0, keyBytes.length, "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(2, (Key)key, new IvParameterSpec(iv));
            byte[] plaintext = cipher.doFinal(Base64.getDecoder().decode(ciphertext));
            return new String(plaintext, StandardCharsets.UTF_8);
        }
        catch (IllegalArgumentException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Cannot decrypt ciphertext", (Throwable)e);
            }
            return null;
        }
    }
}

