/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.utils;

import com.azure.core.http.ProxyOptions;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.HttpClientOptions;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobContainerClientBuilder;
import com.azure.storage.blob.BlobServiceAsyncClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.common.StorageSharedKeyCredential;
import com.nuix.automate.utils.api.configuration.NetworkConfiguration;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.dataset.AzureStorageAccount;
import java.net.InetSocketAddress;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class AzureStorageAccountUtils {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(AzureStorageAccountUtils.class);
    private static AzureStorageAccountUtils instance;

    public static AzureStorageAccountUtils getInstance() {
        if (instance == null) {
            instance = new AzureStorageAccountUtils();
        }
        return instance;
    }

    private AzureStorageAccountUtils() {
    }

    public BlobServiceClient getBlobServiceClient(AzureStorageAccount azureStorageAccount) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Building blob service sync client for azure storage account: " + azureStorageAccount.getAccountUrl());
        }
        return this.prepareBlobServiceClientBuilder(azureStorageAccount).buildClient();
    }

    public BlobServiceAsyncClient getBlobServiceAsyncClient(AzureStorageAccount azureStorageAccount) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Building blob service async client for azure storage account: " + azureStorageAccount.getAccountUrl());
        }
        return this.prepareBlobServiceClientBuilder(azureStorageAccount).buildAsyncClient();
    }

    private BlobServiceClientBuilder prepareBlobServiceClientBuilder(AzureStorageAccount azureStorageAccount) {
        BlobServiceClientBuilder clientBuilder = new BlobServiceClientBuilder().endpoint(azureStorageAccount.getAccountUrl()).credential(this.getCredentials(azureStorageAccount));
        NetworkConfiguration networkConfiguration = NetworkConfiguration.fromSystemProperties();
        if (networkConfiguration.isProxyConfigured()) {
            InetSocketAddress proxyAddress = new InetSocketAddress(networkConfiguration.getProxyHost(), (int)networkConfiguration.getProxyPort());
            ProxyOptions proxyOptions = new ProxyOptions(ProxyOptions.Type.HTTP, proxyAddress);
            if (networkConfiguration.getNonProxyHosts() != null && !networkConfiguration.getNonProxyHosts().isEmpty()) {
                proxyOptions.setNonProxyHosts(networkConfiguration.getNonProxyHostsAsString());
            }
            HttpClientOptions httpClientOptions = new HttpClientOptions();
            httpClientOptions.setProxyOptions(proxyOptions);
            clientBuilder.clientOptions((ClientOptions)httpClientOptions);
        }
        return clientBuilder;
    }

    public BlobContainerClient getBlobContainerClient(AzureStorageAccount azureStorageAccount, String containerUrl) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Building blob container sync client for azure storage container URL: " + containerUrl);
        }
        return new BlobContainerClientBuilder().endpoint(containerUrl).credential(this.getCredentials(azureStorageAccount)).buildClient();
    }

    public StorageSharedKeyCredential getCredentials(AzureStorageAccount azureStorageAccount) {
        return new StorageSharedKeyCredential(azureStorageAccount.getAccountName(), azureStorageAccount.getAccountKey());
    }

    public String normalizeContainerName(String containerName) {
        String normalizedContainerName = containerName.replaceAll("[^a-zA-Z\\d-]", "").replaceAll("^-+|-$+", "").replaceAll("-+", "-");
        if (normalizedContainerName.isEmpty()) {
            normalizedContainerName = "a";
        }
        String suffix = "-" + FormattingUtils.dateTimeToInternationalDateTimeString((DateTime)DateTime.now((DateTimeZone)DateTimeZone.UTC));
        int maxContainerNameLength = 63 - suffix.length();
        if (normalizedContainerName.length() > maxContainerNameLength) {
            normalizedContainerName = normalizedContainerName.substring(0, maxContainerNameLength);
        }
        return (normalizedContainerName + suffix).toLowerCase();
    }
}

