/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.utils;

import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.security.bearer.SystemBearerUser;
import com.nuix.automate.utils.api.response.State;
import com.nuix.automate.utils.exceptions.AuthenticationException;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.nuixlicensesource.NuixLicenseSource;
import com.nuix.automate.utils.models.api.nuixlicensesource.SourceType;
import com.nuix.automate.utils.models.internal.event.EventType;
import com.nuix.automate.utils.models.internal.nuixlicensesource.NuixLicenseSourceModel;

public final class ClsUtils {
    private static InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ClsUtils.class);

    public static String testLicenceSource(NuixLicenseSourceModel nuixLicenseSource, boolean triggerEvents) throws Exception {
        String previousErrorMessage = "";
        if (nuixLicenseSource.getStatus() != null && nuixLicenseSource.getStatus().getCode() == State.ERROR) {
            previousErrorMessage = nuixLicenseSource.getStatus().getMessage();
        }
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Getting available licenses from " + String.valueOf(nuixLicenseSource));
            }
            if (nuixLicenseSource.getSourceType() != SourceType.CLS) {
                throw new IllegalArgumentException("Unexpected License Source type");
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Initializing client");
            }
            if (nuixLicenseSource.getPassword() == null || nuixLicenseSource.getPassword().length() == 0) {
                nuixLicenseSource.getStatus().setError(iu.getString("LicenseUtils.ReenterPassword"));
                throw new AuthenticationException(iu.getString("LicenseUtils.ReenterPassword"));
            }
            return iu.getString("LicenseUtils.Ok");
        }
        catch (Exception e) {
            String currentErrorMessage;
            if (!(e instanceof AuthenticationException)) {
                nuixLicenseSource.getStatus().setError(iu.getFormattedString("LicenseUtils.CannotConnectToCls", (Object)FormattingUtils.getExceptionPrintableMessage((Exception)e)));
            }
            if (triggerEvents && !(currentErrorMessage = nuixLicenseSource.getStatus().getMessage()).equals(previousErrorMessage)) {
                NuixLicenseSource eventResult = SchedulerApplication.getInstance().getSecurityPolicyUtil().setUserPermissions((BearerUser)new SystemBearerUser(), nuixLicenseSource);
                SchedulerApplication.getInstance().getWebhookWorker().triggerEvent(EventType.Type.NUIX_LICENSE_SOURCE_ERROR, eventResult);
            }
            if (e instanceof AuthenticationException) {
                throw e;
            }
            LOGGER.error("Cannot connect to CLS license", (Throwable)e);
            throw new AuthenticationException(iu.getFormattedString("LicenseUtils.CannotConnectToCls", (Object)FormattingUtils.getExceptionPrintableMessage((Exception)e)));
        }
    }
}

