/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.utils;

import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.tus.upload.UploadInfo;
import com.nuix.automate.scheduler.tus.upload.scheduler.SchedulerStorageService;
import com.nuix.automate.scheduler.utils.FileInfoCache;
import com.nuix.automate.utils.general.FilePathUtils;
import com.nuix.automate.utils.general.FileTraversalException;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.client.Client;
import com.nuix.automate.utils.models.api.client.ClientPool;
import com.nuix.automate.utils.models.api.client.Matter;
import com.nuix.automate.utils.models.api.dataset.DataRepository;
import com.nuix.automate.utils.models.api.dataset.Dataset;
import com.nuix.automate.utils.models.api.dataset.DatasetPathFormat;
import com.nuix.automate.utils.models.api.dataset.DatasetType;
import com.nuix.automate.utils.models.api.dataset.FileInfo;
import com.nuix.automate.utils.models.internal.dataset.BatchFileInfoModel;
import com.nuix.automate.utils.models.internal.dataset.UsableSpace;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileStore;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang3.NotImplementedException;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class DatasetUtils {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(DatasetUtils.class);
    private static DatasetUtils instance;
    private final SchedulerApplication schedulerApplication;

    private DatasetUtils(SchedulerApplication schedulerApplication) {
        this.schedulerApplication = schedulerApplication;
    }

    public static synchronized DatasetUtils getDatasetUtils(SchedulerApplication schedulerApplication) {
        if (instance == null) {
            instance = new DatasetUtils(schedulerApplication);
        }
        return instance;
    }

    public void createDataset(Dataset dataset) throws IOException {
        Path datasetDraftPath = this.getDatasetDraftPath(dataset);
        Files.createDirectories(datasetDraftPath, new FileAttribute[0]);
        this.verifyWritePermissions(datasetDraftPath);
    }

    public void batchInsertFileInfos(Collection<FileInfo> fileInfos) {
        ArrayList<BatchFileInfoModel> batchRootFileInfos = new ArrayList<BatchFileInfoModel>();
        this.schedulerApplication.getDatasetResource().addOrUpdateFileInfo(fileInfos);
        for (FileInfo fileInfo : fileInfos) {
            batchRootFileInfos.add(new BatchFileInfoModel(fileInfo));
            if (batchRootFileInfos.size() <= 256) continue;
            this.schedulerApplication.getClientMatterDao().insertBatchedFileInfo(batchRootFileInfos);
            batchRootFileInfos.clear();
        }
        if (batchRootFileInfos.size() > 0) {
            this.schedulerApplication.getClientMatterDao().insertBatchedFileInfo(batchRootFileInfos);
        }
    }

    public long getDatasetFilesCount(String datasetId) {
        return FileInfoCache.getInstance().getDatasetRootFileInfos(datasetId).stream().mapToLong(FileInfo::getFileCount).sum();
    }

    public long getDatasetSize(String datasetId) {
        long fileInfosSize = FileInfoCache.getInstance().getDatasetRootFileInfos(datasetId).stream().mapToLong(FileInfo::getSize).sum();
        long uploadInfosSize = 0L;
        for (UploadInfo uploadInfo : this.schedulerApplication.getDatasetResource().getStorageService().getDatasetUploadInfos(datasetId)) {
            uploadInfosSize += uploadInfo.getLength().longValue();
            Map<String, String> metadata = uploadInfo.getMetadata();
            boolean overwrite = Boolean.parseBoolean(metadata.get("overwrite"));
            if (!overwrite) continue;
            String locationIdentifier = uploadInfo.getLocationIdentifier();
            String relativePath = FileInfo.getNormalizedRelativePath((String)uploadInfo.getRelativePath(metadata));
            String fileInfoId = FileInfo.computeId((String)locationIdentifier, (String)relativePath);
            FileInfo fileInfo = FileInfoCache.getInstance().getFileInfo(fileInfoId);
            if (fileInfo == null) continue;
            fileInfosSize -= fileInfo.getSize();
        }
        return fileInfosSize + uploadInfosSize;
    }

    public synchronized void createOrUpdateRootFileInfo(FileInfo fileInfo) {
        FileInfo rootFileInfo = this.updateAndGetRootFileInfo(fileInfo);
        this.schedulerApplication.getDatasetResource().addOrUpdateFileInfo(rootFileInfo);
        if (this.schedulerApplication.getClientMatterDao().updateFileInfo(rootFileInfo) == 0) {
            this.schedulerApplication.getClientMatterDao().addFileInfo(rootFileInfo);
        }
    }

    public FileInfo updateAndGetRootFileInfo(FileInfo fileInfo) {
        String rootFileRelativePath = FilePathUtils.getRelativePathSplit((String)fileInfo.getRelativePath())[0];
        String rootFileId = FileInfo.computeId((String)fileInfo.getDatasetId(), (String)rootFileRelativePath);
        fileInfo.setRootFileId(rootFileId);
        FileInfo rootFileInfo = FileInfoCache.getInstance().getFileInfo(rootFileId);
        if (rootFileInfo == null) {
            rootFileInfo = new FileInfo(rootFileRelativePath);
            rootFileInfo.setRelativePath(rootFileRelativePath);
            rootFileInfo.setAddedBy(fileInfo.getAddedBy());
            rootFileInfo.setDatasetId(fileInfo.getDatasetId());
            rootFileInfo.setDirectory(Boolean.valueOf(true));
            rootFileInfo.setTotalSizeUploaded(Long.valueOf(0L));
            rootFileInfo.computeId();
        }
        rootFileInfo.setAddedDate(fileInfo.getAddedDate());
        rootFileInfo.setSize(rootFileInfo.getSize() + fileInfo.getSize());
        rootFileInfo.setTotalSizeUploaded(Long.valueOf(rootFileInfo.getTotalSizeUploaded() + fileInfo.getSize()));
        rootFileInfo.setInterruptedCount(rootFileInfo.getInterruptedCount() + fileInfo.getInterruptedCount());
        rootFileInfo.incrementFileCount();
        return rootFileInfo;
    }

    public long getRepositorySize(DataRepository dataRepository) {
        return this.schedulerApplication.getDatasetResource().getDatasets().stream().filter(dataset -> dataRepository.getId() != null && dataRepository.getId().equals(dataset.getDataRepositoryId())).mapToLong(dataset -> this.getDatasetSize(dataset.getId())).sum();
    }

    public Long getDatasetUsableSpace(Dataset dataset) {
        DataRepository dataRepository;
        if (dataset.getType() == DatasetType.MANAGED && (dataRepository = this.schedulerApplication.getDataRepositoryResource().getDataRepository(dataset.getDataRepositoryId())) != null && dataRepository.getDatasetMaxSizeEnabled() == Boolean.TRUE) {
            return Math.max(0L, dataRepository.getDatasetMaxSize() - this.getDatasetSize(dataset.getId()));
        }
        return null;
    }

    public UsableSpace getRepositoryUsableSpace(DataRepository dataRepository) throws IOException {
        if (dataRepository.getType() != DatasetType.MANAGED) {
            return new UsableSpace();
        }
        Long diskUsableSpace = null;
        if (dataRepository.getComputeFileSystemUsableSpace() == Boolean.TRUE) {
            Path repositoryPath = Paths.get(dataRepository.getPath(), new String[0]).toAbsolutePath();
            Path rootPath = repositoryPath.getRoot();
            long rootUploadsAllocatedSpace = 0L;
            for (UploadInfo uploadInfo : this.schedulerApplication.getDatasetResource().getStorageService().getUploadInfos()) {
                Path uploadLocation = SchedulerStorageService.getTempFileLocation(uploadInfo);
                if (!rootPath.equals(uploadLocation.getRoot())) continue;
                rootUploadsAllocatedSpace += uploadInfo.getRemainingLength();
            }
            FileStore fileStore = Files.getFileStore(rootPath);
            diskUsableSpace = Math.max(0L, fileStore.getUsableSpace() - rootUploadsAllocatedSpace);
        }
        Long repositoryQuota = dataRepository.getQuota();
        boolean quotaEnabled = dataRepository.getQuotaEnabled() == Boolean.TRUE && repositoryQuota != null;
        Long repositoryUsableSpace = quotaEnabled ? Long.valueOf(repositoryQuota - this.getRepositorySize(dataRepository)) : diskUsableSpace;
        return new UsableSpace(diskUsableSpace, repositoryUsableSpace);
    }

    public Path getDatasetInProgressPath(Dataset dataset) throws FileTraversalException {
        DataRepository dataRepository = this.schedulerApplication.getDataRepositoryResource().getDataRepository(dataset.getDataRepositoryId());
        if (dataRepository.getType() == DatasetType.MANAGED) {
            return FileUtils.safeResolve((Path)this.getDatasetPath(dataset), (String)"InProgress");
        }
        return null;
    }

    public Path getDatasetDraftPath(Dataset dataset) throws FileTraversalException {
        DataRepository dataRepository = this.schedulerApplication.getDataRepositoryResource().getDataRepository(dataset.getDataRepositoryId());
        if (dataRepository.getType() == DatasetType.MANAGED) {
            return FileUtils.safeResolve((Path)this.getDatasetPath(dataset), (String)"Draft");
        }
        return Paths.get(dataset.getPath(), new String[0]);
    }

    public Path getDatasetFinalPath(Dataset dataset) throws FileTraversalException {
        DataRepository dataRepository = this.schedulerApplication.getDataRepositoryResource().getDataRepository(dataset.getDataRepositoryId());
        if (dataRepository.getType() == DatasetType.MANAGED) {
            return FileUtils.safeResolve((Path)this.getDatasetPath(dataset), (String)"Final");
        }
        return Paths.get(dataset.getPath(), new String[0]);
    }

    public Path getClientPath(DataRepository dataRepository, Client client, DatasetPathFormat datasetPathFormat) {
        if (dataRepository.getType() == DatasetType.MANAGED) {
            if (datasetPathFormat == null || datasetPathFormat == DatasetPathFormat.IDS_FULL) {
                return Paths.get(dataRepository.getPath(), client.getId());
            }
            if (datasetPathFormat == DatasetPathFormat.IDS_8CHAR) {
                return Paths.get(dataRepository.getPath(), "Client-" + FormattingUtils.getShortId((String)client.getId(), (int)8));
            }
            throw new NotImplementedException("Dataset path format " + String.valueOf(datasetPathFormat) + " not supported");
        }
        return null;
    }

    public Path getMatterPath(DataRepository dataRepository, Matter matter, DatasetPathFormat datasetPathFormat) {
        if (dataRepository.getType() == DatasetType.MANAGED) {
            if (datasetPathFormat == null || datasetPathFormat == DatasetPathFormat.IDS_FULL) {
                return Paths.get(dataRepository.getPath(), matter.getClientId(), matter.getId());
            }
            if (datasetPathFormat == DatasetPathFormat.IDS_8CHAR) {
                return Paths.get(dataRepository.getPath(), "Client-" + FormattingUtils.getShortId((String)matter.getClientId(), (int)8), "Matter-" + FormattingUtils.getShortId((String)matter.getId()));
            }
            throw new NotImplementedException("Dataset path format " + String.valueOf(datasetPathFormat) + " not supported");
        }
        return null;
    }

    public Path getDatasetPath(Dataset dataset) {
        DataRepository dataRepository = this.schedulerApplication.getDataRepositoryResource().getDataRepository(dataset.getDataRepositoryId());
        if (dataRepository.getType() == DatasetType.MANAGED) {
            Matter matter = this.schedulerApplication.getClientResource().getMatter(dataset.getMatterId());
            if (dataset.getPathFormat() == null || dataset.getPathFormat() == DatasetPathFormat.IDS_FULL) {
                return Paths.get(dataRepository.getPath(), matter.getClientId(), matter.getId(), dataset.getId());
            }
            if (dataset.getPathFormat() == DatasetPathFormat.IDS_8CHAR) {
                return Paths.get(dataRepository.getPath(), "Client-" + matter.getClientId().substring(0, 8), "Matter-" + matter.getId().substring(0, 8), "Dataset-" + dataset.getId().substring(0, 8));
            }
            throw new NotImplementedException("Dataset path format " + String.valueOf(dataset.getPathFormat()) + " not supported");
        }
        return Paths.get(dataset.getPath(), new String[0]);
    }

    public Map<String, Set<String>> getRequiredMetadataHeaders(Dataset dataset) {
        HashMap<String, Set<String>> requiredMetadataHeaders = new HashMap<String, Set<String>>();
        Matter matter = this.schedulerApplication.getClientResource().getMatter(dataset.getMatterId());
        if (matter != null) {
            this.addRequiredMetadataHeaders(requiredMetadataHeaders, matter.getRequiredMetadataHeaders());
            Client client = this.schedulerApplication.getClientResource().getClient(matter.getClientId());
            if (client != null) {
                this.addRequiredMetadataHeaders(requiredMetadataHeaders, client.getRequiredMetadataHeaders());
                List<String> clientPoolIds = this.schedulerApplication.getClientPoolResource().getPoolsContainingClientId(client.getId());
                for (String clientPoolId : clientPoolIds) {
                    ClientPool clientPool = this.schedulerApplication.getClientPoolResource().getClientPool(clientPoolId);
                    if (clientPool == null) continue;
                    this.addRequiredMetadataHeaders(requiredMetadataHeaders, clientPool.getRequiredMetadataHeaders());
                }
            }
        }
        return requiredMetadataHeaders;
    }

    public Map<String, FileInfo> scanDatasetRootFiles(BearerUser user, Dataset dataset) throws IOException {
        Path datasetPath = this.getDatasetPath(dataset);
        return this.scanDatasetRootFiles(user, dataset, datasetPath);
    }

    public Map<String, FileInfo> scanDatasetRootFiles(final BearerUser user, final Dataset dataset, final Path datasetPath) throws IOException {
        final HashMap<String, FileInfo> rootFileInfos = new HashMap<String, FileInfo>();
        Files.walkFileTree(datasetPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                String rootFileRelativePath;
                if (dir.equals(datasetPath)) {
                    return FileVisitResult.CONTINUE;
                }
                String relativePath = datasetPath.relativize(dir).toString();
                if (relativePath.equals(rootFileRelativePath = FilePathUtils.getRelativePathSplit((String)relativePath)[0])) {
                    this.createRootFileInfo(rootFileRelativePath, true);
                }
                if (attrs.isSymbolicLink() || attrs.isOther()) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return super.preVisitDirectory(dir, attrs);
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                String rootFileRelativePath;
                String relativePath = datasetPath.relativize(file).toString();
                if (relativePath.equals(rootFileRelativePath = FilePathUtils.getRelativePathSplit((String)relativePath)[0])) {
                    this.createRootFileInfo(rootFileRelativePath, Files.isDirectory(file, new LinkOption[0]));
                }
                String rootFileId = FileInfo.computeId((String)dataset.getId(), (String)rootFileRelativePath);
                FileInfo rootFileInfo = (FileInfo)rootFileInfos.get(rootFileId);
                rootFileInfo.setSize(rootFileInfo.getSize() + attrs.size());
                rootFileInfo.incrementFileCount();
                return super.visitFile(file, attrs);
            }

            private void createRootFileInfo(String rootFileRelativePath, boolean dir) {
                LOGGER.info("Creating rootFileInfo: " + rootFileRelativePath);
                FileInfo rootFileInfo = new FileInfo(rootFileRelativePath);
                rootFileInfo.setDatasetId(dataset.getId());
                rootFileInfo.setRelativePath(rootFileRelativePath);
                rootFileInfo.setDirectory(Boolean.valueOf(dir));
                rootFileInfo.setAddedBy(user.getName());
                rootFileInfo.setAddedDate(Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()));
                rootFileInfo.computeId();
                rootFileInfos.put(rootFileInfo.getId(), rootFileInfo);
            }
        });
        return rootFileInfos;
    }

    public void verifyWritePermissions(Path path) throws IOException {
        Path testFile = FileUtils.safeResolve((Path)path, (String)"AutomateWriteTest");
        FileUtils.deleteRecursively((Path)testFile);
        Files.write(testFile, "test".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        if (!Files.exists(testFile, new LinkOption[0])) {
            throw new IOException("Cannot write to path " + String.valueOf(path));
        }
        Files.delete(testFile);
    }

    public void deleteDatasetDirectory(Dataset dataset) throws IOException {
        DataRepository dataRepository = this.schedulerApplication.getDataRepositoryResource().getDataRepository(dataset.getDataRepositoryId());
        if (dataset.getType() == DatasetType.IN_PLACE || dataRepository.getType() == DatasetType.IN_PLACE) {
            return;
        }
        Path datasetPath = this.getDatasetPath(dataset);
        try {
            Files.walkFileTree(datasetPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                    if (e == null) {
                        Files.delete(dir);
                        return FileVisitResult.CONTINUE;
                    }
                    throw e;
                }
            });
            Path matterPath = datasetPath.getParent();
            try (Stream<Path> matterDatasets = Files.list(matterPath);){
                long count = matterDatasets.count();
                if (count == 0L) {
                    Files.delete(matterPath);
                }
            }
            Path clientPath = matterPath.getParent();
            try (Stream<Path> clientMatters = Files.list(clientPath);){
                long count = clientMatters.count();
                if (count == 0L) {
                    Files.delete(clientPath);
                }
            }
        }
        catch (NoSuchFileException noSuchFileException) {
            // empty catch block
        }
    }

    private void addRequiredMetadataHeaders(Map<String, Set<String>> totalRequiredMetadataHeaders, Map<String, String> requiredMetadataHeaders) {
        if (requiredMetadataHeaders != null) {
            for (Map.Entry<String, String> entry : requiredMetadataHeaders.entrySet()) {
                String header = entry.getKey();
                String regex = entry.getValue();
                Set regexSet = totalRequiredMetadataHeaders.computeIfAbsent(header, k -> new HashSet());
                regexSet.add(regex);
            }
        }
    }
}

