/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.utils;

import java.util.HashMap;
import java.util.Map;

public class FileNameUtils {
    private static Map<String, Kind> extensionKind = new HashMap<String, Kind>();
    private static final String UNKNOWN = "Other";

    public static String getFilenameKnownExtension(String filename) {
        if (filename == null) {
            return null;
        }
        int lastIndexOfDot = filename.lastIndexOf(46);
        if (lastIndexOfDot >= 0 && filename.length() > lastIndexOfDot + 1) {
            String extension = filename.substring(lastIndexOfDot + 1);
            if (extensionKind.containsKey(extension = extension.toLowerCase())) {
                return extension;
            }
        }
        return UNKNOWN;
    }

    public static Kind getKnownExtensionKind(String knownExtension) {
        if (knownExtension == null) {
            return null;
        }
        Kind kind = extensionKind.get(knownExtension);
        if (kind != null) {
            return kind;
        }
        return Kind.UNRECOGNISED;
    }

    static {
        extensionKind.put("7z", Kind.CONTAINERS);
        extensionKind.put("ab", Kind.CONTAINERS);
        extensionKind.put("abt", Kind.CONTAINERS);
        extensionKind.put("accdb", Kind.DATABASES);
        extensionKind.put("ace", Kind.CONTAINERS);
        extensionKind.put("acm", Kind.MULTIMEDIA);
        extensionKind.put("ad1", Kind.CONTAINERS);
        extensionKind.put("aff4", Kind.CONTAINERS);
        extensionKind.put("ai", Kind.DRAWINGS);
        extensionKind.put("aiff", Kind.MULTIMEDIA);
        extensionKind.put("album", Kind.CONTAINERS);
        extensionKind.put("alz", Kind.CONTAINERS);
        extensionKind.put("amr", Kind.MULTIMEDIA);
        extensionKind.put("amv", Kind.MULTIMEDIA);
        extensionKind.put("ani", Kind.SYSTEM_FILES);
        extensionKind.put("apk", Kind.CONTAINERS);
        extensionKind.put("ar", Kind.CONTAINERS);
        extensionKind.put("art", Kind.IMAGES);
        extensionKind.put("arw", Kind.IMAGES);
        extensionKind.put("au", Kind.MULTIMEDIA);
        extensionKind.put("automaticdestinations-ms", Kind.SYSTEM_FILES);
        extensionKind.put("avi", Kind.MULTIMEDIA);
        extensionKind.put("axx", Kind.CONTAINERS);
        extensionKind.put("bc", Kind.SYSTEM_FILES);
        extensionKind.put("bcf", Kind.SYSTEM_FILES);
        extensionKind.put("bik", Kind.MULTIMEDIA);
        extensionKind.put("bin", Kind.SYSTEM_FILES);
        extensionKind.put("bkf", Kind.CONTAINERS);
        extensionKind.put("bks", Kind.CONTAINERS);
        extensionKind.put("blend", Kind.OTHER_DOCUMENTS);
        extensionKind.put("bmf", Kind.CONTAINERS);
        extensionKind.put("bmp", Kind.IMAGES);
        extensionKind.put("box", Kind.CONTAINERS);
        extensionKind.put("bsp", Kind.CONTAINERS);
        extensionKind.put("bz2", Kind.CONTAINERS);
        extensionKind.put("cab", Kind.CONTAINERS);
        extensionKind.put("cache", Kind.DATABASES);
        extensionKind.put("caf", Kind.MULTIMEDIA);
        extensionKind.put("cag", Kind.CONTAINERS);
        extensionKind.put("cat", Kind.SYSTEM_FILES);
        extensionKind.put("cdr", Kind.DRAWINGS);
        extensionKind.put("cdr6", Kind.DRAWINGS);
        extensionKind.put("cgm", Kind.DRAWINGS);
        extensionKind.put("chm", Kind.SYSTEM_FILES);
        extensionKind.put("civ5save", Kind.OTHER_DOCUMENTS);
        extensionKind.put("class", Kind.SYSTEM_FILES);
        extensionKind.put("com", Kind.SYSTEM_FILES);
        extensionKind.put("cpio", Kind.CONTAINERS);
        extensionKind.put("cpt", Kind.IMAGES);
        extensionKind.put("cr2", Kind.IMAGES);
        extensionKind.put("cso", Kind.CONTAINERS);
        extensionKind.put("csv", Kind.SPREADSHEETS);
        extensionKind.put("ctr", Kind.CONTAINERS);
        extensionKind.put("cur", Kind.IMAGES);
        extensionKind.put("customdestinations-ms", Kind.SYSTEM_FILES);
        extensionKind.put("dar", Kind.CONTAINERS);
        extensionKind.put("dat", Kind.SYSTEM_FILES);
        extensionKind.put("db", Kind.CONTAINERS);
        extensionKind.put("dbb", Kind.CHAT_CONVERSATIONS);
        extensionKind.put("dbf", Kind.DATABASES);
        extensionKind.put("dbk", Kind.DOCUMENTS);
        extensionKind.put("dbx", Kind.CONTAINERS);
        extensionKind.put("dcm", Kind.IMAGES);
        extensionKind.put("dds", Kind.IMAGES);
        extensionKind.put("deb", Kind.CONTAINERS);
        extensionKind.put("dex", Kind.SYSTEM_FILES);
        extensionKind.put("dgn", Kind.DRAWINGS);
        extensionKind.put("dib", Kind.IMAGES);
        extensionKind.put("djvu", Kind.IMAGES);
        extensionKind.put("dll", Kind.SYSTEM_FILES);
        extensionKind.put("dmg", Kind.CONTAINERS);
        extensionKind.put("dmp", Kind.SYSTEM_FILES);
        extensionKind.put("doc", Kind.DOCUMENTS);
        extensionKind.put("docx", Kind.DOCUMENTS);
        extensionKind.put("drw", Kind.DRAWINGS);
        extensionKind.put("dvs", Kind.CONTAINERS);
        extensionKind.put("dvssp", Kind.CONTAINERS);
        extensionKind.put("dwf", Kind.DRAWINGS);
        extensionKind.put("dwfx", Kind.DRAWINGS);
        extensionKind.put("dwg", Kind.DRAWINGS);
        extensionKind.put("dxf", Kind.DRAWINGS);
        extensionKind.put("dxl", Kind.EMAIL);
        extensionKind.put("e01", Kind.CONTAINERS);
        extensionKind.put("eas", Kind.CONTAINERS);
        extensionKind.put("edb", Kind.CONTAINERS);
        extensionKind.put("efx", Kind.IMAGES);
        extensionKind.put("egg", Kind.CONTAINERS);
        extensionKind.put("emf", Kind.DRAWINGS);
        extensionKind.put("eml", Kind.EMAIL);
        extensionKind.put("emlx", Kind.CONTAINERS);
        extensionKind.put("emx", Kind.CONTAINERS);
        extensionKind.put("epub", Kind.DOCUMENTS);
        extensionKind.put("evt", Kind.LOGS);
        extensionKind.put("evtx", Kind.LOGS);
        extensionKind.put("ex01", Kind.CONTAINERS);
        extensionKind.put("exb", Kind.DRAWINGS);
        extensionKind.put("exe", Kind.SYSTEM_FILES);
        extensionKind.put("fb2", Kind.OTHER_DOCUMENTS);
        extensionKind.put("fdf", Kind.OTHER_DOCUMENTS);
        extensionKind.put("fit", Kind.OTHER_DOCUMENTS);
        extensionKind.put("flac", Kind.MULTIMEDIA);
        extensionKind.put("fli", Kind.MULTIMEDIA);
        extensionKind.put("flv", Kind.MULTIMEDIA);
        extensionKind.put("fo", Kind.OTHER_DOCUMENTS);
        extensionKind.put("fon", Kind.SYSTEM_FILES);
        extensionKind.put("fpt", Kind.CONTAINERS);
        extensionKind.put("fsb", Kind.MULTIMEDIA);
        extensionKind.put("gcf", Kind.CONTAINERS);
        extensionKind.put("gdsii", Kind.DRAWINGS);
        extensionKind.put("gem", Kind.DRAWINGS);
        extensionKind.put("geojson", Kind.OTHER_DOCUMENTS);
        extensionKind.put("gho", Kind.CONTAINERS);
        extensionKind.put("gi", Kind.CONTAINERS);
        extensionKind.put("gif", Kind.IMAGES);
        extensionKind.put("gra", Kind.DRAWINGS);
        extensionKind.put("gul", Kind.DOCUMENTS);
        extensionKind.put("gz", Kind.CONTAINERS);
        extensionKind.put("hdd", Kind.CONTAINERS);
        extensionKind.put("heic", Kind.IMAGES);
        extensionKind.put("hlp", Kind.SYSTEM_FILES);
        extensionKind.put("hpt", Kind.PRESENTATIONS);
        extensionKind.put("html", Kind.DOCUMENTS);
        extensionKind.put("hwp", Kind.DOCUMENTS);
        extensionKind.put("icns", Kind.IMAGES);
        extensionKind.put("ico", Kind.SYSTEM_FILES);
        extensionKind.put("ics", Kind.CALENDAR);
        extensionKind.put("idml", Kind.DOCUMENTS);
        extensionKind.put("idx", Kind.SYSTEM_FILES);
        extensionKind.put("ifm", Kind.OTHER_DOCUMENTS);
        extensionKind.put("indd", Kind.DOCUMENTS);
        extensionKind.put("inf", Kind.SYSTEM_FILES);
        extensionKind.put("ini", Kind.OTHER_DOCUMENTS);
        extensionKind.put("ipa", Kind.CONTAINERS);
        extensionKind.put("ipd", Kind.CONTAINERS);
        extensionKind.put("iso", Kind.CONTAINERS);
        extensionKind.put("itp", Kind.OTHER_DOCUMENTS);
        extensionKind.put("iwa", Kind.OTHER_DOCUMENTS);
        extensionKind.put("jar", Kind.CONTAINERS);
        extensionKind.put("jks", Kind.OTHER_DOCUMENTS);
        extensionKind.put("jnt", Kind.OTHER_DOCUMENTS);
        extensionKind.put("jp2", Kind.IMAGES);
        extensionKind.put("jpeg", Kind.IMAGES);
        extensionKind.put("jpg", Kind.CONTAINERS);
        extensionKind.put("js", Kind.DOCUMENTS);
        extensionKind.put("jsd", Kind.DOCUMENTS);
        extensionKind.put("json", Kind.OTHER_DOCUMENTS);
        extensionKind.put("jsonlz4", Kind.CONTAINERS);
        extensionKind.put("jtd", Kind.DOCUMENTS);
        extensionKind.put("key", Kind.PRESENTATIONS);
        extensionKind.put("l01", Kind.CONTAINERS);
        extensionKind.put("lit", Kind.OTHER_DOCUMENTS);
        extensionKind.put("lnk", Kind.SYSTEM_FILES);
        extensionKind.put("log", Kind.LOGS);
        extensionKind.put("lrf", Kind.OTHER_DOCUMENTS);
        extensionKind.put("lrprev", Kind.CONTAINERS);
        extensionKind.put("luc", Kind.SYSTEM_FILES);
        extensionKind.put("lwp", Kind.DOCUMENTS);
        extensionKind.put("lx01", Kind.CONTAINERS);
        extensionKind.put("lz4", Kind.CONTAINERS);
        extensionKind.put("lzh", Kind.CONTAINERS);
        extensionKind.put("lzma", Kind.CONTAINERS);
        extensionKind.put("lzo", Kind.CONTAINERS);
        extensionKind.put("lzx", Kind.CONTAINERS);
        extensionKind.put("mab", Kind.DATABASES);
        extensionKind.put("macbin", Kind.CONTAINERS);
        extensionKind.put("max", Kind.DRAWINGS);
        extensionKind.put("mbox", Kind.CONTAINERS);
        extensionKind.put("mbx", Kind.CONTAINERS);
        extensionKind.put("mdb", Kind.DATABASES);
        extensionKind.put("mdex", Kind.CONTAINERS);
        extensionKind.put("mdi", Kind.IMAGES);
        extensionKind.put("mdmp", Kind.SYSTEM_FILES);
        extensionKind.put("mfs01", Kind.CONTAINERS);
        extensionKind.put("mht", Kind.DOCUMENTS);
        extensionKind.put("mid", Kind.MULTIMEDIA);
        extensionKind.put("mka", Kind.MULTIMEDIA);
        extensionKind.put("mkv", Kind.MULTIMEDIA);
        extensionKind.put("mny", Kind.DATABASES);
        extensionKind.put("mobi", Kind.OTHER_DOCUMENTS);
        extensionKind.put("mov", Kind.MULTIMEDIA);
        extensionKind.put("mp3", Kind.MULTIMEDIA);
        extensionKind.put("mp4", Kind.MULTIMEDIA);
        extensionKind.put("mpg", Kind.MULTIMEDIA);
        extensionKind.put("mpp", Kind.OTHER_DOCUMENTS);
        extensionKind.put("mrw", Kind.IMAGES);
        extensionKind.put("msg", Kind.EMAIL);
        extensionKind.put("msi", Kind.CONTAINERS);
        extensionKind.put("msp", Kind.CONTAINERS);
        extensionKind.put("mst", Kind.CONTAINERS);
        extensionKind.put("mts", Kind.MULTIMEDIA);
        extensionKind.put("myo", Kind.DATABASES);
        extensionKind.put("nexusqlite", Kind.DATABASES);
        extensionKind.put("nib", Kind.SYSTEM_FILES);
        extensionKind.put("nli", Kind.CONTAINERS);
        extensionKind.put("nls", Kind.SYSTEM_FILES);
        extensionKind.put("nsf", Kind.CONTAINERS);
        extensionKind.put("nsv", Kind.MULTIMEDIA);
        extensionKind.put("numbers", Kind.SPREADSHEETS);
        extensionKind.put("nut", Kind.MULTIMEDIA);
        extensionKind.put("obj", Kind.SYSTEM_FILES);
        extensionKind.put("obv", Kind.CONTAINERS);
        extensionKind.put("odb", Kind.DRAWINGS);
        extensionKind.put("odc", Kind.DRAWINGS);
        extensionKind.put("odf", Kind.OTHER_DOCUMENTS);
        extensionKind.put("odg", Kind.DRAWINGS);
        extensionKind.put("odi", Kind.IMAGES);
        extensionKind.put("odp", Kind.PRESENTATIONS);
        extensionKind.put("ods", Kind.SPREADSHEETS);
        extensionKind.put("odt", Kind.DOCUMENTS);
        extensionKind.put("ofx", Kind.DATABASES);
        extensionKind.put("ogg", Kind.MULTIMEDIA);
        extensionKind.put("olk14contact", Kind.CONTACTS);
        extensionKind.put("olk14event", Kind.CALENDAR);
        extensionKind.put("olk14folder", Kind.CONTAINERS);
        extensionKind.put("olk14message", Kind.EMAIL);
        extensionKind.put("olk14note", Kind.OTHER_DOCUMENTS);
        extensionKind.put("olk14task", Kind.OTHER_DOCUMENTS);
        extensionKind.put("olk15category", Kind.OTHER_DOCUMENTS);
        extensionKind.put("olk15main", Kind.OTHER_DOCUMENTS);
        extensionKind.put("olk15msgattachment", Kind.CONTAINERS);
        extensionKind.put("olk15msgsource", Kind.EMAIL);
        extensionKind.put("olk15search", Kind.OTHER_DOCUMENTS);
        extensionKind.put("olk15signature", Kind.OTHER_DOCUMENTS);
        extensionKind.put("olm", Kind.CONTAINERS);
        extensionKind.put("one", Kind.DOCUMENTS);
        extensionKind.put("onepkg", Kind.CONTAINERS);
        extensionKind.put("onetoc2", Kind.CONTAINERS);
        extensionKind.put("onm", Kind.CONTAINERS);
        extensionKind.put("opt", Kind.CONTAINERS);
        extensionKind.put("opx", Kind.DRAWINGS);
        extensionKind.put("orf", Kind.IMAGES);
        extensionKind.put("otf", Kind.SYSTEM_FILES);
        extensionKind.put("oxps", Kind.DOCUMENTS);
        extensionKind.put("p12", Kind.OTHER_DOCUMENTS);
        extensionKind.put("p7b", Kind.OTHER_DOCUMENTS);
        extensionKind.put("p7s", Kind.OTHER_DOCUMENTS);
        extensionKind.put("pages", Kind.DOCUMENTS);
        extensionKind.put("par", Kind.CONTAINERS);
        extensionKind.put("pbm", Kind.IMAGES);
        extensionKind.put("pc3", Kind.OTHER_DOCUMENTS);
        extensionKind.put("pcap", Kind.LOGS);
        extensionKind.put("pcapng", Kind.LOGS);
        extensionKind.put("pcm", Kind.EMAIL);
        extensionKind.put("pcx", Kind.IMAGES);
        extensionKind.put("pdb", Kind.OTHER_DOCUMENTS);
        extensionKind.put("pdf", Kind.DOCUMENTS);
        extensionKind.put("pf", Kind.SYSTEM_FILES);
        extensionKind.put("pfc", Kind.CONTAINERS);
        extensionKind.put("pfm", Kind.SYSTEM_FILES);
        extensionKind.put("pgi", Kind.CONTAINERS);
        extensionKind.put("pgm", Kind.IMAGES);
        extensionKind.put("pgp", Kind.OTHER_DOCUMENTS);
        extensionKind.put("pict", Kind.IMAGES);
        extensionKind.put("pio", Kind.IMAGES);
        extensionKind.put("pkpass", Kind.DATABASES);
        extensionKind.put("plist", Kind.OTHER_DOCUMENTS);
        extensionKind.put("pmdx", Kind.SPREADSHEETS);
        extensionKind.put("pmf", Kind.SYSTEM_FILES);
        extensionKind.put("pmml", Kind.DOCUMENTS);
        extensionKind.put("pnf", Kind.SYSTEM_FILES);
        extensionKind.put("png", Kind.IMAGES);
        extensionKind.put("ppm", Kind.IMAGES);
        extensionKind.put("ppt", Kind.PRESENTATIONS);
        extensionKind.put("pptx", Kind.PRESENTATIONS);
        extensionKind.put("prdx", Kind.PRESENTATIONS);
        extensionKind.put("prz", Kind.PRESENTATIONS);
        extensionKind.put("ps", Kind.DOCUMENTS);
        extensionKind.put("psd", Kind.IMAGES);
        extensionKind.put("pst", Kind.CONTAINERS);
        extensionKind.put("pub", Kind.DOCUMENTS);
        extensionKind.put("pvr", Kind.IMAGES);
        extensionKind.put("pyc", Kind.SYSTEM_FILES);
        extensionKind.put("qbb", Kind.DATABASES);
        extensionKind.put("qbw", Kind.DATABASES);
        extensionKind.put("qcp", Kind.MULTIMEDIA);
        extensionKind.put("qdf", Kind.DATABASES);
        extensionKind.put("qif", Kind.DOCUMENTS);
        extensionKind.put("qpw", Kind.SPREADSHEETS);
        extensionKind.put("ra", Kind.MULTIMEDIA);
        extensionKind.put("raf", Kind.IMAGES);
        extensionKind.put("rar", Kind.CONTAINERS);
        extensionKind.put("rdf", Kind.OTHER_DOCUMENTS);
        extensionKind.put("reg", Kind.OTHER_DOCUMENTS);
        extensionKind.put("resource", Kind.SYSTEM_FILES);
        extensionKind.put("ri", Kind.SYSTEM_FILES);
        extensionKind.put("rpm", Kind.CONTAINERS);
        extensionKind.put("rpmsg", Kind.EMAIL);
        extensionKind.put("rtf", Kind.DOCUMENTS);
        extensionKind.put("scrivx", Kind.OTHER_DOCUMENTS);
        extensionKind.put("scs", Kind.OTHER_DOCUMENTS);
        extensionKind.put("sda", Kind.DRAWINGS);
        extensionKind.put("sdc", Kind.SPREADSHEETS);
        extensionKind.put("sdd", Kind.PRESENTATIONS);
        extensionKind.put("sdw", Kind.DOCUMENTS);
        extensionKind.put("shs", Kind.CONTAINERS);
        extensionKind.put("shw", Kind.PRESENTATIONS);
        extensionKind.put("shx", Kind.DRAWINGS);
        extensionKind.put("sit", Kind.CONTAINERS);
        extensionKind.put("slb", Kind.DATABASES);
        extensionKind.put("sld", Kind.DRAWINGS);
        extensionKind.put("smf", Kind.OTHER_DOCUMENTS);
        extensionKind.put("sml", Kind.CONTAINERS);
        extensionKind.put("snp", Kind.OTHER_DOCUMENTS);
        extensionKind.put("snt", Kind.CONTAINERS);
        extensionKind.put("sparsebundle", Kind.CONTAINERS);
        extensionKind.put("sparseimage", Kind.CONTAINERS);
        extensionKind.put("sqlite", Kind.DATABASES);
        extensionKind.put("stm", Kind.CONTAINERS);
        extensionKind.put("svg", Kind.DRAWINGS);
        extensionKind.put("swf", Kind.MULTIMEDIA);
        extensionKind.put("sxc", Kind.SPREADSHEETS);
        extensionKind.put("sxd", Kind.DRAWINGS);
        extensionKind.put("sxi", Kind.PRESENTATIONS);
        extensionKind.put("sxm", Kind.OTHER_DOCUMENTS);
        extensionKind.put("sxw", Kind.DOCUMENTS);
        extensionKind.put("tar", Kind.CONTAINERS);
        extensionKind.put("tga", Kind.IMAGES);
        extensionKind.put("thumbnail", Kind.CONTAINERS);
        extensionKind.put("tiff", Kind.IMAGES);
        extensionKind.put("tmdx", Kind.DOCUMENTS);
        extensionKind.put("torrent", Kind.SYSTEM_FILES);
        extensionKind.put("tsv", Kind.SPREADSHEETS);
        extensionKind.put("ttbin", Kind.OTHER_DOCUMENTS);
        extensionKind.put("ttc", Kind.SYSTEM_FILES);
        extensionKind.put("ttf", Kind.SYSTEM_FILES);
        extensionKind.put("txt", Kind.OTHER_DOCUMENTS);
        extensionKind.put("ufdr", Kind.CONTAINERS);
        extensionKind.put("uop", Kind.PRESENTATIONS);
        extensionKind.put("uos", Kind.SPREADSHEETS);
        extensionKind.put("uot", Kind.DOCUMENTS);
        extensionKind.put("usm", Kind.MULTIMEDIA);
        extensionKind.put("uue", Kind.CONTAINERS);
        extensionKind.put("vcf", Kind.CONTACTS);
        extensionKind.put("vcs", Kind.CONTAINERS);
        extensionKind.put("vdi", Kind.CONTAINERS);
        extensionKind.put("vdx", Kind.DRAWINGS);
        extensionKind.put("vgm", Kind.MULTIMEDIA);
        extensionKind.put("vhd", Kind.CONTAINERS);
        extensionKind.put("vhdx", Kind.CONTAINERS);
        extensionKind.put("viv", Kind.MULTIMEDIA);
        extensionKind.put("vmbx", Kind.EMAIL);
        extensionKind.put("vmdk", Kind.CONTAINERS);
        extensionKind.put("vml", Kind.DRAWINGS);
        extensionKind.put("vol", Kind.DATABASES);
        extensionKind.put("vpk", Kind.CONTAINERS);
        extensionKind.put("vqf", Kind.MULTIMEDIA);
        extensionKind.put("vsd", Kind.DRAWINGS);
        extensionKind.put("vsdx", Kind.DRAWINGS);
        extensionKind.put("wallet", Kind.OTHER_DOCUMENTS);
        extensionKind.put("warc", Kind.CONTAINERS);
        extensionKind.put("wav", Kind.MULTIMEDIA);
        extensionKind.put("wbmp", Kind.IMAGES);
        extensionKind.put("wdp", Kind.IMAGES);
        extensionKind.put("webm", Kind.MULTIMEDIA);
        extensionKind.put("webp", Kind.IMAGES);
        extensionKind.put("wim", Kind.CONTAINERS);
        extensionKind.put("wk1", Kind.SPREADSHEETS);
        extensionKind.put("wks", Kind.SPREADSHEETS);
        extensionKind.put("wmf", Kind.DRAWINGS);
        extensionKind.put("wmv", Kind.MULTIMEDIA);
        extensionKind.put("woff", Kind.SYSTEM_FILES);
        extensionKind.put("wpd", Kind.DOCUMENTS);
        extensionKind.put("wpg", Kind.IMAGES);
        extensionKind.put("wps", Kind.DOCUMENTS);
        extensionKind.put("wv", Kind.MULTIMEDIA);
        extensionKind.put("xcf", Kind.IMAGES);
        extensionKind.put("xdw", Kind.OTHER_DOCUMENTS);
        extensionKind.put("xlc", Kind.DRAWINGS);
        extensionKind.put("xls", Kind.SPREADSHEETS);
        extensionKind.put("xlsb", Kind.SPREADSHEETS);
        extensionKind.put("xlsx", Kind.SPREADSHEETS);
        extensionKind.put("xmf", Kind.MULTIMEDIA);
        extensionKind.put("xml", Kind.SYSTEM_FILES);
        extensionKind.put("xnb", Kind.OTHER_DOCUMENTS);
        extensionKind.put("xps", Kind.DOCUMENTS);
        extensionKind.put("xry", Kind.CONTAINERS);
        extensionKind.put("xsl", Kind.SYSTEM_FILES);
        extensionKind.put("xwma", Kind.MULTIMEDIA);
        extensionKind.put("xxe", Kind.CONTAINERS);
        extensionKind.put("xz", Kind.CONTAINERS);
        extensionKind.put("z", Kind.CONTAINERS);
        extensionKind.put("zip", Kind.CONTAINERS);
        extensionKind.put("zoo", Kind.CONTAINERS);
    }

    public static enum Kind {
        CALENDAR,
        CHAT_CONVERSATIONS,
        CHAT_MESSAGES,
        CONTACTS,
        CONTAINERS,
        DATABASES,
        DOCUMENTS,
        DRAWINGS,
        EMAIL,
        IMAGES,
        LOGS,
        MULTIMEDIA,
        OTHER_DOCUMENTS,
        PRESENTATIONS,
        SPREADSHEETS,
        SYSTEM_FILES,
        UNRECOGNISED;

    }
}

