/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.utils;

import com.nuix.automate.scheduler.persistance.logging.LoggingDao;
import com.nuix.automate.scheduler.resources.LogsResource;
import com.nuix.automate.utils.general.SchedulerComponent;
import com.nuix.automate.utils.logging.ApiClientsLogChannels;
import com.nuix.automate.utils.logging.LogChannel;
import com.nuix.automate.utils.logging.LogHandler;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.internal.logging.LogEventModel;
import java.util.List;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;

public class LogWriter {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(LogWriter.class);
    private BlockingDeque<List<LogEventModel>> logsQueue;
    private Thread producerThread;
    private Thread consumerThread;
    private LogsResource resource;
    private final LogHandler logHandler;
    private boolean applicationClosing;
    private int maxNumberLogsPending;

    public LogWriter(LogsResource resource, int maxNumberLogsPending) {
        this.resource = resource;
        this.maxNumberLogsPending = maxNumberLogsPending;
        this.logHandler = LogHandler.getInstance();
    }

    public void start() {
        this.logsQueue = new LinkedBlockingDeque<List<LogEventModel>>();
        this.producerThread = new Thread(this::read);
        this.producerThread.setName("Automate - Centralized logging producer");
        this.producerThread.start();
        this.consumerThread = new Thread(this::write);
        this.consumerThread.setName("Automate - Centralized logging consumer");
        this.consumerThread.start();
    }

    public void stop() {
        this.applicationClosing = true;
    }

    public boolean isRunning() {
        return !this.applicationClosing;
    }

    private void read() {
        LOGGER.info("Starting log producer");
        try {
            List logs;
            while (!this.applicationClosing) {
                while (this.logsQueue.size() > this.maxNumberLogsPending) {
                    if (this.applicationClosing) {
                        return;
                    }
                    Thread.sleep(100L);
                }
                logs = this.logHandler.removeComponentLogs();
                if (logs.size() > 0) {
                    this.logsQueue.add(logs);
                }
                Thread.sleep(100L);
            }
            logs = this.logHandler.removeComponentLogs();
            if (logs.size() > 0) {
                this.logsQueue.add(logs);
            }
        }
        catch (InterruptedException e) {
            LOGGER.error("Failed to produce logs", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void write() {
        LOGGER.info("Starting consumer");
        try {
            while (!this.applicationClosing) {
                int updateCount;
                List<LogEventModel> logList = this.logsQueue.poll(1L, TimeUnit.SECONDS);
                if (logList == null || logList.size() <= 0) continue;
                int[] updates = new int[]{};
                try {
                    LoggingDao loggingDao = this.resource.getActiveLoggingDao();
                    synchronized (loggingDao) {
                        updates = this.resource.getActiveLoggingDao().insertLogEvents(logList);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Cannot write logs", (Throwable)e);
                    int logline = 0;
                    for (LogEventModel logEventModel : logList) {
                        LOGGER.warn("Could not write log: " + String.valueOf(logEventModel));
                        if (++logline <= 20) continue;
                        LOGGER.warn("Could not write log: ...");
                        break;
                    }
                }
                if ((updateCount = IntStream.of(updates).sum()) == logList.size()) continue;
                LOGGER.error("Could not write " + (logList.size() - updateCount) + " log records.");
            }
            List<LogEventModel> logs = this.logsQueue.poll(100L, TimeUnit.MILLISECONDS);
            if (logs != null) {
                LoggingDao loggingDao = this.resource.getActiveLoggingDao();
                synchronized (loggingDao) {
                    this.resource.getActiveLoggingDao().insertLogEvents(logs);
                }
            }
        }
        catch (InterruptedException e) {
            LOGGER.info("Centralized logging consumer thread interrupted");
            return;
        }
        LOGGER.info("Exiting centralized logging consumer thread");
    }

    public void setApiLogEnabled(String name, String username, boolean enabled) {
        LogChannel logChannel = ApiClientsLogChannels.getInstance().getLogChannel(name, username);
        logChannel.setEnabled(enabled);
        if (!enabled) {
            this.resource.getActiveLoggingDao().deleteLogs(name + "/" + username, SchedulerComponent.API_CLIENT.name());
        }
    }
}

