/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.utils;

import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.SchedulerConfiguration;
import com.nuix.automate.scheduler.security.bearer.SystemBearerUser;
import com.nuix.automate.utils.api.response.State;
import com.nuix.automate.utils.exceptions.AuthenticationException;
import com.nuix.automate.utils.general.DropwizardRestClientFactory;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.nuixlicensesource.RelayType;
import com.nuix.automate.utils.models.api.nuixlicensesource.SourceType;
import com.nuix.automate.utils.models.internal.event.EventType;
import com.nuix.automate.utils.models.internal.nuixlicensesource.NuixLicenseSourceModel;
import com.nuix.automate.utils.models.internal.template.AutomateApplication;
import com.nuix.automate.utils.models.internal.template.AutomateConfiguration;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import javax.net.ssl.SSLHandshakeException;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;

public class NmsUtils {
    private InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(NmsUtils.class);
    private SchedulerConfiguration schedulerConfiguration;
    private SchedulerApplication schedulerApplication;

    public NmsUtils(SchedulerApplication schedulerApplication) {
        this.schedulerApplication = schedulerApplication;
        this.schedulerConfiguration = schedulerApplication.getConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public String testLicenceSource(NuixLicenseSourceModel nuixLicenseSource, Client client, boolean triggerEvents) throws Exception {
        previousErrorMessage = "";
        if (nuixLicenseSource.getStatus() != null && nuixLicenseSource.getStatus().getCode() == State.ERROR) {
            previousErrorMessage = nuixLicenseSource.getStatus().getMessage();
        }
        if (NmsUtils.LOGGER.isDebugEnabled()) {
            NmsUtils.LOGGER.debug("Getting available licenses from " + String.valueOf(nuixLicenseSource));
        }
        if (nuixLicenseSource.getSourceType() != SourceType.NMS) {
            throw new IllegalArgumentException("Unexpected License Source type");
        }
        response = null;
        try {
            block43: {
                block44: {
                    block41: {
                        block42: {
                            block39: {
                                block40: {
                                    block37: {
                                        block38: {
                                            serverNameSplits = nuixLicenseSource.getServerName().split("/");
                                            if (nuixLicenseSource.getPassword() == null || nuixLicenseSource.getPassword().length() == 0) {
                                                nuixLicenseSource.getStatus().setError(this.iu.getString("LicenseUtils.ReenterPassword"));
                                                throw new AuthenticationException(this.iu.getString("LicenseUtils.ReenterPassword"));
                                            }
                                            auth = nuixLicenseSource.getUsername() + ":" + nuixLicenseSource.getPassword();
                                            basicToken = Base64.getEncoder().encodeToString(auth.getBytes(StandardCharsets.UTF_8));
                                            payload = new HashMap<String, ArrayList<E>>();
                                            params = new ArrayList<String>();
                                            params.add(null);
                                            payload.put("params", params);
                                            baseUrl = "https://" + serverNameSplits[0] + ":" + nuixLicenseSource.getServerPort();
                                            licensesEndpoint = "/api/nurpc/v9/licences/listAvailableLicences";
                                            relay = false;
                                            if (nuixLicenseSource.getRelayType() != null && !RelayType.NONE.equals((Object)nuixLicenseSource.getRelayType())) {
                                                relay = true;
                                                licensesEndpoint = "/api/cls/v1/available";
                                            }
                                            webTarget = client.target(baseUrl + licensesEndpoint);
                                            invocationBuilder = webTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Basic " + basicToken));
                                            response = relay != false ? invocationBuilder.get() : invocationBuilder.post(Entity.json(payload));
                                            if (NmsUtils.LOGGER.isDebugEnabled()) {
                                                NmsUtils.LOGGER.debug("NMS " + licensesEndpoint + " returned HTTP/" + response.getStatus() + " for user " + nuixLicenseSource.getUsername());
                                            }
                                            if (response.getStatus() == 500) {
                                                error = (String)response.readEntity(String.class);
                                                NmsUtils.LOGGER.debug("NMS error: " + error);
                                                params.add("100.0.0.1");
                                                webTarget = client.target(baseUrl + licensesEndpoint);
                                                invocationBuilder = webTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Basic " + basicToken));
                                                response = relay != false ? invocationBuilder.get() : invocationBuilder.post(Entity.json(payload));
                                            }
                                            if (response.getStatus() != 500) ** GOTO lbl55
                                            if (serverNameSplits.length <= 1 || !serverNameSplits[1].equals("*")) break block37;
                                            nuixLicenseSource.getStatus().resetOkMessage(this.iu.getString("LicenseUtils.Ok"));
                                            error = this.iu.getString("LicenseUtils.Ok");
                                            if (response == null) break block38;
                                            response.close();
                                        }
                                        return error;
                                    }
                                    error = (String)response.readEntity(String.class);
                                    nuixLicenseSource.getStatus().setError(error);
                                    NmsUtils.LOGGER.warn("NMS error: " + error);
lbl55:
                                    // 2 sources

                                    if (response.getStatus() != 200) ** GOTO lbl81
                                    availableLicenses = (String)response.readEntity(String.class);
                                    if (!relay) break block39;
                                    nuixLicenseSource.getStatus().resetOkMessage(this.iu.getString("LicenseUtils.Ok"));
                                    var17_21 = this.iu.getString("LicenseUtils.Ok");
                                    if (response == null) break block40;
                                    response.close();
                                }
                                return var17_21;
                            }
                            if (!availableLicenses.contains("availableProfiles")) break block41;
                            if (nuixLicenseSource.getFilter() != null && nuixLicenseSource.getFilter().length() > 0 && !availableLicenses.contains(nuixLicenseSource.getFilter())) {
                                nuixLicenseSource.getStatus().setError(this.iu.getFormattedString("LicenseUtils.FilterNotMatched", (Object)nuixLicenseSource.getFilter()));
                                throw new AuthenticationException(this.iu.getFormattedString("LicenseUtils.FilterNotMatched", (Object)nuixLicenseSource.getFilter()));
                            }
                            nuixLicenseSource.getStatus().resetOkMessage(this.iu.getString("LicenseUtils.Ok"));
                            var17_22 = this.iu.getString("LicenseUtils.Ok");
                            if (response == null) break block42;
                            response.close();
                        }
                        return var17_22;
                    }
                    NmsUtils.LOGGER.error("NMS server returned " + availableLicenses);
                    nuixLicenseSource.getStatus().setError(this.iu.getString("LicenseUtils.UnexpectedResponse"));
                    throw new AuthenticationException(this.iu.getString("LicenseUtils.UnexpectedResponse"));
lbl81:
                    // 1 sources

                    if (response.getStatus() != 401) ** GOTO lbl95
                    if (response.getHeaderString("WWW-Authenticate") == null || !response.getHeaderString("WWW-Authenticate").contains("NTLM")) break block43;
                    nuixLicenseSource.getStatus().resetOkMessage(this.iu.getString("LicenseUtils.OkNoAuth"));
                    availableLicenses = this.iu.getString("LicenseUtils.OkNoAuth");
                    if (response == null) break block44;
                    response.close();
                }
                return availableLicenses;
            }
            try {
                try {
                    try {
                        nuixLicenseSource.getStatus().setError(this.iu.getString("LicenseUtils.IncorrectUsernamePassword"));
                        throw new AuthenticationException(this.iu.getString("LicenseUtils.IncorrectUsernamePassword"));
lbl95:
                        // 1 sources

                        errorMessage = this.iu.getFormattedString("LicenseUtils.UnexpectedStatus", (Object)("" + response.getStatus()));
                        nuixLicenseSource.getStatus().setError(errorMessage);
                        throw new AuthenticationException(this.iu.getFormattedString("LicenseUtils.UnexpectedStatus", (Object)response.getStatus()));
                    }
                    catch (ProcessingException e) {
                        NmsUtils.LOGGER.error("Cannot test NMS license", (Throwable)e);
                        certificateFingerprintException = null;
                        if (e.getCause() != null && e.getCause() instanceof SSLHandshakeException) {
                            dummyFingerprints = new HashSet<String>();
                            dummyFingerprints.add("Invalid");
                            certificateResponse = null;
                            try {
                                dummyClient = DropwizardRestClientFactory.getClientWithWhitelistValidation((String)("NmsUtils-" + nuixLicenseSource.getId() + "-dummyFingerprint"), dummyFingerprints, (AutomateApplication)this.schedulerApplication, (AutomateConfiguration)this.schedulerConfiguration);
                                webTarget = dummyClient.target("https://" + serverNameSplits[0] + ":" + nuixLicenseSource.getServerPort());
                                invocationBuilder = webTarget.request(new String[]{"application/json"});
                                certificateResponse = invocationBuilder.get();
                            }
                            catch (Exception ex) {
                                certificateFingerprintException = ex;
                            }
                            finally {
                                if (certificateResponse != null) {
                                    certificateResponse.close();
                                }
                            }
                        }
                        errorMessage = e.getCause() != null ? (certificateFingerprintException != null && !certificateFingerprintException.getLocalizedMessage().equals(e.getLocalizedMessage()) ? this.iu.getFormattedString("LicenseUtils.CouldNotInitializeServerWithFingerprint", (Object[])new String[]{e.getLocalizedMessage(), certificateFingerprintException.getLocalizedMessage()}) : this.iu.getFormattedString("LicenseUtils.CouldNotInitializeServer", (Object)e.getLocalizedMessage())) : this.iu.getString("LicenseUtils.CouldNotInitializeServer.IncorrectProtocolResponse");
                        nuixLicenseSource.getStatus().setError(errorMessage);
                        throw new AuthenticationException(errorMessage);
                    }
                }
                catch (Throwable var19_24) {
                    if (response != null) {
                        response.close();
                    }
                    throw var19_24;
                }
            }
            catch (Exception e) {
                if (!(e instanceof AuthenticationException)) {
                    nuixLicenseSource.getStatus().setError(this.iu.getFormattedString("LicenseUtils.CannotConnectToNms", (Object)FormattingUtils.getExceptionPrintableMessage((Exception)e)));
                }
                if (triggerEvents && !(currentErrorMessage = nuixLicenseSource.getStatus().getMessage()).equals(previousErrorMessage)) {
                    eventResult = SchedulerApplication.getInstance().getSecurityPolicyUtil().setUserPermissions((BearerUser)new SystemBearerUser(), nuixLicenseSource);
                    SchedulerApplication.getInstance().getWebhookWorker().triggerEvent(EventType.Type.NUIX_LICENSE_SOURCE_ERROR, eventResult);
                }
                if (e instanceof AuthenticationException) {
                    throw e;
                }
                NmsUtils.LOGGER.error("Cannot connect to NMS license", (Throwable)e);
                throw new AuthenticationException(this.iu.getFormattedString("LicenseUtils.CannotConnectToNms", (Object)FormattingUtils.getExceptionPrintableMessage((Exception)e)));
            }
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }
}

