/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.utils;

import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.utils.FileInfoCache;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.models.api.dataset.FileInfo;
import com.nuix.automate.utils.models.api.legalhold.LegalHold;
import com.nuix.automate.utils.models.api.legalhold.LegalHoldExportOptions;
import com.nuix.automate.utils.models.api.notice.CommentType;
import com.nuix.automate.utils.models.api.notice.FormElementType;
import com.nuix.automate.utils.models.api.notice.FormOption;
import com.nuix.automate.utils.models.api.notice.Notice;
import com.nuix.automate.utils.models.api.notice.NoticeComment;
import com.nuix.automate.utils.models.api.notice.NoticeEvent;
import com.nuix.automate.utils.models.api.user.UserAccount;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.commonmark.parser.Parser;
import org.commonmark.renderer.html.HtmlRenderer;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;

public class NoticeHtmlBuilder {
    private final InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");
    private final DateTimeFormatter localDateTimeFormatter = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT).withZone(ZoneId.of("UTC"));
    private final SchedulerApplication schedulerApplication;
    private final BearerUser user;
    private final LegalHoldExportOptions exportOptions;
    private final Document userNoticeTemplate;
    private final Parser markdownParser;
    private final HtmlRenderer htmlRenderer;
    private final Map<String, Element> optionKeyToElement;
    private final Element messageContainer;
    private final Element surveyContainer;
    private final Element commentContainer;
    private final Element checkboxTemplate;
    private final Element dataUploadTemplate;
    private final Element filesTableRowTemplate;
    private final Element commentDisplay;
    private final Element commentTemplate;
    private final Element adminNoteTemplate;
    private Notice notice;

    public NoticeHtmlBuilder(SchedulerApplication schedulerApplication, BearerUser user, LegalHoldExportOptions exportOptions) throws IOException {
        this.schedulerApplication = schedulerApplication;
        this.user = user;
        this.exportOptions = exportOptions;
        this.optionKeyToElement = new HashMap<String, Element>();
        this.markdownParser = Parser.builder().build();
        this.htmlRenderer = HtmlRenderer.builder().build();
        this.userNoticeTemplate = Jsoup.parse((String)IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/templates/userNoticeTemplate.html"), (Charset)StandardCharsets.UTF_8));
        this.messageContainer = this.userNoticeTemplate.getElementById("userNoticeMessageContainer");
        this.surveyContainer = this.userNoticeTemplate.getElementById("userNoticeSurveyContainer");
        this.commentContainer = this.userNoticeTemplate.getElementById("userNoticeCommentContainer");
        this.checkboxTemplate = this.userNoticeTemplate.getElementById("checkboxTemplate");
        this.checkboxTemplate.remove();
        this.dataUploadTemplate = this.userNoticeTemplate.getElementById("dataUploadTemplate");
        this.dataUploadTemplate.remove();
        this.filesTableRowTemplate = this.dataUploadTemplate.getElementsByClass("table-row-group").first().child(0);
        this.filesTableRowTemplate.remove();
        this.commentDisplay = this.userNoticeTemplate.getElementById("userNoticeCommentDisplay");
        Elements commentTemplates = this.commentContainer.getElementsByClass("notice-comment__background");
        this.commentTemplate = (Element)commentTemplates.get(0);
        this.commentTemplate.remove();
        this.adminNoteTemplate = (Element)commentTemplates.get(1);
        this.adminNoteTemplate.remove();
    }

    public void addStyleElement(String styles) {
        Element styleElement = this.userNoticeTemplate.head().appendElement("style");
        styleElement.html(styles);
    }

    public void linkStyleSheet(String href) {
        Element styleLinkElement = this.userNoticeTemplate.head().appendElement("link");
        styleLinkElement.attr("rel", "stylesheet");
        styleLinkElement.attr("href", href);
    }

    public void imprintNotice(Notice notice) {
        this.reset();
        this.notice = notice;
        LegalHold legalHold = this.schedulerApplication.getLegalHoldResource().getLegalHold(notice.getLegalHoldId());
        this.userNoticeTemplate.getElementById("userNoticeSubjectValue").text(FormattingUtils.encodeForHtml((String)notice.getSubject()));
        this.userNoticeTemplate.getElementById("userNoticeLegalHoldNameValue").text(FormattingUtils.encodeForHtml((String)legalHold.getName()));
        this.userNoticeTemplate.getElementById("userNoticeTypeLabel").text(FormattingUtils.encodeForHtml((String)this.iu.getString("NoticeType." + notice.getType().name())));
        if (notice.getMessage() != null) {
            org.commonmark.node.Node markdownDocument = this.markdownParser.parse(FormattingUtils.encodeForHtml((String)notice.getMessage()));
            this.messageContainer.html(this.htmlRenderer.render(markdownDocument));
        }
        if (notice.hasSurveyFormOptions()) {
            this.surveyContainer.appendChild((Node)this.buildNoticeSurvey(notice.getSurveyFormOptions()));
            for (FormOption option : notice.getSurveyFormOptions()) {
                String key = option.getKey();
                Element optionElement = this.surveyContainer.getElementById(key);
                if (FormElementType.HEADER.equals((Object)option.getType()) || optionElement == null) continue;
                this.optionKeyToElement.put(key, optionElement);
            }
        }
    }

    public String printNoticeEvent(NoticeEvent noticeEvent) throws IOException {
        Element escalatedDateContainer;
        Element lastRemindedDateContainer;
        Element respondByDateContainer;
        Element sentDateElement;
        Element userIconContainer;
        Element recipientNameValue;
        String username;
        UserAccount noticeEventUser = this.schedulerApplication.getUserServiceResource().getUser(noticeEvent.getUserId());
        String userIconSvgString = null;
        if (noticeEventUser != null) {
            username = noticeEventUser.getName();
            if (this.exportOptions.getIncludeIcons()) {
                userIconSvgString = this.getUserSvgIcon(this.user, username);
            }
        } else {
            username = noticeEvent.getUserId();
        }
        if ((recipientNameValue = this.userNoticeTemplate.getElementById("userNoticeRecipientNameValue")) != null) {
            recipientNameValue.text(FormattingUtils.encodeForHtml((String)username));
        }
        if ((userIconContainer = this.userNoticeTemplate.getElementById("userNoticeRecipientUserIconContainer")) != null) {
            if (userIconSvgString != null) {
                userIconContainer.html(userIconSvgString);
                Element userIconSvg = userIconContainer.getElementsByTag("svg").first();
                if (userIconSvg != null) {
                    userIconSvg.addClass("round-image").attr("width", "").attr("height", "");
                }
            } else {
                userIconContainer.attr("style", "display: none;");
            }
        }
        if ((sentDateElement = this.userNoticeTemplate.getElementById("userNoticeSentValue")) != null) {
            String sentDate = this.localDateTimeFormatter.format(Instant.ofEpochMilli(noticeEvent.getSentDate()));
            sentDateElement.text(FormattingUtils.encodeForHtml((String)sentDate));
        }
        if ((respondByDateContainer = this.userNoticeTemplate.getElementById("userNoticeRespondByRow")) != null) {
            if (Boolean.TRUE.equals(this.notice.getConfiguration().getRequireResponse())) {
                respondByDateContainer.removeAttr("style");
                Element respondByDateValueElement = this.userNoticeTemplate.getElementById("userNoticeRespondByValue");
                if (respondByDateValueElement != null) {
                    long respondByDate = this.notice.getConfiguration().getRespondByMillis(noticeEvent.getSentDate().longValue());
                    respondByDateValueElement.text(FormattingUtils.encodeForHtml((String)this.localDateTimeFormatter.format(Instant.ofEpochMilli(respondByDate))));
                }
            } else {
                respondByDateContainer.attr("style", "display: none;");
            }
        }
        Long respondedDate = noticeEvent.getLastRespondedDate();
        Element respondedDateContainer = this.userNoticeTemplate.getElementById("userNoticeRespondedRow");
        if (respondedDateContainer != null) {
            if (respondedDate != null) {
                respondedDateContainer.removeAttr("style");
                Element respondedDateValueElement = this.userNoticeTemplate.getElementById("userNoticeRespondedValue");
                if (respondedDateValueElement != null) {
                    respondedDateValueElement.text(FormattingUtils.encodeForHtml((String)this.localDateTimeFormatter.format(Instant.ofEpochMilli(respondedDate))));
                }
            } else {
                respondedDateContainer.attr("style", "display: none;");
            }
        }
        if ((lastRemindedDateContainer = this.userNoticeTemplate.getElementById("userNoticeLastRemindedRow")) != null) {
            Long lastRemindedDate = noticeEvent.getLastRemindedDate();
            if (lastRemindedDate != null) {
                lastRemindedDateContainer.removeAttr("style");
                Element lastRemindedDateValueElement = this.userNoticeTemplate.getElementById("userNoticeLastRemindedValue");
                if (lastRemindedDateValueElement != null) {
                    lastRemindedDateValueElement.text(FormattingUtils.encodeForHtml((String)this.localDateTimeFormatter.format(Instant.ofEpochMilli(lastRemindedDate))));
                }
            } else {
                lastRemindedDateContainer.attr("style", "display: none;");
            }
        }
        if ((escalatedDateContainer = this.userNoticeTemplate.getElementById("userNoticeEscalatedRow")) != null) {
            Long escalatedDate = noticeEvent.getEscalatedDate();
            if (escalatedDate != null) {
                escalatedDateContainer.removeAttr("style");
                Element escalatedDateValueElement = this.userNoticeTemplate.getElementById("userNoticeEscalatedValue");
                if (escalatedDateValueElement != null) {
                    escalatedDateValueElement.text(FormattingUtils.encodeForHtml((String)this.localDateTimeFormatter.format(Instant.ofEpochMilli(escalatedDate))));
                }
            } else {
                escalatedDateContainer.attr("style", "display: none;");
            }
        }
        Map surveyValues = noticeEvent.getSurveyFormValues();
        block8: for (String key : this.optionKeyToElement.keySet()) {
            Element optionElement = this.optionKeyToElement.get(key);
            String optionValue = "";
            if (respondedDate != null && surveyValues != null) {
                optionValue = (String)surveyValues.get(key);
            }
            switch (optionElement.tagName()) {
                case "label": {
                    optionElement.text(FormattingUtils.encodeForHtml((String)optionValue));
                    break;
                }
                case "div": {
                    if (!optionElement.hasClass("data-upload")) continue block8;
                    Element filesTableRowGroupElement = optionElement.getElementsByClass("table-row-group").first();
                    filesTableRowGroupElement.children().remove();
                    if (optionValue == null || !this.exportOptions.getIncludeDatasetFiles()) continue block8;
                    for (FileInfo fileInfo : FileInfoCache.getInstance().getDatasetRootFileInfos(optionValue)) {
                        Element filesTableRowElement = this.filesTableRowTemplate.clone();
                        Elements rowLabels = filesTableRowElement.getElementsByTag("label");
                        ((Element)rowLabels.get(0)).text(fileInfo.getRelativePath());
                        ((Element)rowLabels.get(1)).text(FormattingUtils.sizeToDisplaySize((long)fileInfo.getSize()));
                        filesTableRowGroupElement.appendChild((Node)filesTableRowElement);
                    }
                    continue block8;
                }
                default: {
                    if (optionElement.attr("type").equalsIgnoreCase("checkbox")) {
                        optionElement.attr("checked", "true".equalsIgnoreCase(optionValue));
                        break;
                    }
                    optionElement.val(FormattingUtils.encodeForHtml((String)optionValue));
                }
            }
        }
        List<NoticeComment> noticeComments = null;
        if (this.exportOptions.getIncludeComments() || this.exportOptions.getIncludeAdminNotes()) {
            noticeComments = this.schedulerApplication.getSchedulerConfigurationDao().getNoticeComments(noticeEvent.getId());
        }
        if (noticeComments != null) {
            if (!this.exportOptions.getIncludeComments()) {
                noticeComments.removeIf(comment -> comment.getType() == CommentType.REGULAR);
            }
            if (!this.exportOptions.getIncludeAdminNotes()) {
                noticeComments.removeIf(comment -> comment.getType() == CommentType.ADMIN_NOTE);
            }
        }
        if (noticeComments == null || noticeComments.isEmpty()) {
            this.commentDisplay.attr("style", "display: none;");
        } else {
            this.commentDisplay.removeAttr("style");
            for (NoticeComment noticeComment : noticeComments) {
                String commentUsername;
                UserAccount commentUser = this.schedulerApplication.getUserServiceResource().getUser(noticeComment.getUserId());
                String commentUserIconSvgString = null;
                if (commentUser != null) {
                    commentUsername = commentUser.getName();
                    if (this.exportOptions.getIncludeIcons()) {
                        commentUserIconSvgString = this.getUserSvgIcon(this.user, commentUsername);
                    }
                } else {
                    commentUsername = noticeComment.getUserId();
                }
                Element comment2 = noticeComment.getType() == CommentType.ADMIN_NOTE ? this.adminNoteTemplate.clone() : this.commentTemplate.clone();
                this.commentContainer.appendChild((Node)comment2);
                Element commentIconContainer = comment2.getElementsByClass("icon").first();
                if (commentUserIconSvgString != null) {
                    commentIconContainer.html(FormattingUtils.encodeForHtml((String)commentUserIconSvgString));
                    commentIconContainer.getElementsByTag("svg").first().addClass("round-image").attr("width", "").attr("height", "");
                } else {
                    commentIconContainer.attr("style", "display: none;");
                }
                Elements commentLabels = comment2.getElementsByTag("label");
                ((Element)commentLabels.get(0)).text(FormattingUtils.encodeForHtml((String)commentUsername));
                ((Element)commentLabels.get(1)).text(FormattingUtils.encodeForHtml((String)this.localDateTimeFormatter.format(Instant.ofEpochMilli(noticeComment.getCreatedDate()))));
                ((Element)comment2.getElementsByClass("label is-wordwrap").get(0)).text(FormattingUtils.encodeForHtml((String)noticeComment.getMessage()));
            }
        }
        return this.userNoticeTemplate.toString();
    }

    public Element buildNoticeSurvey(List<FormOption> surveyFormOptions) {
        Element noticeSurveyContainer = new Element("div").addClass("form-builder");
        Element tableRowGroup = noticeSurveyContainer.appendElement("div").addClass("form-table align-top").appendElement("div").addClass("table-row-group");
        block10: for (FormOption option : surveyFormOptions) {
            Element tableCell = tableRowGroup.appendElement("div").addClass("table-row").appendElement("div").addClass("table-cell");
            if (FormElementType.HEADER.equals((Object)option.getType())) {
                tableCell.appendElement("label").addClass("label is-heading").text(FormattingUtils.encodeForHtml((String)option.getTitle()));
            }
            if (option.getDescription() != null) {
                tableCell.appendElement("label").addClass("label is-wordwrap").text(FormattingUtils.encodeForHtml((String)option.getDescription()));
            }
            String optionId = option.getKey();
            switch (option.getType()) {
                case HEADER: {
                    continue block10;
                }
                case CHECKBOX: {
                    Element checkbox = this.checkboxTemplate.clone();
                    checkbox.removeAttr("id");
                    checkbox.getElementsByTag("input").first().attr("id", optionId);
                    checkbox.getElementsByTag("label").first().append(FormattingUtils.encodeForHtml((String)option.getLabel()));
                    tableCell.appendChild((Node)checkbox);
                    continue block10;
                }
                case TEXTAREA: {
                    tableCell.appendElement("textarea").addClass("textarea is-readonly").attr("id", optionId).attr("rows", "4").attr("disabled", true);
                    continue block10;
                }
                case NUMBER: {
                    tableCell.appendElement("input").addClass("input is-readonly").attr("style", "width: 10rem;").attr("id", optionId).attr("type", "number").attr("disabled", true);
                    continue block10;
                }
                case DATE: {
                    tableCell.appendElement("input").addClass("input is-readonly").attr("style", "width: 10rem;").attr("id", optionId).attr("type", "date").attr("disabled", true);
                    continue block10;
                }
                case TIME: {
                    tableCell.appendElement("input").addClass("input is-readonly").attr("style", "width: 10rem;").attr("id", optionId).attr("type", "time").attr("disabled", true);
                    continue block10;
                }
                case DROPDOWN: {
                    tableCell.appendElement("input").addClass("input is-readonly").attr("style", "width: 10rem;").attr("id", optionId).attr("disabled", true);
                    continue block10;
                }
                case DATA_UPLOAD: {
                    Element dataUpload = this.dataUploadTemplate.clone().attr("id", optionId);
                    dataUpload.getElementsByTag("label").first().text(FormattingUtils.encodeForHtml((String)option.getLabel()));
                    tableCell.appendChild((Node)dataUpload);
                    continue block10;
                }
            }
            tableCell.appendElement("input").addClass("input is-readonly").attr("id", option.getKey()).attr("disabled", true);
        }
        return noticeSurveyContainer;
    }

    public void reset() {
        this.notice = null;
        this.optionKeyToElement.clear();
        this.messageContainer.children().remove();
        this.surveyContainer.children().remove();
        this.commentContainer.children().remove();
    }

    private String getUserSvgIcon(BearerUser user, String username) throws IOException {
        Response response = this.schedulerApplication.getMediaResources().getUserIcon(user, username);
        if (Response.Status.OK.getStatusCode() == response.getStatus() && response.getMediaType().equals((Object)new MediaType("image", "svg+xml"))) {
            InputStream iconStream = (InputStream)response.getEntity();
            return IOUtils.toString((InputStream)iconStream, (Charset)StandardCharsets.UTF_8);
        }
        return null;
    }
}

