/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.utils;

import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.utils.general.DropwizardRestClientFactory;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.LocalizedEnum;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.client.Client;
import com.nuix.automate.utils.models.api.client.Matter;
import com.nuix.automate.utils.models.api.job.OperationStatus;
import com.nuix.automate.utils.models.api.notificationrule.EmailNotificationRule;
import com.nuix.automate.utils.models.api.notificationrule.NotificationRule;
import com.nuix.automate.utils.models.api.notificationrule.WebhookNotificationRule;
import com.nuix.automate.utils.models.api.smtp.EmailState;
import com.nuix.automate.utils.models.api.smtp.EmailType;
import com.nuix.automate.utils.models.api.smtp.SmtpEmail;
import com.nuix.automate.utils.models.api.workflowlibrary.Workflow;
import com.nuix.automate.utils.models.api.workflowlibrary.WorkflowLibrary;
import com.nuix.automate.utils.models.internal.executionprofile.ExecutionProfileModel;
import com.nuix.automate.utils.models.internal.job.JobDetailsModel;
import com.nuix.automate.utils.models.internal.job.JobEvent;
import com.nuix.automate.utils.models.internal.job.JobModel;
import com.nuix.automate.utils.models.internal.template.AutomateApplication;
import com.nuix.automate.utils.models.internal.template.AutomateConfiguration;
import com.nuix.automate.utils.responsecache.CacheKey;
import com.nuix.automate.utils.responsecache.ResponseCache;
import com.nuix.automate.utils.ui.IconType;
import com.nuix.automate.utils.ui.Icons;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;

public class NotificationsHandler {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(NotificationsHandler.class);
    private static final int SLACK_MAX_TEXT_SIZE = 3000;
    private SchedulerApplication schedulerApplication;
    private InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");
    private Map<String, javax.ws.rs.client.Client> notificationRuleClients;

    public NotificationsHandler(SchedulerApplication schedulerApplication) {
        this.schedulerApplication = schedulerApplication;
        this.notificationRuleClients = new HashMap<String, javax.ws.rs.client.Client>();
    }

    private javax.ws.rs.client.Client getNotificationRuleClient(String ruleId) {
        javax.ws.rs.client.Client client = this.notificationRuleClients.get(ruleId);
        if (client == null) {
            client = DropwizardRestClientFactory.getClient((String)("NotificationRule-" + ruleId), (boolean)true, (boolean)true, (boolean)true, (AutomateApplication)this.schedulerApplication, (AutomateConfiguration)this.schedulerApplication.getConfiguration());
        }
        this.notificationRuleClients.put(ruleId, client);
        return client;
    }

    public void triggerNotificationEvent(JobDetailsModel jobDetailsModel, JobEvent trigger) {
        this.triggerNotificationEvent(jobDetailsModel, trigger, null, null);
    }

    public void triggerNotificationEvent(JobDetailsModel jobDetailsModel, JobEvent trigger, Set<String> additionalExecutionProfileIds, LinkedHashMap<String, String> additionalProperties) {
        try {
            ExecutionProfileModel executionProfile;
            HashSet<ExecutionProfileModel> executionProfiles = new HashSet<ExecutionProfileModel>();
            if (additionalExecutionProfileIds != null) {
                for (String additionalExecutionProfileId : additionalExecutionProfileIds) {
                    ExecutionProfileModel executionProfile2 = this.schedulerApplication.getExecutionProfileResource().getExecutionProfile(additionalExecutionProfileId);
                    if (executionProfile2 == null) continue;
                    executionProfiles.add(executionProfile2);
                }
            }
            if (jobDetailsModel.getSettings().getExecutionProfileId() != null && (executionProfile = this.schedulerApplication.getExecutionProfileResource().getExecutionProfile(jobDetailsModel.getSettings().getExecutionProfileId())) != null) {
                executionProfiles.add(executionProfile);
            }
            HashSet<NotificationRule> notificationRules = new HashSet<NotificationRule>();
            for (ExecutionProfileModel executionProfile2 : executionProfiles) {
                if (executionProfile2.getNotificationRuleIds() == null) continue;
                for (String ruleId : executionProfile2.getNotificationRuleIds()) {
                    NotificationRule notificationRule = this.schedulerApplication.getNotificationRuleResource().getNotificationRule(ruleId);
                    if (notificationRule == null || notificationRule.getTriggers() == null || !notificationRule.getTriggers().contains(trigger)) continue;
                    notificationRules.add(notificationRule);
                }
            }
            for (NotificationRule notificationRule : notificationRules) {
                try {
                    this.sendNotification(notificationRule, trigger, jobDetailsModel, additionalProperties, true);
                }
                catch (Exception e) {
                    LOGGER.error("Cannot send notification for " + String.valueOf(notificationRule), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Cannot handle notifications", (Throwable)e);
        }
    }

    public String testNotificationRule(NotificationRule notificationRule, LinkedHashMap<String, String> additionalProperties, String testedBy) throws IOException {
        JobDetailsModel dummyJobModel = new JobDetailsModel();
        dummyJobModel.setSettings(new JobModel());
        dummyJobModel.setOperations(new ArrayList());
        dummyJobModel.getSettings().setName("Sample Project");
        dummyJobModel.getSettings().setSubmittedBy(testedBy);
        dummyJobModel.setOperations(new LinkedList());
        return this.sendNotification(notificationRule, JobEvent.TRIGGER_TEST, dummyJobModel, additionalProperties, false);
    }

    private String sendNotification(NotificationRule notificationRule, JobEvent trigger, JobDetailsModel jobDetailsModel, LinkedHashMap<String, String> additionalProperties, boolean async) throws IOException {
        if (notificationRule instanceof WebhookNotificationRule) {
            return this.sendWebhookNotification((WebhookNotificationRule)notificationRule, trigger, jobDetailsModel, additionalProperties, async);
        }
        if (notificationRule instanceof EmailNotificationRule) {
            return this.sendEmailNotification((EmailNotificationRule)notificationRule, trigger, jobDetailsModel, additionalProperties, async);
        }
        throw new IOException("Notification method not implemented");
    }

    private String getTriggerImageUrl(JobEvent trigger) {
        switch (trigger) {
            case JOB_PAUSED: {
                return "https://rampiva-downloads.s3.amazonaws.com/media/status-paused.png";
            }
            case JOB_QUEUED: {
                return "https://rampiva-downloads.s3.amazonaws.com/media/status-queued.png";
            }
            case JOB_STARTED: {
                return "https://rampiva-downloads.s3.amazonaws.com/media/status-started.png";
            }
            case JOB_STOPPED: {
                return "https://rampiva-downloads.s3.amazonaws.com/media/status-stopped.png";
            }
            case JOB_WARNING: {
                return "https://rampiva-downloads.s3.amazonaws.com/media/status-warning.png";
            }
            case JOB_INFO: {
                return "https://rampiva-downloads.s3.amazonaws.com/media/status-info.png";
            }
            case JOB_WARNING_RESOLVED: {
                return "https://rampiva-downloads.s3.amazonaws.com/media/status-warning-resolved.png";
            }
            case JOB_CANCELED: {
                return "https://rampiva-downloads.s3.amazonaws.com/media/status-canceled.png";
            }
            case JOB_MODIFIED: {
                return "https://rampiva-downloads.s3.amazonaws.com/media/status-modified.png";
            }
            case JOB_ERROR: {
                return "https://rampiva-downloads.s3.amazonaws.com/media/status-error.png";
            }
            case JOB_FINISHED_SUCCESSFULLY: {
                return "https://rampiva-downloads.s3.amazonaws.com/media/status-success.png";
            }
            case JOB_FINISHED_WITH_WARNINGS: {
                return "https://rampiva-downloads.s3.amazonaws.com/media/status-warning.png";
            }
            case JOB_SOFT_ERROR: 
            case JOB_FINISHED_WITH_SOFT_ERRORS: {
                return "https://rampiva-downloads.s3.amazonaws.com/media/status-soft-error.png";
            }
            case TRIGGER_TEST: {
                return "https://rampiva-downloads.s3.amazonaws.com/media/status-info.png";
            }
        }
        return "";
    }

    private IconType getImageIconType(JobEvent trigger) {
        switch (trigger) {
            case JOB_PAUSED: {
                return IconType.JOB_PAUSED;
            }
            case JOB_QUEUED: {
                return IconType.JOB_QUEUED;
            }
            case JOB_STARTED: {
                return IconType.JOB_STARTED;
            }
            case JOB_STOPPED: {
                return IconType.JOB_STOPPED;
            }
            case JOB_WARNING: {
                return IconType.WARNING;
            }
            case JOB_INFO: {
                return IconType.INFO;
            }
            case JOB_WARNING_RESOLVED: {
                return IconType.WARNING_RESOLVED;
            }
            case JOB_CANCELED: {
                return IconType.CANCELLED;
            }
            case JOB_MODIFIED: {
                return IconType.JOB_MODIFIED;
            }
            case JOB_ERROR: {
                return IconType.ERROR;
            }
            case JOB_FINISHED_SUCCESSFULLY: {
                return IconType.SUCCESS;
            }
            case JOB_FINISHED_WITH_WARNINGS: {
                return IconType.WARNING;
            }
            case JOB_SOFT_ERROR: 
            case JOB_FINISHED_WITH_SOFT_ERRORS: {
                return IconType.SOFT_ERROR;
            }
            case TRIGGER_TEST: {
                return IconType.INFO;
            }
        }
        return null;
    }

    private void addProperty(Map<String, Set<String>> properties, String property, String value) {
        if (!properties.containsKey(property)) {
            properties.put(property, new LinkedHashSet());
        }
        properties.get(property).add(value);
    }

    private Map<String, Set<String>> populateNotificationProperties(JobEvent trigger, JobDetailsModel jobDetailsModel, LinkedHashMap<String, String> additionalProperties) {
        LinkedHashMap<String, Set<String>> properties = new LinkedHashMap<String, Set<String>>();
        this.addProperty(properties, this.iu.getString("JobResource.ModificationLabel.Job"), jobDetailsModel.getSettings().getName());
        if (trigger.equals((Object)JobEvent.JOB_QUEUED)) {
            this.addProperty(properties, this.iu.getString("JobResource.ModificationLabel.SubmittedBy"), jobDetailsModel.getSettings().getSubmittedBy());
            Client client = null;
            String clientId = jobDetailsModel.getSettings().getClientId();
            if (clientId != null && (client = this.schedulerApplication.getClientResource().getClient(clientId)) != null) {
                this.addProperty(properties, this.iu.getString("JobResource.ModificationLabel.ClientName"), client.getName());
            }
            Matter matter = null;
            String matterId = jobDetailsModel.getSettings().getMatterId();
            if (matterId != null && (matter = this.schedulerApplication.getClientResource().getMatter(matterId)) != null) {
                this.addProperty(properties, this.iu.getString("JobResource.ModificationLabel.MatterName"), matter.getName());
            }
            WorkflowLibrary workflowLibrary = null;
            String libraryId = jobDetailsModel.getSettings().getLibraryId();
            if (libraryId != null && (workflowLibrary = this.schedulerApplication.getLibraryResource().getWorkflowLibrary(libraryId)) != null) {
                this.addProperty(properties, this.iu.getString("JobResource.ModificationLabel.LibraryName"), workflowLibrary.getName());
            }
            Workflow workflow = null;
            String workflowId = jobDetailsModel.getSettings().getLibraryWorkflowId();
            if (workflowId != null && (workflow = this.schedulerApplication.getLibraryResource().getLibraryWorkflow(workflowId)) != null) {
                this.addProperty(properties, this.iu.getString("JobResource.ModificationLabel.WorkflowName"), workflow.getName());
            }
        } else if (trigger.equals((Object)JobEvent.JOB_STARTED)) {
            this.addProperty(properties, this.iu.getString("JobResource.ModificationLabel.Server"), jobDetailsModel.getSettings().getServerName());
            this.addProperty(properties, this.iu.getString("JobResource.ModificationLabel.Engine"), jobDetailsModel.getSettings().getEngineName());
        } else if (trigger.equals((Object)JobEvent.JOB_ERROR)) {
            this.addProperty(properties, this.iu.getString("JobResource.ModificationLabel.Error"), jobDetailsModel.getSettings().getError());
            for (OperationStatus operationStatus : jobDetailsModel.getOperations()) {
                if (operationStatus.getError() == null || operationStatus.getError().length() <= 0) continue;
                this.addProperty(properties, this.iu.getString("JobResource.ModificationLabel.Error"), operationStatus.getName() + " - " + operationStatus.getError());
            }
            for (String warning : jobDetailsModel.getSettings().getWarnings()) {
                this.addProperty(properties, this.iu.getString("JobResource.ModificationLabel.Warning"), warning);
            }
            for (OperationStatus operationStatus : jobDetailsModel.getOperations()) {
                for (String warning : operationStatus.getWarnings()) {
                    this.addProperty(properties, this.iu.getString("JobResource.ModificationLabel.Warning"), operationStatus.getName() + " - " + warning);
                }
            }
            for (String softError : jobDetailsModel.getSettings().getSoftErrors()) {
                this.addProperty(properties, this.iu.getString("JobResource.ModificationLabel.SoftError"), softError);
            }
            for (OperationStatus operationStatus : jobDetailsModel.getOperations()) {
                if (!operationStatus.hasSoftErrors()) continue;
                this.addProperty(properties, this.iu.getString("JobResource.ModificationLabel.SoftError"), operationStatus.getName() + " - " + operationStatus.getError());
            }
        } else if (trigger.equals((Object)JobEvent.JOB_FINISHED_WITH_WARNINGS)) {
            for (String warning : jobDetailsModel.getSettings().getWarnings()) {
                this.addProperty(properties, this.iu.getString("JobResource.ModificationLabel.Warning"), warning);
            }
            for (OperationStatus operationStatus : jobDetailsModel.getOperations()) {
                for (String warning : operationStatus.getWarnings()) {
                    this.addProperty(properties, this.iu.getString("JobResource.ModificationLabel.Warning"), operationStatus.getName() + " - " + warning);
                }
            }
        } else if (trigger.equals((Object)JobEvent.JOB_FINISHED_WITH_SOFT_ERRORS)) {
            for (String softError : jobDetailsModel.getSettings().getSoftErrors()) {
                this.addProperty(properties, this.iu.getString("JobResource.ModificationLabel.SoftError"), softError);
            }
            for (OperationStatus operationStatus : jobDetailsModel.getOperations()) {
                if (!operationStatus.hasSoftErrors()) continue;
                this.addProperty(properties, this.iu.getString("JobResource.ModificationLabel.SoftError"), operationStatus.getName() + " - " + operationStatus.getError());
            }
        }
        if (additionalProperties != null) {
            for (String property : additionalProperties.keySet()) {
                this.addProperty(properties, property, additionalProperties.get(property));
            }
        }
        return properties;
    }

    private Map<String, Object> generateDiscordPayload(JobEvent trigger, Map<String, Set<String>> properties) throws IOException {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        ArrayList embeds = new ArrayList();
        payload.put("embeds", embeds);
        HashMap authorBlock = new HashMap();
        embeds.add(authorBlock);
        HashMap<String, String> author = new HashMap<String, String>();
        authorBlock.put("author", author);
        author.put("name", new LocalizedEnum("SchedulerText", (Enum)trigger).toString());
        author.put("icon_url", this.getTriggerImageUrl(trigger));
        HashMap fieldsBlock = new HashMap();
        embeds.add(fieldsBlock);
        ArrayList fields = new ArrayList();
        fieldsBlock.put("fields", fields);
        if (properties != null) {
            for (String property : properties.keySet()) {
                for (String propertyValue : properties.get(property)) {
                    HashMap<String, Object> field = new HashMap<String, Object>();
                    field.put("name", "*" + property + "*");
                    field.put("value", propertyValue);
                    fields.add(field);
                }
            }
        }
        return payload;
    }

    private Map<String, Object> generateTeamsPayload(JobEvent trigger, Map<String, Set<String>> properties) throws IOException {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("@type", "MessageCard");
        payload.put("@context", "http://schema.org/extensions");
        payload.put("summary", new LocalizedEnum("SchedulerText", (Enum)trigger).toString());
        ArrayList sections = new ArrayList();
        payload.put("sections", sections);
        HashMap<String, Object> section = new HashMap<String, Object>();
        sections.add(section);
        section.put("activityTitle", new LocalizedEnum("SchedulerText", (Enum)trigger).toString());
        section.put("activityImage", this.getTriggerImageUrl(trigger));
        ArrayList facts = new ArrayList();
        section.put("facts", facts);
        if (properties != null) {
            for (String property : properties.keySet()) {
                for (String propertyValue : properties.get(property)) {
                    HashMap<String, String> fact = new HashMap<String, String>();
                    fact.put("name", property);
                    fact.put("value", propertyValue);
                    facts.add(fact);
                }
            }
        }
        return payload;
    }

    private Map<String, Object> generateSlackPayload(JobEvent trigger, Map<String, Set<String>> properties) throws IOException {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        ArrayList blocks = new ArrayList();
        payload.put("blocks", blocks);
        HashMap<String, Object> contextBlock = new HashMap<String, Object>();
        blocks.add(contextBlock);
        contextBlock.put("type", "context");
        ArrayList elements = new ArrayList();
        contextBlock.put("elements", elements);
        HashMap<String, String> imageElement = new HashMap<String, String>();
        elements.add(imageElement);
        imageElement.put("type", "image");
        imageElement.put("image_url", this.getTriggerImageUrl(trigger));
        imageElement.put("alt_text", (String)trigger);
        HashMap<String, Object> textElement = new HashMap<String, Object>();
        elements.add(textElement);
        textElement.put("type", "mrkdwn");
        textElement.put("text", "*" + new LocalizedEnum("SchedulerText", (Enum)trigger).toString() + "*");
        HashMap<String, Object> mainBlock = new HashMap<String, Object>();
        blocks.add(mainBlock);
        mainBlock.put("type", "section");
        HashMap<String, Object> textSection = new HashMap<String, Object>();
        mainBlock.put("text", textSection);
        textSection.put("type", "mrkdwn");
        StringBuilder sectionText = new StringBuilder();
        if (properties != null) {
            for (String property : properties.keySet()) {
                for (String propertyValue : properties.get(property)) {
                    if (sectionText.length() > 0) {
                        sectionText.append("\n");
                    }
                    sectionText.append("*").append(property).append("*: ").append(propertyValue);
                }
            }
        }
        Object text = sectionText.length() > 3000 ? sectionText.substring(0, 2997) + "..." : sectionText.toString();
        textSection.put("text", text);
        HashMap<String, String> dividerBlock = new HashMap<String, String>();
        blocks.add(dividerBlock);
        dividerBlock.put("type", "divider");
        return payload;
    }

    private String sendWebhookNotification(final WebhookNotificationRule notificationRule, JobEvent trigger, JobDetailsModel jobDetailsModel, LinkedHashMap<String, String> additionalProperties, boolean async) throws IOException {
        Map<String, Set<String>> properties = this.populateNotificationProperties(trigger, jobDetailsModel, additionalProperties);
        Map<String, Object> payload = null;
        switch (notificationRule.getWebhookPlatform()) {
            case SLACK: {
                payload = this.generateSlackPayload(trigger, properties);
                break;
            }
            case DISCORD: {
                payload = this.generateDiscordPayload(trigger, properties);
                break;
            }
            case MICROSOFT_TEAMS: {
                payload = this.generateTeamsPayload(trigger, properties);
            }
        }
        if (payload != null) {
            final Entity entity = Entity.json(payload);
            final String[] serverResponse = new String[]{null};
            final Map<String, Object> finalPayload = payload;
            Thread notifyThread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try (Response response = null;){
                        javax.ws.rs.client.Client client;
                        javax.ws.rs.client.Client client2 = client = NotificationsHandler.this.getNotificationRuleClient(notificationRule.getId());
                        synchronized (client2) {
                            WebTarget webTarget = client.target(notificationRule.getUrl());
                            Invocation.Builder invocationBuilder = webTarget.request(new String[]{"application/json"});
                            client.property("Content-Length", (Object)entity.toString().getBytes(StandardCharsets.UTF_8).length);
                            response = invocationBuilder.post(entity);
                            if (response.getStatus() != 200 && response.getStatus() != 204) {
                                String message = (String)response.readEntity(String.class);
                                LOGGER.warn("Cannot send notification, status " + response.getStatus() + ", message " + message);
                                LOGGER.warn("Payload: " + SerializationUtils.toJson((Object)finalPayload));
                                serverResponse[0] = message;
                                notificationRule.getStatus().setError(NotificationsHandler.this.iu.getFormattedString("NotificationRule.CannotSendNotification", (Object)message));
                            } else {
                                notificationRule.getStatus().resetOkMessage(NotificationsHandler.this.iu.getString("NotificationRule.NotificationSent"));
                            }
                        }
                    }
                    ResponseCache.getInstance().resetKeyId(CacheKey.NOTIFICATION_RULES, "");
                }
            });
            notifyThread.setName("Automate - Notify");
            notifyThread.start();
            if (async) {
                return "async";
            }
            try {
                notifyThread.join();
            }
            catch (InterruptedException e) {
                notifyThread.interrupt();
                Thread.currentThread().interrupt();
            }
            if (serverResponse[0] != null) {
                throw new IOException(serverResponse[0]);
            }
            return "";
        }
        throw new IOException("Notification method not implemented");
    }

    private String sendEmailNotification(EmailNotificationRule notificationRule, JobEvent trigger, JobDetailsModel jobDetailsModel, LinkedHashMap<String, String> additionalProperties, boolean async) throws IOException {
        Object message;
        Map<String, Set<String>> properties = this.populateNotificationProperties(trigger, jobDetailsModel, additionalProperties);
        String subject = String.valueOf(new LocalizedEnum("SchedulerText", (Enum)trigger)) + " - " + jobDetailsModel.getSettings().getName();
        if (notificationRule.getHtmlFormat().booleanValue()) {
            StringBuilder htmlEmailMessage = new StringBuilder("<!DOCTYPE html>\n<html>\n<style>table.notification, table.header {\n    font-family: arial, sans-serif;\n}\ntd.propertyName, td.notification {\n\tfont-weight: bold;\n}</style>\n<body>\n\n <p><table class=\"header\">\n    <tr>\n      <td>\n        <img width=\"24\" height=\"24\" src=\"" + Icons.getInstance().getIconUrl(this.getImageIconType(trigger)) + "\"/>\n      </td>\n      <td class=\"propertyName\">\n" + new LocalizedEnum("SchedulerText", (Enum)trigger).toString() + "\n      </td>\n    </tr>\n  </table></p>\n<table class=\"notification\">");
            if (properties != null) {
                for (String string : properties.keySet()) {
                    for (String propertyValue : properties.get(string)) {
                        htmlEmailMessage.append("<tr>\n<td class=\"propertyName\">").append(string).append(": </td>\n").append("<td>").append(propertyValue).append("</td>\n").append("</tr>");
                    }
                }
            }
            htmlEmailMessage.append("</table>\n</body>\n</html>");
            message = htmlEmailMessage.toString();
        } else {
            message = String.valueOf(new LocalizedEnum("SchedulerText", (Enum)trigger)) + "\n\n";
            if (properties != null) {
                for (String property : properties.keySet()) {
                    for (String propertyValue : properties.get(property)) {
                        message = (String)message + property + ": " + propertyValue + "\n";
                    }
                }
            }
        }
        AtomicReference emailSendException = new AtomicReference();
        String finalMessage = message;
        String string = notificationRule.getTo().replace("{job_submitted_by}", jobDetailsModel.getSettings().getSubmittedBy());
        String finalCcAddress = notificationRule.getCc().replace("{job_submitted_by}", jobDetailsModel.getSettings().getSubmittedBy());
        SmtpEmail smtpEmail = new SmtpEmail(notificationRule);
        smtpEmail.setType(EmailType.NOTIFICATION);
        smtpEmail.setTo(string);
        smtpEmail.setCc(finalCcAddress);
        smtpEmail.setSubject(subject);
        smtpEmail.setMessage(finalMessage);
        smtpEmail.setHtmlFormat(notificationRule.getHtmlFormat());
        Thread notifyThread = new Thread(() -> {
            try {
                Future<SmtpEmail> future = this.schedulerApplication.getThirdPartyServiceResource().submitEmail(smtpEmail);
                SmtpEmail smtpEmailResult = future.get();
                if (smtpEmailResult.getState() == EmailState.SENT) {
                    notificationRule.getStatus().resetOkMessage(this.iu.getString("NotificationRule.NotificationSent"));
                } else {
                    String statusMessage = String.valueOf(smtpEmailResult.getStatus().getCode()) + ": " + smtpEmailResult.getStatus().getMessage();
                    LOGGER.warn("Could not send email notification, " + statusMessage);
                    notificationRule.getStatus().setError(this.iu.getFormattedString("NotificationRule.CouldNotSendEmailNotification", (Object)statusMessage));
                    emailSendException.set(new IOException(notificationRule.getStatus().getMessage()));
                }
            }
            catch (Exception e) {
                LOGGER.warn("Error waiting for email to send", (Throwable)e);
                notificationRule.getStatus().setError(this.iu.getFormattedString("NotificationRule.ErrorWaitingForEmail", (Object)ExceptionUtils.getExceptionPrintableMessage((Throwable)e)));
                emailSendException.set(e);
            }
        });
        notifyThread.setName("Automate - Notify");
        notifyThread.start();
        if (async) {
            return "async";
        }
        try {
            notifyThread.join();
        }
        catch (InterruptedException e) {
            notifyThread.interrupt();
            Thread.currentThread().interrupt();
        }
        if (emailSendException.get() != null) {
            throw new IOException((Throwable)emailSendException.get());
        }
        if (!finalCcAddress.isEmpty()) {
            return this.iu.getFormattedString("JobResource.NotificationSentTo", new Object[]{string, finalCcAddress});
        }
        return this.iu.getFormattedString("JobResource.NotificationSentTo", (Object)string);
    }
}

