/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.utils;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.function.Consumer;

public class ProcessExecutor {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ProcessExecutor.class);
    private final ProcessBuilder processBuilder;
    private Consumer<String> outputConsumer;
    private Consumer<String> errorConsumer;

    public ProcessExecutor(String ... command) {
        this.processBuilder = new ProcessBuilder(command);
    }

    public Process start() throws IOException {
        LOGGER.info("Starting new process with command: " + String.join((CharSequence)" ", this.processBuilder.command()));
        Process process = this.processBuilder.start();
        if (this.outputConsumer != null) {
            Thread outputReaderThread = new Thread(new StreamReader(process.getInputStream(), this.outputConsumer));
            outputReaderThread.setName("Process Output Reader");
            outputReaderThread.start();
        }
        if (this.errorConsumer != null) {
            Thread errorReaderThread = new Thread(new StreamReader(process.getErrorStream(), this.errorConsumer));
            errorReaderThread.setName("Process Error Reader");
            errorReaderThread.start();
        }
        return process;
    }

    public ProcessBuilder getProcessBuilder() {
        return this.processBuilder;
    }

    public void setOutputConsumer(Consumer<String> outputConsumer) {
        this.outputConsumer = outputConsumer;
    }

    public void setErrorConsumer(Consumer<String> errorConsumer) {
        this.errorConsumer = errorConsumer;
    }

    private static class StreamReader
    implements Runnable {
        private final InputStream inputStream;
        private final Consumer<String> consumer;

        public StreamReader(InputStream inputStream, Consumer<String> consumer) {
            this.inputStream = inputStream;
            this.consumer = consumer;
        }

        @Override
        public void run() {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.inputStream));){
                String line;
                while ((line = reader.readLine()) != null) {
                    this.consumer.accept(line);
                }
            }
            catch (IOException e) {
                LOGGER.error("Error reading lines from inputStream", (Throwable)e);
            }
        }
    }
}

