/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.utils;

import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.persistance.application.ApplicationDao;
import com.nuix.automate.scheduler.security.oidc.microsoft.MicrosoftUserService;
import com.nuix.automate.scheduler.security.thirdparty.SmtpServiceSession;
import com.nuix.automate.scheduler.security.thirdparty.ThirdPartyServiceSession;
import com.nuix.automate.scheduler.utils.LegalHoldParticipationCache;
import com.nuix.automate.scheduler.utils.TagsUtil;
import com.nuix.automate.utils.api.automatelicense.AutomateLicence;
import com.nuix.automate.utils.api.configuration.NetworkConfiguration;
import com.nuix.automate.utils.api.internal.automatelicense.AutomateLicenceModel;
import com.nuix.automate.utils.api.internal.permission.Permission;
import com.nuix.automate.utils.api.internal.permission.PermissionWrapper;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.apikey.ApiKey;
import com.nuix.automate.utils.models.api.apikey.ApiKeyWithSecret;
import com.nuix.automate.utils.models.api.client.Client;
import com.nuix.automate.utils.models.api.client.ClientPool;
import com.nuix.automate.utils.models.api.client.Matter;
import com.nuix.automate.utils.models.api.comment.UserComment;
import com.nuix.automate.utils.models.api.dataset.AzureStorageAccount;
import com.nuix.automate.utils.models.api.dataset.DataRepository;
import com.nuix.automate.utils.models.api.dataset.Dataset;
import com.nuix.automate.utils.models.api.engine.Engine;
import com.nuix.automate.utils.models.api.executionprofile.ExecutionProfile;
import com.nuix.automate.utils.models.api.filelibrary.FileLibrary;
import com.nuix.automate.utils.models.api.job.Job;
import com.nuix.automate.utils.models.api.job.Priority;
import com.nuix.automate.utils.models.api.legalhold.CustodianState;
import com.nuix.automate.utils.models.api.legalhold.LegalHoldParticipation;
import com.nuix.automate.utils.models.api.legalhold.LegalHoldRole;
import com.nuix.automate.utils.models.api.legalhold.LegalHoldState;
import com.nuix.automate.utils.models.api.notice.Notice;
import com.nuix.automate.utils.models.api.notice.NoticeComment;
import com.nuix.automate.utils.models.api.notice.NoticeEvent;
import com.nuix.automate.utils.models.api.notice.NoticeTemplate;
import com.nuix.automate.utils.models.api.notice.UserNotice;
import com.nuix.automate.utils.models.api.notificationrule.EmailNotificationRule;
import com.nuix.automate.utils.models.api.notificationrule.NotificationRule;
import com.nuix.automate.utils.models.api.nuixlicensesource.NuixLicenseSource;
import com.nuix.automate.utils.models.api.resourcepool.ResourcePool;
import com.nuix.automate.utils.models.api.schedule.Schedule;
import com.nuix.automate.utils.models.api.securitypolicy.Identifier;
import com.nuix.automate.utils.models.api.securitypolicy.SecurityPolicy;
import com.nuix.automate.utils.models.api.server.Server;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyDetails;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyService;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyUserCredential;
import com.nuix.automate.utils.models.api.userdatadir.UserDataDir;
import com.nuix.automate.utils.models.api.webhook.Webhook;
import com.nuix.automate.utils.models.api.workflowlibrary.Workflow;
import com.nuix.automate.utils.models.api.workflowlibrary.WorkflowLibrary;
import com.nuix.automate.utils.models.internal.engine.EngineModel;
import com.nuix.automate.utils.models.internal.executionprofile.ExecutionProfileModel;
import com.nuix.automate.utils.models.internal.job.JobDetailsModel;
import com.nuix.automate.utils.models.internal.job.JobModel;
import com.nuix.automate.utils.models.internal.nuixlicensesource.NuixLicenseSourceModel;
import com.nuix.automate.utils.models.internal.policy.PolicyInfoModel;
import com.nuix.automate.utils.models.internal.resourcepool.ResourcePoolModel;
import com.nuix.automate.utils.models.internal.user.LdapUserService;
import com.nuix.automate.utils.models.internal.user.OidcUserService;
import com.nuix.automate.utils.models.internal.user.RelativityUserImpersonationService;
import com.nuix.automate.utils.models.internal.user.UmsUserService;
import com.nuix.automate.utils.models.internal.user.UserService;
import com.nuix.automate.utils.security.policies.BuiltInPrincipalIdentifiers;
import com.nuix.automate.utils.security.policies.BuiltInScopeIdentifiers;
import com.nuix.automate.utils.security.policies.IdentifierType;
import com.nuix.automate.utils.utilization.DataSet;
import com.nuix.automate.utils.utilization.LegalHold;
import com.nuix.automate.utils.utilization.Operation;
import com.nuix.automate.utils.utilization.Session;
import com.nuix.automate.utils.utilization.Transfer;
import com.nuix.automate.utils.utilization.legacy.v1.BatchUtilizationModel;
import com.nuix.automate.utils.utilization.legacy.v1.JobUtilizationModel;
import com.nuix.automate.utils.workflow.StaticParameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;

public class SecurityPolicyUtil {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(SecurityPolicyUtil.class);
    private InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");
    ApplicationDao securityDao;
    Map<String, SecurityPolicy> policies;
    SchedulerApplication schedulerApplication;

    public SecurityPolicyUtil(SchedulerApplication schedulerApplication) {
        this.schedulerApplication = schedulerApplication;
    }

    public SecurityPolicyUtil(ApplicationDao securityDao, SchedulerApplication schedulerApplication) {
        this(schedulerApplication);
        this.securityDao = securityDao;
        this.policies = new ConcurrentHashMap<String, SecurityPolicy>();
        this.initializeFromConfiguration();
        if (securityDao != null) {
            this.initializeFromStore();
        }
    }

    public List<SecurityPolicy> getPolicies() {
        ArrayList<SecurityPolicy> result = new ArrayList<SecurityPolicy>();
        for (SecurityPolicy securityPolicy : this.policies.values()) {
            if ((securityPolicy.getId().equals("84884db3-ca7f-3f1a-068b-239374b82ba2") || securityPolicy.getName().equals("Default Policy") && securityPolicy.getDescription().equals("This policy allows any internal user to perform any action")) && (!securityPolicy.isHasWarnings() || securityPolicy.getWarnings() == null || securityPolicy.getWarnings().size() == 0)) {
                HashSet<String> warnings = new HashSet<String>();
                warnings.add(this.iu.getString("Security.Warning.UnmodifiedDefaultPolicy"));
                securityPolicy.setWarnings(warnings);
                securityPolicy.setHasWarnings(true);
            }
            result.add(new SecurityPolicy(securityPolicy));
        }
        return result;
    }

    public String policyChangesToString(SecurityPolicy originalSecurityPolicy, SecurityPolicy updatedSecurityPolicy) {
        String updatedScope;
        String originalScope;
        String updatedPermissions;
        String originalPermissions;
        String updatedPrincipals;
        String originalPrincipals;
        StringBuilder details = new StringBuilder();
        if (originalSecurityPolicy.getName() == null || !originalSecurityPolicy.getName().equals(updatedSecurityPolicy.getName())) {
            if (details.length() > 0) {
                details.append("\n");
            }
            details.append(this.iu.getFormattedString("SecurityPolicyUtil.Details.Name", (Object)updatedSecurityPolicy.getName()));
        }
        if (originalSecurityPolicy.getDescription() == null || !originalSecurityPolicy.getDescription().equals(updatedSecurityPolicy.getDescription())) {
            if (details.length() > 0) {
                details.append("\n");
            }
            details.append(this.iu.getFormattedString("SecurityPolicyUtil.Details.Description", (Object)updatedSecurityPolicy.getDescription()));
        }
        if (originalSecurityPolicy.getEnabled() == null || !originalSecurityPolicy.getEnabled().equals(updatedSecurityPolicy.getEnabled())) {
            if (details.length() > 0) {
                details.append("\n");
            }
            details.append(this.iu.getFormattedString("SecurityPolicyUtil.Details.Enabled", (Object)updatedSecurityPolicy.getEnabled()));
        }
        if (!(originalPrincipals = this.identifiersToString(originalSecurityPolicy.getPrincipals(), "\t", "\n")).equals(updatedPrincipals = this.identifiersToString(updatedSecurityPolicy.getPrincipals(), "\t", "\n"))) {
            if (details.length() > 0) {
                details.append("\n");
            }
            details.append(this.iu.getFormattedString("SecurityPolicyUtil.Details.Principals", (Object)("\n" + updatedPrincipals)));
        }
        if (!(originalPermissions = this.permissionsToString(originalSecurityPolicy.getPermissions(), "\t", "\n")).equals(updatedPermissions = this.permissionsToString(updatedSecurityPolicy.getPermissions(), "\t", "\n"))) {
            if (details.length() > 0) {
                details.append("\n");
            }
            details.append(this.iu.getFormattedString("SecurityPolicyUtil.Details.Permissions", (Object)("\n" + updatedPermissions)));
        }
        if (!(originalScope = this.identifiersToString(originalSecurityPolicy.getScope(), "\t", "\n")).equals(updatedScope = this.identifiersToString(updatedSecurityPolicy.getScope(), "\t", "\n"))) {
            if (details.length() > 0) {
                details.append("\n");
            }
            details.append(this.iu.getFormattedString("SecurityPolicyUtil.Details.Scope", (Object)("\n" + updatedScope)));
        }
        return details.toString();
    }

    public String policyToString(SecurityPolicy securityPolicy) {
        StringBuilder details = new StringBuilder();
        if (securityPolicy.getName() != null) {
            if (details.length() > 0) {
                details.append("\n");
            }
            details.append(this.iu.getFormattedString("SecurityPolicyUtil.Details.Name", (Object)securityPolicy.getName()));
        }
        if (securityPolicy.getDescription() != null) {
            if (details.length() > 0) {
                details.append("\n");
            }
            details.append(this.iu.getFormattedString("SecurityPolicyUtil.Details.Description", (Object)securityPolicy.getDescription()));
        }
        if (securityPolicy.getEnabled() != null) {
            if (details.length() > 0) {
                details.append("\n");
            }
            details.append(this.iu.getFormattedString("SecurityPolicyUtil.Details.Enabled", (Object)securityPolicy.getEnabled()));
        }
        String originalPrincipals = this.identifiersToString(securityPolicy.getPrincipals(), "\t", "\n");
        if (details.length() > 0) {
            details.append("\n");
        }
        details.append(this.iu.getFormattedString("SecurityPolicyUtil.Details.Principals", (Object)("\n" + originalPrincipals)));
        String originalPermissions = this.permissionsToString(securityPolicy.getPermissions(), "\t", "\n");
        if (details.length() > 0) {
            details.append("\n");
        }
        details.append(this.iu.getFormattedString("SecurityPolicyUtil.Details.Permissions", (Object)("\n" + originalPermissions)));
        String originalScope = this.identifiersToString(securityPolicy.getScope(), "\t", "\n");
        if (details.length() > 0) {
            details.append("\n");
        }
        details.append(this.iu.getFormattedString("SecurityPolicyUtil.Details.Scope", (Object)("\n" + originalScope)));
        return details.toString();
    }

    private String identifiersToString(Set<Identifier> identifiers, String prefix, String separator) {
        StringBuilder result = new StringBuilder();
        for (Identifier identifier : identifiers) {
            if (result.length() > 0) {
                result.append(separator);
            }
            result.append(prefix);
            String identifierFriendlyName = this.schedulerApplication.getUtilResource().resolveId(identifier.getIdentifierName(), identifier.getIdentifierType());
            if (identifierFriendlyName != null) {
                result.append(identifierFriendlyName);
            } else {
                result.append(identifier.getIdentifierName());
            }
            result.append(" (");
            result.append(identifier.getIdentifierType());
            result.append(")");
            if (identifierFriendlyName == null) continue;
            result.append(" ");
            result.append(identifier.getIdentifierName());
        }
        return result.toString();
    }

    private String permissionsToString(Set<Permission> permissions, String prefix, String separator) {
        StringBuilder result = new StringBuilder();
        for (Permission permission : permissions) {
            if (result.length() > 0) {
                result.append(separator);
            }
            result.append(prefix);
            result.append(permission.name());
        }
        return result.toString();
    }

    public SecurityPolicy getPolicy(String policyId) {
        return this.policies.get(policyId);
    }

    public NotificationRule setUserPermissions(BearerUser user, NotificationRule notificationRule) {
        NotificationRule response = notificationRule.clone();
        response.setUserPermissions(new HashSet());
        HashSet<Identifier> scopeIdentifiers = new HashSet<Identifier>();
        scopeIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        scopeIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_NOTIFICATION_RULES));
        scopeIdentifiers.add(new Identifier(IdentifierType.NOTIFICATION_RULE_ID, notificationRule.getId()));
        response.getUserPermissions().addAll(this.getPermissions(user.getIdentifiers(), scopeIdentifiers));
        if (response.getUserPermissions().contains(Permission.VIEW_LIMITED) && !response.getUserPermissions().contains(Permission.VIEW)) {
            response = response.cloneLimited();
            response.getUserPermissions().add(Permission.VIEW);
        }
        if (response instanceof EmailNotificationRule) {
            ((EmailNotificationRule)response).setEmailCounter(SmtpServiceSession.getInitiatorEmailCounter(response.getId()));
        }
        return response;
    }

    public AutomateLicence setUserPermissions(BearerUser user, AutomateLicenceModel rampivaLicense) {
        AutomateLicence response = new AutomateLicence(rampivaLicense);
        response.setUserPermissions(new HashSet());
        HashSet<Identifier> scopeIdentifiers = new HashSet<Identifier>();
        scopeIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        scopeIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.AUTOMATE_LICENCE));
        response.getUserPermissions().addAll(this.getPermissions(user.getIdentifiers(), scopeIdentifiers));
        if (response.getUserPermissions().contains(Permission.VIEW_LIMITED) && !response.getUserPermissions().contains(Permission.VIEW)) {
            response = response.cloneLimited();
            response.getUserPermissions().add(Permission.VIEW);
        }
        return response;
    }

    public NetworkConfiguration setUserPermissions(BearerUser user, NetworkConfiguration networkConfiguration) {
        NetworkConfiguration response = networkConfiguration.clone();
        response.setUserPermissions(new HashSet());
        HashSet<Identifier> scopeIdentifiers = new HashSet<Identifier>();
        scopeIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        scopeIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.NETWORK_CONFIGURATION));
        response.getUserPermissions().addAll(this.getPermissions(user.getIdentifiers(), scopeIdentifiers));
        if (response.getUserPermissions().contains(Permission.VIEW_LIMITED) && !response.getUserPermissions().contains(Permission.VIEW)) {
            response = response.cloneLimited();
            response.getUserPermissions().add(Permission.VIEW);
        }
        return response;
    }

    public UserDataDir setUserPermissions(BearerUser user, UserDataDir userDataDir) {
        UserDataDir response = userDataDir.clone();
        response.setUserPermissions(new HashSet());
        HashSet<Identifier> scopeIdentifiers = new HashSet<Identifier>();
        scopeIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        scopeIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.USER_DATA_DIR));
        response.getUserPermissions().addAll(this.getPermissions(user.getIdentifiers(), scopeIdentifiers));
        if (response.getUserPermissions().contains(Permission.VIEW_LIMITED) && !response.getUserPermissions().contains(Permission.VIEW)) {
            response = response.cloneLimited();
            response.getUserPermissions().add(Permission.VIEW);
        }
        return response;
    }

    public ExecutionProfile setUserPermissions(BearerUser user, ExecutionProfileModel executionProfileModel) {
        ExecutionProfile response = new ExecutionProfile(executionProfileModel);
        Map workflowParameters = response.getWorkflowParameters();
        for (String parameterName : workflowParameters.keySet()) {
            StaticParameter staticParameter = new StaticParameter(parameterName, "");
            if (!staticParameter.isEffectiveTypeMaskedOrProtected()) continue;
            workflowParameters.put(parameterName, null);
        }
        response.setUserPermissions(new HashSet());
        HashSet<Identifier> scopeIdentifiers = new HashSet<Identifier>();
        scopeIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        scopeIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_EXECUTION_PROFILES));
        scopeIdentifiers.add(new Identifier(IdentifierType.EXECUTION_PROFILE_ID, executionProfileModel.getId()));
        response.getUserPermissions().addAll(this.getPermissions(user.getIdentifiers(), scopeIdentifiers));
        if (response.getUserPermissions().contains(Permission.VIEW_LIMITED) && !response.getUserPermissions().contains(Permission.VIEW)) {
            response = response.cloneLimited();
            response.getUserPermissions().add(Permission.VIEW);
        }
        if (executionProfileModel.getReadOnly()) {
            response.getUserPermissions().remove(Permission.MODIFY);
            response.getUserPermissions().remove(Permission.MODIFY_CHILDREN);
        }
        return response;
    }

    public ApiKey setUserPermissions(BearerUser user, ApiKey apiKey) {
        ApiKey response = apiKey.clone();
        response.setUserPermissions(new HashSet());
        HashSet<Object> scopeIdentifiers = new HashSet<Identifier>();
        scopeIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_API_KEYS));
        response.getUserPermissions().addAll(this.getPermissions(user.getIdentifiers(), scopeIdentifiers));
        if (user.getIdentifier().equals((Object)apiKey.getUser())) {
            scopeIdentifiers = new HashSet();
            scopeIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.API_KEYS));
            response.getUserPermissions().addAll(this.getPermissions(user.getIdentifiers(), scopeIdentifiers));
        }
        if (response.getUserPermissions().contains(Permission.VIEW_LIMITED) && !response.getUserPermissions().contains(Permission.VIEW)) {
            response = response.cloneLimited();
            response.getUserPermissions().add(Permission.VIEW);
        }
        return response;
    }

    public ApiKeyWithSecret setUserPermissions(BearerUser user, ApiKeyWithSecret apiKey) {
        ApiKeyWithSecret response = apiKey.clone();
        response.setUserPermissions(new HashSet());
        HashSet<Object> scopeIdentifiers = new HashSet<Identifier>();
        scopeIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_API_KEYS));
        response.getUserPermissions().addAll(this.getPermissions(user.getIdentifiers(), scopeIdentifiers));
        if (user.getIdentifier().equals((Object)apiKey.getUser())) {
            scopeIdentifiers = new HashSet();
            scopeIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.API_KEYS));
            response.getUserPermissions().addAll(this.getPermissions(user.getIdentifiers(), scopeIdentifiers));
        }
        if (response.getUserPermissions().contains(Permission.VIEW_LIMITED) && !response.getUserPermissions().contains(Permission.VIEW)) {
            response = response.cloneLimited();
            response.getUserPermissions().add(Permission.VIEW);
        }
        return response;
    }

    public Webhook setUserPermissions(BearerUser user, Webhook webhook) {
        Webhook response = webhook.clone();
        response.setUserPermissions(new HashSet());
        HashSet<Identifier> scopeIdentifiers = new HashSet<Identifier>();
        scopeIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.WEBHOOKS));
        response.getUserPermissions().addAll(this.getPermissions(user.getIdentifiers(), scopeIdentifiers));
        if (response.getUserPermissions().contains(Permission.VIEW_LIMITED) && !response.getUserPermissions().contains(Permission.VIEW)) {
            response = response.cloneLimited();
            response.getUserPermissions().add(Permission.VIEW);
        }
        return response;
    }

    public UserService setUserPermissions(BearerUser user, UserService userService) {
        UserService response = userService.clone();
        response.setUserPermissions(new HashSet());
        HashSet<Identifier> scopeIdentifiers = new HashSet<Identifier>();
        scopeIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        scopeIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.USER_SERVICES));
        scopeIdentifiers.add(new Identifier(IdentifierType.USER_SERVICE_ID, userService.getId()));
        response.getUserPermissions().addAll(this.getPermissions(user.getIdentifiers(), scopeIdentifiers));
        if (response instanceof LdapUserService) {
            ((LdapUserService)response).setServiceAccountPassword(null);
        }
        if (response instanceof UmsUserService) {
            ((UmsUserService)response).setServiceAccountPassword(null);
        }
        if (response instanceof OidcUserService) {
            OidcUserService oidcResponse = (OidcUserService)response;
            oidcResponse.setClientSecret(null);
        }
        if (response instanceof MicrosoftUserService) {
            MicrosoftUserService purviewResponse = (MicrosoftUserService)response;
            purviewResponse.setRefreshToken(null);
        }
        if (response instanceof RelativityUserImpersonationService) {
            RelativityUserImpersonationService relativityUserImpersonationService = (RelativityUserImpersonationService)response;
            relativityUserImpersonationService.setSecret(null);
        }
        if (response.getUserPermissions().contains(Permission.VIEW_LIMITED) && !response.getUserPermissions().contains(Permission.VIEW)) {
            response = response.cloneLimited();
            response.getUserPermissions().add(Permission.VIEW);
        }
        if (userService.getReadOnly()) {
            response.getUserPermissions().remove(Permission.MODIFY);
            response.getUserPermissions().remove(Permission.MODIFY_CHILDREN);
        }
        return response;
    }

    public Set<Permission> getNoticeDatasetPermissions(BearerUser user, Dataset dataset) {
        NoticeEvent noticeEvent;
        HashSet<Permission> permissions = new HashSet<Permission>();
        if (dataset.getNoticeEventId() != null && (noticeEvent = this.schedulerApplication.getSchedulerConfigurationDao().getNoticeEvent(dataset.getNoticeEventId())) != null) {
            permissions.addAll(this.setUserPermissions(user, noticeEvent).getUserPermissions());
        }
        return permissions;
    }

    public DataRepository setUserPermissions(BearerUser user, DataRepository dataRepository) {
        DataRepository response = dataRepository.clone();
        response.setUserPermissions(new HashSet());
        HashSet<Identifier> scopeIdentifiers = new HashSet<Identifier>();
        scopeIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        scopeIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_DATA_REPOSITORIES));
        scopeIdentifiers.add(new Identifier(IdentifierType.DATA_REPOSITORY_ID, dataRepository.getId()));
        response.getUserPermissions().addAll(this.getPermissions(user.getIdentifiers(), scopeIdentifiers));
        AzureStorageAccount azureStorageAccount = response.getAzureStorageAccount();
        if (azureStorageAccount != null) {
            azureStorageAccount.setAccountKey(null);
        }
        if (response.getUserPermissions().contains(Permission.VIEW_LIMITED) && !response.getUserPermissions().contains(Permission.VIEW)) {
            response = response.cloneLimited();
            response.getUserPermissions().add(Permission.VIEW);
        }
        return response;
    }

    public ThirdPartyDetails setUserPermissions(BearerUser user, ThirdPartyServiceSession<?, ?> client) {
        ThirdPartyDetails response = new ThirdPartyDetails(client.getServiceId());
        response.setService(this.setUserPermissions(user, client.getService().clone()));
        response.setStatus(client.getStatus().clone());
        response.setLog(new ArrayList(client.getLog().getLog()));
        Set servicePermissions = response.getUserPermissions();
        if (response.getUserPermissions().contains(Permission.VIEW_LIMITED)) {
            response.setLog(new ArrayList());
            response.setStatus(response.getStatus().cloneLimited());
        }
        if (servicePermissions.contains(Permission.VIEW) || servicePermissions.contains(Permission.VIEW_LIMITED)) {
            response.setUserCredential(this.setUserPermissions(user, (ThirdPartyUserCredential)client.getUserCredential()));
        } else {
            response.setUserCredential(null);
        }
        return response;
    }

    public ThirdPartyService setUserPermissions(BearerUser user, ThirdPartyService thirdPartyService) {
        ThirdPartyService response = thirdPartyService.clone();
        HashSet<Permission> userPermissions = new HashSet<Permission>();
        response.setUserPermissions(userPermissions);
        HashSet<Identifier> scopeIdentifiers = new HashSet<Identifier>();
        scopeIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        scopeIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_THIRD_PARTY_SERVICES));
        scopeIdentifiers.add(new Identifier(IdentifierType.THIRD_PARTY_SERVICE_ID, response.getId()));
        userPermissions.addAll(this.getPermissions(user.getIdentifiers(), scopeIdentifiers));
        if (response.getUserPermissions().contains(Permission.VIEW)) {
            response.getUserPermissions().remove(Permission.VIEW_LIMITED);
        }
        if (response.getUserPermissions().contains(Permission.VIEW_LIMITED) && !response.getUserPermissions().contains(Permission.VIEW)) {
            response = response.cloneLimited();
            response.getUserPermissions().add(Permission.VIEW);
        }
        if (thirdPartyService.getReadOnly()) {
            response.getUserPermissions().remove(Permission.MODIFY);
            response.getUserPermissions().remove(Permission.MODIFY_CHILDREN);
        }
        return response;
    }

    public ThirdPartyUserCredential setUserPermissions(BearerUser user, ThirdPartyUserCredential thirdPartyUserCredential) {
        return thirdPartyUserCredential.cloneNonSensitive();
    }

    public com.nuix.automate.utils.models.api.legalhold.LegalHold setUserPermissions(BearerUser user, com.nuix.automate.utils.models.api.legalhold.LegalHold legalHold) {
        com.nuix.automate.utils.models.api.legalhold.LegalHold response = legalHold.clone();
        HashSet<Permission> permissions = new HashSet<Permission>();
        HashSet<Identifier> scopeIdentifiers = new HashSet<Identifier>();
        scopeIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.LEGAL_HOLDS));
        HashSet<Identifier> parentScopeIdentifiers = new HashSet<Identifier>();
        parentScopeIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_CLIENTS));
        parentScopeIdentifiers.add(new Identifier(IdentifierType.CLIENT_ID, response.getClientId()));
        parentScopeIdentifiers.add(new Identifier(IdentifierType.MATTER_ID, response.getMatterId()));
        Matter matter = this.schedulerApplication.getClientResource().getMatter(response.getMatterId());
        if (matter != null) {
            parentScopeIdentifiers.add(new Identifier(IdentifierType.CLIENT_ID_MATTERS, matter.getClientId()));
        }
        for (String clientPoolId : this.schedulerApplication.getClientPoolResource().getPoolsContainingClientId(response.getClientId())) {
            parentScopeIdentifiers.add(new Identifier(IdentifierType.CLIENT_POOL_ID, clientPoolId));
            parentScopeIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_CLIENT_POOLS));
        }
        Set<Permission> legalHoldPermissions = this.getPermissions(user.getIdentifiers(), scopeIdentifiers);
        Set<Permission> parentPermissions = this.getPermissions(user.getIdentifiers(), parentScopeIdentifiers);
        boolean isUserReleased = true;
        if (legalHold.getSilent() != Boolean.TRUE) {
            List<LegalHoldParticipation> currentUserParticipations = LegalHoldParticipationCache.getInstance().getUserLegalHoldParticipations(legalHold.getId(), user.getId());
            for (LegalHoldParticipation participationModel : currentUserParticipations) {
                if (participationModel.getRole() == LegalHoldRole.ADMINISTRATOR && com.nuix.automate.utils.models.api.legalhold.LegalHold.manageStates.contains(legalHold.getState())) {
                    legalHoldPermissions.add(Permission.MANAGE);
                }
                if (participationModel.getRole() != LegalHoldRole.CUSTODIAN || !com.nuix.automate.utils.models.api.legalhold.LegalHold.replyStates.contains(legalHold.getState())) continue;
                legalHoldPermissions.add(Permission.RESPOND);
                if (participationModel.getCustodianState() == CustodianState.RELEASED) continue;
                isUserReleased = false;
            }
        }
        if (parentPermissions.contains(Permission.VIEW) && legalHoldPermissions.contains(Permission.VIEW)) {
            permissions.add(Permission.VIEW);
        }
        if (legalHoldPermissions.contains(Permission.MANAGE)) {
            permissions.add(Permission.VIEW);
            permissions.add(Permission.MANAGE);
        }
        if (parentPermissions.contains(Permission.VIEW_SENSITIVE) && legalHoldPermissions.contains(Permission.VIEW_SENSITIVE)) {
            permissions.add(Permission.VIEW_SENSITIVE);
        }
        if ((parentPermissions.contains(Permission.MODIFY) || parentPermissions.contains(Permission.MODIFY_CHILDREN)) && legalHoldPermissions.contains(Permission.MODIFY)) {
            permissions.add(Permission.MODIFY);
        }
        if ((parentPermissions.contains(Permission.MODIFY) || parentPermissions.contains(Permission.MODIFY_CHILDREN)) && legalHoldPermissions.contains(Permission.CREATE)) {
            permissions.add(Permission.CREATE);
        }
        if (legalHoldPermissions.contains(Permission.RESPOND)) {
            permissions.add(Permission.RESPOND);
        }
        response.setUserPermissions(permissions);
        if (!permissions.contains(Permission.VIEW)) {
            response.setCreatedBy(null);
            response.setCreatedDate(null);
            response.setLastChangedBy(null);
            response.setLastChangedDate(null);
            response.setSchedulerUrl(null);
            response.setDataRepositoryId(null);
            response.setSmtpServerId(null);
            response.setEnableLoginLinks(null);
            response.setTriggerConfigurations(null);
            response.setParameters(null);
            response.setStatus(null);
            response.setEmailCounter(null);
            response.setHoldNoticeConfiguration(null);
            response.setRecurringNoticeConfiguration(null);
            response.setReleaseNoticeConfiguration(null);
            response.setSurveyNoticeConfigurations(null);
            if (isUserReleased && permissions.contains(Permission.RESPOND)) {
                response.setState(LegalHoldState.RELEASED);
            }
        }
        if (response.getUserPermissions().contains(Permission.VIEW_LIMITED) && !response.getUserPermissions().contains(Permission.VIEW)) {
            response = response.cloneLimited();
            response.getUserPermissions().add(Permission.VIEW);
        }
        if (!Boolean.TRUE.equals(response.getSilent())) {
            response.setEmailCounter(SmtpServiceSession.getInitiatorEmailCounter(response.getId()));
        }
        return response;
    }

    public Notice setUserPermissions(BearerUser user, Notice noticeModel) {
        Notice response = noticeModel.clone();
        HashSet permissions = new HashSet();
        com.nuix.automate.utils.models.api.legalhold.LegalHold legalHold = this.schedulerApplication.getLegalHoldResource().getLegalHold(noticeModel.getLegalHoldId());
        if (legalHold != null) {
            Set legalHoldPermissions = this.setUserPermissions(user, legalHold).getUserPermissions();
            permissions.addAll(legalHoldPermissions);
        }
        if (permissions.contains(Permission.RESPOND)) {
            permissions.remove(Permission.MANAGE);
        }
        response.setUserPermissions(permissions);
        if (!response.getUserPermissions().contains(Permission.VIEW_LIMITED) || !response.getUserPermissions().contains(Permission.VIEW)) {
            // empty if block
        }
        return response;
    }

    public UserNotice setUserPermissions(BearerUser user, UserNotice userNotice) {
        com.nuix.automate.utils.models.api.legalhold.LegalHold legalHold;
        UserNotice response = userNotice.clone();
        HashSet permissions = new HashSet();
        Notice noticeModel = this.schedulerApplication.getNoticeResource().getNotice(userNotice.getNoticeId());
        if (noticeModel != null && (legalHold = this.schedulerApplication.getLegalHoldResource().getLegalHold(noticeModel.getLegalHoldId())) != null) {
            Set legalHoldPermissions = this.setUserPermissions(user, legalHold).getUserPermissions();
            permissions.addAll(legalHoldPermissions);
            permissions.remove(Permission.MODIFY);
        }
        if (!response.getUserId().equals(user.getId())) {
            permissions.remove(Permission.RESPOND);
        }
        if (permissions.contains(Permission.RESPOND)) {
            permissions.remove(Permission.MANAGE);
        }
        response.setUserPermissions(permissions);
        if (!response.getUserPermissions().contains(Permission.VIEW_LIMITED) || !response.getUserPermissions().contains(Permission.VIEW)) {
            // empty if block
        }
        return response;
    }

    public NoticeEvent setUserPermissions(BearerUser user, NoticeEvent noticeEvent) {
        com.nuix.automate.utils.models.api.legalhold.LegalHold legalHold;
        NoticeEvent response = noticeEvent.clone();
        HashSet permissions = new HashSet();
        Notice noticeModel = this.schedulerApplication.getNoticeResource().getNotice(noticeEvent.getNoticeId());
        if (noticeModel != null && (legalHold = this.schedulerApplication.getLegalHoldResource().getLegalHold(noticeModel.getLegalHoldId())) != null) {
            Set legalHoldPermissions = this.setUserPermissions(user, legalHold).getUserPermissions();
            permissions.addAll(legalHoldPermissions);
            permissions.remove(Permission.MODIFY);
        }
        if (!response.getUserId().equals(user.getId())) {
            permissions.remove(Permission.RESPOND);
        }
        if (permissions.contains(Permission.RESPOND)) {
            permissions.remove(Permission.MANAGE);
        }
        if (!response.getUserPermissions().contains(Permission.VIEW_LIMITED) || !response.getUserPermissions().contains(Permission.VIEW)) {
            // empty if block
        }
        response.setUserPermissions(permissions);
        return response;
    }

    public NoticeComment setUserPermissions(BearerUser user, NoticeComment noticeComment) {
        NoticeComment response = noticeComment.clone();
        HashSet<Permission> permissions = new HashSet<Permission>();
        NoticeEvent noticeEvent = this.schedulerApplication.getSchedulerConfigurationDao().getNoticeEvent(noticeComment.getNoticeEventId());
        if (noticeEvent != null) {
            Set noticeEventPermissions = this.setUserPermissions(user, noticeEvent).getUserPermissions();
            permissions.addAll(noticeEventPermissions);
        }
        if (noticeComment.getUserId().equals(user.getId())) {
            permissions.add(Permission.MODIFY);
        }
        response.setUserPermissions(permissions);
        if (!response.getUserPermissions().contains(Permission.VIEW_LIMITED) || !response.getUserPermissions().contains(Permission.VIEW)) {
            // empty if block
        }
        return response;
    }

    public UserComment setUserPermissions(BearerUser user, UserComment userComment, Set<Permission> objectPermissions) {
        UserComment response = userComment.clone();
        HashSet<Permission> permissions = new HashSet<Permission>(objectPermissions);
        if (!userComment.getUserId().equals(user.getId())) {
            permissions.remove(Permission.MODIFY);
        }
        response.setUserPermissions(permissions);
        response.setViewedByUser(Boolean.valueOf(response.getViewedByUserIds().contains(user.getId())));
        if (!response.getUserPermissions().contains(Permission.VIEW_LIMITED) || !response.getUserPermissions().contains(Permission.VIEW)) {
            // empty if block
        }
        return response;
    }

    public UserComment setUserPermissions(BearerUser user, UserComment userComment) {
        HashSet<Permission> objectPermissions = new HashSet<Permission>();
        switch (userComment.getObjectType()) {
            case JOB: {
                JobDetailsModel jobDetails = this.schedulerApplication.getJobResource().getJobDetailsModel(userComment.getObjectId());
                if (jobDetails == null) break;
                objectPermissions.addAll(this.setUserPermissions(user, jobDetails.getSettings()).getUserPermissions());
            }
        }
        return this.setUserPermissions(user, userComment, objectPermissions);
    }

    public NoticeTemplate setUserPermissions(BearerUser user, NoticeTemplate noticeTemplate) {
        NoticeTemplate response = noticeTemplate.clone();
        response.setUserPermissions(new HashSet());
        HashSet<Identifier> scopeIdentifiers = new HashSet<Identifier>();
        scopeIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        scopeIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_NOTICE_TEMPLATES));
        scopeIdentifiers.add(new Identifier(IdentifierType.NOTICE_TEMPLATE_ID, noticeTemplate.getId()));
        response.getUserPermissions().addAll(this.getPermissions(user.getIdentifiers(), scopeIdentifiers));
        if (response.getUserPermissions().contains(Permission.VIEW_LIMITED) && !response.getUserPermissions().contains(Permission.VIEW)) {
            response = response.cloneLimited();
            response.getUserPermissions().add(Permission.VIEW);
        }
        return response;
    }

    public Schedule setUserPermissions(BearerUser user, Schedule schedule) {
        Schedule response = schedule.clone();
        response.setUserPermissions(new HashSet());
        HashSet<Identifier> submittedJobIdentifiers = new HashSet<Identifier>();
        if (schedule.getSameMatterAsTriggerMatter() != null && schedule.getSameMatterAsTriggerMatter().booleanValue()) {
            submittedJobIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_CLIENTS));
        } else if (schedule.getClientId() == null) {
            submittedJobIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.UNASSIGNED_CLIENT));
        } else {
            submittedJobIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_CLIENTS));
            submittedJobIdentifiers.add(new Identifier(IdentifierType.CLIENT_ID, schedule.getClientId()));
            for (String clientPoolId : this.schedulerApplication.getClientPoolResource().getPoolsContainingClientId(schedule.getClientId())) {
                submittedJobIdentifiers.add(new Identifier(IdentifierType.CLIENT_POOL_ID, clientPoolId));
                submittedJobIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_CLIENT_POOLS));
            }
            submittedJobIdentifiers.add(new Identifier(IdentifierType.MATTER_ID, schedule.getMatterId()));
            Matter matter = this.schedulerApplication.getClientResource().getMatter(schedule.getMatterId());
            if (matter != null) {
                submittedJobIdentifiers.add(new Identifier(IdentifierType.CLIENT_ID_MATTERS, matter.getClientId()));
            }
        }
        response.getUserPermissions().addAll(this.getPermissions(user.getIdentifiers(), submittedJobIdentifiers));
        HashSet<Object> resourceIdentifiers = new HashSet<Identifier>();
        if (schedule.getSameWorkflowTemplateAsTriggerMatter() != null && schedule.getSameWorkflowTemplateAsTriggerMatter().booleanValue()) {
            resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_LIBRARIES));
        } else if (schedule.getLibraryWorkflowId() == null) {
            resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_LIBRARIES));
        } else {
            resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_LIBRARIES));
            resourceIdentifiers.add(new Identifier(IdentifierType.LIBRARY_ID, schedule.getLibraryId()));
            resourceIdentifiers.add(new Identifier(IdentifierType.WORKFLOW_ID, schedule.getLibraryWorkflowId()));
        }
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.SUBMIT_JOB)) {
            response.getUserPermissions().remove(Permission.SUBMIT_JOB);
            response.getUserPermissions().remove(Permission.MODIFY);
        }
        resourceIdentifiers = new HashSet();
        if (schedule.getSameExecutionProfileAsTriggerMatter() != null && schedule.getSameExecutionProfileAsTriggerMatter().booleanValue()) {
            resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_EXECUTION_PROFILES));
            if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.SUBMIT_JOB)) {
                response.getUserPermissions().remove(Permission.SUBMIT_JOB);
                response.getUserPermissions().remove(Permission.MODIFY);
            }
        } else if (schedule.getExecutionProfileId() != null && schedule.getExecutionProfileId().length() > 0) {
            resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_EXECUTION_PROFILES));
            resourceIdentifiers.add(new Identifier(IdentifierType.EXECUTION_PROFILE_ID, schedule.getExecutionProfileId()));
            resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
            if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.SUBMIT_JOB)) {
                response.getUserPermissions().remove(Permission.SUBMIT_JOB);
                response.getUserPermissions().remove(Permission.MODIFY);
            }
        }
        resourceIdentifiers = new HashSet();
        if (schedule.getSameResourcePoolIdAsTriggerMatter() != null && schedule.getSameResourcePoolIdAsTriggerMatter().booleanValue()) {
            resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_RESOURCE_POOLS));
            if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.SUBMIT_JOB)) {
                response.getUserPermissions().remove(Permission.SUBMIT_JOB);
                response.getUserPermissions().remove(Permission.MODIFY);
            }
            if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.MODIFY) && schedule.getPriority() != null && schedule.getPriority() == Priority.HIGHEST) {
                response.setPriority(Priority.HIGH);
            }
        } else if (schedule.getResourcePoolId() != null && schedule.getResourcePoolId().length() > 0) {
            resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_EXECUTION_PROFILES));
            resourceIdentifiers.add(new Identifier(IdentifierType.RESOURCE_POOL_ID, schedule.getResourcePoolId()));
            resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
            if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.SUBMIT_JOB)) {
                response.getUserPermissions().remove(Permission.SUBMIT_JOB);
                response.getUserPermissions().remove(Permission.MODIFY);
            }
            if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.MODIFY) && schedule.getPriority() != null && schedule.getPriority() == Priority.HIGHEST) {
                response.setPriority(Priority.HIGH);
            }
        }
        HashSet<Identifier> triggerJobIdentifiers = new HashSet<Identifier>();
        if (schedule.getEventTrigger() != null) {
            triggerJobIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_CLIENTS));
            Set<Permission> triggerJobPermissions = this.getPermissions(user.getIdentifiers(), triggerJobIdentifiers);
            if (!triggerJobPermissions.contains(Permission.VIEW)) {
                response.getUserPermissions().remove(Permission.SUBMIT_JOB);
                response.getUserPermissions().remove(Permission.MODIFY);
            }
        }
        HashSet<Identifier> scheduleIdentifiers = new HashSet<Identifier>();
        scheduleIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.SCHEDULES));
        Set<Permission> schedulePermissions = this.getPermissions(user.getIdentifiers(), scheduleIdentifiers);
        if (!schedulePermissions.contains(Permission.VIEW)) {
            response.getUserPermissions().remove(Permission.SUBMIT_JOB);
            response.getUserPermissions().remove(Permission.MODIFY);
            response.getUserPermissions().remove(Permission.VIEW);
        }
        if (!schedulePermissions.contains(Permission.MODIFY)) {
            response.getUserPermissions().remove(Permission.MODIFY);
        }
        if (!schedulePermissions.contains(Permission.SUBMIT_JOB)) {
            response.getUserPermissions().remove(Permission.SUBMIT_JOB);
        }
        if (response.getUserPermissions().contains(Permission.VIEW_LIMITED) && !response.getUserPermissions().contains(Permission.VIEW)) {
            response = response.cloneLimited();
            response.getUserPermissions().add(Permission.VIEW);
        }
        return response;
    }

    public Client setUserPermissions(BearerUser user, Client client) {
        Client response = client.clone();
        response.setUserPermissions(new HashSet());
        LinkedHashMap workflowParameters = response.getWorkflowParameters();
        for (String parameterName : workflowParameters.keySet()) {
            StaticParameter staticParameter = new StaticParameter(parameterName, "");
            if (!staticParameter.isEffectiveTypeMaskedOrProtected()) continue;
            workflowParameters.put(parameterName, null);
        }
        HashSet<Object> scopeIdentifiers = new HashSet<Identifier>();
        scopeIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_CLIENTS));
        scopeIdentifiers.add(new Identifier(IdentifierType.CLIENT_ID, client.getId()));
        Set<Permission> permissions = this.getPermissions(user.getIdentifiers(), scopeIdentifiers);
        scopeIdentifiers = new HashSet();
        for (String clientPoolId : this.schedulerApplication.getClientPoolResource().getPoolsContainingClientId(client.getId())) {
            scopeIdentifiers.add(new Identifier(IdentifierType.CLIENT_POOL_ID, clientPoolId));
            scopeIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_CLIENT_POOLS));
        }
        Set<Permission> parentPermissions = this.getPermissions(user.getIdentifiers(), scopeIdentifiers);
        parentPermissions.remove(Permission.VIEW_NON_RECURSIVE);
        permissions.addAll(parentPermissions);
        if (parentPermissions.contains(Permission.MODIFY_CHILDREN)) {
            permissions.add(Permission.MODIFY);
        }
        if (!(permissions.contains(Permission.VIEW) && permissions.contains(Permission.SUBMIT_JOB) && permissions.contains(Permission.STAGE_JOB))) {
            Collection<Matter> matters = this.schedulerApplication.getClientResource().getClientMatters(client.getId());
            scopeIdentifiers = new HashSet();
            scopeIdentifiers.add(new Identifier(IdentifierType.CLIENT_ID_MATTERS, client.getId()));
            for (Matter matter : matters) {
                scopeIdentifiers.add(new Identifier(IdentifierType.MATTER_ID, matter.getId()));
            }
            Set<Permission> matterPermissions = this.getPermissions(user.getIdentifiers(), scopeIdentifiers);
            if (matterPermissions.contains(Permission.VIEW)) {
                permissions.add(Permission.VIEW);
            }
            if (matterPermissions.contains(Permission.SUBMIT_JOB)) {
                permissions.add(Permission.SUBMIT_JOB);
            }
            if (matterPermissions.contains(Permission.STAGE_JOB)) {
                permissions.add(Permission.STAGE_JOB);
            }
        }
        response.getUserPermissions().addAll(permissions);
        if (response.getUserPermissions().contains(Permission.VIEW_LIMITED) && !response.getUserPermissions().contains(Permission.VIEW)) {
            response = response.cloneLimited();
            response.getUserPermissions().add(Permission.VIEW);
        }
        return response;
    }

    public ClientPool setUserPermissions(BearerUser user, ClientPool clientPool) {
        ClientPool response = clientPool.clone();
        response.setUserPermissions(new HashSet());
        LinkedHashMap workflowParameters = response.getWorkflowParameters();
        for (String parameterName : workflowParameters.keySet()) {
            StaticParameter staticParameter = new StaticParameter(parameterName, "");
            if (!staticParameter.isEffectiveTypeMaskedOrProtected()) continue;
            workflowParameters.put(parameterName, null);
        }
        HashSet<Identifier> scopeIdentifiers = new HashSet<Identifier>();
        scopeIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_CLIENT_POOLS));
        scopeIdentifiers.add(new Identifier(IdentifierType.CLIENT_POOL_ID, clientPool.getId()));
        Set<Permission> permissions = this.getPermissions(user.getIdentifiers(), scopeIdentifiers);
        if (permissions.contains(Permission.VIEW_NON_RECURSIVE)) {
            permissions.add(Permission.VIEW);
        }
        response.getUserPermissions().addAll(permissions);
        if (response.getUserPermissions().contains(Permission.VIEW_LIMITED) && !response.getUserPermissions().contains(Permission.VIEW)) {
            response = response.cloneLimited();
            response.getUserPermissions().add(Permission.VIEW);
        }
        return response;
    }

    public Matter setUserPermissions(BearerUser user, Matter matter) {
        Matter response = matter.clone();
        response.setUserPermissions(new HashSet());
        LinkedHashMap workflowParameters = response.getWorkflowParameters();
        for (String parameterName : workflowParameters.keySet()) {
            StaticParameter staticParameter = new StaticParameter(parameterName, "");
            if (!staticParameter.isEffectiveTypeMaskedOrProtected()) continue;
            workflowParameters.put(parameterName, null);
        }
        HashSet<Object> scopeIdentifiers = new HashSet<Identifier>();
        scopeIdentifiers.add(new Identifier(IdentifierType.MATTER_ID, matter.getId()));
        if (matter.getClientId() != null) {
            scopeIdentifiers.add(new Identifier(IdentifierType.CLIENT_ID_MATTERS, matter.getClientId()));
        }
        Set<Permission> permissions = this.getPermissions(user.getIdentifiers(), scopeIdentifiers);
        scopeIdentifiers = new HashSet();
        scopeIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_CLIENTS));
        if (matter.getClientId() != null) {
            scopeIdentifiers.add(new Identifier(IdentifierType.CLIENT_ID, matter.getClientId()));
            for (String clientPoolId : this.schedulerApplication.getClientPoolResource().getPoolsContainingClientId(matter.getClientId())) {
                scopeIdentifiers.add(new Identifier(IdentifierType.CLIENT_POOL_ID, clientPoolId));
                scopeIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_CLIENT_POOLS));
            }
        }
        Set<Permission> parentPermissions = this.getPermissions(user.getIdentifiers(), scopeIdentifiers);
        parentPermissions.remove(Permission.VIEW_NON_RECURSIVE);
        permissions.addAll(parentPermissions);
        if (parentPermissions.contains(Permission.MODIFY_CHILDREN)) {
            permissions.add(Permission.MODIFY);
        }
        response.getUserPermissions().addAll(permissions);
        if (response.getUserPermissions().contains(Permission.VIEW_LIMITED) && !response.getUserPermissions().contains(Permission.VIEW)) {
            response = response.cloneLimited();
            response.getUserPermissions().add(Permission.VIEW);
        }
        return response;
    }

    public Dataset setUserPermissions(BearerUser user, Dataset dataset) {
        Dataset response = dataset.clone();
        HashSet<Permission> permissions = new HashSet<Permission>();
        Matter matter = this.schedulerApplication.getClientResource().getMatter(dataset.getMatterId());
        if (matter != null) {
            Set parentPermissions = this.setUserPermissions(user, matter).getUserPermissions();
            parentPermissions.remove(Permission.VIEW_NON_RECURSIVE);
            permissions.addAll(parentPermissions);
            if (parentPermissions.contains(Permission.MODIFY_CHILDREN)) {
                permissions.add(Permission.MODIFY);
            }
        }
        response.setUserPermissions(permissions);
        if (response.getUserPermissions().contains(Permission.VIEW_LIMITED) && !response.getUserPermissions().contains(Permission.VIEW)) {
            response = response.cloneLimited();
            response.getUserPermissions().add(Permission.VIEW);
        }
        return response;
    }

    public WorkflowLibrary setUserPermissions(BearerUser user, WorkflowLibrary workflowLibrary) {
        WorkflowLibrary response = new WorkflowLibrary(workflowLibrary);
        response.setUserPermissions(new HashSet());
        HashSet<Object> scopeIdentifiers = new HashSet<Identifier>();
        scopeIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_LIBRARIES));
        scopeIdentifiers.add(new Identifier(IdentifierType.LIBRARY_ID, workflowLibrary.getId()));
        Set<Permission> permissions = this.getPermissions(user.getIdentifiers(), scopeIdentifiers);
        if (!(permissions.contains(Permission.VIEW) && permissions.contains(Permission.SUBMIT_JOB) && permissions.contains(Permission.STAGE_JOB))) {
            Collection<Workflow> libraryWorkflows = this.schedulerApplication.getLibraryResource().getLibraryWorkflows(workflowLibrary.getId());
            scopeIdentifiers = new HashSet();
            for (Workflow libraryWorkflow : libraryWorkflows) {
                scopeIdentifiers.add(new Identifier(IdentifierType.WORKFLOW_ID, libraryWorkflow.getId()));
            }
            Set<Permission> workflowPermissions = this.getPermissions(user.getIdentifiers(), scopeIdentifiers);
            if (workflowPermissions.contains(Permission.VIEW)) {
                permissions.add(Permission.VIEW);
            }
            if (workflowPermissions.contains(Permission.SUBMIT_JOB)) {
                permissions.add(Permission.SUBMIT_JOB);
            }
            if (workflowPermissions.contains(Permission.STAGE_JOB)) {
                permissions.add(Permission.STAGE_JOB);
            }
        }
        response.getUserPermissions().addAll(permissions);
        if (response.getUserPermissions().contains(Permission.VIEW_LIMITED) && !response.getUserPermissions().contains(Permission.VIEW)) {
            response = response.cloneLimited();
            response.getUserPermissions().add(Permission.VIEW);
        }
        return response;
    }

    public Workflow setUserPermissions(BearerUser user, Workflow workflow) {
        Workflow response = workflow.clone();
        response.setUserPermissions(new HashSet());
        HashSet<Identifier> scopeIdentifiers = new HashSet<Identifier>();
        scopeIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_LIBRARIES));
        scopeIdentifiers.add(new Identifier(IdentifierType.LIBRARY_ID, workflow.getLibraryId()));
        scopeIdentifiers.add(new Identifier(IdentifierType.WORKFLOW_ID, workflow.getId()));
        Set<Permission> permissions = this.getPermissions(user.getIdentifiers(), scopeIdentifiers);
        HashSet<Identifier> parentScopeIdentifiers = new HashSet<Identifier>();
        parentScopeIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_LIBRARIES));
        parentScopeIdentifiers.add(new Identifier(IdentifierType.LIBRARY_ID, workflow.getLibraryId()));
        Set<Permission> parentPermissions = this.getPermissions(user.getIdentifiers(), parentScopeIdentifiers);
        parentPermissions.remove(Permission.VIEW_NON_RECURSIVE);
        permissions.addAll(parentPermissions);
        if (parentPermissions.contains(Permission.MODIFY_CHILDREN)) {
            permissions.add(Permission.MODIFY);
        }
        response.getUserPermissions().addAll(permissions);
        if (response.getUserPermissions().contains(Permission.VIEW_LIMITED) && !response.getUserPermissions().contains(Permission.VIEW)) {
            response = response.cloneLimited();
            response.getUserPermissions().add(Permission.VIEW);
        }
        return response;
    }

    public SecurityPolicy setUserPermissions(BearerUser user, SecurityPolicy securityPolicy) {
        SecurityPolicy response = new SecurityPolicy(securityPolicy);
        response.setUserPermissions(new HashSet());
        HashSet<Identifier> scopeIdentifiers = new HashSet<Identifier>();
        scopeIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.SECURITY));
        response.getUserPermissions().addAll(this.getPermissions(user.getIdentifiers(), scopeIdentifiers));
        if (response.getUserPermissions().contains(Permission.VIEW_LIMITED) && !response.getUserPermissions().contains(Permission.VIEW)) {
            response = response.cloneLimited();
            response.getUserPermissions().add(Permission.VIEW);
        }
        if (securityPolicy.getReadOnly()) {
            response.getUserPermissions().remove(Permission.MODIFY);
            response.getUserPermissions().remove(Permission.MODIFY_CHILDREN);
        }
        return response;
    }

    public ResourcePool setUserPermissions(BearerUser user, ResourcePoolModel resourcePool) {
        ResourcePool response = new ResourcePool(resourcePool);
        response.setUserPermissions(new HashSet());
        HashSet<Identifier> scopeIdentifiers = new HashSet<Identifier>();
        scopeIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        scopeIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_RESOURCE_POOLS));
        scopeIdentifiers.add(new Identifier(IdentifierType.RESOURCE_POOL_ID, resourcePool.getId()));
        response.getUserPermissions().addAll(this.getPermissions(user.getIdentifiers(), scopeIdentifiers));
        if (response.getUserPermissions().contains(Permission.VIEW_LIMITED) && !response.getUserPermissions().contains(Permission.VIEW)) {
            response = response.cloneLimited();
            response.getUserPermissions().add(Permission.VIEW);
        }
        if (resourcePool.isReadOnly()) {
            response.getUserPermissions().remove(Permission.MODIFY);
            response.getUserPermissions().remove(Permission.MODIFY_CHILDREN);
        }
        return response;
    }

    public Engine setUserPermissions(BearerUser user, EngineModel engineModel) {
        Engine response = new Engine(engineModel);
        response.setUserPermissions(new HashSet());
        HashSet<Identifier> scopeIdentifiers = new HashSet<Identifier>();
        scopeIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        for (ResourcePoolModel resourcePool : this.schedulerApplication.getResourcePoolResource().getResourcePools()) {
            Set engineIds = resourcePool.getEngineIds();
            if (engineIds == null || !engineIds.contains(engineModel.getId())) continue;
            scopeIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_RESOURCE_POOLS));
            scopeIdentifiers.add(new Identifier(IdentifierType.RESOURCE_POOL_ID, resourcePool.getId()));
        }
        Set<Permission> permissions = this.getPermissions(user.getIdentifiers(), scopeIdentifiers);
        if (TagsUtil.hasTag(TagsUtil.CLOUD_INSTANCE_ID, engineModel.getTags())) {
            permissions.remove(Permission.MODIFY);
        }
        if (TagsUtil.hasTag(TagsUtil.AUTO_REGISTER_RESOURCE_POOL_ID, engineModel.getTags())) {
            permissions.remove(Permission.MODIFY);
        }
        response.getUserPermissions().addAll(permissions);
        if (response.getUserPermissions().contains(Permission.VIEW_LIMITED) && !response.getUserPermissions().contains(Permission.VIEW)) {
            response = response.cloneLimited();
            response.getUserPermissions().add(Permission.VIEW);
        }
        return response;
    }

    public Server setUserPermissions(BearerUser user, Server server) {
        Server response = new Server(server);
        response.setUserPermissions(new HashSet());
        HashSet<Identifier> scopeIdentifiers = new HashSet<Identifier>();
        scopeIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        Set<Permission> permissions = this.getPermissions(user.getIdentifiers(), scopeIdentifiers);
        if (TagsUtil.hasTag(TagsUtil.CLOUD_INSTANCE_ID, server.getTags())) {
            permissions.remove(Permission.MODIFY);
        }
        if (TagsUtil.hasTag(TagsUtil.AUTO_REGISTER_RESOURCE_POOL_ID, server.getTags())) {
            permissions.remove(Permission.MODIFY);
        }
        response.getUserPermissions().addAll(permissions);
        if (response.getUserPermissions().contains(Permission.VIEW_LIMITED) && !response.getUserPermissions().contains(Permission.VIEW)) {
            response = response.cloneLimited();
            response.getUserPermissions().add(Permission.VIEW);
        }
        return response;
    }

    public NuixLicenseSource setUserPermissions(BearerUser user, NuixLicenseSourceModel nuixLicenseSource) {
        NuixLicenseSource response = new NuixLicenseSource(nuixLicenseSource);
        response.setUserPermissions(new HashSet());
        HashSet<Identifier> scopeIdentifiers = new HashSet<Identifier>();
        scopeIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        scopeIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_NUIX_LICENSE_SOURCES));
        scopeIdentifiers.add(new Identifier(IdentifierType.NUIX_LICENCE_SOURCE_ID, nuixLicenseSource.getId()));
        response.getUserPermissions().addAll(this.getPermissions(user.getIdentifiers(), scopeIdentifiers));
        if (response.getUserPermissions().contains(Permission.VIEW_LIMITED) && !response.getUserPermissions().contains(Permission.VIEW)) {
            response = response.cloneLimited();
            response.getUserPermissions().add(Permission.VIEW);
        }
        if (nuixLicenseSource.isReadOnly()) {
            response.getUserPermissions().remove(Permission.MODIFY);
            response.getUserPermissions().remove(Permission.MODIFY_CHILDREN);
        }
        return response;
    }

    public FileLibrary setUserPermissions(BearerUser user, FileLibrary library) {
        FileLibrary response = library.clone();
        response.setUserPermissions(new HashSet());
        HashSet<Identifier> scopeIdentifiers = new HashSet<Identifier>();
        scopeIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        scopeIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_FILE_LIBRARIES));
        scopeIdentifiers.add(new Identifier(IdentifierType.FILE_LIBRARY_ID, library.getId()));
        response.getUserPermissions().addAll(this.getPermissions(user.getIdentifiers(), scopeIdentifiers));
        if (response.getUserPermissions().contains(Permission.VIEW_LIMITED) && !response.getUserPermissions().contains(Permission.VIEW)) {
            response = response.cloneLimited();
            response.getUserPermissions().add(Permission.VIEW);
        }
        return response;
    }

    public JobModel setUserPermissionsInternal(BearerUser user, JobModel jobModel) {
        JobModel response = new JobModel(jobModel, true, false);
        response.setUserPermissions(new HashSet());
        HashSet<Identifier> scopeIdentifiers = new HashSet<Identifier>();
        if (response.getClientId() == null) {
            scopeIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.UNASSIGNED_CLIENT));
        } else {
            scopeIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_CLIENTS));
            scopeIdentifiers.add(new Identifier(IdentifierType.CLIENT_ID, response.getClientId()));
            for (String clientPoolId : this.schedulerApplication.getClientPoolResource().getPoolsContainingClientId(response.getClientId())) {
                scopeIdentifiers.add(new Identifier(IdentifierType.CLIENT_POOL_ID, clientPoolId));
                scopeIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_CLIENT_POOLS));
            }
            scopeIdentifiers.add(new Identifier(IdentifierType.MATTER_ID, response.getMatterId()));
            Matter matter = this.schedulerApplication.getClientResource().getMatter(response.getMatterId());
            if (matter != null) {
                scopeIdentifiers.add(new Identifier(IdentifierType.CLIENT_ID_MATTERS, matter.getClientId()));
            }
        }
        Set<Permission> scopePermissions = this.getPermissions(user.getIdentifiers(), scopeIdentifiers);
        if (scopePermissions.remove(Permission.MODIFY_CHILDREN)) {
            scopePermissions.add(Permission.MODIFY);
        }
        response.getUserPermissions().addAll(scopePermissions);
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        if (jobModel.getLibraryWorkflowId() == null) {
            resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_LIBRARIES));
        } else {
            resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_LIBRARIES));
            resourceIdentifiers.add(new Identifier(IdentifierType.LIBRARY_ID, jobModel.getLibraryId()));
            resourceIdentifiers.add(new Identifier(IdentifierType.WORKFLOW_ID, jobModel.getLibraryWorkflowId()));
        }
        boolean canModifySubmitJob = true;
        boolean canModifyStageJob = jobModel.getInStaging();
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.SUBMIT_JOB)) {
            response.getUserPermissions().remove(Permission.SUBMIT_JOB);
            canModifySubmitJob = false;
        }
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.STAGE_JOB)) {
            response.getUserPermissions().remove(Permission.STAGE_JOB);
            canModifyStageJob = false;
        }
        if (!canModifySubmitJob && !canModifyStageJob) {
            response.getUserPermissions().remove(Permission.MODIFY);
        }
        if (response.getUserPermissions().contains(Permission.VIEW_LIMITED) && !response.getUserPermissions().contains(Permission.VIEW)) {
            response = response.cloneLimited();
            response.getUserPermissions().add(Permission.VIEW);
        }
        return response;
    }

    public Job setUserPermissions(BearerUser user, JobModel jobModel) {
        SchedulerApplication.getInstance().getJobResource().resolveJobNames(jobModel);
        Job response = new Job(jobModel, true);
        response.setUserPermissions(new HashSet());
        HashSet<Identifier> scopeIdentifiers = new HashSet<Identifier>();
        if (response.getClientId() == null) {
            scopeIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.UNASSIGNED_CLIENT));
        } else {
            scopeIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_CLIENTS));
            scopeIdentifiers.add(new Identifier(IdentifierType.CLIENT_ID, response.getClientId()));
            for (String clientPoolId : this.schedulerApplication.getClientPoolResource().getPoolsContainingClientId(response.getClientId())) {
                scopeIdentifiers.add(new Identifier(IdentifierType.CLIENT_POOL_ID, clientPoolId));
                scopeIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_CLIENT_POOLS));
            }
            scopeIdentifiers.add(new Identifier(IdentifierType.MATTER_ID, response.getMatterId()));
            Matter matter = this.schedulerApplication.getClientResource().getMatter(response.getMatterId());
            if (matter != null) {
                scopeIdentifiers.add(new Identifier(IdentifierType.CLIENT_ID_MATTERS, matter.getClientId()));
            }
        }
        response.getUserPermissions().addAll(this.getPermissions(user.getIdentifiers(), scopeIdentifiers));
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        if (jobModel.getLibraryWorkflowId() == null) {
            resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_LIBRARIES));
        } else {
            resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_LIBRARIES));
            resourceIdentifiers.add(new Identifier(IdentifierType.LIBRARY_ID, jobModel.getLibraryId()));
            resourceIdentifiers.add(new Identifier(IdentifierType.WORKFLOW_ID, jobModel.getLibraryWorkflowId()));
        }
        boolean canModifySubmitJob = true;
        boolean canModifyStageJob = jobModel.getInStaging();
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.SUBMIT_JOB)) {
            response.getUserPermissions().remove(Permission.SUBMIT_JOB);
            canModifySubmitJob = false;
        }
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.STAGE_JOB)) {
            response.getUserPermissions().remove(Permission.STAGE_JOB);
            canModifyStageJob = false;
        }
        if (!canModifySubmitJob && !canModifyStageJob) {
            response.getUserPermissions().remove(Permission.MODIFY);
        }
        if (response.getUserPermissions().contains(Permission.VIEW)) {
            response.getUserPermissions().remove(Permission.VIEW_LIMITED);
        }
        if (response.getUserPermissions().contains(Permission.VIEW_LIMITED) && !response.getUserPermissions().contains(Permission.VIEW)) {
            response = response.cloneLimited();
            response.getUserPermissions().add(Permission.VIEW);
        }
        return response;
    }

    public SecurityPolicy createDefaultPolicy() {
        SecurityPolicy securityPolicy = this.getDefaultPolicy();
        this.addOrUpdatePolicy(securityPolicy);
        return securityPolicy;
    }

    public SecurityPolicy createProcessingJobViewerPolicy() {
        SecurityPolicy securityPolicy = this.getProcessingJobViewerPolicy();
        this.addOrUpdatePolicy(securityPolicy);
        return securityPolicy;
    }

    public SecurityPolicy createProcessingJobSubmitterPolicy() {
        SecurityPolicy securityPolicy = this.getProcessingJobSubmitterPolicy();
        this.addOrUpdatePolicy(securityPolicy);
        return securityPolicy;
    }

    public SecurityPolicy createAdministratorPolicy() {
        SecurityPolicy securityPolicy = this.getAdministratorPolicy();
        this.addOrUpdatePolicy(securityPolicy);
        return securityPolicy;
    }

    public SecurityPolicy createSecurityAdministratorPolicy() {
        SecurityPolicy securityPolicy = this.getSecurityAdministratorPolicy();
        this.addOrUpdatePolicy(securityPolicy);
        return securityPolicy;
    }

    public void deletePolicy(String policyId) {
        this.securityDao.deletePolicyInfo(policyId);
        this.securityDao.deletePolicyScope(policyId);
        this.securityDao.deletePolicyPrincipals(policyId);
        this.securityDao.deletePolicyPermissions(policyId);
        this.policies.remove(policyId);
    }

    public void addOrUpdatePolicy(SecurityPolicy securityPolicy) {
        this.securityDao.deletePolicyInfo(securityPolicy.getId());
        this.securityDao.deletePolicyPermissions(securityPolicy.getId());
        this.securityDao.deletePolicyPrincipals(securityPolicy.getId());
        this.securityDao.deletePolicyScope(securityPolicy.getId());
        PolicyInfoModel policyInfoModel = new PolicyInfoModel();
        policyInfoModel.setEnabled(securityPolicy.getEnabled().booleanValue());
        policyInfoModel.setDescription(securityPolicy.getDescription());
        policyInfoModel.setId(securityPolicy.getId());
        policyInfoModel.setName(securityPolicy.getName());
        this.securityDao.addPolicyInfo(policyInfoModel);
        for (Identifier principalIdentifier : securityPolicy.getPrincipals()) {
            this.securityDao.addPolicyPrincipal(securityPolicy.getId(), principalIdentifier);
        }
        for (Identifier scopeIdentifier : securityPolicy.getScope()) {
            this.securityDao.addPolicyScope(securityPolicy.getId(), scopeIdentifier);
        }
        for (Permission permission : securityPolicy.getPermissions()) {
            this.securityDao.addPolicyPermission(securityPolicy.getId(), new PermissionWrapper(permission));
        }
        this.policies.put(securityPolicy.getId(), securityPolicy);
    }

    private SecurityPolicy getSamplePolicy() {
        SecurityPolicy securityPolicy = new SecurityPolicy();
        securityPolicy.setId(UidUtils.getRandom());
        securityPolicy.setEnabled(Boolean.valueOf(false));
        securityPolicy.setName("Sample Policy");
        securityPolicy.setDescription("This is a sample policy with different types of identifiers");
        LinkedHashSet<Identifier> principals = new LinkedHashSet<Identifier>();
        principals.add(new Identifier(IdentifierType.AZURE_GROUP_ID, "04097a83-5235-41a2-882c-38f3a04f7f01"));
        securityPolicy.setPrincipals(principals);
        principals.add(new Identifier(IdentifierType.AZURE_USERNAME, "jsmith@rampiva.com"));
        securityPolicy.setPrincipals(principals);
        principals.add(new Identifier(IdentifierType.UMS_USERNAME, "jsmith"));
        securityPolicy.setPrincipals(principals);
        LinkedHashSet<Identifier> scope = new LinkedHashSet<Identifier>();
        scope.add(new Identifier(IdentifierType.LIBRARY_ID, "055c9300-be98-4087-bb7d-8bcd80a7e398"));
        scope.add(new Identifier(IdentifierType.MATTER_ID, "56ab9129-5fae-462e-808c-7c15a9cfcd1c"));
        scope.add(new Identifier(IdentifierType.WORKFLOW_ID, "89a436b8-944e-4357-91d6-bfdbf66ccd17"));
        scope.add(new Identifier(IdentifierType.CLIENT_ID, "9342f28d-f199-4940-a087-bdee6225b8cc"));
        scope.add(new Identifier(IdentifierType.RESOURCE_POOL_ID, "5bff873b-f584-4c2c-9aaa-6ae7ff9e467f"));
        scope.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.UNASSIGNED_CLIENT));
        securityPolicy.setScope(scope);
        LinkedHashSet<Permission> permissions = new LinkedHashSet<Permission>();
        permissions.add(Permission.VIEW);
        permissions.add(Permission.MODIFY);
        permissions.add(Permission.VIEW_SENSITIVE);
        securityPolicy.setPermissions(permissions);
        return securityPolicy;
    }

    private SecurityPolicy getDefaultPolicy() {
        SecurityPolicy securityPolicy = new SecurityPolicy();
        securityPolicy.setId("84884db3-ca7f-3f1a-068b-239374b82ba2");
        securityPolicy.setEnabled(Boolean.valueOf(true));
        securityPolicy.setName("Default Policy");
        securityPolicy.setDescription("This policy allows any internal user to perform any action");
        HashSet<String> warnings = new HashSet<String>();
        warnings.add(this.iu.getString("Security.Warning.UnmodifiedDefaultPolicy"));
        securityPolicy.setWarnings(warnings);
        securityPolicy.setHasWarnings(true);
        HashSet<Identifier> principals = new HashSet<Identifier>();
        principals.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInPrincipalIdentifiers.INTERNAL_USER));
        securityPolicy.setPrincipals(principals);
        HashSet<Identifier> scope = new HashSet<Identifier>();
        for (BuiltInScopeIdentifiers inScopeIdentifiers : BuiltInScopeIdentifiers.values()) {
            if (inScopeIdentifiers.equals((Object)BuiltInScopeIdentifiers.UNASSIGNED_CLIENT) || inScopeIdentifiers.equals((Object)BuiltInScopeIdentifiers.ALL_API_KEYS) || inScopeIdentifiers.equals((Object)BuiltInScopeIdentifiers.SCRIPTS) || inScopeIdentifiers.equals((Object)BuiltInScopeIdentifiers.EXTERNAL_APPLICATIONS)) continue;
            scope.add(new Identifier(IdentifierType.BUILTIN, (Enum)inScopeIdentifiers));
        }
        securityPolicy.setScope(scope);
        HashSet<Permission> permissions = new HashSet<Permission>();
        permissions.add(Permission.VIEW);
        permissions.add(Permission.VIEW_SENSITIVE);
        permissions.add(Permission.CREATE);
        permissions.add(Permission.MODIFY);
        permissions.add(Permission.SUBMIT_JOB);
        permissions.add(Permission.DOWNLOAD_LOGS);
        securityPolicy.setPermissions(permissions);
        return securityPolicy;
    }

    private SecurityPolicy getProcessingJobViewerPolicy() {
        SecurityPolicy securityPolicy = new SecurityPolicy();
        securityPolicy.setId(UidUtils.getRandom());
        securityPolicy.setEnabled(Boolean.valueOf(false));
        securityPolicy.setName("Job Viewer");
        securityPolicy.setDescription("This policy allows the internal user sample_user to view Jobs");
        HashSet<Identifier> principals = new HashSet<Identifier>();
        principals.add(new Identifier(IdentifierType.INTERNAL_USERNAME, "sample_user"));
        securityPolicy.setPrincipals(principals);
        HashSet<Identifier> scope = new HashSet<Identifier>();
        scope.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_CLIENTS));
        securityPolicy.setScope(scope);
        HashSet<Permission> permissions = new HashSet<Permission>();
        permissions.add(Permission.VIEW);
        permissions.add(Permission.DOWNLOAD_LOGS);
        securityPolicy.setPermissions(permissions);
        return securityPolicy;
    }

    private SecurityPolicy getProcessingJobSubmitterPolicy() {
        SecurityPolicy securityPolicy = new SecurityPolicy();
        securityPolicy.setId(UidUtils.getRandom());
        securityPolicy.setEnabled(Boolean.valueOf(false));
        securityPolicy.setName("Job Submitter");
        securityPolicy.setDescription("This policy allows the internal user sample_submitter to submit and view Jobs");
        HashSet<Identifier> principals = new HashSet<Identifier>();
        principals.add(new Identifier(IdentifierType.INTERNAL_USERNAME, "sample_submitter"));
        securityPolicy.setPrincipals(principals);
        HashSet<Identifier> scope = new HashSet<Identifier>();
        scope.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_CLIENTS));
        scope.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_EXECUTION_PROFILES));
        scope.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_LIBRARIES));
        scope.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_RESOURCE_POOLS));
        scope.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.SCHEDULES));
        securityPolicy.setScope(scope);
        HashSet<Permission> permissions = new HashSet<Permission>();
        permissions.add(Permission.VIEW);
        permissions.add(Permission.DOWNLOAD_LOGS);
        permissions.add(Permission.SUBMIT_JOB);
        securityPolicy.setPermissions(permissions);
        return securityPolicy;
    }

    private SecurityPolicy getAdministratorPolicy() {
        SecurityPolicy securityPolicy = new SecurityPolicy();
        securityPolicy.setId(UidUtils.getRandom());
        securityPolicy.setEnabled(Boolean.valueOf(false));
        securityPolicy.setName("Administrator");
        securityPolicy.setDescription("This policy allows the internal user sample_administrator to modify all system resources, except for Security Policies");
        HashSet<Identifier> principals = new HashSet<Identifier>();
        principals.add(new Identifier(IdentifierType.INTERNAL_USERNAME, "sample_administrator"));
        securityPolicy.setPrincipals(principals);
        HashSet<Identifier> scope = new HashSet<Identifier>();
        scope.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        scope.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.API_KEYS));
        securityPolicy.setScope(scope);
        HashSet<Permission> permissions = new HashSet<Permission>();
        permissions.add(Permission.VIEW);
        permissions.add(Permission.MODIFY);
        permissions.add(Permission.CREATE);
        permissions.add(Permission.DOWNLOAD_LOGS);
        securityPolicy.setPermissions(permissions);
        return securityPolicy;
    }

    private SecurityPolicy getSecurityAdministratorPolicy() {
        SecurityPolicy securityPolicy = new SecurityPolicy();
        securityPolicy.setId(UidUtils.getRandom());
        securityPolicy.setEnabled(Boolean.valueOf(false));
        securityPolicy.setName("Security Administrator");
        securityPolicy.setDescription("This policy allows the internal user sample_security_administrator to modify Security Policies");
        HashSet<Identifier> principals = new HashSet<Identifier>();
        principals.add(new Identifier(IdentifierType.INTERNAL_USERNAME, "sample_security_administrator"));
        securityPolicy.setPrincipals(principals);
        HashSet<Identifier> scope = new HashSet<Identifier>();
        scope.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.SECURITY));
        securityPolicy.setScope(scope);
        HashSet<Permission> permissions = new HashSet<Permission>();
        permissions.add(Permission.VIEW);
        permissions.add(Permission.MODIFY);
        securityPolicy.setPermissions(permissions);
        return securityPolicy;
    }

    public void initializeFromConfiguration() {
        SecurityPolicy configurationSecurityPolicy = this.schedulerApplication.getConfiguration().getSecurityPolicy();
        if (configurationSecurityPolicy != null) {
            configurationSecurityPolicy.setReadOnly(true);
            this.policies.put(configurationSecurityPolicy.getId(), configurationSecurityPolicy);
        }
    }

    public void initializeFromStore() {
        List<PolicyInfoModel> policiesInfos = this.securityDao.getPoliciesInfos();
        for (PolicyInfoModel policyInfoModel : policiesInfos) {
            SecurityPolicy securityPolicy = new SecurityPolicy();
            securityPolicy.setId(policyInfoModel.getId());
            securityPolicy.setName(policyInfoModel.getName());
            securityPolicy.setDescription(policyInfoModel.getDescription());
            securityPolicy.setEnabled(Boolean.valueOf(policyInfoModel.getEnabled()));
            LinkedHashSet<Identifier> principalIdentifiers = new LinkedHashSet<Identifier>();
            for (Identifier identifier : this.securityDao.getPolicyPrincipals(securityPolicy.getId())) {
                if (identifier.getIdentifierType().equals((Object)IdentifierType.BUILTIN)) {
                    try {
                        BuiltInPrincipalIdentifiers.valueOf((String)identifier.getIdentifierName());
                    }
                    catch (IllegalArgumentException e) {
                        BuiltInPrincipalIdentifiers builtInPrincipalIdentifier = BuiltInPrincipalIdentifiers.fromString((String)identifier.getIdentifierName());
                        identifier.setIdentifierName(builtInPrincipalIdentifier.name());
                    }
                }
                principalIdentifiers.add(identifier);
            }
            securityPolicy.setPrincipals(principalIdentifiers);
            LinkedHashSet<Identifier> scopeIdentifiers = new LinkedHashSet<Identifier>();
            for (Identifier daoIdentifier3 : this.securityDao.getPolicyScope(securityPolicy.getId())) {
                if (daoIdentifier3.getIdentifierType().equals((Object)IdentifierType.BUILTIN)) {
                    if (daoIdentifier3.getIdentifierName().equalsIgnoreCase("Unassigned Library") || daoIdentifier3.getIdentifierName().equalsIgnoreCase("UNASSIGNED_LIBRARY")) {
                        this.securityDao.removePolicyScope(policyInfoModel.getId(), daoIdentifier3);
                        continue;
                    }
                    try {
                        BuiltInScopeIdentifiers.valueOf((String)daoIdentifier3.getIdentifierName());
                    }
                    catch (IllegalArgumentException e) {
                        LOGGER.warn("Unexpected Built-in identifier " + daoIdentifier3.getIdentifierName());
                        continue;
                    }
                }
                scopeIdentifiers.add(daoIdentifier3);
            }
            securityPolicy.setScope(scopeIdentifiers);
            LinkedHashSet<Permission> linkedHashSet = new LinkedHashSet<Permission>();
            linkedHashSet.addAll(this.securityDao.getPolicyPermissions(securityPolicy.getId()));
            if (linkedHashSet.contains(Permission.VIEW_CONFIDENTIAL)) {
                linkedHashSet.add(Permission.VIEW_SENSITIVE);
                this.securityDao.addPolicyPermission(securityPolicy.getId(), new PermissionWrapper(Permission.VIEW_SENSITIVE));
                linkedHashSet.remove(Permission.VIEW_CONFIDENTIAL);
                this.securityDao.removePolicyPermission(securityPolicy.getId(), new PermissionWrapper(Permission.VIEW_CONFIDENTIAL));
            }
            securityPolicy.setPermissions(linkedHashSet);
            this.policies.put(securityPolicy.getId(), securityPolicy);
        }
    }

    public boolean isAnyAllowed(Set<Identifier> principalIdentifiers, Identifier resourceIdentifier, Permission action) {
        HashSet<Identifier> resourceIdentities = new HashSet<Identifier>();
        resourceIdentities.add(resourceIdentifier);
        return this.isAnyAllowed(principalIdentifiers, (Set<Identifier>)resourceIdentities, action);
    }

    public Set<Permission> getPermissions(Set<Identifier> principalIdentifiers, Set<Identifier> scopeIdentifiers) {
        TreeSet<Permission> permissions = new TreeSet<Permission>();
        for (SecurityPolicy securityPolicy : this.policies.values()) {
            if (!securityPolicy.getEnabled().booleanValue()) continue;
            boolean identityInScope = false;
            for (Identifier principalIdentity : principalIdentifiers) {
                if (!securityPolicy.getPrincipals().contains(principalIdentity)) continue;
                identityInScope = true;
                break;
            }
            if (!identityInScope) continue;
            identityInScope = false;
            for (Identifier resourceIdentity : scopeIdentifiers) {
                if (!securityPolicy.getScope().contains(resourceIdentity)) continue;
                identityInScope = true;
                break;
            }
            if (!identityInScope) continue;
            permissions.addAll(securityPolicy.getPermissions());
        }
        return permissions;
    }

    public boolean isAnyAllowed(Set<Identifier> principalIdentifiers, Set<Identifier> resourceIdentifiers, Permission ... actions) {
        for (SecurityPolicy securityPolicy : this.policies.values()) {
            if (!securityPolicy.getEnabled().booleanValue()) continue;
            boolean identityInScope = false;
            for (Identifier principalIdentity : principalIdentifiers) {
                if (!securityPolicy.getPrincipals().contains(principalIdentity)) continue;
                identityInScope = true;
                break;
            }
            if (!identityInScope) continue;
            identityInScope = false;
            for (Identifier resourceIdentity : resourceIdentifiers) {
                if (!securityPolicy.getScope().contains(resourceIdentity)) continue;
                identityInScope = true;
                break;
            }
            if (!identityInScope) continue;
            for (Permission action : actions) {
                if (!securityPolicy.getPermissions().contains(action)) continue;
                return true;
            }
        }
        return false;
    }

    public Set<String> getAllowedAuthenticationServiceIds(Set<Identifier> principalIdentifiers, Permission action, boolean includeDisabled) {
        HashSet<String> result = new HashSet<String>();
        for (SecurityPolicy securityPolicy : this.policies.values()) {
            if (!securityPolicy.getEnabled().booleanValue()) continue;
            boolean identityInScope = false;
            for (Identifier principalIdentity : principalIdentifiers) {
                if (!securityPolicy.getPrincipals().contains(principalIdentity)) continue;
                identityInScope = true;
                break;
            }
            if (!identityInScope || !securityPolicy.getPermissions().contains(action)) continue;
            TreeSet policyScope = securityPolicy.getScope();
            for (Identifier policyScopeIdentifier : policyScope) {
                if (!policyScopeIdentifier.getIdentifierType().equals((Object)IdentifierType.USER_SERVICE_ID)) continue;
                String userServiceId = policyScopeIdentifier.getPrintableName();
                if (includeDisabled) {
                    result.add(policyScopeIdentifier.getPrintableName());
                    continue;
                }
                UserService userService = this.schedulerApplication.getUserServiceResource().getUserService(userServiceId);
                if (userService == null || !userService.getEnabled().booleanValue()) continue;
                result.add(policyScopeIdentifier.getPrintableName());
            }
        }
        return result;
    }

    public boolean isAnyAllowed(Set<Identifier> principalIdentifiers, Set<Identifier> resourceIdentifiers, Permission action) {
        for (SecurityPolicy securityPolicy : this.policies.values()) {
            if (!securityPolicy.getEnabled().booleanValue()) continue;
            boolean identityInScope = false;
            for (Identifier principalIdentity : principalIdentifiers) {
                if (!securityPolicy.getPrincipals().contains(principalIdentity)) continue;
                identityInScope = true;
                break;
            }
            if (!identityInScope) continue;
            identityInScope = false;
            for (Identifier resourceIdentity : resourceIdentifiers) {
                if (!securityPolicy.getScope().contains(resourceIdentity)) continue;
                identityInScope = true;
                break;
            }
            if (!identityInScope || !securityPolicy.getPermissions().contains(action)) continue;
            return true;
        }
        return false;
    }

    public Set<Permission> whatIfGetPermissions(Set<Identifier> principalIdentifiers, Set<Identifier> scopeIdentifiers, String deletedPolicyId, SecurityPolicy modifiedSecurityPolicy) {
        HashSet<Permission> permissions = new HashSet<Permission>();
        ArrayList<SecurityPolicy> policiesInScope = new ArrayList<SecurityPolicy>();
        for (SecurityPolicy securityPolicy : this.policies.values()) {
            if (deletedPolicyId != null && deletedPolicyId.equals(securityPolicy.getId()) || modifiedSecurityPolicy != null && securityPolicy.getId().equals(modifiedSecurityPolicy.getId())) continue;
            policiesInScope.add(securityPolicy);
        }
        if (modifiedSecurityPolicy != null) {
            policiesInScope.add(modifiedSecurityPolicy);
        }
        for (SecurityPolicy securityPolicy : policiesInScope) {
            if (!securityPolicy.getEnabled().booleanValue()) continue;
            boolean identityInScope = false;
            for (Identifier principalIdentity : principalIdentifiers) {
                if (!securityPolicy.getPrincipals().contains(principalIdentity)) continue;
                identityInScope = true;
                break;
            }
            if (!identityInScope) continue;
            identityInScope = false;
            for (Identifier resourceIdentity : scopeIdentifiers) {
                if (!securityPolicy.getScope().contains(resourceIdentity)) continue;
                identityInScope = true;
                break;
            }
            if (!identityInScope) continue;
            permissions.addAll(securityPolicy.getPermissions());
        }
        return permissions;
    }

    public boolean isUserAllowedLibraryId(BearerUser user, String libraryId) {
        WorkflowLibrary result;
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_LIBRARIES));
        if (this.isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.VIEW)) {
            return true;
        }
        WorkflowLibrary workflowLibrary = this.schedulerApplication.getLibraryResource().getWorkflowLibrary(libraryId);
        return workflowLibrary != null && (result = this.setUserPermissions(user, workflowLibrary)).getUserPermissions().contains(Permission.VIEW);
    }

    public boolean isUserAllowedMatterId(BearerUser user, String matterId) {
        Matter result;
        Matter matter;
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_CLIENTS));
        if (this.isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.VIEW)) {
            return true;
        }
        return matterId != null && (matter = this.schedulerApplication.getClientResource().getMatter(matterId)) != null && (result = this.setUserPermissions(user, matter)).getUserPermissions().contains(Permission.VIEW);
    }

    public boolean isUserAllowedDataRepositoryId(BearerUser user, String dataRepositoryId) {
        DataRepository result;
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_DATA_REPOSITORIES));
        if (this.isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.VIEW)) {
            return true;
        }
        DataRepository dataRepository = this.schedulerApplication.getDataRepositoryResource().getDataRepository(dataRepositoryId);
        return dataRepository != null && (result = this.setUserPermissions(user, dataRepository)).getUserPermissions().contains(Permission.VIEW);
    }

    public boolean isUserAllowedWorkflowId(BearerUser user, String workflowId) {
        Workflow result;
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_LIBRARIES));
        if (this.isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.VIEW)) {
            return true;
        }
        Workflow workflowModel = this.schedulerApplication.getLibraryResource().getLibraryWorkflow(workflowId);
        return workflowModel != null && (result = this.setUserPermissions(user, workflowModel)).getUserPermissions().contains(Permission.VIEW);
    }

    public boolean isUserAllowedExecutionProfileId(BearerUser user, String executionProfileId) {
        ExecutionProfile result;
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_EXECUTION_PROFILES));
        if (this.isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.VIEW)) {
            return true;
        }
        ExecutionProfileModel executionProfile = this.schedulerApplication.getExecutionProfileResource().getExecutionProfile(executionProfileId);
        return executionProfile != null && (result = this.setUserPermissions(user, executionProfile)).getUserPermissions().contains(Permission.VIEW);
    }

    public boolean isUserAllowedClientId(BearerUser user, String clientId) {
        Client result;
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_CLIENTS));
        if (this.isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.VIEW)) {
            return true;
        }
        Client client = this.schedulerApplication.getClientResource().getClient(clientId);
        return client != null && (result = this.setUserPermissions(user, client)).getUserPermissions().contains(Permission.VIEW);
    }

    public boolean isUserAllowedJob(BearerUser user, JobUtilizationModel job) {
        return this.isUserAllowedMatterId(user, job.getMatterId());
    }

    public boolean isUserAllowedJob(BearerUser user, com.nuix.automate.utils.utilization.Job job) {
        return this.isUserAllowedMatterId(user, job.getMatterId());
    }

    public boolean isUserAllowedJobId(BearerUser user, String jobId) {
        com.nuix.automate.utils.utilization.Job job = this.schedulerApplication.getUtilizationDaoV2().getJob(jobId);
        return this.isUserAllowedJob(user, job);
    }

    public boolean isUserAllowedBatch(BearerUser user, BatchUtilizationModel batch) {
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_CLIENTS));
        if (this.isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.VIEW)) {
            return true;
        }
        return this.isUserAllowedJobId(user, batch.getJobId());
    }

    public boolean isUserAllowedAllClients(BearerUser user) {
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_CLIENTS));
        return this.isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.VIEW);
    }

    public boolean isUserAllowedSessionId(BearerUser user, String sessionId) {
        Session session = this.schedulerApplication.getUtilizationDaoV2().getSession(sessionId);
        return this.isUserAllowedSession(user, session);
    }

    public boolean isUserAllowedSession(BearerUser user, Session session) {
        if (session.getJobId() == null) {
            HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
            resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
            return this.isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.VIEW);
        }
        return this.isUserAllowedJobId(user, session.getJobId());
    }

    public Set<String> getUserAllowedUtilizationOperationIds(BearerUser user, long afterDate, long beforeDate) {
        HashSet<Identifier> allClientsIdentifier = new HashSet<Identifier>();
        allClientsIdentifier.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_CLIENTS));
        if (this.isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)allClientsIdentifier, Permission.VIEW)) {
            return null;
        }
        Set<String> allowedSessionIds = this.getUserAllowedUtilizationSessionIds(user, afterDate, beforeDate);
        if (allowedSessionIds == null) {
            return null;
        }
        HashSet<String> allowedOperationIds = new HashSet<String>();
        for (Operation operation : this.schedulerApplication.getUtilizationDaoV2().getOperations()) {
            if (!allowedSessionIds.contains(operation.getSessionId())) continue;
            allowedOperationIds.add(operation.getOperationId());
        }
        return allowedOperationIds;
    }

    public Set<String> getUserAllowedUtilizationSessionIds(BearerUser user, long afterDate, long beforeDate) {
        HashSet<Identifier> allClientsIdentifier = new HashSet<Identifier>();
        allClientsIdentifier.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_CLIENTS));
        if (this.isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)allClientsIdentifier, Permission.VIEW)) {
            return null;
        }
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        boolean userIsAllowedResources = this.isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.VIEW);
        Set<String> allowedJobIds = this.getUserAllowedUtilizationJobIds(user);
        HashSet<String> allowedSessionIds = new HashSet<String>();
        for (Session session : this.schedulerApplication.getUtilizationDaoV2().getSessionsWithDateRange(afterDate, beforeDate)) {
            if (session.getJobId() == null) {
                if (!userIsAllowedResources) continue;
                allowedSessionIds.add(session.getSessionId());
                continue;
            }
            if (allowedJobIds != null && !allowedJobIds.contains(session.getJobId())) continue;
            allowedSessionIds.add(session.getSessionId());
        }
        return allowedSessionIds;
    }

    public Set<String> getUserAllowedUtilizationJobIds(BearerUser user) {
        HashSet<Identifier> allClientsIdentifier = new HashSet<Identifier>();
        allClientsIdentifier.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_CLIENTS));
        if (this.isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)allClientsIdentifier, Permission.VIEW)) {
            return null;
        }
        Set<String> allowedMatterIds = this.getUserAllowedUtilizationMatterIds(user);
        if (allowedMatterIds == null) {
            return null;
        }
        HashSet<String> allowedJobIds = new HashSet<String>();
        for (com.nuix.automate.utils.utilization.Job job : this.schedulerApplication.getUtilizationDaoV2().getJobs()) {
            if (job.getMatterId() == null || !allowedMatterIds.contains(job.getMatterId())) continue;
            allowedJobIds.add(job.getJobId());
        }
        return allowedJobIds;
    }

    public boolean getUserAllowedConsumption(BearerUser user) {
        HashSet<Identifier> allClientsIdentifier = new HashSet<Identifier>();
        allClientsIdentifier.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        return this.isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)allClientsIdentifier, Permission.VIEW);
    }

    public Set<String> getUserAllowedUtilizationMatterIds(BearerUser user) {
        HashSet<Identifier> allClientsIdentifier = new HashSet<Identifier>();
        allClientsIdentifier.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_CLIENTS));
        if (this.isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)allClientsIdentifier, Permission.VIEW)) {
            return null;
        }
        Set<String> allowedClientIds = this.getUserAllowedUtilizationClientIds(user);
        if (allowedClientIds == null) {
            return null;
        }
        HashSet<String> allowedMatterIds = new HashSet<String>();
        for (com.nuix.automate.utils.utilization.Matter matter : this.schedulerApplication.getUtilizationDaoV2().getMatters()) {
            if (matter.getClientId() != null && allowedClientIds.contains(matter.getClientId())) {
                allowedMatterIds.add(matter.getMatterId());
                continue;
            }
            if (!this.isUserAllowedMatterId(user, matter.getMatterId())) continue;
            allowedMatterIds.add(matter.getMatterId());
        }
        return allowedMatterIds;
    }

    public Set<String> getUserAllowedDataSetIds(BearerUser user) {
        HashSet<Identifier> allClientsIdentifier = new HashSet<Identifier>();
        allClientsIdentifier.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_CLIENTS));
        if (this.isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)allClientsIdentifier, Permission.VIEW)) {
            return null;
        }
        Set<String> allowedMatterIds = this.getUserAllowedUtilizationMatterIds(user);
        if (allowedMatterIds == null) {
            return null;
        }
        HashSet<String> allowedDataSetIds = new HashSet<String>();
        for (DataSet dataset : this.schedulerApplication.getUtilizationDaoV2().getDataSets()) {
            if (dataset.getMatterId() == null || !allowedMatterIds.contains(dataset.getMatterId())) continue;
            allowedDataSetIds.add(dataset.getDataSetId());
        }
        return allowedDataSetIds;
    }

    public Set<String> getUserAllowedLegalHoldIds(BearerUser user) {
        HashSet<Identifier> allClientsIdentifier = new HashSet<Identifier>();
        allClientsIdentifier.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_CLIENTS));
        if (this.isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)allClientsIdentifier, Permission.VIEW)) {
            return null;
        }
        Set<String> allowedMatterIds = this.getUserAllowedUtilizationMatterIds(user);
        if (allowedMatterIds == null) {
            return null;
        }
        HashSet<String> allowedLegalHoldIds = new HashSet<String>();
        for (LegalHold legalHold : this.schedulerApplication.getUtilizationDaoV2().getLegalHolds()) {
            if (legalHold.getMatterId() == null || !allowedMatterIds.contains(legalHold.getMatterId())) continue;
            allowedLegalHoldIds.add(legalHold.getLegalHoldId());
        }
        return allowedLegalHoldIds;
    }

    public Set<String> getUserAllowedCollectionIds(BearerUser user) {
        HashSet<Identifier> allClientsIdentifier = new HashSet<Identifier>();
        allClientsIdentifier.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_CLIENTS));
        if (this.isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)allClientsIdentifier, Permission.VIEW)) {
            return null;
        }
        Set<String> allowedMatterIds = this.getUserAllowedUtilizationMatterIds(user);
        if (allowedMatterIds == null) {
            return null;
        }
        HashSet<String> allowedCollectionIds = new HashSet<String>();
        for (com.nuix.automate.utils.utilization.Collection collection : this.schedulerApplication.getUtilizationDaoV2().getCollections()) {
            if (collection.getMatterId() == null || !allowedMatterIds.contains(collection.getMatterId())) continue;
            allowedCollectionIds.add(collection.getCollectionId());
        }
        return allowedCollectionIds;
    }

    public Set<String> getUserAllowedTransferIds(BearerUser user) {
        HashSet<Identifier> allClientsIdentifier = new HashSet<Identifier>();
        allClientsIdentifier.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_CLIENTS));
        if (this.isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)allClientsIdentifier, Permission.VIEW)) {
            return null;
        }
        Set<String> allowedDataSetIds = this.getUserAllowedDataSetIds(user);
        if (allowedDataSetIds == null) {
            return null;
        }
        HashSet<String> allowedTransferIds = new HashSet<String>();
        for (Transfer transfer : this.schedulerApplication.getUtilizationDaoV2().getTransfers()) {
            if (transfer.getTransferId() == null || !allowedTransferIds.contains(transfer.getTransferId())) continue;
            allowedTransferIds.add(transfer.getTransferId());
        }
        return allowedTransferIds;
    }

    public Set<String> getUserAllowedUtilizationClientIds(BearerUser user) {
        HashSet<Identifier> allClientsIdentifier = new HashSet<Identifier>();
        allClientsIdentifier.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_CLIENTS));
        if (this.isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)allClientsIdentifier, Permission.VIEW)) {
            return null;
        }
        HashSet<String> allowedClientIds = new HashSet<String>();
        for (com.nuix.automate.utils.utilization.Client client : this.schedulerApplication.getUtilizationDaoV2().getClients()) {
            if (!this.isUserAllowedClientId(user, client.getClientId())) continue;
            allowedClientIds.add(client.getClientId());
        }
        return allowedClientIds;
    }

    public boolean isUserAllowedResourcePoolId(BearerUser user, String resourcePoolId) {
        ResourcePool result;
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_RESOURCE_POOLS));
        if (this.isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.VIEW)) {
            return true;
        }
        ResourcePoolModel resourcePool = this.schedulerApplication.getResourcePoolResource().getResourcePool(resourcePoolId);
        return resourcePool != null && (result = this.setUserPermissions(user, resourcePool)).getUserPermissions().contains(Permission.VIEW);
    }

    public boolean isUserAllowedResources(BearerUser user) {
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        return this.isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.VIEW);
    }

    public boolean doesUserHaveAllPermissionsOnAnyLibrary(BearerUser user, Permission ... permissions) {
        return this.doesUserHavePermissionOnAnyLibrary(user, true, permissions);
    }

    public boolean doesUserHaveAnyPermissionOnAnyLibrary(BearerUser user, Permission ... permissions) {
        return this.doesUserHavePermissionOnAnyLibrary(user, false, permissions);
    }

    public boolean doesUserHavePermissionOnAnyLibrary(BearerUser user, boolean requireAllPermissions, Permission ... permissions) {
        for (SecurityPolicy securityPolicy : this.schedulerApplication.getSecurityPolicyUtil().getPolicies()) {
            Object principalIdentity2;
            if (!securityPolicy.getEnabled().booleanValue()) continue;
            boolean appliesToUser = false;
            for (Object principalIdentity2 : user.getIdentifiers()) {
                if (!securityPolicy.getPrincipals().contains(principalIdentity2)) continue;
                appliesToUser = true;
                break;
            }
            if (!appliesToUser) continue;
            boolean appliesToScope = false;
            principalIdentity2 = securityPolicy.getScope().iterator();
            while (principalIdentity2.hasNext()) {
                Identifier scopeIdentifier = (Identifier)principalIdentity2.next();
                if (scopeIdentifier.getIdentifierType() == IdentifierType.LIBRARY_ID) {
                    appliesToScope = true;
                    break;
                }
                if (scopeIdentifier.getIdentifierType() != IdentifierType.BUILTIN || !scopeIdentifier.getIdentifierName().equals(BuiltInScopeIdentifiers.ALL_LIBRARIES.name())) continue;
                appliesToScope = true;
                break;
            }
            if (!appliesToScope) continue;
            if (requireAllPermissions) {
                boolean containsAllPermissions = true;
                Permission[] permissionArray = permissions;
                int n = permissionArray.length;
                for (int i = 0; i < n; ++i) {
                    Permission permission = permissionArray[i];
                    if (securityPolicy.getPermissions().contains(permission)) continue;
                    containsAllPermissions = false;
                    break;
                }
                if (!containsAllPermissions) continue;
                return true;
            }
            for (Permission permission : permissions) {
                if (!securityPolicy.getPermissions().contains(permission)) continue;
                return true;
            }
        }
        return false;
    }
}

