/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.utils;

import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.persistance.utilization.UtilizationDao;
import com.nuix.automate.scheduler.utils.StringUtils;
import com.nuix.automate.utils.licence.services.EventInfo;
import com.nuix.automate.utils.licence.services.Type;
import com.nuix.automate.utils.licence.services.metrics.Activity;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.utilization.DiagnosticLevel;
import com.nuix.automate.utils.utilization.Session;
import com.nuix.automate.utils.utilization.consumption.Consumption;
import com.nuix.automate.utils.utilization.consumption.ConsumptionEvent;
import java.util.LinkedHashSet;
import java.util.List;

public class SessionUtils {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(SessionUtils.class);
    private SchedulerApplication schedulerApplication;
    private LinkedHashSet<String> trackedEventIds;

    public SessionUtils(SchedulerApplication schedulerApplication) {
        this.schedulerApplication = schedulerApplication;
        this.trackedEventIds = new LinkedHashSet();
    }

    public synchronized void trackConsumptions(List<Consumption> consumptions) {
        UtilizationDao utilizationDao = this.schedulerApplication.getUtilizationDaoV2();
        for (Consumption consumption : consumptions) {
            try {
                for (ConsumptionEvent consumptionEvent : consumption.getConsumptionEvents()) {
                    try {
                        utilizationDao.addConsumption(consumptionEvent);
                    }
                    catch (Exception e) {
                        LOGGER.error("Failed consumption event " + consumptionEvent.toString(), (Throwable)e);
                        throw e;
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Cannot handle consumption " + String.valueOf(consumption), (Throwable)e);
            }
        }
    }

    public synchronized void trackSessionUtilization(List<EventInfo> eventInfos) {
        UtilizationDao utilizationDao = this.schedulerApplication.getUtilizationDaoV2();
        for (EventInfo eventInfo : eventInfos) {
            try {
                if (!eventInfo.getType().equals((Object)Type.SESSION_PING) && this.trackedEventIds.contains(eventInfo.getId())) continue;
                this.trackedEventIds.add(eventInfo.getId());
                while (this.trackedEventIds.size() > 1000) {
                    this.trackedEventIds.remove(this.trackedEventIds.iterator().next());
                }
                Session session = utilizationDao.getSession(eventInfo.getSessionId());
                if (session == null) {
                    session = new Session();
                    session.setSessionId(eventInfo.getSessionId());
                }
                switch (eventInfo.getType()) {
                    case SESSION_START: {
                        Object diagnosticLevelString;
                        session.setSessionStartEpoch(eventInfo.getDate());
                        session.setLicenseId(StringUtils.valueOf(eventInfo.getProperties().get("rampivaLicenseId")));
                        session.setProductName(StringUtils.valueOf(eventInfo.getProperties().get("productName")));
                        session.setProductVersion(StringUtils.valueOf(eventInfo.getProperties().get("productVersion")));
                        session.setNuixVersion(StringUtils.valueOf(eventInfo.getProperties().get("nuixVersion")));
                        session.setNuixLicenseType(StringUtils.valueOf(eventInfo.getProperties().get("nuixLicenseShortName")));
                        session.setNuixLicenseId(StringUtils.valueOf(eventInfo.getProperties().get("nuixLicenseId")));
                        session.setNuixLicenseOwner(StringUtils.valueOf(eventInfo.getProperties().get("nuixLicenseOwner")));
                        session.setNuixLicenseFingerprint(StringUtils.valueOf(eventInfo.getProperties().get("nuixLicenseFingerprint")));
                        Object sessionJob = eventInfo.getProperties().get("jobId");
                        if (sessionJob != null) {
                            session.setJobId(eventInfo.getProperties().get("jobId").toString());
                        }
                        if ((diagnosticLevelString = eventInfo.getProperties().get("diagnosticLevel")) != null) {
                            try {
                                DiagnosticLevel diagnosticLevel = DiagnosticLevel.valueOf((String)diagnosticLevelString.toString());
                                session.setDiagnosticLevel(diagnosticLevel);
                            }
                            catch (Exception diagnosticLevel) {
                                // empty catch block
                            }
                        }
                        if (eventInfo.getProperties().get("remote") != null) {
                            session.setRemote(Boolean.parseBoolean(eventInfo.getProperties().get("remote").toString()));
                        }
                        if (eventInfo.getProperties().get("nuixWorkersCount") == null) break;
                        session.setSessionWorkers((int)Double.parseDouble(eventInfo.getProperties().get("nuixWorkersCount").toString()));
                        session.setNuixLicenseType(eventInfo.getProperties().get("nuixLicenseShortName").toString());
                        break;
                    }
                    case SESSION_METRICS: {
                        Activity activity = Activity.valueOf((String)eventInfo.getProperties().get("activity").toString());
                        long volume = (long)Double.parseDouble(eventInfo.getProperties().get("volume").toString());
                        switch (activity) {
                            case LOAD: {
                                session.setVolumeLoaded(session.getVolumeLoaded() + volume);
                                break;
                            }
                            case EXPORT: {
                                session.setVolumeExported(session.getVolumeExported() + volume);
                                break;
                            }
                            case OCR: {
                                session.setVolumeOcred(session.getVolumeOcred() + volume);
                            }
                        }
                        break;
                    }
                    case SESSION_END: 
                    case SESSION_PING: {
                        Object relativityServiceId;
                        if (eventInfo.getProperties() != null && (relativityServiceId = eventInfo.getProperties().get("relativityServiceId")) != null) {
                            String previousId = session.getRelativityServiceId();
                            if (previousId == null) {
                                session.setRelativityServiceId(StringUtils.valueOf(relativityServiceId));
                            } else if (!previousId.contains(relativityServiceId.toString())) {
                                session.setRelativityServiceId(session.getRelativityServiceId() + ", " + StringUtils.valueOf(relativityServiceId));
                            }
                        }
                        session.setSessionEndEpoch(Math.max(session.getSessionEndEpoch(), eventInfo.getDate()));
                    }
                }
                utilizationDao.replaceSession(session);
            }
            catch (Exception e) {
                LOGGER.error("Cannot handle session event " + String.valueOf(eventInfo), (Throwable)e);
            }
        }
    }
}

