/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.utils;

import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.persistance.logging.LoggingDao;
import com.nuix.automate.scheduler.utils.WorkflowSerializationUtils;
import com.nuix.automate.utils.api.internal.permission.Permission;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.MimeTypeStat;
import com.nuix.automate.utils.general.OperationMimeTypeStats;
import com.nuix.automate.utils.general.SchedulerComponent;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.audit.AuditEvent;
import com.nuix.automate.utils.models.api.filelibrary.FileLibraryFile;
import com.nuix.automate.utils.models.api.filelibrary.LibraryNuixFileType;
import com.nuix.automate.utils.models.api.job.JobOperationMimeTypeStats;
import com.nuix.automate.utils.models.api.job.OperationStatus;
import com.nuix.automate.utils.models.api.job.Parameter;
import com.nuix.automate.utils.models.api.workflowlibrary.Workflow;
import com.nuix.automate.utils.models.internal.executionprofile.ExecutionProfileModel;
import com.nuix.automate.utils.models.internal.job.JobDetailsModel;
import com.nuix.automate.utils.models.internal.job.JobModel;
import com.nuix.automate.utils.models.internal.logging.LogEventModel;
import com.nuix.automate.utils.models.internal.logging.LogInfoModel;
import com.nuix.automate.utils.models.internal.logging.history.HistoryComponent;
import com.nuix.automate.utils.models.internal.logging.history.HistoryComponentType;
import com.nuix.automate.utils.workflow.LogLevel;
import com.nuix.automate.utils.workflow.ParameterType;
import com.nuix.automate.workflow.core.execution.workflow.ImmutableWorkflow;
import com.nuix.automate.workflow.core.execution.workflow.WorkflowRenderer;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.Semaphore;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;
import javax.ws.rs.core.StreamingOutput;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class ZippedLogsStreamingOutput
implements StreamingOutput {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ZippedLogsStreamingOutput.class);
    private final InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");
    private JobDetailsModel detailsModel;
    private boolean requestedJobLogs = false;
    private final List<LoggingDao> loggingDaos;
    private Set<LogInfoModel> logsInfo;
    private long afterDate;
    private long beforeDate;
    private boolean canViewSensitive = false;
    private SchedulerApplication schedulerApplication;

    public ZippedLogsStreamingOutput(List<LoggingDao> loggingDaos, JobDetailsModel detailsModel, Set<LogInfoModel> logsInfo, long afterDate, long beforeDate, SchedulerApplication schedulerApplication) {
        this.loggingDaos = loggingDaos;
        this.logsInfo = logsInfo;
        if (detailsModel != null) {
            this.requestedJobLogs = true;
            this.detailsModel = detailsModel;
        }
        this.afterDate = afterDate;
        this.beforeDate = beforeDate;
        this.schedulerApplication = schedulerApplication;
    }

    public ZippedLogsStreamingOutput(List<LoggingDao> loggingDaos, JobDetailsModel detailsModel, long afterDate, long beforeDate, SchedulerApplication schedulerApplication) {
        this.loggingDaos = loggingDaos;
        if (detailsModel != null) {
            this.requestedJobLogs = true;
            this.detailsModel = detailsModel;
        }
        this.afterDate = afterDate;
        this.beforeDate = beforeDate;
        this.schedulerApplication = schedulerApplication;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(OutputStream outputStream) {
        ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)new BufferedOutputStream(outputStream), StandardCharsets.UTF_8);
        zipOutputStream.setLevel(1);
        int listSize = 8192 * this.loggingDaos.size();
        long currentDate = this.afterDate;
        long creationDate = 0L;
        long lastModifiedDate = 0L;
        ZipEntry currentEntry = null;
        long downloadStartDate = System.currentTimeMillis();
        try {
            Semaphore lock = this.schedulerApplication.getLogsResource().getDaoLock();
            if (this.requestedJobLogs) {
                this.writeJobDetails(zipOutputStream);
                zipOutputStream.flush();
            }
            this.logsInfo = new HashSet<LogInfoModel>();
            for (LoggingDao loggingDao : this.loggingDaos) {
                LoggingDao loggingDao2;
                if (lock.availablePermits() == 0) {
                    LOGGER.warn("Exiting download, logs requested while database is being rolled over.");
                    zipOutputStream.close();
                    return;
                }
                if (this.requestedJobLogs) {
                    loggingDao2 = loggingDao;
                    synchronized (loggingDao2) {
                        this.logsInfo.addAll(loggingDao.getLogsForJobId(this.detailsModel.getSettings().getId()));
                        continue;
                    }
                }
                loggingDao2 = loggingDao;
                synchronized (loggingDao2) {
                    this.logsInfo.addAll(loggingDao.getLogsForRange(this.afterDate, this.beforeDate));
                }
            }
            for (LogInfoModel logInfo : this.logsInfo) {
                currentDate = this.afterDate;
                if (lock.availablePermits() == 0) {
                    LOGGER.warn("Exiting download, logs requested while database is being rolled over.");
                    zipOutputStream.close();
                    return;
                }
                ArrayList<LogEventModel> logs = new ArrayList<LogEventModel>();
                Iterator<LoggingDao> iterator = this.loggingDaos.iterator();
                while (iterator.hasNext()) {
                    LoggingDao loggingDao;
                    LoggingDao loggingDao3 = loggingDao = iterator.next();
                    synchronized (loggingDao3) {
                        if (logInfo.getJobId() != null) {
                            logs.addAll(loggingDao.getJobLogs(logInfo.getId(), logInfo.getJobId(), currentDate));
                        } else {
                            logs.addAll(loggingDao.getSystemLogs(logInfo.getId(), currentDate, this.beforeDate));
                        }
                    }
                }
                if (logs.size() == 0) {
                    LOGGER.info("Log size is zero skipping");
                    continue;
                }
                creationDate = ((LogEventModel)logs.get(0)).getDate();
                String component = logInfo.getComponent();
                String entryName = "";
                entryName = component.equals(SchedulerComponent.API_CLIENT.name()) || component.equals(SchedulerComponent.ENGINE.name()) || component.equals(SchedulerComponent.ENGINE_SERVER.name()) || component.equals(SchedulerComponent.SCHEDULER.name()) ? this.getEntryName(logInfo.getId(), logInfo.getComponent(), logInfo.getJobId()) : logInfo.getId();
                LOGGER.info("Logs preparing file " + entryName + " ...");
                currentEntry = new ZipEntry(entryName);
                try {
                    zipOutputStream.putNextEntry(currentEntry);
                    this.appendBOM(zipOutputStream);
                }
                catch (IOException ioe) {
                    if (ioe instanceof ZipException) {
                        LOGGER.error("Error when adding new entry", (Throwable)ioe);
                        continue;
                    }
                    throw ioe;
                }
                HashSet<UUID> resultSetRowIds = new HashSet<UUID>();
                boolean downloadTimeoutEnabled = this.schedulerApplication.getConfiguration().isEnableCentralizedLoggingDownloadTimeout();
                long downloadTimeout = this.schedulerApplication.getConfiguration().getCentralizedLoggingDownloadTimeout();
                try {
                    boolean finished = false;
                    do {
                        long timePassed;
                        if (lock.availablePermits() == 0) {
                            LOGGER.warn("Exiting download, logs requested while database is being rolled over.");
                            zipOutputStream.close();
                            return;
                        }
                        logs.sort(Comparator.comparing(LogEventModel::getDate).thenComparing(LogEventModel::getLogLine));
                        for (LogEventModel log : logs) {
                            UUID uniqueRowId = new UUID(log.getDate(), log.getLogLine());
                            if (!resultSetRowIds.add(uniqueRowId)) continue;
                            zipOutputStream.write(log.getMessage());
                        }
                        zipOutputStream.flush();
                        if (downloadTimeoutEnabled && (timePassed = System.currentTimeMillis() - downloadStartDate) > downloadTimeout) {
                            LOGGER.error("Log download took " + timePassed + " ms, which exceeds timeout of " + downloadTimeout + " ms");
                            zipOutputStream.close();
                            return;
                        }
                        if (logs.size() < listSize) {
                            finished = true;
                        }
                        lastModifiedDate = currentDate = ((LogEventModel)logs.get(logs.size() - 1)).getDate();
                        logs.clear();
                        if (finished) continue;
                        Iterator<Object> iterator2 = this.loggingDaos.iterator();
                        while (iterator2.hasNext()) {
                            LoggingDao loggingDao;
                            LoggingDao loggingDao4 = loggingDao = (LoggingDao)iterator2.next();
                            synchronized (loggingDao4) {
                                if ((logInfo.getComponent().equals(SchedulerComponent.ENGINE.name()) || logInfo.getComponent().equals(SchedulerComponent.API_CLIENT.name()) || logInfo.getComponent().equals(SchedulerComponent.NUIX_LOG.name()) || logInfo.getComponent().equals(SchedulerComponent.NUIX_STD_OUT_LOG.name()) || logInfo.getComponent().equals(SchedulerComponent.NUIX_STD_ERR_LOG.name()) || logInfo.getComponent().equals(SchedulerComponent.NUIX_DERBY_LOG.name()) || logInfo.getComponent().equals(SchedulerComponent.OTHER.name())) && logInfo.getJobId() != null) {
                                    logs.addAll(loggingDao.getJobLogs(logInfo.getId(), logInfo.getJobId(), currentDate));
                                } else {
                                    logs.addAll(loggingDao.getSystemLogs(logInfo.getId(), currentDate, this.beforeDate));
                                }
                            }
                        }
                    } while (!finished);
                }
                catch (IOException ioe) {
                    throw ioe;
                }
                catch (Exception e) {
                    LOGGER.error("Failed to write to log stream", (Throwable)e);
                }
                currentEntry.setCreationTime(FileTime.fromMillis(creationDate));
                currentEntry.setLastModifiedTime(FileTime.fromMillis(lastModifiedDate));
            }
        }
        catch (IOException ioe) {
            LOGGER.error("Output stream closed", (Throwable)ioe);
            return;
        }
        catch (Exception e) {
            LOGGER.error("Failed to generate logs", (Throwable)e);
        }
        try {
            zipOutputStream.close();
        }
        catch (Exception e) {
            LOGGER.error("Failed to close output stream", (Throwable)e);
        }
    }

    private void writeJobDetails(ZipOutputStream out) throws IOException {
        block58: {
            try {
                LOGGER.info("Job logs preparing job details ...");
                JobModel model = this.detailsModel.getSettings();
                boolean canViewSensitive = model.getUserPermissions().contains(Permission.VIEW_SENSITIVE);
                long lastModified = DateTime.now().getMillis();
                if (model.getLastStateChangedDate() != null) {
                    lastModified = model.getLastStateChangedDate();
                }
                String sanitizedModelName = FormattingUtils.sanitizeFilename((String)model.getName());
                if (canViewSensitive) {
                    ZipEntry htmlEntry;
                    ZipEntry rfnEntry;
                    Object sanitizedWorkflowName;
                    ImmutableWorkflow workflow;
                    Workflow libraryWorkflow;
                    ExecutionProfileModel executionProfile;
                    LOGGER.info("Job logs preparing job parameters ...");
                    StringBuilder parameterString = new StringBuilder();
                    parameterString.append("ParameterName\tValue");
                    for (Object workflowParameter : model.getSessionParameters()) {
                        String row = workflowParameter.getName() + "\t";
                        if (ParameterType.FILE_CONTENTS.equals((Object)workflowParameter.getParameterType())) {
                            String filename = "unknown";
                            String[] fileDataSplit = workflowParameter.getValue().split(":");
                            if (fileDataSplit.length == 2) {
                                filename = fileDataSplit[0];
                                ZipEntry fileEntry = new ZipEntry(this.getFileDirectoryForType(LibraryNuixFileType.CUSTOM_FILE) + filename);
                                out.putNextEntry(fileEntry);
                                out.write(FileUtils.decodeFileData((String)fileDataSplit[1]));
                            } else {
                                LOGGER.error("Unexpected parameter " + workflowParameter.getName() + " value format");
                            }
                            row = row + filename;
                        } else if (!workflowParameter.isSensitive()) {
                            row = row + workflowParameter.getValue();
                        }
                        parameterString.append("\r\n").append(row);
                    }
                    if (model.getExecutionProfileId() != null && (executionProfile = SchedulerApplication.getInstance().getExecutionProfileResource().getExecutionProfile(model.getExecutionProfileId())) != null) {
                        for (String executionParameter : executionProfile.getWorkflowParameters().keySet()) {
                            Parameter parameter = new Parameter(executionParameter, (String)executionProfile.getWorkflowParameters().get(executionParameter));
                            String row = parameter.getName() + "\t" + (!parameter.isSensitive() ? parameter.getValue() : "");
                            parameterString.append("\r\n").append(row);
                        }
                    }
                    String workflowXml = null;
                    String workflowDynamicUpdateXml = null;
                    long currentTimeMillis = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
                    List<HistoryComponent> jobHistory = this.schedulerApplication.getLoggingResource().getActiveLoggingDao().getJobHistoryComponents(model.getId());
                    for (HistoryComponent historyComponent : jobHistory) {
                        try {
                            try {
                                this.schedulerApplication.getLoggingResource().getActiveLoggingDao().updateComponentHistory(historyComponent.getId(), historyComponent.getVersion(), historyComponent.getType(), currentTimeMillis);
                            }
                            catch (Exception e) {
                                LOGGER.error("Unable to update component history", (Throwable)e);
                            }
                            if (historyComponent.getType() == HistoryComponentType.WORKFLOW) {
                                if (workflowXml != null) continue;
                                workflowXml = historyComponent.getData();
                                continue;
                            }
                            if (historyComponent.getType() == HistoryComponentType.WORKFLOW_DYNAMIC_UPDATE && workflowDynamicUpdateXml == null) {
                                workflowDynamicUpdateXml = historyComponent.getData();
                                continue;
                            }
                            try {
                                FileLibraryFile file = (FileLibraryFile)SerializationUtils.fromJson((String)historyComponent.getData(), FileLibraryFile.class);
                                String sanitizedFileName = FormattingUtils.sanitizeFilename((String)file.getName());
                                ZipEntry fileEntry = new ZipEntry(this.getFileDirectoryForType(file.getNuixFileType()) + sanitizedFileName);
                                out.putNextEntry(fileEntry);
                                fileEntry.setCreationTime(FileTime.fromMillis(file.getCreatedDate()));
                                fileEntry.setLastModifiedTime(FileTime.fromMillis(file.getLastStateChangedDate()));
                                out.write(this.decodeFileData(file.getData()));
                            }
                            catch (Exception e) {
                                LOGGER.error("Cannot deserialize " + String.valueOf(model) + " history component " + historyComponent.getId(), (Throwable)e);
                            }
                        }
                        catch (Exception e) {
                            LOGGER.error("Job logs cannot handle component", (Throwable)e);
                        }
                    }
                    if (workflowXml == null && model.getLibraryWorkflowId() != null && (libraryWorkflow = this.schedulerApplication.getLibraryResource().getLibraryWorkflow(model.getLibraryWorkflowId())) != null) {
                        workflowXml = this.schedulerApplication.getLibraryResource().getLibraryWorkflow(model.getLibraryWorkflowId()).getOperationsXml();
                    }
                    LOGGER.info("Job logs preparing submitted workflow ...");
                    try {
                        if (workflowXml != null) {
                            workflow = WorkflowSerializationUtils.getInstance().fromWorkflowCache(workflowXml);
                            sanitizedWorkflowName = FormattingUtils.sanitizeFilename((String)workflow.getName());
                            if (workflowDynamicUpdateXml != null) {
                                sanitizedWorkflowName = (String)sanitizedWorkflowName + " (Submitted)";
                            }
                            rfnEntry = new ZipEntry((String)sanitizedWorkflowName + ".rfn");
                            out.putNextEntry(rfnEntry);
                            this.appendBOM(out);
                            rfnEntry.setCreationTime(FileTime.fromMillis(lastModified));
                            rfnEntry.setLastModifiedTime(FileTime.fromMillis(lastModified));
                            out.write(workflow.toXml().getBytes(StandardCharsets.UTF_8));
                            htmlEntry = new ZipEntry((String)sanitizedWorkflowName + ".html");
                            out.putNextEntry(htmlEntry);
                            this.appendBOM(out);
                            htmlEntry.setCreationTime(FileTime.fromMillis(lastModified));
                            htmlEntry.setLastModifiedTime(FileTime.fromMillis(lastModified));
                            long workflowLastModifiedDefaultDate = lastModified;
                            if (model.getSubmittedDate() != null) {
                                workflowLastModifiedDefaultDate = model.getSubmittedDate();
                            }
                            out.write(WorkflowRenderer.getWorkflowHtmlReport((ImmutableWorkflow)workflow, (long)workflowLastModifiedDefaultDate).getBytes(StandardCharsets.UTF_8));
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("Job logs cannot handle submitted workflow", (Throwable)e);
                    }
                    LOGGER.info("Job logs preparing executed workflow ...");
                    try {
                        if (workflowDynamicUpdateXml != null) {
                            workflow = WorkflowSerializationUtils.getInstance().fromWorkflowCache(workflowDynamicUpdateXml);
                            sanitizedWorkflowName = FormattingUtils.sanitizeFilename((String)workflow.getName());
                            rfnEntry = new ZipEntry((String)sanitizedWorkflowName + ".rfn");
                            out.putNextEntry(rfnEntry);
                            this.appendBOM(out);
                            rfnEntry.setCreationTime(FileTime.fromMillis(lastModified));
                            rfnEntry.setLastModifiedTime(FileTime.fromMillis(lastModified));
                            out.write(workflow.toXml().getBytes(StandardCharsets.UTF_8));
                            htmlEntry = new ZipEntry((String)sanitizedWorkflowName + ".html");
                            out.putNextEntry(htmlEntry);
                            this.appendBOM(out);
                            htmlEntry.setCreationTime(FileTime.fromMillis(lastModified));
                            htmlEntry.setLastModifiedTime(FileTime.fromMillis(lastModified));
                            long workflowLastModifiedDefaultDate = lastModified;
                            if (model.getSubmittedDate() != null) {
                                workflowLastModifiedDefaultDate = model.getSubmittedDate();
                            }
                            out.write(WorkflowRenderer.getWorkflowHtmlReport((ImmutableWorkflow)workflow, (long)workflowLastModifiedDefaultDate).getBytes(StandardCharsets.UTF_8));
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("Job logs cannot handle executed workflow", (Throwable)e);
                    }
                    Iterator parametersEntry = new ZipEntry(sanitizedModelName + "_parameters.tsv");
                    out.putNextEntry((ZipEntry)((Object)parametersEntry));
                    this.appendBOM(out);
                    ((ZipEntry)((Object)parametersEntry)).setCreationTime(FileTime.fromMillis(lastModified));
                    ((ZipEntry)((Object)parametersEntry)).setLastModifiedTime(FileTime.fromMillis(lastModified));
                    out.write(parameterString.toString().getBytes(StandardCharsets.UTF_8));
                }
                try {
                    List<LogEventModel> executionLogs = this.schedulerApplication.getJobsDao().getRawJobExecutionLog(model.getId());
                    if (executionLogs == null || executionLogs.size() == 0) {
                        executionLogs = this.schedulerApplication.getJobsArchiveDao().getRawJobExecutionLog(model.getId());
                    }
                    if (executionLogs != null && executionLogs.size() > 0) {
                        ZipEntry executionLogEntry = new ZipEntry(sanitizedModelName + ".log");
                        out.putNextEntry(executionLogEntry);
                        this.appendBOM(out);
                        executionLogEntry.setCreationTime(FileTime.fromMillis(lastModified));
                        executionLogEntry.setLastModifiedTime(FileTime.fromMillis(lastModified));
                        HashSet<LogLevel> levelsToPrint = new HashSet<LogLevel>(Arrays.asList(LogLevel.WARNING, LogLevel.TRANSIENT_WARNING_TRIGGERED, LogLevel.TRANSIENT_WARNING_RESOLVED, LogLevel.ERROR, LogLevel.NON_CRITICAL_ERROR, LogLevel.SOFT_ERROR));
                        for (LogEventModel executionLog : executionLogs) {
                            LogLevel logLevel = LogLevel.valueOf((String)executionLog.getComponent());
                            if (levelsToPrint.contains(logLevel)) {
                                out.write((this.iu.getString("LogLevel." + logLevel.name()) + " ").getBytes(StandardCharsets.UTF_8));
                            }
                            out.write(executionLog.getMessage());
                            out.write("\n".getBytes(StandardCharsets.UTF_8));
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Job logs cannot handle execution log", (Throwable)e);
                }
                if (!canViewSensitive) break block58;
                try {
                    if (this.schedulerApplication.getConfiguration().getTrackUtilization()) {
                        StringBuilder changeLogString = new StringBuilder();
                        changeLogString.append("Date,PerformedBy,EventType,Details\r\n");
                        List<AuditEvent> changeLog = this.schedulerApplication.getAuditLogDao().getAuditEvents(model.getId());
                        TreeSet<String> dataSetIds = new TreeSet<String>();
                        TreeSet<String> thirdPartyServiceIds = new TreeSet<String>();
                        TreeSet<String> legalHoldIds = new TreeSet<String>();
                        List sessionParameters = model.getSessionParameters();
                        for (Parameter sessionParameter : sessionParameters) {
                            if (sessionParameter.isDataSet()) {
                                String datasetId = sessionParameter.getValue();
                                dataSetIds.add(datasetId);
                                continue;
                            }
                            if (sessionParameter.isThirdPartyServiceParameter()) {
                                thirdPartyServiceIds.add(sessionParameter.getValue());
                                continue;
                            }
                            if (!sessionParameter.isLegalHold()) continue;
                            legalHoldIds.add(sessionParameter.getValue());
                        }
                        for (String dataSetId : dataSetIds) {
                            changeLog.addAll(this.schedulerApplication.getAuditLogDao().getAuditEvents(dataSetId));
                        }
                        for (String thirdPartyServiceId : thirdPartyServiceIds) {
                            changeLog.addAll(this.schedulerApplication.getAuditLogDao().getAuditEvents(thirdPartyServiceId));
                        }
                        for (String legalHoldId : legalHoldIds) {
                            changeLog.addAll(this.schedulerApplication.getAuditLogDao().getAuditEvents(legalHoldId));
                        }
                        changeLog.sort(Comparator.comparing(AuditEvent::getDate));
                        long lastAuditModified = 0L;
                        for (AuditEvent event : changeLog) {
                            changeLogString.append(FormattingUtils.encodeForCsv((String)FormattingUtils.dateTimeToExcelDateTimeString((DateTime)new DateTime((Object)event.getDate())))).append(",").append(FormattingUtils.encodeForCsv((String)event.getPerformedBy())).append(",").append(FormattingUtils.encodeForCsv((String)event.getEventType().toString())).append(",").append(FormattingUtils.encodeForCsv((String)event.getDetails())).append("\r\n");
                            lastAuditModified = event.getDate();
                        }
                        if (changeLog.size() > 0) {
                            ZipEntry changeLogEntry = new ZipEntry(sanitizedModelName + "_changelog.csv");
                            out.putNextEntry(changeLogEntry);
                            this.appendBOM(out);
                            changeLogEntry.setCreationTime(FileTime.fromMillis(changeLog.get(0).getDate()));
                            changeLogEntry.setLastModifiedTime(FileTime.fromMillis(lastAuditModified));
                            out.write(changeLogString.toString().getBytes(StandardCharsets.UTF_8));
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Job logs cannot handle change log", (Throwable)e);
                }
                JobOperationMimeTypeStats stats = this.schedulerApplication.getJobsDao().getJobOperationMimeTypeStats(model.getId());
                if (stats != null && stats.getMimeTypeStats() != null) {
                    for (OperationMimeTypeStats stat : stats.getMimeTypeStats()) {
                        try {
                            Object mimeStat2;
                            String sanitizedOperationName = "Operation Stats/" + FormattingUtils.sanitizeFilename((String)(stat.getOperationIndex() + 1 + ". " + ((OperationStatus)this.detailsModel.getOperations().get(stat.getOperationIndex())).getName()));
                            ZipEntry mimeTypeEntry = new ZipEntry(sanitizedOperationName + ".csv");
                            out.putNextEntry(mimeTypeEntry);
                            this.appendBOM(out);
                            ArrayList sortedMimeTypeStats = new ArrayList(stat.getOperationMimeTypeStats().values());
                            sortedMimeTypeStats.sort(Comparator.comparing(MimeTypeStat::getProcessed).reversed());
                            LinkedHashSet<String> columns = new LinkedHashSet<String>();
                            columns.add("mime_type");
                            columns.add("file_type");
                            HashSet emptySortedColumns = new HashSet();
                            emptySortedColumns.addAll(stat.getSortedStageNames());
                            columns.addAll(stat.getSortedStageNames());
                            for (Object mimeStat2 : sortedMimeTypeStats) {
                                columns.addAll(mimeStat2.getColumnItemCount().keySet());
                                emptySortedColumns.removeAll(mimeStat2.getColumnItemCount().keySet());
                            }
                            columns.removeAll(emptySortedColumns);
                            ArrayList<String> encodedHeaders = new ArrayList<String>();
                            mimeStat2 = columns.iterator();
                            while (mimeStat2.hasNext()) {
                                String header = (String)mimeStat2.next();
                                String translatedHeader = null;
                                if (header.endsWith("_processed")) {
                                    String updatedHeaderName = header.replace("_processed", "");
                                    translatedHeader = FormattingUtils.getExportStageTranslation((String)updatedHeaderName);
                                } else {
                                    translatedHeader = FormattingUtils.getExportStageTranslation((String)header);
                                }
                                String encodedHeader = FormattingUtils.encodeForCsv((String)translatedHeader);
                                encodedHeaders.add(encodedHeader);
                            }
                            StringBuilder mimeTypeStatsString = new StringBuilder();
                            mimeTypeStatsString.append(String.join((CharSequence)",", encodedHeaders)).append("\r\n");
                            for (MimeTypeStat mimeStat3 : sortedMimeTypeStats) {
                                ArrayList<Object> row = new ArrayList<Object>();
                                row.add(mimeStat3.getMimeType());
                                row.add(mimeStat3.getFileType());
                                for (String header : columns) {
                                    if (header.equals("mime_type") || header.equals("file_type")) continue;
                                    Long value = (Long)mimeStat3.getColumnItemCount().get(header);
                                    row.add(value == null ? "0" : "" + value);
                                }
                                mimeTypeStatsString.append(String.join((CharSequence)",", row) + "\r\n");
                            }
                            out.write(mimeTypeStatsString.toString().getBytes(StandardCharsets.UTF_8));
                        }
                        catch (Exception e) {
                            LOGGER.error("Job logs cannot handle mime stats", (Throwable)e);
                        }
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Cannot prepare job log details", (Throwable)e);
            }
        }
    }

    private String getFileDirectoryForType(LibraryNuixFileType type) {
        switch (type) {
            case CONFIGURATION_PROFILE: {
                return "Configuration Profiles/";
            }
            case PROCESSING_PROFILE: {
                return "Processing Profiles/";
            }
            case PRODUCTION_PROFILE: {
                return "Production Profiles/";
            }
            case METADATA_IMPORT_PROFILE: {
                return "Metadata Import Profiles/";
            }
            case PLAYBOOK: {
                return "Playbook/";
            }
            case METADATA_PROFILE: {
                return "Metadata Profiles/";
            }
            case IMAGING_PROFILE: {
                return "Imaging Profiles/";
            }
            case OCR_PROFILE: {
                return "OCR Profiles/";
            }
        }
        return "Additional Files/";
    }

    private byte[] decodeFileData(String encodedFileData) {
        byte[] fileData;
        if (encodedFileData == null) {
            return null;
        }
        try {
            fileData = Base64.getDecoder().decode(encodedFileData);
        }
        catch (Exception e) {
            fileData = encodedFileData.getBytes(StandardCharsets.UTF_8);
        }
        return fileData;
    }

    private void appendBOM(ZipOutputStream out) throws IOException {
        out.write(65263);
        out.write(65211);
        out.write(65215);
        out.flush();
    }

    private String getEntryName(String id, String component, String jobId) {
        if (component == null) {
            return "engine." + this.getShortId(id) + "-job." + this.getShortId(jobId) + ".log";
        }
        if (component.equals(SchedulerComponent.ENGINE.name())) {
            if (jobId == null) {
                return "engine." + this.getShortId(id) + "-init.log";
            }
            return "engine." + this.getShortId(id) + "-job." + this.getShortId(jobId) + ".log";
        }
        if (component.equals(SchedulerComponent.API_CLIENT.name())) {
            if (jobId == null) {
                return "automate-api." + id + ".log";
            }
            return "automate-api." + id + "-job." + this.getShortId(jobId) + ".log";
        }
        String componentName = component.toLowerCase().replace("_", "-");
        String sanitizedComponentName = FormattingUtils.sanitizeFilename((String)componentName);
        return "automate-" + sanitizedComponentName + "." + this.getShortId(id) + ".log";
    }

    public String getShortId(String id) {
        if (id != null) {
            return UidUtils.getShortId((String)id);
        }
        return "00000000";
    }
}

