/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.utils.allowedvalues;

import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.utils.allowedvalues.AllowedValueObjects;
import com.nuix.automate.scheduler.utils.allowedvalues.AllowedValues;
import com.nuix.automate.scheduler.utils.allowedvalues.DataRepositoryAllowedValues;
import com.nuix.automate.scheduler.utils.allowedvalues.DataSetAllowedValues;
import com.nuix.automate.scheduler.utils.allowedvalues.EccObjectAllowedValues;
import com.nuix.automate.scheduler.utils.allowedvalues.GroupAllowedValues;
import com.nuix.automate.scheduler.utils.allowedvalues.LegalHoldAllowedValues;
import com.nuix.automate.scheduler.utils.allowedvalues.LibraryFileAllowedValues;
import com.nuix.automate.scheduler.utils.allowedvalues.NuixProfileAllowedValues;
import com.nuix.automate.scheduler.utils.allowedvalues.ParameterAllowedValues;
import com.nuix.automate.scheduler.utils.allowedvalues.RelativityFilterableObjectAllowedValues;
import com.nuix.automate.scheduler.utils.allowedvalues.ScriptedAllowedValues;
import com.nuix.automate.scheduler.utils.allowedvalues.ThirdPartyServiceAllowedValues;
import com.nuix.automate.scheduler.utils.allowedvalues.TimezoneAllowedValues;
import com.nuix.automate.utils.api.internal.permission.Permission;
import com.nuix.automate.utils.general.CollectionUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.client.Client;
import com.nuix.automate.utils.models.api.client.ClientPool;
import com.nuix.automate.utils.models.api.client.Matter;
import com.nuix.automate.utils.models.api.dataset.DatasetType;
import com.nuix.automate.utils.models.api.job.AllowedValueItem;
import com.nuix.automate.utils.models.api.job.Parameter;
import com.nuix.automate.utils.models.api.workflowlibrary.Workflow;
import com.nuix.automate.utils.models.api.workflowlibrary.WorkflowLibrary;
import com.nuix.automate.utils.workflow.ParameterType;
import com.nuix.automate.workflow.core.utils.general.ScriptUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class AllowedValueUtils {
    protected static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(AllowedValueUtils.class);
    protected InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");
    private SchedulerApplication schedulerApplication;
    private static AllowedValueUtils instance;

    public static AllowedValueUtils getInstance(SchedulerApplication schedulerApplication) {
        if (instance == null) {
            instance = new AllowedValueUtils(schedulerApplication);
        }
        return instance;
    }

    private AllowedValueUtils(SchedulerApplication schedulerApplication) {
        this.schedulerApplication = schedulerApplication;
    }

    public Map<String, List<AllowedValueItem>> getAllowedSessionParameterValueItems(BearerUser user, String matterId, String workflowId, List<Parameter> parameters, LinkedHashMap<String, String> parameterNameValueMap, Permission allowedValuesScopePermission, boolean includeHiddenDatasets) {
        HashMap<ParameterType, String> serviceIds = new HashMap<ParameterType, String>();
        for (Parameter parameter : parameters) {
            String value;
            if (!parameter.isThirdPartyServiceParameter() || (value = parameterNameValueMap.get(parameter.getName())) == null) continue;
            serviceIds.putIfAbsent(parameter.getParameterType(), value);
        }
        return this.getAllowedSessionParameterValueItems(user, matterId, workflowId, parameters, serviceIds, parameterNameValueMap, allowedValuesScopePermission, includeHiddenDatasets);
    }

    public Map<String, List<AllowedValueItem>> getAllowedSessionParameterValueItems(BearerUser user, String matterId, String workflowId, List<Parameter> parameters, Map<ParameterType, String> serviceIds, LinkedHashMap<String, String> parameterNameValueMap, Permission allowedValuesScopePermission, boolean includeHiddenDatasets) {
        HashMap<String, List<AllowedValueItem>> allowedValueItems = new HashMap<String, List<AllowedValueItem>>();
        AllowedValueObjects allowedValueObjects = this.getAllowedValueObjects(workflowId, matterId, parameterNameValueMap);
        for (Parameter parameter : parameters) {
            List<String> clientPoolsAllowedValues = this.resolveClientPoolAllowedValues(allowedValueObjects.getClientPools(), parameter.getName());
            List matterAllowedValues = null;
            if (allowedValueObjects.getMatter() != null) {
                matterAllowedValues = (List)allowedValueObjects.getMatter().getAllowedParameterValues().get(parameter.getName());
            }
            List clientAllowedValues = null;
            if (allowedValueObjects.getClient() != null) {
                clientAllowedValues = (List)allowedValueObjects.getClient().getAllowedParameterValues().get(parameter.getName());
            }
            AllowedValues allowedValues = this.getAllowedValues(user, parameter, clientAllowedValues, matterAllowedValues, clientPoolsAllowedValues, allowedValueObjects.getClient(), allowedValueObjects.getMatter(), allowedValueObjects.getWorkflowLibrary(), allowedValueObjects.getWorkflow(), parameterNameValueMap, serviceIds, includeHiddenDatasets);
            List<AllowedValueItem> parameterAllowedValueItems = null;
            if (allowedValues != null) {
                parameterAllowedValueItems = allowedValues.getAllowedSessionParameterValueItems(allowedValuesScopePermission);
                this.verifyAllowedValues(parameter, parameterAllowedValueItems);
            }
            if (parameterAllowedValueItems != null && this.schedulerApplication.getConfiguration().getSortAllowedParametersValues()) {
                parameterAllowedValueItems.sort(Comparator.comparing(AllowedValueItem::getName));
            }
            allowedValueItems.put(parameter.getName(), parameterAllowedValueItems);
        }
        return allowedValueItems;
    }

    public Map<String, List<String>> getAllowedSessionParameterValues(BearerUser user, String matterId, String workflowId, Set<String> parameterNames, LinkedHashMap<String, String> parameterNameValueMap, boolean ignoreException) {
        HashMap<String, List<String>> allowedValueItems = new HashMap<String, List<String>>();
        AllowedValueObjects allowedValueObjects = this.getAllowedValueObjects(workflowId, matterId, parameterNameValueMap);
        Map<String, Parameter> sessionParametersMap = null;
        if (allowedValueObjects.getWorkflow() != null) {
            sessionParametersMap = allowedValueObjects.getWorkflow().getSessionParameters().stream().collect(Collectors.toMap(Parameter::getName, p -> p, Parameter::new));
        }
        for (String parameterName : parameterNames) {
            List<String> clientPoolsAllowedValues = this.resolveClientPoolAllowedValues(allowedValueObjects.getClientPools(), parameterName);
            List matterAllowedValues = null;
            if (allowedValueObjects.getMatter() != null) {
                matterAllowedValues = (List)allowedValueObjects.getMatter().getAllowedParameterValues().get(parameterName);
            }
            List clientAllowedValues = null;
            if (allowedValueObjects.getClient() != null) {
                clientAllowedValues = (List)allowedValueObjects.getClient().getAllowedParameterValues().get(parameterName);
            }
            Parameter parameter = null;
            parameter = allowedValueObjects.getWorkflow() != null ? sessionParametersMap.get(parameterName) : new Parameter(parameterName, null);
            AllowedValues allowedValues = this.getAllowedValues(user, parameter, clientAllowedValues, matterAllowedValues, clientPoolsAllowedValues, allowedValueObjects.getClient(), allowedValueObjects.getMatter(), allowedValueObjects.getWorkflowLibrary(), allowedValueObjects.getWorkflow(), parameterNameValueMap, null, true);
            List<String> parameterAllowedValues = null;
            if (allowedValues != null) {
                parameterAllowedValues = allowedValues.getAllowedSessionParameterValues();
                this.verifyAllowedValues(parameter, ignoreException, parameterAllowedValues);
            }
            if (parameterAllowedValues != null && this.schedulerApplication.getConfiguration().getSortAllowedParametersValues()) {
                parameterAllowedValues.sort(String::compareTo);
            }
            allowedValueItems.put(parameterName, parameterAllowedValues);
        }
        return allowedValueItems;
    }

    private AllowedValues getAllowedValues(BearerUser user, Parameter parameter, List<String> clientAllowedValues, List<String> matterAllowedValues, List<String> clientPoolAllowedValues, Client client, Matter matter, WorkflowLibrary workflowLibrary, Workflow workflowModel, LinkedHashMap<String, String> parameterNameValueMap, Map<ParameterType, String> serviceIds, boolean includeHiddenDatasets) {
        switch (parameter.getParameterType()) {
            case TEXT: 
            case INTEGER: 
            case BOOLEAN: 
            case DATE_TIME: 
            case DATE: 
            case SERVER_FILE: 
            case FILE_CONTENTS: 
            case SERVER_FOLDER: {
                return new ParameterAllowedValues(this.schedulerApplication, parameter, clientAllowedValues, matterAllowedValues, clientPoolAllowedValues);
            }
            case PURVIEW_SERVICE: 
            case RELATIVITY_SERVICE: 
            case DISCOVER_SERVICE: 
            case NLP_SERVICE: 
            case VAULT_SERVICE: 
            case VERITONE_SERVICE: 
            case SMTP_SERVICE: 
            case GRAPH_SERVICE: 
            case GEN_AI_SERVICE: 
            case ELASTICSEARCH_SERVICE: 
            case SEMANTIC_SERVICE: 
            case ECC_SERVICE: {
                ThirdPartyServiceAllowedValues allowedValues = new ThirdPartyServiceAllowedValues(this.schedulerApplication, parameter, clientAllowedValues, matterAllowedValues, clientPoolAllowedValues, user);
                allowedValues.setParameterType(parameter.getParameterType());
                return allowedValues;
            }
            case RELATIVITY_WORKSPACE: 
            case RELATIVITY_CLIENT: 
            case RELATIVITY_MATTER: 
            case RELATIVITY_WORKSPACE_FIELD: 
            case RELATIVITY_DT_SEARCH: 
            case RELATIVITY_VIEW: 
            case RELATIVITY_FOLDER: 
            case RELATIVITY_SAVED_SEARCH: {
                return new RelativityFilterableObjectAllowedValues(this.schedulerApplication, parameter, clientAllowedValues, matterAllowedValues, clientPoolAllowedValues, user, serviceIds, parameterNameValueMap);
            }
            case GROUP: {
                return new GroupAllowedValues(this.schedulerApplication, parameter, clientAllowedValues, matterAllowedValues, clientPoolAllowedValues, user);
            }
            case LIBRARY_FILE: {
                return new LibraryFileAllowedValues(this.schedulerApplication, parameter, clientAllowedValues, matterAllowedValues, clientPoolAllowedValues, user);
            }
            case DATA_SET: {
                String matterId = matter == null ? null : matter.getId();
                return new DataSetAllowedValues(this.schedulerApplication, parameter, clientAllowedValues, matterAllowedValues, clientPoolAllowedValues, user, matterId, includeHiddenDatasets);
            }
            case AZURE_STORAGE_ACCOUNT: {
                DataRepositoryAllowedValues allowedValues = new DataRepositoryAllowedValues(this.schedulerApplication, parameter, clientAllowedValues, matterAllowedValues, clientPoolAllowedValues, user);
                allowedValues.setType(DatasetType.AZURE_STORAGE_ACCOUNT);
                return allowedValues;
            }
            case LEGAL_HOLD: {
                return new LegalHoldAllowedValues(this.schedulerApplication, parameter, clientAllowedValues, matterAllowedValues, clientPoolAllowedValues, user);
            }
            case SCRIPTED: {
                return new ScriptedAllowedValues(this.schedulerApplication, parameter, clientAllowedValues, matterAllowedValues, clientPoolAllowedValues, user, client, matter, workflowLibrary, workflowModel, serviceIds, parameterNameValueMap);
            }
            case ECC_COMPUTER: 
            case ECC_CONFIGURATION: {
                return new EccObjectAllowedValues(this.schedulerApplication, parameter, clientAllowedValues, matterAllowedValues, clientPoolAllowedValues, user, serviceIds, parameterNameValueMap);
            }
            case PROCESSING_PROFILE: 
            case CONFIGURATION_PROFILE: 
            case METADATA_PROFILE: 
            case METADATA_IMPORT_PROFILE: 
            case PLAYBOOK: 
            case OCR_PROFILE: 
            case IMAGING_PROFILE: 
            case PRODUCTION_PROFILE: {
                NuixProfileAllowedValues allowedValues = new NuixProfileAllowedValues(this.schedulerApplication, parameter, clientAllowedValues, matterAllowedValues, clientPoolAllowedValues, user);
                allowedValues.setFileType(parameter.getParameterType());
                return allowedValues;
            }
            case TIMEZONE: {
                return new TimezoneAllowedValues(this.schedulerApplication, parameter, clientAllowedValues, matterAllowedValues, clientPoolAllowedValues);
            }
        }
        return null;
    }

    private AllowedValueObjects getAllowedValueObjects(String workflowId, String matterId, LinkedHashMap<String, String> parameterNameValueMap) {
        AllowedValueObjects allowedValueObjects = new AllowedValueObjects();
        Workflow workflowModel = null;
        if (workflowId != null) {
            workflowModel = this.schedulerApplication.getLibraryResource().getLibraryWorkflow(workflowId);
            allowedValueObjects.setWorkflow(workflowModel);
        }
        WorkflowLibrary workflowLibrary = null;
        if (workflowModel != null) {
            workflowLibrary = this.schedulerApplication.getLibraryResource().getWorkflowLibrary(workflowModel.getLibraryId());
            allowedValueObjects.setWorkflowLibrary(workflowLibrary);
        }
        Matter matter = null;
        if (matterId != null) {
            matter = this.schedulerApplication.getClientResource().getMatter(matterId);
            allowedValueObjects.setMatter(matter);
        }
        Client client = null;
        if (matter != null) {
            client = this.schedulerApplication.getClientResource().getClient(matter.getClientId());
            allowedValueObjects.setClient(client);
        }
        HashSet<ClientPool> clientPools = new HashSet<ClientPool>();
        if (client != null) {
            Set<String> clientPoolsIds = this.schedulerApplication.getClientMatterDao().getClientPoolIdsWithClientId(client.getId());
            for (String clientPoolId : clientPoolsIds) {
                ClientPool clientPool = this.schedulerApplication.getClientMatterDao().getClientPool(clientPoolId);
                if (clientPool == null) continue;
                clientPools.add(clientPool);
            }
        }
        allowedValueObjects.setClientPools(clientPools);
        return allowedValueObjects;
    }

    private List<String> resolveClientPoolAllowedValues(Set<ClientPool> clientPools, String parameterName) {
        ArrayList allowedValues = null;
        for (ClientPool clientPool : clientPools) {
            List additionalValues = (List)clientPool.getAllowedParameterValues().get(parameterName);
            if (additionalValues == null) continue;
            if (allowedValues == null) {
                allowedValues = new ArrayList(additionalValues);
                continue;
            }
            allowedValues = CollectionUtils.intersection(allowedValues, (List)additionalValues);
        }
        return allowedValues;
    }

    public void verifyAllowedValues(Parameter parameter, List<AllowedValueItem> allowedValueItems) {
        ArrayList<String> allowedValues = new ArrayList<String>();
        if (allowedValueItems != null) {
            for (AllowedValueItem allowedValueItem : allowedValueItems) {
                allowedValues.add(allowedValueItem.getValue());
            }
        }
        this.verifyAllowedValues(parameter, true, allowedValues);
    }

    public void verifyAllowedValues(Parameter parameter, boolean ignoreException, List<String> allowedValues) {
        if (allowedValues != null) {
            String parameterNameFriendlyName = parameter.getFriendlyNameAndName();
            if (allowedValues.size() == 0 && !ignoreException) {
                LOGGER.error("Cannot evaluate parameter " + parameterNameFriendlyName + ". No values are allowed.");
                throw new IllegalArgumentException(this.iu.getFormattedString("ScriptUtils.ErrorParameterNoValuesAllowed", (Object)parameterNameFriendlyName));
            }
            for (String allowedValue : allowedValues) {
                String scriptEngineName = ScriptUtils.getScriptEngineName((String)allowedValue);
                if (scriptEngineName == null) continue;
                throw new IllegalArgumentException(this.iu.getFormattedString("ScriptUtils.ScripedAllowedValuesAreNotSupported", (Object)parameterNameFriendlyName));
            }
        }
    }

    public Map<String, List<String>> getAllowedSessionParameterValues(BearerUser user, String matterId, String workflowId, Set<String> parameterNames, LinkedHashMap<String, String> parameterNameValueMap) {
        return this.getAllowedSessionParameterValues(user, matterId, workflowId, parameterNames, parameterNameValueMap, false);
    }
}

