/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.utils.allowedvalues;

import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.utils.api.internal.permission.Permission;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.job.AllowedValueItem;
import com.nuix.automate.utils.models.api.job.Parameter;
import com.nuix.automate.utils.workflow.ParameterValueMatchBy;
import java.util.List;

public abstract class AllowedValues {
    protected static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(AllowedValues.class);
    protected InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");
    protected SchedulerApplication schedulerApplication;
    protected Parameter parameter;

    public AllowedValues(SchedulerApplication schedulerApplication, Parameter parameter) {
        this.schedulerApplication = schedulerApplication;
        this.parameter = parameter;
    }

    protected boolean matchesAllowedValues(List<String> parameterAllowedValues, String systemValue, String displayValue) {
        if (parameterAllowedValues == null) {
            return true;
        }
        ParameterValueMatchBy allowedValuesMatchBy = this.parameter.getAllowedValuesMatchBy();
        if (allowedValuesMatchBy == null) {
            allowedValuesMatchBy = ParameterValueMatchBy.SYSTEM_OR_USER_PRINTABLE_VALUE;
        }
        switch (allowedValuesMatchBy) {
            case SYSTEM_VALUE: {
                return parameterAllowedValues.contains(systemValue);
            }
            case USER_PRINTABLE_VALUE: {
                return parameterAllowedValues.contains(displayValue);
            }
        }
        return parameterAllowedValues.contains(systemValue) || parameterAllowedValues.contains(displayValue);
    }

    protected abstract List<String> getAllowedSessionParameterValues();

    protected abstract List<AllowedValueItem> getAllowedSessionParameterValueItems(Permission var1);
}

