/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.utils.allowedvalues;

import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.security.thirdparty.EccServiceSession;
import com.nuix.automate.scheduler.utils.allowedvalues.ParameterAllowedValues;
import com.nuix.automate.utils.api.internal.permission.Permission;
import com.nuix.automate.utils.ecc.responses.computers.Computer;
import com.nuix.automate.utils.ecc.responses.configurations.Configuration;
import com.nuix.automate.utils.models.api.job.AllowedValueItem;
import com.nuix.automate.utils.models.api.job.Parameter;
import com.nuix.automate.utils.workflow.ParameterType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class EccObjectAllowedValues
extends ParameterAllowedValues {
    protected String eccServiceId;
    protected BearerUser user;
    protected LinkedHashMap<String, String> parameterNameValueMap;

    public EccObjectAllowedValues(SchedulerApplication schedulerApplication, Parameter parameter, List<String> clientAllowedValues, List<String> matterAllowedValues, List<String> clientPoolAllowedValues, BearerUser user, Map<ParameterType, String> serviceIds, LinkedHashMap<String, String> parameterNameValueMap) {
        super(schedulerApplication, parameter, clientAllowedValues, matterAllowedValues, clientPoolAllowedValues);
        this.user = user;
        if (serviceIds != null && serviceIds.get(ParameterType.ECC_SERVICE) != null) {
            this.eccServiceId = serviceIds.get(ParameterType.ECC_SERVICE);
        }
        this.parameterNameValueMap = parameterNameValueMap;
    }

    protected List<AllowedValueItem> getEccObjects() {
        block12: {
            if (this.eccServiceId != null && !this.eccServiceId.equals("")) {
                try {
                    EccServiceSession eccServiceSession = (EccServiceSession)this.schedulerApplication.getThirdPartyServiceResource().getThirdPartyServiceSession(this.eccServiceId, this.user.getId(), true);
                    if (!eccServiceSession.getSignedIn()) break block12;
                    ArrayList<AllowedValueItem> allowedValueItems = new ArrayList<AllowedValueItem>();
                    try {
                        switch (this.parameter.getParameterType()) {
                            case ECC_COMPUTER: {
                                List<Computer> computers = eccServiceSession.getComputers();
                                if (computers == null) break;
                                for (Computer computer : computers) {
                                    allowedValueItems.add(new AllowedValueItem(computer.getName()));
                                }
                                break;
                            }
                            case ECC_CONFIGURATION: {
                                List<Configuration> configurations = eccServiceSession.getConfigurations();
                                if (configurations == null) break;
                                for (Configuration configuration : configurations) {
                                    allowedValueItems.add(new AllowedValueItem(configuration.getName()));
                                }
                                break;
                            }
                        }
                    }
                    catch (IOException e) {
                        LOGGER.error("Unable to query " + this.parameter.getParameterType().toLocalizedString(), (Throwable)e);
                    }
                    if (allowedValueItems.size() >= 1) {
                        return allowedValueItems;
                    }
                }
                catch (IOException e) {
                    LOGGER.error("Cannot retrieve client", (Throwable)e);
                }
            }
        }
        return null;
    }

    @Override
    protected List<AllowedValueItem> getAllowedSessionParameterValueItems(Permission allowedValuesScopePermission) {
        List<String> parameterAllowedValues = this.getAllowedSessionParameterValues();
        List<AllowedValueItem> eccObjects = this.getEccObjects();
        ArrayList<AllowedValueItem> parameterAllowedValueItems = new ArrayList<AllowedValueItem>();
        if (eccObjects != null) {
            for (AllowedValueItem allowedValue : eccObjects) {
                if (!this.matchesAllowedValues(parameterAllowedValues, allowedValue.getValue(), allowedValue.getName())) continue;
                parameterAllowedValueItems.add(allowedValue);
            }
        }
        return parameterAllowedValueItems;
    }
}

