/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.utils.allowedvalues;

import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.utils.allowedvalues.ParameterAllowedValues;
import com.nuix.automate.utils.api.internal.permission.Permission;
import com.nuix.automate.utils.models.api.job.AllowedValueItem;
import com.nuix.automate.utils.models.api.job.Parameter;
import com.nuix.automate.utils.models.api.thirdparty.InvestigateService;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyService;
import com.nuix.automate.workflow.core.utils.investigate.Group;
import com.nuix.automate.workflow.core.utils.investigate.InvestigateServiceRestClient;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class GroupAllowedValues
extends ParameterAllowedValues {
    protected BearerUser user;

    public GroupAllowedValues(SchedulerApplication schedulerApplication, Parameter parameter, List<String> clientAllowedValues, List<String> matterAllowedValues, List<String> clientPoolAllowedValues, BearerUser user) {
        super(schedulerApplication, parameter, clientAllowedValues, matterAllowedValues, clientPoolAllowedValues);
        this.user = user;
    }

    @Override
    protected List<AllowedValueItem> getAllowedSessionParameterValueItems(Permission allowedValuesScopePermission) {
        ArrayList<AllowedValueItem> parameterAllowedValueItems = new ArrayList<AllowedValueItem>();
        for (ThirdPartyService thirdPartyService : this.schedulerApplication.getThirdPartyServiceResource().getThirdPartyServices()) {
            ThirdPartyService result;
            Set userPermissions;
            if (!(thirdPartyService instanceof InvestigateService) || !Boolean.TRUE.equals(thirdPartyService.getEnabled()) || !Boolean.TRUE.equals(thirdPartyService.getAvailableByDefault()) || !(userPermissions = (result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(this.user, thirdPartyService)).getUserPermissions()).contains(Permission.VIEW) || !userPermissions.contains(allowedValuesScopePermission)) continue;
            String investigateServiceId = thirdPartyService.getId();
            String schedulerUrl = this.schedulerApplication.getConfiguration().getLoopbackUrl();
            HashSet<String> whitelistedCertFingerprints = new HashSet<String>();
            whitelistedCertFingerprints.add(this.schedulerApplication.getConfiguration().getLoopbackFingerprint());
            String bearerToken = this.schedulerApplication.getApiKeyResource().addEphemeralApiKey(this.user).getBearerToken();
            try (InvestigateServiceRestClient investigateServiceClient = new InvestigateServiceRestClient(investigateServiceId, schedulerUrl, bearerToken, whitelistedCertFingerprints);){
                List groups = investigateServiceClient.getGroups();
                for (Group group : groups) {
                    parameterAllowedValueItems.add(new AllowedValueItem(group.getName()));
                }
            }
            catch (IOException | GeneralSecurityException e) {
                LOGGER.error("Cannot create Investigate client", (Throwable)e);
            }
            break;
        }
        return parameterAllowedValueItems;
    }
}

