/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.utils.allowedvalues;

import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.security.thirdparty.DiscoverServiceSession;
import com.nuix.automate.scheduler.security.thirdparty.GenAiServiceSession;
import com.nuix.automate.scheduler.security.thirdparty.RelativityServiceSession;
import com.nuix.automate.scheduler.utils.WorkflowSerializationUtils;
import com.nuix.automate.scheduler.utils.allowedvalues.ParameterAllowedValues;
import com.nuix.automate.utils.exceptions.DiscoverSettingsNotDefinedException;
import com.nuix.automate.utils.exceptions.RelativitySettingsNotDefinedException;
import com.nuix.automate.utils.general.CollectionUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.JwtUtils;
import com.nuix.automate.utils.models.api.client.Client;
import com.nuix.automate.utils.models.api.client.Matter;
import com.nuix.automate.utils.models.api.filelibrary.FileLibraryFile;
import com.nuix.automate.utils.models.api.job.Parameter;
import com.nuix.automate.utils.models.api.relativity.EndpointType;
import com.nuix.automate.utils.models.api.thirdparty.DiscoverService;
import com.nuix.automate.utils.models.api.thirdparty.DiscoverUserCredential;
import com.nuix.automate.utils.models.api.thirdparty.GenAiService;
import com.nuix.automate.utils.models.api.thirdparty.GenAiUserCredential;
import com.nuix.automate.utils.models.api.thirdparty.RelativityService;
import com.nuix.automate.utils.models.api.thirdparty.RelativityUserCredential;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyService;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyUserCredential;
import com.nuix.automate.utils.models.api.workflowlibrary.Workflow;
import com.nuix.automate.utils.models.api.workflowlibrary.WorkflowLibrary;
import com.nuix.automate.utils.models.internal.executionprofile.ExecutionProfileModel;
import com.nuix.automate.utils.models.internal.resourcepool.ResourcePoolModel;
import com.nuix.automate.utils.workflow.ParameterType;
import com.nuix.automate.workflow.core.execution.script.RestApplication;
import com.nuix.automate.workflow.core.execution.script.RestApplicationConfiguration;
import com.nuix.automate.workflow.core.execution.script.RestApplicationsConfiguration;
import com.nuix.automate.workflow.core.execution.workflow.ImmutableWorkflow;
import com.nuix.automate.workflow.core.utils.general.ScriptUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import javax.script.ScriptException;
import org.jetbrains.annotations.NotNull;

public class ScriptedAllowedValues
extends ParameterAllowedValues {
    protected static InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"WorkflowText");
    protected BearerUser user;
    protected Client client;
    protected Matter matter;
    protected WorkflowLibrary workflowLibrary;
    protected Workflow workflowModel;
    protected LinkedHashMap<String, String> parameterNameValueMap;
    protected Map<ParameterType, String> serviceIds;

    public ScriptedAllowedValues(SchedulerApplication schedulerApplication, Parameter parameter, List<String> clientAllowedValues, List<String> matterAllowedValues, List<String> clientPoolAllowedValues, BearerUser user, Client client, Matter matter, WorkflowLibrary workflowLibrary, Workflow workflowModel, Map<ParameterType, String> serviceIds, LinkedHashMap<String, String> parameterNameValueMap) {
        super(schedulerApplication, parameter, clientAllowedValues, matterAllowedValues, clientPoolAllowedValues);
        this.client = client;
        this.matter = matter;
        this.workflowLibrary = workflowLibrary;
        this.workflowModel = workflowModel;
        this.parameterNameValueMap = parameterNameValueMap;
        this.user = user;
        this.serviceIds = serviceIds;
    }

    @Override
    protected List<String> getAllowedSessionParameterValues() {
        ArrayList<String> allowedValues = super.getAllowedSessionParameterValues();
        ArrayList evaluatedAllowedValues = new ArrayList();
        try {
            long allowedParameterValuesScriptTimeout = this.schedulerApplication.getConfiguration().getAllowedParameterValuesScriptTimeout();
            FileLibraryFile libraryFile = null;
            if (this.parameter.isUseLibraryFile() && (libraryFile = this.schedulerApplication.getFileLibraryResource().getScriptFile(this.parameter.getLibraryFileId())) == null) {
                throw new IllegalArgumentException(iu.getFormattedString("ScriptUtils.ErrorEvaluatingScriptedParameter", new Object[]{this.parameter.getName(), iu.getFormattedString("ScriptUtils.ScriptDoesNotExistAsFile", (Object)String.valueOf(this.parameter.getLibraryFileId()))}));
            }
            LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
            String defaultExecutionProfileId = "";
            String defaultExecutionProfileName = "";
            String defaultResourcePoolId = "";
            String defaultResourcePoolName = "";
            if (this.matter != null && this.matter.getDefaultExecutionProfileId() != null && !this.matter.getDefaultExecutionProfileId().equals("")) {
                defaultExecutionProfileId = this.matter.getDefaultExecutionProfileId();
            } else if (this.client != null && this.client.getDefaultExecutionProfileId() != null && !this.client.getDefaultExecutionProfileId().equals("")) {
                defaultExecutionProfileId = this.client.getDefaultExecutionProfileId();
            }
            ExecutionProfileModel executionProfile = this.schedulerApplication.getExecutionProfileResource().getExecutionProfile(defaultExecutionProfileId);
            if (executionProfile != null) {
                defaultExecutionProfileName = executionProfile.getName();
            }
            if (this.matter != null && this.matter.getDefaultResourcePoolId() != null && !this.matter.getDefaultResourcePoolId().equals("")) {
                defaultResourcePoolId = this.matter.getDefaultResourcePoolId();
            } else if (this.client != null && this.client.getDefaultResourcePoolId() != null && !this.client.getDefaultResourcePoolId().equals("")) {
                defaultResourcePoolId = this.client.getDefaultResourcePoolId();
            }
            ResourcePoolModel resourcePool = this.schedulerApplication.getResourcePoolResource().getResourcePool(defaultResourcePoolId);
            if (resourcePool != null) {
                defaultResourcePoolName = resourcePool.getName();
            }
            parameters.put("{default_execution_profile_id}", defaultExecutionProfileId);
            parameters.put("{default_execution_profile_name}", defaultExecutionProfileName);
            parameters.put("{default_resource_pool_id}", defaultResourcePoolId);
            parameters.put("{default_resource_pool_name}", defaultResourcePoolName);
            if (this.workflowModel != null && this.workflowModel.getOperationsXml() != null) {
                ImmutableWorkflow immutableWorkflow = WorkflowSerializationUtils.getInstance().fromWorkflowCache(this.workflowModel.getOperationsXml());
                List staticParameters = immutableWorkflow.getStaticParameters();
                for (Parameter staticParameter : staticParameters) {
                    String parameterValue = staticParameter.isSensitive() ? com.nuix.automate.utils.workflow.Parameter.MASKED_VALUE : staticParameter.getValue();
                    parameters.put(staticParameter.getName(), parameterValue);
                }
            }
            if (this.parameterNameValueMap != null) {
                parameters.putAll(this.parameterNameValueMap);
            }
            RestApplicationsConfiguration restApplicationsConfiguration = new RestApplicationsConfiguration();
            RestApplicationConfiguration automateRestApplicationConfiguration = new RestApplicationConfiguration();
            automateRestApplicationConfiguration.setBaseUrl(this.schedulerApplication.getConfiguration().getLoopbackUrl());
            automateRestApplicationConfiguration.setFingerprint(this.schedulerApplication.getConfiguration().getLoopbackFingerprint());
            automateRestApplicationConfiguration.setSecret(this.schedulerApplication.getApiKeyResource().addEphemeralApiKey(this.user).getBearerToken());
            restApplicationsConfiguration.getConfigurations().put(RestApplication.AUTOMATE, automateRestApplicationConfiguration);
            if (this.serviceIds != null) {
                GenAiServiceSession genAiServiceSession;
                String genAiServiceId;
                DiscoverServiceSession discoverServiceSession;
                String discoverServiceId;
                RelativityServiceSession relativityServiceSession;
                String relativityServiceId = this.serviceIds.get(ParameterType.RELATIVITY_SERVICE);
                if (relativityServiceId != null && relativityServiceId.length() > 0 && (relativityServiceSession = (RelativityServiceSession)this.schedulerApplication.getThirdPartyServiceResource().getThirdPartyServiceSession(relativityServiceId, this.user.getId())).getSignedIn()) {
                    RestApplicationConfiguration relativityRestApplicationConfiguration = ScriptedAllowedValues.getRelativityRestApplicationConfiguration(relativityServiceSession);
                    restApplicationsConfiguration.getConfigurations().put(RestApplication.RELATIVITY, relativityRestApplicationConfiguration);
                }
                if ((discoverServiceId = this.serviceIds.get(ParameterType.DISCOVER_SERVICE)) != null && discoverServiceId.length() > 0 && (discoverServiceSession = (DiscoverServiceSession)this.schedulerApplication.getThirdPartyServiceResource().getThirdPartyServiceSession(discoverServiceId, this.user.getId())).getSignedIn()) {
                    RestApplicationConfiguration discoverRestApplicationConfiguration = ScriptedAllowedValues.getDiscoverRestApplicationConfiguration(discoverServiceSession);
                    restApplicationsConfiguration.getConfigurations().put(RestApplication.DISCOVER, discoverRestApplicationConfiguration);
                }
                if ((genAiServiceId = this.serviceIds.get(ParameterType.GEN_AI_SERVICE)) != null && genAiServiceId.length() > 0 && (genAiServiceSession = (GenAiServiceSession)this.schedulerApplication.getThirdPartyServiceResource().getThirdPartyServiceSession(genAiServiceId, this.user.getId())).getSignedIn()) {
                    RestApplicationConfiguration genAiApplicationConfiguration = ScriptedAllowedValues.getGenAiApplicationConfiguration(genAiServiceSession);
                    restApplicationsConfiguration.getConfigurations().put(RestApplication.GEN_AI, genAiApplicationConfiguration);
                }
            }
            evaluatedAllowedValues.addAll(ScriptUtils.getScriptAllowedValues((long)allowedParameterValuesScriptTimeout, (String)this.user.getName(), (Parameter)this.parameter, (Client)this.client, (Matter)this.matter, (WorkflowLibrary)this.workflowLibrary, (Workflow)this.workflowModel, parameters, (FileLibraryFile)libraryFile, (RestApplicationsConfiguration)restApplicationsConfiguration));
        }
        catch (IOException | ScriptException e) {
            if (e.getCause() != null && e.getCause().getCause() != null && e.getCause().getCause() instanceof RelativitySettingsNotDefinedException) {
                boolean isRelativityParameterServicePresent = this.isParameterTypePresent(ParameterType.RELATIVITY_SERVICE);
                if (!isRelativityParameterServicePresent) {
                    LOGGER.error("Cannot evaluate scripted parameter " + this.parameter.getName(), e.getCause().getCause());
                    throw new IllegalArgumentException(iu.getFormattedString("ScriptUtils.ErrorEvaluatingScriptedParameter", new Object[]{this.parameter.getName(), e.getCause().getCause().getMessage()}));
                }
            }
            if (e.getCause() != null && e.getCause().getCause() != null && e.getCause().getCause() instanceof DiscoverSettingsNotDefinedException) {
                boolean isDiscoverServiceParameterPresent = this.isParameterTypePresent(ParameterType.DISCOVER_SERVICE);
                if (!isDiscoverServiceParameterPresent) {
                    LOGGER.error("Cannot evaluate scripted parameter " + this.parameter.getName(), e.getCause().getCause());
                    throw new IllegalArgumentException(iu.getFormattedString("ScriptUtils.ErrorEvaluatingScriptedParameter", new Object[]{this.parameter.getName(), e.getCause().getCause().getMessage()}));
                }
            }
            LOGGER.error("Cannot evaluate scripted parameter " + this.parameter.getName(), (Throwable)e);
            throw new IllegalArgumentException(iu.getFormattedString("ScriptUtils.ErrorEvaluatingScriptedParameter", new Object[]{this.parameter.getName(), e.getMessage()}));
        }
        catch (NullPointerException e) {
            LOGGER.error("Cannot evaluate scripted parameter " + this.parameter.getName(), (Throwable)e);
            throw new IllegalArgumentException(iu.getFormattedString("ScriptUtils.ErrorEvaluatingScriptedParameter", new Object[]{this.parameter.getName(), iu.getString("ScriptUtils.NoValueReturned")}));
        }
        catch (TimeoutException e) {
            LOGGER.error("Cannot evaluate parameter " + this.parameter.getName() + " because script did not complete in time");
            throw new IllegalArgumentException(iu.getFormattedString("ScriptUtils.ErrorEvaluatingScriptedParameter", new Object[]{this.parameter.getName(), iu.getString("ScriptUtils.ScriptTimeout")}));
        }
        catch (Exception e) {
            LOGGER.error("Cannot evaluate scripted parameter " + this.parameter.getName(), (Throwable)e);
            throw new IllegalArgumentException(e.getMessage());
        }
        allowedValues = allowedValues == null ? new ArrayList<String>(evaluatedAllowedValues) : CollectionUtils.intersection(allowedValues, evaluatedAllowedValues);
        return allowedValues;
    }

    @NotNull
    private static RestApplicationConfiguration getDiscoverRestApplicationConfiguration(DiscoverServiceSession discoverServiceSession) {
        RestApplicationConfiguration discoverRestApplicationConfiguration = new RestApplicationConfiguration();
        DiscoverService discoverService = (DiscoverService)discoverServiceSession.getService();
        DiscoverUserCredential discoverUserCredential = (DiscoverUserCredential)discoverServiceSession.getUserCredential();
        String apiToken = discoverUserCredential.getToken();
        String hostname = discoverService.getHostname();
        Map claims = JwtUtils.getTokenClaimsNoVerify((String)apiToken);
        String apiUrl = claims.get("apiUrl").toString();
        if (!apiUrl.toLowerCase(Locale.ROOT).startsWith("http://" + hostname + "/") && !apiUrl.toLowerCase(Locale.ROOT).startsWith("https://" + hostname + "/")) {
            LOGGER.error(iu.getFormattedString("DiscoverRestClient.Error.InvalidHostname", new Object[]{apiUrl, hostname}));
            hostname = null;
            apiToken = null;
        }
        discoverRestApplicationConfiguration.setBaseUrl(apiUrl);
        discoverRestApplicationConfiguration.setSecret(apiToken);
        discoverRestApplicationConfiguration.setAuthenticationMethod(discoverService.getAuthenticationMethod());
        discoverRestApplicationConfiguration.setFingerprint(null);
        Set<String> fingerprints = discoverServiceSession.getWhitelistedCertFingerprints();
        if (fingerprints != null && !fingerprints.isEmpty()) {
            discoverRestApplicationConfiguration.setFingerprint(fingerprints.iterator().next());
        }
        return discoverRestApplicationConfiguration;
    }

    @NotNull
    private static RestApplicationConfiguration getGenAiApplicationConfiguration(GenAiServiceSession genAiServiceSession) {
        RestApplicationConfiguration genAiApplicationConfiguration = new RestApplicationConfiguration();
        GenAiService genAiService = ((GenAiService)genAiServiceSession.getService()).clone();
        GenAiUserCredential userCredential = (GenAiUserCredential)genAiServiceSession.getUserCredential();
        genAiService.setUserCredential((ThirdPartyUserCredential)userCredential);
        genAiApplicationConfiguration.setThirdPartyService((ThirdPartyService)genAiService);
        return genAiApplicationConfiguration;
    }

    @NotNull
    private static RestApplicationConfiguration getRelativityRestApplicationConfiguration(RelativityServiceSession relativityServiceSession) {
        RestApplicationConfiguration relativityRestApplicationConfiguration = new RestApplicationConfiguration();
        RelativityService relativityService = (RelativityService)relativityServiceSession.getService();
        RelativityUserCredential relativityUserCredential = (RelativityUserCredential)relativityServiceSession.getUserCredential();
        Object baseUrl = relativityService.getEndpointType() == EndpointType.HTTP ? "http://" : "https://";
        baseUrl = (String)baseUrl + relativityService.getHostname();
        relativityRestApplicationConfiguration.setBaseUrl((String)baseUrl);
        relativityRestApplicationConfiguration.setAuthenticationMethod(relativityService.getAuthenticationMethod());
        relativityRestApplicationConfiguration.setUsername(relativityUserCredential.getUsername());
        switch (relativityService.getAuthenticationMethod()) {
            case OIDC_AUTHORIZATION_CODE: {
                relativityRestApplicationConfiguration.setSecret(relativityUserCredential.getToken());
                break;
            }
            default: {
                relativityRestApplicationConfiguration.setSecret(relativityUserCredential.getPassword());
            }
        }
        relativityRestApplicationConfiguration.setFingerprint(null);
        Set<String> fingerprints = relativityServiceSession.getWhitelistedCertFingerprints();
        if (fingerprints != null && !fingerprints.isEmpty()) {
            relativityRestApplicationConfiguration.setFingerprint(fingerprints.iterator().next());
        }
        return relativityRestApplicationConfiguration;
    }

    private boolean isParameterTypePresent(ParameterType parameterType) {
        if (this.workflowModel == null) {
            return false;
        }
        for (Parameter parameter : this.workflowModel.getSessionParameters()) {
            if (parameter.getParameterType() != parameterType) continue;
            return true;
        }
        return false;
    }
}

