/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.utils.allowedvalues;

import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.security.thirdparty.ThirdPartyServiceSession;
import com.nuix.automate.scheduler.utils.allowedvalues.ParameterAllowedValues;
import com.nuix.automate.utils.api.internal.permission.Permission;
import com.nuix.automate.utils.models.api.job.AllowedValueItem;
import com.nuix.automate.utils.models.api.job.Parameter;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyService;
import com.nuix.automate.utils.workflow.ParameterType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class ThirdPartyServiceAllowedValues
extends ParameterAllowedValues {
    protected BearerUser user;
    private ParameterType parameterType;

    public ThirdPartyServiceAllowedValues(SchedulerApplication schedulerApplication, Parameter parameter, List<String> clientAllowedValues, List<String> matterAllowedValues, List<String> clientPoolAllowedValues, BearerUser user) {
        super(schedulerApplication, parameter, clientAllowedValues, matterAllowedValues, clientPoolAllowedValues);
        this.user = user;
    }

    public void setParameterType(ParameterType parameterType) {
        this.parameterType = parameterType;
    }

    @Override
    protected List<AllowedValueItem> getAllowedSessionParameterValueItems(Permission allowedValuesScopePermission) {
        List<String> parameterAllowedValues = this.getAllowedSessionParameterValues();
        ArrayList<AllowedValueItem> parameterAllowedValueItems = new ArrayList<AllowedValueItem>();
        for (ThirdPartyService thirdPartyService : this.schedulerApplication.getThirdPartyServiceResource().getThirdPartyServices()) {
            if (Boolean.FALSE.equals(thirdPartyService.getEnabled()) || this.parameterType != null && thirdPartyService.getParameterType() != this.parameterType || !this.matchesAllowedValues(parameterAllowedValues, thirdPartyService.getId(), thirdPartyService.getName())) continue;
            ThirdPartyService result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(this.user, thirdPartyService);
            Set userPermissions = result.getUserPermissions();
            if (allowedValuesScopePermission.equals((Object)Permission.SUBMIT_JOB)) {
                ThirdPartyServiceSession<?, ?> serviceSession;
                try {
                    serviceSession = this.schedulerApplication.getThirdPartyServiceResource().getThirdPartyServiceSession(thirdPartyService.getId(), this.user.getId());
                }
                catch (IOException e) {
                    LOGGER.error("Cannot retrieve session", (Throwable)e);
                    continue;
                }
                if (serviceSession.getLicenseException() != null) continue;
            }
            if (!userPermissions.contains(Permission.VIEW) || !userPermissions.contains(allowedValuesScopePermission)) continue;
            parameterAllowedValueItems.add(new AllowedValueItem(result.getName(), result.getId()));
        }
        return parameterAllowedValueItems;
    }
}

