/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.utils.benchmark;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import java.util.List;
import java.util.stream.Collectors;
import org.jdbi.v3.core.statement.SqlLogger;
import org.jdbi.v3.core.statement.StatementContext;

public class CallAwareSqlLogger
implements SqlLogger {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(CallAwareSqlLogger.class);
    private final String appBasePackage;
    private final String loggerClassName = CallAwareSqlLogger.class.getName();
    private final String loggerPackage = CallAwareSqlLogger.class.getPackage().getName();

    public CallAwareSqlLogger(String appBasePackage) {
        this.appBasePackage = appBasePackage;
    }

    public void logBeforeExecution(StatementContext ctx) {
        try {
            String caller = this.buildCallerPath();
            ctx.define("caller.path", (Object)caller);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void logAfterExecution(StatementContext ctx) {
        try {
            String daoMethod = ctx.getExtensionMethod().getMethod().toGenericString();
            daoMethod = daoMethod.substring(daoMethod.indexOf("com.nuix.automate.scheduler."));
            String caller = String.valueOf(ctx.getAttribute("caller.path"));
            LOGGER.info(caller + " -> " + daoMethod);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String buildCallerPath() {
        StackWalker sw = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
        List frames = sw.walk(stream -> stream.filter(this::isAppFrame).limit(1L).map(f -> f.getClassName() + "#" + f.getMethodName() + "()").collect(Collectors.toList()));
        return frames.isEmpty() ? "<unknown-caller>" : String.join((CharSequence)" -> ", frames);
    }

    private boolean isAppFrame(StackWalker.StackFrame f) {
        String cn = f.getClassName();
        if (!cn.startsWith(this.appBasePackage)) {
            return false;
        }
        if (cn.equals(this.loggerClassName) || cn.startsWith(this.loggerPackage + ".")) {
            return false;
        }
        return !cn.startsWith("org.jdbi.") && !cn.startsWith("java.") && !cn.startsWith("jdk.") && !cn.startsWith("com.sun.") && !cn.contains("$$") && !cn.contains("$Proxy");
    }
}

