/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.workers;

import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.internal.job.JobState;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Set;
import java.util.TimerTask;

public class ArchivedJobWorker
extends TimerTask {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ArchivedJobWorker.class);
    private SchedulerApplication schedulerApplication;
    private final long archivedJobRetentionDays;

    public ArchivedJobWorker(SchedulerApplication schedulerApplication) {
        this.schedulerApplication = schedulerApplication;
        this.archivedJobRetentionDays = schedulerApplication.getConfiguration().getArchivedJobRetentionDays();
    }

    @Override
    public void run() {
        long retentionDay = Instant.now().minus(this.archivedJobRetentionDays, ChronoUnit.DAYS).toEpochMilli();
        Set<String> archivedJobIds = this.schedulerApplication.getJobsArchiveDao().getJobsForDateState(retentionDay, JobState.ARCHIVED);
        if (archivedJobIds == null || archivedJobIds.isEmpty()) {
            return;
        }
        for (String jobId : archivedJobIds) {
            LOGGER.info("Deleting archived job with ID: " + jobId);
        }
        int jobExecutionLogResult = this.schedulerApplication.getJobsArchiveDao().removeJobExecutionLogs(archivedJobIds);
        LOGGER.info("Deleted " + jobExecutionLogResult + " execution logs");
        int jobOperationMimeTypeStatsResult = this.schedulerApplication.getJobsArchiveDao().removeJobMimeTypeStats(archivedJobIds);
        LOGGER.info("Deleted " + jobOperationMimeTypeStatsResult + " operation mime type stats");
        int jobResult = this.schedulerApplication.getJobsArchiveDao().removeJobDetails(archivedJobIds);
        LOGGER.info("Deleted " + jobResult + " archived job");
    }
}

