/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.workers;

import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.resources.AutomateLicenseResource;
import com.nuix.automate.scheduler.security.bearer.SystemBearerUser;
import com.nuix.automate.utils.api.automatelicense.AutomateLicence;
import com.nuix.automate.utils.api.internal.automatelicense.AutomateLicenceModel;
import com.nuix.automate.utils.api.response.State;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.licence.LicenceFactory;
import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.licence.services.LicenceInfo;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.internal.event.EventType;
import java.io.Closeable;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Semaphore;

public class AutomateLicenceWorker
extends TimerTask
implements Closeable {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(AutomateLicenceWorker.class);
    private InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");
    private SchedulerApplication schedulerApplication;
    private AutomateLicenseResource automateLicenseResource;
    private AutomateLicenceModel model;
    Semaphore pingServerSemaphore;
    protected Timer timer;

    public AutomateLicenceWorker(SchedulerApplication schedulerApplication, AutomateLicenseResource automateLicenseResource, AutomateLicenceModel model) {
        this.schedulerApplication = schedulerApplication;
        this.automateLicenseResource = automateLicenseResource;
        this.model = model;
        this.pingServerSemaphore = new Semaphore(1);
        this.timer = new Timer(true);
        this.timer.schedule((TimerTask)this, 0L, schedulerApplication.getConfiguration().getAutomateLicensePingInterval());
    }

    public void setRampivaLicence(AutomateLicenceModel model) {
        this.model = model;
    }

    @Override
    public void run() {
        boolean lockAvailable = this.pingServerSemaphore.tryAcquire();
        if (lockAvailable) {
            Thread pingServerThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (AutomateLicenceWorker.this.model.getStatus().getCode() == State.ERROR) {
                            AutomateLicenceWorker.this.model.getStatus().reset();
                        }
                        AutomateLicenceWorker.this.pingLicence();
                    }
                    catch (Throwable t) {
                        LOGGER.error(String.valueOf(AutomateLicenceWorker.this.model) + " ping error", t);
                    }
                }
            });
            pingServerThread.setDaemon(true);
            pingServerThread.setName("Automate Licence - ping");
            pingServerThread.start();
            try {
                pingServerThread.join(this.schedulerApplication.getConfiguration().getAutomateLicenseTimeout());
                if (pingServerThread.isAlive()) {
                    LOGGER.error(String.valueOf(this.model) + " ping did not complete");
                    LOGGER.warn(String.valueOf(this.model) + " stack trace:");
                    for (StackTraceElement stackTraceElement : pingServerThread.getStackTrace()) {
                        LOGGER.warn("\t" + stackTraceElement.toString());
                    }
                    LOGGER.warn(String.valueOf(this.model) + " Interrupting");
                    pingServerThread.interrupt();
                    pingServerThread.join(this.schedulerApplication.getConfiguration().getAutomateLicenseTimeout());
                    if (pingServerThread.isAlive()) {
                        LOGGER.error(String.valueOf(this.model) + " ping thread did not interrupt");
                    }
                }
            }
            catch (InterruptedException e) {
                LOGGER.error(String.valueOf(this.model) + " cannot wait for ping thread to complete", (Throwable)e);
                this.model.getStatus().reset();
                this.model.getStatus().setError(this.iu.getString("Generic.CannotQueryDetails.TimeOut"));
            }
            this.pingServerSemaphore.release();
        } else {
            LOGGER.warn(String.valueOf(this.model) + " ping lock not available");
        }
    }

    public void pingLicence() {
        if (this.model.getLegacyLicence() != null && this.model.getLicenceInfo() == null) {
            LicenceInfo licenceInfo = LicenceFactory.getInstance().convertToLicenseInfo(this.model.getLegacyLicence());
            this.model.setLicenceInfo(licenceInfo);
            this.automateLicenseResource.trackLicenseUpdated();
        }
        this.validate(this.model, true, true);
    }

    public void validate(AutomateLicenceModel model, boolean forceRefresh, boolean triggerEvents) {
        if (model != null) {
            String errorMessage;
            String previousWarning = "";
            String previousError = "";
            if (model.getStatus().getCode() == State.WARNING) {
                previousWarning = model.getStatus().getMessage();
            } else if (model.getStatus().getCode() == State.ERROR) {
                previousError = model.getStatus().getMessage();
            }
            if (model.getCredentials() != null) {
                LicenceInfo licenceInfo;
                if (model.getLicenceInfo() == null) {
                    errorMessage = null;
                    try {
                        licenceInfo = LicenceFactory.getInstance().getServerLicenseInfo(model.getCredentials(), ModuleType.SCHEDULER_STANDARD);
                        model.setLicenceInfo(licenceInfo);
                        this.automateLicenseResource.trackLicenseUpdated();
                        errorMessage = LicenceFactory.getInstance().getLicenceErrorMessage(model.getLicenceInfo());
                    }
                    catch (IOException e) {
                        LOGGER.warn("Cannot get Automate license from credentials", (Throwable)e);
                        errorMessage = ExceptionUtils.getExceptionPrintableMessage((Throwable)e);
                    }
                    model.getStatus().reset();
                    if (errorMessage != null) {
                        model.getStatus().setError(errorMessage);
                    }
                } else if (forceRefresh) {
                    errorMessage = LicenceFactory.getInstance().getLicenceErrorMessage(model.getLicenceInfo());
                    if (errorMessage != null) {
                        model.getStatus().reset();
                        model.getStatus().setError(errorMessage);
                    }
                    try {
                        licenceInfo = LicenceFactory.getInstance().getServerLicenseInfo(model.getCredentials(), ModuleType.SCHEDULER_STANDARD);
                        model.setLicenceInfo(licenceInfo);
                        this.automateLicenseResource.trackLicenseUpdated();
                        errorMessage = LicenceFactory.getInstance().getLicenceErrorMessage(model.getLicenceInfo());
                        model.getStatus().reset();
                        if (errorMessage != null) {
                            model.getStatus().setError(errorMessage);
                        }
                    }
                    catch (IOException e) {
                        LOGGER.warn("Cannot get Automate license from credentials", (Throwable)e);
                        model.getStatus().setWarningMessage(this.iu.getFormattedString("Licence.Warning.CannotUpdateLicense", (Object)ExceptionUtils.getExceptionPrintableMessage((Throwable)e)));
                    }
                }
            } else {
                errorMessage = LicenceFactory.getInstance().getLicenceErrorMessage(model.getLicenceInfo());
                model.getStatus().reset();
                if (errorMessage != null) {
                    model.getStatus().setError(errorMessage);
                }
            }
            if (triggerEvents && this.schedulerApplication.getWebhookWorker() != null) {
                AutomateLicence eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions((BearerUser)new SystemBearerUser(), model);
                eventResult.setDiagnosticLevel(this.schedulerApplication.getSettingsResource().getDiagnosticLevel());
                eventResult.setDiagnosticKeyId(this.schedulerApplication.getSettingsResource().getDiagnosticKey().getId());
                try {
                    String currentWarning;
                    if (model.getStatus().getCode() == State.ERROR) {
                        String currentError = model.getStatus().getMessage();
                        if (!currentError.equals(previousError)) {
                            this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.AUTOMATE_LICENSE_ERROR, eventResult);
                        }
                    } else if (model.getStatus().getCode() == State.WARNING && !(currentWarning = model.getStatus().getMessage()).equals(previousWarning)) {
                        this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.AUTOMATE_LICENSE_WARNING, eventResult);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Cannot trigger event", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.timer != null) {
                this.timer.cancel();
            }
        }
        catch (Exception e) {
            LOGGER.warn(String.valueOf(this.model) + " cannot cancel timer");
        }
    }
}

