/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.workers;

import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.utils.general.IconUtils;
import com.nuix.automate.utils.general.MimeTypeUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.internal.cache.CachedObject;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;

public class FileExtensionIconWorker {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(FileExtensionIconWorker.class);
    private final SchedulerApplication schedulerApplication;
    private final Map<String, CachedObject<byte[]>> extensionIcons;
    private final Map<String, CachedObject<byte[]>> largeExtensionIcons;

    public FileExtensionIconWorker(SchedulerApplication schedulerApplication) {
        this.schedulerApplication = schedulerApplication;
        this.extensionIcons = new ConcurrentHashMap<String, CachedObject<byte[]>>();
        this.largeExtensionIcons = new ConcurrentHashMap<String, CachedObject<byte[]>>();
        schedulerApplication.getScheduledExecutorService().scheduleWithFixedDelay(() -> {
            this.extensionIcons.values().removeIf(CachedObject::isExpired);
            this.largeExtensionIcons.values().removeIf(CachedObject::isExpired);
        }, 0L, 60L, TimeUnit.MINUTES);
    }

    public byte[] getExtensionIcon(String extension, boolean getLargeIcon) {
        Map<String, CachedObject<byte[]>> cachedIcons = getLargeIcon ? this.largeExtensionIcons : this.extensionIcons;
        CachedObject cachedIcon = cachedIcons.get(extension);
        if (cachedIcon == null || cachedIcon.isExpired()) {
            byte[] iconData = this.getIconDataForExtension(extension, getLargeIcon);
            cachedIcon = iconData != null ? new CachedObject((Object)iconData, this.schedulerApplication.getConfiguration().getFileIconCacheKeepAlive()) : new CachedObject(null, 60000L);
            cachedIcons.put(extension, (CachedObject<byte[]>)cachedIcon);
        }
        return (byte[])cachedIcon.getObject();
    }

    public byte[] getMimeTypeIcon(String mimeType, boolean getLargeIcon) {
        String extension = MimeTypeUtils.getInstance().getDefaultExtension(mimeType);
        if (extension == null) {
            extension = mimeType.equalsIgnoreCase("filesystem/directory") ? "directory" : "";
        }
        return this.getExtensionIcon(extension, getLargeIcon);
    }

    private byte[] getIconDataForExtension(String extension, boolean getLargeIcon) {
        BufferedImage image = IconUtils.getImageIcon((String)extension, (boolean)getLargeIcon);
        if (image != null) {
            byte[] byArray;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                ImageIO.write((RenderedImage)image, "PNG", byteArrayOutputStream);
                byArray = byteArrayOutputStream.toByteArray();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        byteArrayOutputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.error("Failed to get icon data for extension: " + extension, (Throwable)e);
                }
            }
            byteArrayOutputStream.close();
            return byArray;
        }
        return null;
    }
}

