/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.workers;

import com.nuix.automate.dropwizard.utils.models.UserServiceClient;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.security.ldap.LdapClient;
import com.nuix.automate.scheduler.workers.UserServiceWorker;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.userservice.LdapComputer;
import com.nuix.automate.utils.models.api.userservice.UserServiceObjectType;
import com.nuix.automate.utils.models.internal.user.LdapUserService;
import com.nuix.automate.utils.models.internal.user.UserService;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class LdapUserServiceWorker
extends UserServiceWorker {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(LdapUserServiceWorker.class);

    public LdapUserServiceWorker(SchedulerApplication schedulerApplication, LdapUserService userService) {
        super(schedulerApplication, (UserService)userService);
    }

    @Override
    public int synchronizeObjects(UserServiceClient userServiceClient) {
        LdapClient ldapClient = (LdapClient)userServiceClient;
        int synchronizedObjectsCount = 0;
        try {
            synchronizedObjectsCount += this.synchronizeComputers(ldapClient);
        }
        catch (Exception e) {
            LOGGER.error("Could not synchronize " + String.valueOf(this.userService) + " Computers", (Throwable)e);
            this.userService.getStatus().setError(this.iu.getFormattedString("UsersResource.ScheduledQueryError", new Object[]{this.userService.getName(), e}));
        }
        return synchronizedObjectsCount;
    }

    private int synchronizeComputers(LdapClient ldapClient) throws Exception {
        LOGGER.info("Querying " + String.valueOf(this.userService) + " computers");
        long startMs = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
        List<LdapComputer> serviceComputers = ldapClient.getComputers(this.userService);
        long endMs = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
        LOGGER.info("Querying " + String.valueOf(this.userService) + " computers took " + (endMs - startMs) / 1000L + "s");
        LOGGER.info("LDAP Authentication Service " + this.userService.getName() + " found " + serviceComputers.size() + " Computers");
        return this.persistUserServiceObjects(UserServiceObjectType.COMPUTER, serviceComputers);
    }
}

