/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.workers;

import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.security.bearer.LegalHoldBearerUser;
import com.nuix.automate.scheduler.utils.LegalHoldParticipationCache;
import com.nuix.automate.utils.exceptions.LegalHoldTriggerConfigurationException;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.ThreadPoolUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.audit.AuditEvent;
import com.nuix.automate.utils.models.api.dataset.Dataset;
import com.nuix.automate.utils.models.api.legalhold.CustodianState;
import com.nuix.automate.utils.models.api.legalhold.JobTriggerType;
import com.nuix.automate.utils.models.api.legalhold.LegalHold;
import com.nuix.automate.utils.models.api.legalhold.LegalHoldParticipation;
import com.nuix.automate.utils.models.api.legalhold.LegalHoldParticipations;
import com.nuix.automate.utils.models.api.legalhold.LegalHoldRole;
import com.nuix.automate.utils.models.api.legalhold.LegalHoldState;
import com.nuix.automate.utils.models.api.legalhold.LegalHoldTaskState;
import com.nuix.automate.utils.models.api.legalhold.SurveyNoticesTrigger;
import com.nuix.automate.utils.models.api.legalhold.TriggerConfiguration;
import com.nuix.automate.utils.models.api.legalhold.TriggerConfigurationEvent;
import com.nuix.automate.utils.models.api.notice.Notice;
import com.nuix.automate.utils.models.api.notice.NoticeConfiguration;
import com.nuix.automate.utils.models.api.notice.NoticeEvent;
import com.nuix.automate.utils.models.api.smtp.EmailType;
import com.nuix.automate.utils.models.internal.event.EventType;
import com.nuix.automate.utils.models.internal.legalhold.LegalHoldEvent;
import com.nuix.automate.utils.responsecache.CacheKey;
import com.nuix.automate.utils.responsecache.ResponseCache;
import com.nuix.automate.utils.utilization.consumption.Consumption;
import com.nuix.automate.utils.utilization.consumption.ConsumptionEvent;
import com.nuix.automate.utils.utilization.consumption.ConsumptionPlatformType;
import com.nuix.automate.utils.utilization.consumption.ConsumptionSubType;
import com.nuix.automate.utils.utilization.consumption.ConsumptionType;
import com.nuix.automate.utils.utilization.consumption.ResourceSubType;
import com.nuix.automate.utils.utilization.consumption.ResourceType;
import com.nuix.automate.utils.utilization.consumption.UnitType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class LegalHoldWorker {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(LegalHoldWorker.class);
    private final InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");
    private static final int PROGRESS_UPDATE_INTERVAL = 64;
    private static final int CONSUMPTION_CUSTODIANS_SPLIT_SIZE = 1000;
    private final SchedulerApplication schedulerApplication;
    private final ThreadPoolExecutor threadPoolExecutor;
    private final Set<String> submittedLegalHoldIds;
    private ScheduledExecutorService consumptionReportingSchedule;

    public LegalHoldWorker(SchedulerApplication schedulerApplication) {
        this.schedulerApplication = schedulerApplication;
        this.threadPoolExecutor = ThreadPoolUtils.createScheduledThreadPoolExecutor((String)this.getClass().getSimpleName(), (int)schedulerApplication.getConfiguration().getLegalHoldWorkerThreadCount());
        this.submittedLegalHoldIds = ConcurrentHashMap.newKeySet();
        this.consumptionReportingSchedule = Executors.newScheduledThreadPool(1);
        this.consumptionReportingSchedule.scheduleAtFixedRate(() -> this.trackExistingHoldsConsumption(), 30L, 3600L, TimeUnit.SECONDS);
    }

    public boolean containsWorkForLegalHold(String legalHoldId) {
        if (legalHoldId != null) {
            return this.submittedLegalHoldIds.contains(legalHoldId);
        }
        return false;
    }

    public synchronized void submitIssueHoldsTask(BearerUser user, String remoteAddress, LegalHold legalHold, List<LegalHoldParticipation> custodianParticipations) {
        LOGGER.info("Submitting task to issue holds for " + custodianParticipations.size() + " custodians in legal hold " + legalHold.getName());
        this.submittedLegalHoldIds.add(legalHold.getId());
        legalHold.updateTaskState(LegalHoldTaskState.PENDING);
        this.threadPoolExecutor.submit(() -> {
            try {
                this.issueHolds(user, remoteAddress, legalHold, custodianParticipations);
                legalHold.setTaskDone();
            }
            catch (Throwable t) {
                LOGGER.error("Error issuing holds", t);
                if (t instanceof LegalHoldTriggerConfigurationException) {
                    legalHold.setTaskError(this.iu.getFormattedString("LegalHoldWorker.ErrorIssuingHolds", (Object)t.getLocalizedMessage()));
                } else {
                    legalHold.setTaskError(this.iu.getFormattedString("LegalHoldWorker.ErrorIssuingHolds", (Object)t));
                }
            }
            finally {
                this.submittedLegalHoldIds.remove(legalHold.getId());
                this.resetLegalHoldCache(legalHold);
            }
        });
    }

    public synchronized void trackExistingHoldsConsumption() {
        LOGGER.info("Tracking existing holds consumption");
        long currentTime = DateTime.now().getMillis();
        String currentYearMonth = new DateTime(currentTime).toDateTime(DateTimeZone.UTC).toString("YYYY-MM");
        for (LegalHold legalHold : this.schedulerApplication.getLegalHoldResource().getLegalHolds()) {
            String legalHoldLastTrackingYearMonth;
            if (!legalHold.getState().equals((Object)LegalHoldState.ACTIVE) || (legalHoldLastTrackingYearMonth = new DateTime(legalHold.getLastConsumptionTrackingEpoch()).toDateTime(DateTimeZone.UTC).toString("YYYY-MM")).equals(currentYearMonth)) continue;
            try {
                this.trackLegalHoldConsumption(legalHold);
                legalHold.setLastConsumptionTrackingEpoch(currentTime);
                this.schedulerApplication.getSchedulerConfigurationDao().updateLegalHold(legalHold);
            }
            catch (Exception e) {
                LOGGER.error("Cannot track Legal Hold Custodians consumption", (Throwable)e);
            }
        }
    }

    private void trackLegalHoldConsumption(LegalHold legalHold) {
        List<LegalHoldParticipation> participations = LegalHoldParticipationCache.getInstance().getLegalHoldParticipations(legalHold.getId());
        this.trackCustodiansConsumption(participations, ConsumptionSubType.CONTINUING_HOLD);
    }

    private void trackCustodiansConsumption(List<LegalHoldParticipation> custodianParticipations, ConsumptionSubType consumptionSubType) {
        if (custodianParticipations.size() > 0) {
            Consumption consumption = new Consumption();
            ConsumptionEvent consumptionEvent = new ConsumptionEvent();
            consumptionEvent.setLicenseId(SchedulerApplication.getInstance().getLicenceUtils().assertLicenceInfo().getId());
            consumptionEvent.setConsumptionStartEpoch(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis());
            consumptionEvent.setConsumptionEndEpoch(consumptionEvent.getConsumptionStartEpoch());
            consumptionEvent.setPlatformType(ConsumptionPlatformType.NUIX_AUTOMATE);
            consumptionEvent.setConsumptionType(ConsumptionType.CUSTODIAN_UNDER_HOLD);
            consumptionEvent.setConsumptionSubType(consumptionSubType);
            consumptionEvent.setUnitType(UnitType.CUSTODIANS);
            consumptionEvent.setResourceType(ResourceType.NUIX_AUTOMATE_LEGAL_HOLD_ID);
            consumptionEvent.setResourceId(custodianParticipations.get(0).getLegalHoldId());
            consumptionEvent.setResourceSubType(ResourceSubType.CUSTODIAN_IDS);
            HashSet<String> consumptionCustodianIds = new HashSet<String>();
            for (LegalHoldParticipation legalHoldParticipation : custodianParticipations) {
                if (!legalHoldParticipation.getRole().equals((Object)LegalHoldRole.CUSTODIAN)) continue;
                consumptionCustodianIds.add(legalHoldParticipation.getUserId());
            }
            if (consumptionCustodianIds.size() > 0) {
                consumption.addConsumptionEvents(consumptionEvent, consumptionCustodianIds);
                this.schedulerApplication.getAutomateLicenceResource().getLicenceSession().tryTrackConsumption(consumption, true, false);
            }
        }
    }

    public synchronized void submitReleaseHoldsTask(BearerUser user, String remoteAddress, LegalHold legalHold, List<LegalHoldParticipation> custodianParticipations) {
        LOGGER.info("Submitting task to release holds for " + custodianParticipations.size() + " custodians in legal hold " + legalHold.getName());
        this.submittedLegalHoldIds.add(legalHold.getId());
        legalHold.updateTaskState(LegalHoldTaskState.PENDING);
        this.threadPoolExecutor.submit(() -> {
            try {
                this.releaseHolds(user, remoteAddress, legalHold, custodianParticipations);
                legalHold.setTaskDone();
            }
            catch (Exception e) {
                LOGGER.error("Error releasing holds", (Throwable)e);
                legalHold.setTaskError(this.iu.getFormattedString("LegalHoldWorker.ErrorReleasingHolds", (Object)e));
            }
            finally {
                this.submittedLegalHoldIds.remove(legalHold.getId());
                this.resetLegalHoldCache(legalHold);
            }
        });
    }

    public synchronized void submitUpdateLegalHoldParticipationsAndEventsTask(String remoteAddress, BearerUser user, LegalHold legalHold, Set<String> administratorIds, Set<String> custodianIds, List<String> changedDetails) {
        LOGGER.info("Submitting task to update participations for legal hold " + legalHold.getName());
        this.submittedLegalHoldIds.add(legalHold.getId());
        legalHold.updateTaskState(LegalHoldTaskState.PENDING);
        this.threadPoolExecutor.submit(() -> {
            try {
                this.updateLegalHoldParticipations(remoteAddress, user, legalHold, administratorIds, custodianIds, changedDetails);
                this.triggerMissingLegalHoldEvents(user, legalHold);
                legalHold.setTaskDone();
            }
            catch (Exception e) {
                LOGGER.error("Error updating participations and events", (Throwable)e);
                legalHold.setTaskError(this.iu.getFormattedString("LegalHoldWorker.ErrorUpdatingParticipationsAndEvents", (Object)e));
            }
            finally {
                this.submittedLegalHoldIds.remove(legalHold.getId());
                this.resetLegalHoldCache(legalHold);
            }
        });
    }

    public synchronized void submitDisableReleaseNoticeTask(LegalHold legalHold) {
        LOGGER.info("Submitting task to disable release notices for legal hold " + legalHold.getName());
        this.submittedLegalHoldIds.add(legalHold.getId());
        legalHold.updateTaskState(LegalHoldTaskState.PENDING);
        this.threadPoolExecutor.submit(() -> {
            try {
                this.disableReleaseNotice(legalHold);
                legalHold.setTaskDone();
            }
            catch (Exception e) {
                LOGGER.error("Error disabling notices", (Throwable)e);
                legalHold.setTaskError(this.iu.getFormattedString("LegalHoldWorker.ErrorDisablingNotices", (Object)e));
            }
            finally {
                this.submittedLegalHoldIds.remove(legalHold.getId());
                this.resetLegalHoldCache(legalHold);
            }
        });
    }

    public synchronized void submitDeleteLegalHoldTask(HttpServletRequest request, LegalHold legalHold) {
        LOGGER.info("Submitting task to delete legal hold " + legalHold.getName());
        this.submittedLegalHoldIds.add(legalHold.getId());
        legalHold.updateTaskState(LegalHoldTaskState.PENDING);
        this.threadPoolExecutor.submit(() -> {
            try {
                this.deleteLegalHold(request, legalHold);
                legalHold.setTaskDone();
            }
            catch (Exception e) {
                LOGGER.error("Error deleting legal hold", (Throwable)e);
                legalHold.setTaskError(this.iu.getFormattedString("LegalHoldWorker.ErrorDeletingLegalHold", (Object)e));
            }
            finally {
                this.submittedLegalHoldIds.remove(legalHold.getId());
                this.resetLegalHoldCache(legalHold);
            }
        });
    }

    private void issueHolds(BearerUser user, String remoteAddr, LegalHold legalHold, List<LegalHoldParticipation> custodianParticipations) {
        if (legalHold.getState() != LegalHoldState.ACTIVE) {
            return;
        }
        LOGGER.info("Issuing holds for " + custodianParticipations.size() + " custodians in legal hold " + legalHold.getName());
        legalHold.updateTaskState(LegalHoldTaskState.ISSUING_HOLDS);
        boolean silent = legalHold.getSilent() == Boolean.TRUE;
        ArrayList<Notice> holdAndSurveyNotices = null;
        if (!silent) {
            holdAndSurveyNotices = new ArrayList<Notice>();
            holdAndSurveyNotices.add(this.schedulerApplication.getNoticeResource().getNotice(legalHold.getHoldNoticeConfiguration().getNoticeId()));
            if (legalHold.getSurveyNoticesTrigger() == SurveyNoticesTrigger.ON_HOLD) {
                holdAndSurveyNotices.addAll(this.schedulerApplication.getNoticeUtils().getEnabledSurveyNotices(legalHold));
            }
        }
        int participationsWeight = custodianParticipations.size();
        int jobsWeight = 0;
        int othersWeight = 8;
        if (legalHold.getTriggerConfigurations() != null) {
            jobsWeight = legalHold.getTriggerConfigurations().size();
        }
        int total = participationsWeight + jobsWeight + othersWeight;
        int progress = 0;
        ArrayList<LegalHoldParticipation> custodiansIssuedHold = new ArrayList<LegalHoldParticipation>();
        for (int i = 0; i < custodianParticipations.size(); ++i) {
            LegalHoldParticipation custodianParticipation = custodianParticipations.get(i);
            boolean holdIssued = !silent ? this.schedulerApplication.getLegalHoldUtils().issueHold(user, custodianParticipation, holdAndSurveyNotices) : this.schedulerApplication.getLegalHoldUtils().issueSilentHold(custodianParticipation);
            if (holdIssued) {
                custodiansIssuedHold.add(custodianParticipation);
            }
            ++progress;
            if (i % 64 != 0) continue;
            this.updatePercentageProgress(legalHold, progress, total);
        }
        this.updatePercentageProgress(legalHold, progress, total);
        int holdsIssueCount = custodiansIssuedHold.size();
        if (holdsIssueCount > 0) {
            LegalHoldParticipations custodiansParticipations = new LegalHoldParticipations(custodiansIssuedHold);
            SchedulerApplication.getInstance().getWebhookWorker().triggerEvent(EventType.Type.LEGAL_HOLD_CUSTODIANS_ISSUED_HOLD, custodiansParticipations, user.getName());
            this.schedulerApplication.getScheduleWorker().triggerLegalHoldEvent(LegalHoldEvent.CUSTODIANS_ISSUED_HOLD, legalHold, custodiansIssuedHold);
            this.schedulerApplication.getLegalHoldUtils().handleCustodianTriggerConfiguration(legalHold, JobTriggerType.ON_MATTER_CUSTODIANS_HOLD, custodiansIssuedHold, null, null, null);
            for (LegalHoldParticipation participation : custodiansIssuedHold) {
                this.schedulerApplication.getLegalHoldUtils().handleCustodianTriggerConfiguration(legalHold, JobTriggerType.ON_CUSTODIAN_HOLD, Collections.singletonList(participation), null, null, null);
            }
            this.schedulerApplication.getLegalHoldResource().updateLegalHoldImplicitPolicies(legalHold.getId());
            this.schedulerApplication.getLegalHoldResource().trackSilentLegalHoldCustodiansUtilization(legalHold, custodiansParticipations, user.getName());
            this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), legalHold.getId(), Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()), user.getName(), EventType.Type.LEGAL_HOLD_CUSTODIANS_ISSUED_HOLD, this.iu.getFormattedString("LegalHoldResource.AuditLog.HoldIssued", (Object)holdsIssueCount), remoteAddr));
            this.schedulerApplication.getLegalHoldUtils().sendEmailToAdmins(user, legalHold, EmailType.HOLD_ISSUED, this.iu.getNumeralFormattedString("LegalHoldResource.HoldIssuedEmailDescription", (long)holdsIssueCount, (Object)legalHold.getName()));
        }
        this.updatePercentageProgress(legalHold, progress += jobsWeight + othersWeight, total);
        this.trackCustodiansConsumption(custodianParticipations, ConsumptionSubType.ADDED_TO_HOLD);
    }

    private void releaseHolds(BearerUser user, String remoteAddr, LegalHold legalHold, List<LegalHoldParticipation> custodianParticipations) {
        if (legalHold.getState() != LegalHoldState.ACTIVE && legalHold.getState() != LegalHoldState.RELEASED) {
            return;
        }
        if (custodianParticipations.size() == 0) {
            this.schedulerApplication.getLegalHoldUtils().handleMatterTriggerConfiguration(legalHold, JobTriggerType.ON_MATTER_RELEASE);
            return;
        }
        LOGGER.info("Releasing holds for " + custodianParticipations.size() + " custodians in legal hold " + legalHold.getName());
        legalHold.updateTaskState(LegalHoldTaskState.RELEASING_HOLDS);
        boolean silent = legalHold.getSilent() == Boolean.TRUE;
        Notice releaseNotice = null;
        if (!silent) {
            releaseNotice = this.schedulerApplication.getNoticeResource().getNotice(legalHold.getReleaseNoticeConfiguration().getNoticeId());
        }
        int participationsWeight = custodianParticipations.size();
        int collectionsWeight = 0;
        int othersWeight = 8;
        if (legalHold.getTriggerConfigurations() != null) {
            collectionsWeight = legalHold.getTriggerConfigurations().size();
        }
        int total = participationsWeight + collectionsWeight + othersWeight;
        int progress = 0;
        ArrayList<LegalHoldParticipation> custodiansReleased = new ArrayList<LegalHoldParticipation>();
        for (int i = 0; i < custodianParticipations.size(); ++i) {
            LegalHoldParticipation custodianParticipation = custodianParticipations.get(i);
            boolean releaseIssued = !silent ? this.schedulerApplication.getLegalHoldUtils().issueRelease(user, custodianParticipation, releaseNotice) : this.schedulerApplication.getLegalHoldUtils().issueSilentRelease(custodianParticipation);
            if (releaseIssued) {
                custodiansReleased.add(custodianParticipation);
            }
            ++progress;
            if (i % 64 != 0) continue;
            this.updatePercentageProgress(legalHold, progress, total);
        }
        this.updatePercentageProgress(legalHold, progress, total);
        int holdsReleasedCount = custodiansReleased.size();
        if (custodiansReleased.size() > 0) {
            SchedulerApplication.getInstance().getWebhookWorker().triggerEvent(EventType.Type.LEGAL_HOLD_CUSTODIANS_RELEASED, new LegalHoldParticipations(custodiansReleased), user.getName());
            this.schedulerApplication.getLegalHoldResource().updateLegalHoldImplicitPolicies(legalHold.getId());
            this.schedulerApplication.getScheduleWorker().triggerLegalHoldEvent(LegalHoldEvent.CUSTODIANS_ISSUED_RELEASE, legalHold, custodiansReleased);
            this.schedulerApplication.getLegalHoldUtils().handleCustodianTriggerConfiguration(legalHold, JobTriggerType.ON_MATTER_CUSTODIANS_RELEASE, custodiansReleased, null, null, null);
            for (LegalHoldParticipation participation : custodiansReleased) {
                this.schedulerApplication.getLegalHoldUtils().handleCustodianTriggerConfiguration(legalHold, JobTriggerType.ON_CUSTODIAN_RELEASE, Collections.singletonList(participation), null, null, null);
            }
            this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), legalHold.getId(), Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()), user.getName(), EventType.Type.LEGAL_HOLD_CUSTODIANS_RELEASED, this.iu.getFormattedString("LegalHoldResource.AuditLog.ReleaseIssued", (Object)holdsReleasedCount), remoteAddr));
            this.schedulerApplication.getLegalHoldUtils().sendEmailToAdmins(user, legalHold, EmailType.LEGAL_HOLD_RELEASED, this.iu.getNumeralFormattedString("LegalHoldResource.HoldReleasedEmailDescription", (long)holdsReleasedCount, (Object)legalHold.getName()));
        }
        this.schedulerApplication.getLegalHoldUtils().handleMatterTriggerConfiguration(legalHold, JobTriggerType.ON_MATTER_RELEASE);
        this.updatePercentageProgress(legalHold, progress += collectionsWeight + othersWeight, total);
    }

    private void updateLegalHoldParticipations(String remoteAddress, BearerUser user, LegalHold legalHold, Set<String> administratorIds, Set<String> custodianIds, List<String> changedDetails) {
        int custodiansRemovedCount;
        int custodiansAddedCount;
        LOGGER.info("Updating participations for legal hold " + legalHold.getName());
        legalHold.updateTaskState(LegalHoldTaskState.UPDATING_PARTICIPATIONS);
        boolean changedLegalHoldSettings = changedDetails.size() > 0;
        Map<String, LegalHoldParticipation> userIdToAdminParticipations = null;
        Map<String, LegalHoldParticipation> userIdToCustodianParticipations = null;
        if (administratorIds != null) {
            userIdToAdminParticipations = LegalHoldParticipationCache.getInstance().getLegalHoldParticipations(legalHold.getId(), LegalHoldRole.ADMINISTRATOR).stream().collect(Collectors.toMap(LegalHoldParticipation::getUserId, p -> p));
        }
        if (custodianIds != null) {
            userIdToCustodianParticipations = LegalHoldParticipationCache.getInstance().getLegalHoldParticipations(legalHold.getId(), LegalHoldRole.CUSTODIAN).stream().collect(Collectors.toMap(LegalHoldParticipation::getUserId, p -> p));
        }
        ArrayList<LegalHoldParticipation> newLegalHoldParticipations = new ArrayList<LegalHoldParticipation>();
        ArrayList<LegalHoldParticipation> custodiansRemoved = new ArrayList<LegalHoldParticipation>();
        ArrayList<LegalHoldParticipation> custodiansAdded = new ArrayList<LegalHoldParticipation>();
        if (custodianIds != null) {
            for (String userId : custodianIds) {
                LegalHoldParticipation participationModel = userIdToCustodianParticipations.get(userId);
                if (participationModel != null) continue;
                participationModel = new LegalHoldParticipation(legalHold.getId(), userId, LegalHoldRole.CUSTODIAN);
                newLegalHoldParticipations.add(participationModel);
                custodiansAdded.add(participationModel);
            }
            for (LegalHoldParticipation custodianParticipation : userIdToCustodianParticipations.values()) {
                if (custodianIds.contains(custodianParticipation.getUserId())) continue;
                custodiansRemoved.add(custodianParticipation);
            }
        }
        if ((custodiansAddedCount = custodiansAdded.size()) > 0) {
            changedDetails.add(this.iu.getFormattedString("LegalHoldResource.Details.CustodiansAdded", (Object)custodiansAddedCount));
            SchedulerApplication.getInstance().getWebhookWorker().triggerEvent(EventType.Type.LEGAL_HOLD_CUSTODIANS_ADDED, new LegalHoldParticipations(custodiansAdded), user.getName());
            this.issueHolds(user, remoteAddress, legalHold, custodiansAdded);
        }
        if ((custodiansRemovedCount = custodiansRemoved.size()) > 0) {
            changedDetails.add(this.iu.getFormattedString("LegalHoldResource.Details.CustodiansRemoved", (Object)custodiansRemovedCount));
            SchedulerApplication.getInstance().getWebhookWorker().triggerEvent(EventType.Type.LEGAL_HOLD_CUSTODIANS_REMOVED, new LegalHoldParticipations(custodiansRemoved), user.getName());
            this.releaseHolds(user, remoteAddress, legalHold, custodiansRemoved);
        }
        legalHold.updateTaskState(LegalHoldTaskState.UPDATING_PARTICIPATIONS);
        int othersWeight = 16;
        int total = othersWeight + custodiansRemovedCount * 4;
        if (administratorIds != null) {
            total += userIdToAdminParticipations.size();
        }
        int progress = 0;
        if (custodiansRemovedCount > 0) {
            Set<String> legalHoldNoticeIds = this.schedulerApplication.getSchedulerConfigurationDao().getLegalHoldNoticesIds(legalHold.getId());
            Set<String> removedCustodianUserIds = custodiansRemoved.stream().map(LegalHoldParticipation::getUserId).collect(Collectors.toSet());
            this.schedulerApplication.getLegalHoldUtils().removeOrUpdateTriggerConfigurationEvents(legalHold.getId(), removedCustodianUserIds);
            progress += 4;
            int i = 0;
            for (String removedCustodianUserId : removedCustodianUserIds) {
                for (String noticeId : legalHoldNoticeIds) {
                    for (NoticeEvent noticeEvent : this.schedulerApplication.getSchedulerConfigurationDao().getUserNoticeEvents(noticeId, removedCustodianUserId)) {
                        this.schedulerApplication.getSchedulerConfigurationDao().deleteNoticeEventsComments(noticeEvent.getId());
                    }
                    this.schedulerApplication.getSchedulerConfigurationDao().deleteNoticeUsersNoticeEvents(noticeId, removedCustodianUserId);
                }
                this.schedulerApplication.getLegalHoldResource().deleteLegalHoldParticipation(legalHold.getId(), removedCustodianUserId, LegalHoldRole.CUSTODIAN);
                this.schedulerApplication.getSchedulerConfigurationDao().deleteLegalHoldParticipation(legalHold.getId(), removedCustodianUserId, LegalHoldRole.CUSTODIAN);
                progress += 4;
                if (++i % 64 != 0) continue;
                this.updatePercentageProgress(legalHold, progress, total);
            }
        }
        this.updatePercentageProgress(legalHold, progress, total);
        int adminsAddedCount = 0;
        int adminsRemovedCount = 0;
        if (administratorIds != null) {
            legalHold.setAdministratorIds(administratorIds);
            for (String userId : administratorIds) {
                LegalHoldParticipation participationModel = userIdToAdminParticipations.get(userId);
                if (participationModel != null) continue;
                participationModel = new LegalHoldParticipation(legalHold.getId(), userId, LegalHoldRole.ADMINISTRATOR);
                newLegalHoldParticipations.add(participationModel);
                ++adminsAddedCount;
            }
            this.updatePercentageProgress(legalHold, progress, total);
            for (String userId : userIdToAdminParticipations.keySet()) {
                if (!administratorIds.contains(userId)) {
                    this.schedulerApplication.getLegalHoldResource().deleteLegalHoldParticipation(legalHold.getId(), userId, LegalHoldRole.ADMINISTRATOR);
                    this.schedulerApplication.getSchedulerConfigurationDao().deleteLegalHoldParticipation(legalHold.getId(), userId, LegalHoldRole.ADMINISTRATOR);
                    ++adminsRemovedCount;
                }
                ++progress;
            }
            this.updatePercentageProgress(legalHold, progress, total);
            if (adminsAddedCount > 0) {
                changedDetails.add(this.iu.getFormattedString("LegalHoldResource.Details.AdministratorsAdded", (Object)adminsAddedCount));
            }
            if (adminsRemovedCount > 0) {
                changedDetails.add(this.iu.getFormattedString("LegalHoldResource.Details.AdministratorsRemoved", (Object)adminsRemovedCount));
            }
        }
        this.schedulerApplication.getLegalHoldResource().addLegalHoldParticipations(newLegalHoldParticipations);
        this.schedulerApplication.getSchedulerConfigurationDao().addLegalHoldParticipations(newLegalHoldParticipations);
        this.updatePercentageProgress(legalHold, progress += othersWeight - 4, total);
        long lastChangedDate = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
        if (changedLegalHoldSettings) {
            legalHold.setLastChangedDate(Long.valueOf(lastChangedDate));
            legalHold.setLastChangedBy(user.getName());
            legalHold.setLastChangedByUserId(user.getId());
        }
        this.schedulerApplication.getSchedulerConfigurationDao().updateLegalHold(legalHold);
        if (!(changedLegalHoldSettings || custodiansAddedCount <= 0 && custodiansRemovedCount <= 0 && adminsAddedCount <= 0 && adminsRemovedCount <= 0)) {
            this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), legalHold.getId(), Long.valueOf(lastChangedDate), user.getName(), EventType.Type.LEGAL_HOLD_PARTICIPATION_CHANGED, String.join((CharSequence)"\n", changedDetails), remoteAddress));
        } else {
            this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), legalHold.getId(), Long.valueOf(lastChangedDate), user.getName(), EventType.Type.LEGAL_HOLD_MODIFIED, String.join((CharSequence)"\n", changedDetails), remoteAddress));
        }
        ResponseCache.getInstance().resetKeyId(CacheKey.USERS);
    }

    private void triggerMissingLegalHoldEvents(BearerUser user, LegalHold legalHold) {
        if (legalHold.getState() != LegalHoldState.ACTIVE) {
            return;
        }
        LOGGER.info("Updating notice and collection events for legal hold " + legalHold.getName());
        legalHold.updateTaskState(LegalHoldTaskState.UPDATING_EVENTS);
        List custodiansOnHold = LegalHoldParticipationCache.getInstance().getLegalHoldParticipations(legalHold.getId(), LegalHoldRole.CUSTODIAN).stream().filter(participation -> participation.getCustodianState() == CustodianState.ON_HOLD).collect(Collectors.toList());
        boolean hasTriggerConfigurations = legalHold.getTriggerConfigurations() != null && legalHold.getTriggerConfigurations().size() > 0;
        int participationsWeight = custodiansOnHold.size();
        int triggersWeight = 0;
        if (hasTriggerConfigurations) {
            triggersWeight = legalHold.getTriggerConfigurations().size() * participationsWeight + 2;
        }
        int total = participationsWeight + triggersWeight;
        int progress = 0;
        this.updatePercentageProgress(legalHold, progress, total);
        ArrayList<Notice> holdAndSurveyNotices = new ArrayList<Notice>();
        if (legalHold.getSilent() != Boolean.TRUE) {
            Notice holdNotice = this.schedulerApplication.getNoticeResource().getNotice(legalHold.getHoldNoticeConfiguration().getNoticeId());
            List<Notice> surveyNotices = this.schedulerApplication.getNoticeUtils().getEnabledSurveyNotices(legalHold);
            holdAndSurveyNotices.add(holdNotice);
            holdAndSurveyNotices.addAll(surveyNotices);
            SurveyNoticesTrigger surveyNoticesTrigger = legalHold.getSurveyNoticesTrigger();
            for (int i = 0; i < custodiansOnHold.size(); ++i) {
                boolean sendSurveys;
                LegalHoldParticipation custodianParticipation = (LegalHoldParticipation)custodiansOnHold.get(i);
                String userId = custodianParticipation.getUserId();
                List<NoticeEvent> holdNoticeEvents = this.schedulerApplication.getSchedulerConfigurationDao().getUserNoticeEvents(holdNotice.getId(), userId);
                if (this.missingNoticeEvent(custodianParticipation, holdNoticeEvents)) {
                    this.schedulerApplication.getNoticeUtils().buildNoticeEvent(user, holdNotice, userId, holdNoticeEvents);
                }
                boolean submittedHoldResponse = holdNoticeEvents.size() > 0 && holdNoticeEvents.get(0).getLastRespondedDate() != null;
                boolean bl = sendSurveys = surveyNoticesTrigger == SurveyNoticesTrigger.ON_HOLD || surveyNoticesTrigger == SurveyNoticesTrigger.ON_HOLD_RESPONSE && submittedHoldResponse;
                if (sendSurveys) {
                    for (Notice notice : surveyNotices) {
                        List<NoticeEvent> noticeEvents = this.schedulerApplication.getSchedulerConfigurationDao().getUserNoticeEvents(notice.getId(), userId);
                        if (!this.missingNoticeEvent(custodianParticipation, noticeEvents)) continue;
                        this.schedulerApplication.getNoticeUtils().buildNoticeEvent(user, notice, userId, noticeEvents);
                    }
                }
                ++progress;
                if (i % 64 != 0) continue;
                this.updatePercentageProgress(legalHold, progress, total);
            }
        }
        if (!hasTriggerConfigurations) {
            this.updatePercentageProgress(legalHold, progress, total);
            return;
        }
        int i = 0;
        for (TriggerConfiguration configuration : legalHold.getTriggerConfigurations().values()) {
            if (configuration.getEnabled() != Boolean.TRUE) {
                progress += participationsWeight;
                continue;
            }
            List<TriggerConfigurationEvent> triggerConfigurationEvents = this.schedulerApplication.getSchedulerConfigurationDao().getTriggerConfigurationTriggerConfigurationEvents(configuration.getId());
            HashSet<LegalHoldParticipation> custodiansToIssueHold = new HashSet<LegalHoldParticipation>();
            for (LegalHoldParticipation custodianParticipation : custodiansOnHold) {
                ArrayList<TriggerConfigurationEvent> userTriggerConfigurationEvents = new ArrayList<TriggerConfigurationEvent>();
                for (TriggerConfigurationEvent event2 : triggerConfigurationEvents) {
                    if (!event2.getUserIds().contains(custodianParticipation.getUserId())) continue;
                    userTriggerConfigurationEvents.add(event2);
                }
                if (userTriggerConfigurationEvents.stream().allMatch(event -> event.getTriggeredDate() < custodianParticipation.getHoldIssuedDate())) {
                    switch (configuration.getTrigger()) {
                        case ON_CUSTODIAN_HOLD: {
                            custodiansToIssueHold.add(custodianParticipation);
                            break;
                        }
                        case ON_CUSTODIAN_RESPONSE: {
                            for (Notice notice : holdAndSurveyNotices) {
                                NoticeEvent noticeEvent;
                                List<NoticeEvent> noticeEvents = this.schedulerApplication.getSchedulerConfigurationDao().getUserNoticeEvents(notice.getId(), custodianParticipation.getUserId());
                                if (noticeEvents.size() == 0 || (noticeEvent = noticeEvents.get(0)).getLastRespondedDate() == null || noticeEvent.getLastRespondedDate() <= custodianParticipation.getHoldIssuedDate()) continue;
                                this.schedulerApplication.getLegalHoldUtils().handleCustodianTriggerConfiguration(legalHold, JobTriggerType.ON_CUSTODIAN_RESPONSE, null, notice, noticeEvent, noticeEvent.getSurveyFormValues());
                            }
                            break;
                        }
                    }
                }
                ++progress;
                if (++i % 64 != 0) continue;
                this.updatePercentageProgress(legalHold, progress, total);
            }
            if (custodiansToIssueHold.size() <= 0) continue;
            this.schedulerApplication.getLegalHoldUtils().handleCustodianTriggerConfiguration(legalHold, JobTriggerType.ON_CUSTODIAN_HOLD, new ArrayList<LegalHoldParticipation>(custodiansToIssueHold), null, null, null);
        }
        this.updatePercentageProgress(legalHold, progress += 2, total);
    }

    private void disableReleaseNotice(LegalHold legalHold) {
        if (legalHold.getState() != LegalHoldState.ARCHIVED || legalHold.getSilent() == Boolean.TRUE) {
            return;
        }
        LOGGER.info("Disabling Release notices for legal hold " + legalHold.getName());
        legalHold.updateTaskState(LegalHoldTaskState.DISABLING_NOTICES);
        NoticeConfiguration releaseNoticeConfiguration = legalHold.getReleaseNoticeConfiguration();
        ArrayList<Notice> noticesToDisable = new ArrayList<Notice>();
        noticesToDisable.add(this.schedulerApplication.getNoticeResource().getNotice(releaseNoticeConfiguration.getNoticeId()));
        noticesToDisable.addAll(this.schedulerApplication.getNoticeUtils().getReminderAndEscalateNotices(noticesToDisable));
        ArrayList<NoticeEvent> noticeEventsToDisable = new ArrayList<NoticeEvent>();
        for (Notice notice : noticesToDisable) {
            noticeEventsToDisable.addAll(this.schedulerApplication.getSchedulerConfigurationDao().getNoticeNoticeEvents(notice.getId()));
        }
        int total = noticeEventsToDisable.size();
        int progress = 0;
        for (int i = 0; i < noticeEventsToDisable.size(); ++i) {
            NoticeEvent noticeEvent = (NoticeEvent)noticeEventsToDisable.get(i);
            if (noticeEvent.getEnabled() != Boolean.FALSE) {
                noticeEvent.setEnabled(Boolean.valueOf(false));
                this.schedulerApplication.getSchedulerConfigurationDao().updateNoticeEvent(noticeEvent);
            }
            ++progress;
            if (i % 64 != 0) continue;
            this.updatePercentageProgress(legalHold, progress, total);
        }
        this.updatePercentageProgress(legalHold, progress, total);
    }

    private void deleteLegalHold(HttpServletRequest request, LegalHold legalHold) {
        LOGGER.info("Deleting all objects for legal hold " + legalHold.getName());
        legalHold.updateTaskState(LegalHoldTaskState.DELETING);
        int total = 16;
        int progress = 0;
        this.updatePercentageProgress(legalHold, progress, total);
        String legalHoldId = legalHold.getId();
        this.updatePercentageProgress(legalHold, progress += 4, total);
        this.schedulerApplication.getNoticeResource().getNotices().removeIf(notice -> {
            if (legalHoldId.equals(notice.getLegalHoldId())) {
                Set<String> noticeEventIds = this.schedulerApplication.getSchedulerConfigurationDao().getNoticeNoticeEventIds(notice.getId());
                for (Dataset dataset : this.schedulerApplication.getDatasetResource().getDatasets()) {
                    Response response;
                    if (dataset.isDeleted() || dataset.getNoticeEventId() == null || !noticeEventIds.contains(dataset.getNoticeEventId()) || (response = this.schedulerApplication.getDatasetResource().deleteDataset(new LegalHoldBearerUser(), dataset.getId(), request, true)).getStatus() == Response.Status.OK.getStatusCode()) continue;
                    return false;
                }
                for (String noticeEventId : noticeEventIds) {
                    this.schedulerApplication.getSchedulerConfigurationDao().deleteNoticeEventsComments(noticeEventId);
                }
                this.schedulerApplication.getSchedulerConfigurationDao().deleteNoticesNoticeEvents(notice.getId());
                return true;
            }
            return false;
        });
        this.updatePercentageProgress(legalHold, progress += 8, total);
        this.schedulerApplication.getLegalHoldResource().deleteLegalHoldParticipations(legalHoldId);
        this.schedulerApplication.getSchedulerConfigurationDao().deleteLegalHoldParticipations(legalHoldId);
        this.schedulerApplication.getSchedulerConfigurationDao().deleteLegalHoldNotices(legalHoldId);
        this.schedulerApplication.getSchedulerConfigurationDao().deleteLegalHold(legalHoldId);
        this.updatePercentageProgress(legalHold, progress += 4, total);
        ResponseCache.getInstance().resetKeyId(CacheKey.USERS);
    }

    private boolean missingNoticeEvent(LegalHoldParticipation custodianParticipation, List<NoticeEvent> noticeEvents) {
        if (noticeEvents.size() == 0) {
            return true;
        }
        NoticeEvent noticeEvent = noticeEvents.get(0);
        return noticeEvent.getEnabled() != Boolean.TRUE && (noticeEvent.getLastRespondedDate() == null || noticeEvent.getLastRespondedDate() < custodianParticipation.getHoldIssuedDate());
    }

    private void updatePercentageProgress(LegalHold legalHold, int progress, int total) {
        legalHold.setTaskPercentProgress(total > 0 ? progress * 100 / total : 0);
        this.resetLegalHoldCache(legalHold);
    }

    private void resetLegalHoldCache(LegalHold legalHold) {
        this.schedulerApplication.getSchedulerConfigurationDao().updateLegalHold(legalHold);
        ResponseCache.getInstance().resetKeyId(CacheKey.LEGAL_HOLDS, "");
        ResponseCache.getInstance().resetKeyId(CacheKey.LEGAL_HOLD, legalHold.getId());
        ResponseCache.getInstance().resetKeyId(CacheKey.NOTICES, legalHold.getId());
    }
}

