/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.workers;

import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.resources.ResourcePoolResource;
import com.nuix.automate.scheduler.workers.ResourcePoolWorker;
import com.nuix.automate.scheduler.workers.ServerWorker;
import com.nuix.automate.utils.exceptions.ServerException;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.engine.EngineRole;
import com.nuix.automate.utils.models.api.engine.EngineStatus;
import com.nuix.automate.utils.models.api.server.MaintenanceStatus;
import com.nuix.automate.utils.models.internal.engine.EngineModel;
import com.nuix.automate.utils.models.internal.job.BootstrappableJob;
import com.nuix.automate.utils.models.internal.job.JobDetailsModel;
import com.nuix.automate.utils.models.internal.job.RemoteWorkersSpecModel;
import com.nuix.automate.utils.models.internal.resourcepool.ResourcePoolModel;
import com.nuix.automate.utils.workflow.ExecutionMode;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.stream.Collectors;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class LocalResourcePoolWorker
extends ResourcePoolWorker {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(LocalResourcePoolWorker.class);

    @Override
    public void onBeforeDelete() throws IllegalStateException {
        this.timer.cancel();
    }

    @Override
    public boolean getUsingRemoteWorkers() {
        return this.getEngineIds(EngineRole.REMOTE).size() > 0;
    }

    public LocalResourcePoolWorker(SchedulerApplication schedulerApplication, ResourcePoolResource resourcePoolResource, ResourcePoolModel resourcePool) {
        super(schedulerApplication, resourcePoolResource, resourcePool);
        this.timer.schedule((TimerTask)this, schedulerApplication.getConfiguration().getResourcePoolBootstrapDelay(), schedulerApplication.getConfiguration().getResourcePoolInterval());
    }

    void joinRemoteEngines(JobDetailsModel runningJob) {
        int currentRemoteWorkerPoolSize;
        int totalWorkerCount = this.schedulerApplication.getJobResource().getJobMaxWorkerCount(runningJob);
        int requiredWorkers = totalWorkerCount - (currentRemoteWorkerPoolSize = this.getCurrentAssignedWorkerCount(runningJob));
        if (requiredWorkers <= 0) {
            return;
        }
        Set<String> remoteEngines = this.getEngineIds(EngineRole.REMOTE);
        for (ServerWorker serverWorker : this.schedulerApplication.getServerResource().getServerWorkers().values()) {
            if (serverWorker.isUserDataDirSyncActive() || serverWorker.getModel().getMaintenanceStatus() != MaintenanceStatus.NONE) continue;
            for (EngineModel engineModel : serverWorker.getEngineModels()) {
                if (!remoteEngines.contains(engineModel.getId()) || engineModel.getStatus() != EngineStatus.STANDBY || requiredWorkers <= 0) continue;
                try {
                    engineModel.setWorkerAgentOnly(true);
                    serverWorker.joinRemoteJob(engineModel.getId(), runningJob);
                    requiredWorkers -= engineModel.getTargetNuixWorkers().intValue();
                }
                catch (Exception e) {
                    LOGGER.info(String.valueOf(engineModel) + " cannot join remote " + String.valueOf(runningJob.getSettings()));
                }
            }
        }
        if (requiredWorkers <= 0) {
            int iteration = 0;
            int assignedWorkerCount = 0;
            do {
                if (iteration == 300) {
                    LOGGER.error("Failed to add remote engine to job after trying for 30 seconds");
                    break;
                }
                assignedWorkerCount = this.getCurrentAssignedWorkerCount(runningJob);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    LOGGER.error("");
                }
                ++iteration;
            } while (totalWorkerCount - assignedWorkerCount >= 0);
        }
    }

    public int getCurrentAssignedWorkerCount(JobDetailsModel runningJob) {
        int currentRemoteWorkerPoolSize = 0;
        Set<String> remoteEngines = this.getEngineIds(EngineRole.REMOTE);
        for (ServerWorker serverWorker : this.schedulerApplication.getServerResource().getServerWorkers().values()) {
            if (serverWorker.isUserDataDirSyncActive() || serverWorker.getModel().getMaintenanceStatus() != MaintenanceStatus.NONE) continue;
            for (EngineModel engineModel : serverWorker.getEngineModels()) {
                boolean engineBootstrappingCurrentJob;
                if (!remoteEngines.contains(engineModel.getId())) continue;
                boolean engineRunningCurrentJob = engineModel.getRunningJobId() != null && engineModel.getRunningJobId().equals(runningJob.getSettings().getId());
                boolean bl = engineBootstrappingCurrentJob = engineModel.getBootstrappingJobId() != null && engineModel.getBootstrappingJobId().equals(runningJob.getSettings().getId());
                if (!engineModel.getWorkerAgentOnly() || !engineRunningCurrentJob && !engineBootstrappingCurrentJob) continue;
                currentRemoteWorkerPoolSize += engineModel.getTargetNuixWorkers().intValue();
            }
        }
        return currentRemoteWorkerPoolSize;
    }

    @Override
    protected void manageWork() {
        block24: {
            List<JobDetailsModel> runningJobs = this.getRunningJobs();
            for (JobDetailsModel runningJob : runningJobs) {
                if (!this.schedulerApplication.getJobResource().jobHasUnfulfilledWorkers(runningJob)) continue;
                this.joinRemoteEngines(runningJob);
            }
            if (this.model.getActive() != null && this.model.getActive().booleanValue()) {
                HashMap<EngineModel, Integer> candidateEngineIds = new HashMap<EngineModel, Integer>();
                Set<String> resourcePoolEngineIds = this.getEngineIds(EngineRole.MAIN);
                try {
                    for (ServerWorker serverWorker : this.schedulerApplication.getServerResource().getServerWorkers().values()) {
                        if (serverWorker.isUserDataDirSyncActive() || serverWorker.getModel().getMaintenanceStatus() != MaintenanceStatus.NONE) continue;
                        int serverRunningEngines = 0;
                        for (EngineModel engineModel : serverWorker.getEngineModels()) {
                            if (engineModel.getStatus() != EngineStatus.RUNNING) continue;
                            ++serverRunningEngines;
                        }
                        for (EngineModel engineModel : serverWorker.getEngineModels()) {
                            if (!resourcePoolEngineIds.contains(engineModel.getId()) || engineModel.getStatus() != EngineStatus.STANDBY) continue;
                            candidateEngineIds.put(engineModel, -100 * engineModel.getPriority().getInt() + serverRunningEngines);
                        }
                    }
                    HashMap<ExecutionMode, EngineModel> candidateEngineWithExecutionMode = new HashMap<ExecutionMode, EngineModel>();
                    HashMap<ExecutionMode, ServerWorker> candidateServerWorkerWithExecutionMode = new HashMap<ExecutionMode, ServerWorker>();
                    if (candidateEngineIds.size() == 0) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug(String.valueOf(this.model) + " - No engine is available");
                        }
                        break block24;
                    }
                    for (ExecutionMode executionMode : ExecutionMode.values()) {
                        LinkedHashMap sortedCandidateEngineIds = candidateEngineIds.entrySet().stream().filter(engineModelIntegerEntry -> ((EngineModel)engineModelIntegerEntry.getKey()).getSupportedExecutionMode().equals((Object)executionMode)).sorted(Map.Entry.comparingByValue()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e2, LinkedHashMap::new));
                        if (sortedCandidateEngineIds.size() <= 0) continue;
                        EngineModel candidateEngine = (EngineModel)sortedCandidateEngineIds.keySet().iterator().next();
                        candidateEngineWithExecutionMode.put(executionMode, candidateEngine);
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug(String.valueOf(this.model) + " - " + String.valueOf(executionMode) + " - Best available candidate " + String.valueOf(candidateEngine));
                        }
                        ServerWorker candidateServerWorker = null;
                        for (ServerWorker serverWorker : this.schedulerApplication.getServerResource().getServerWorkers().values()) {
                            if (!serverWorker.getModel().getId().equals(candidateEngine.getServerId())) continue;
                            candidateServerWorker = serverWorker;
                            candidateServerWorkerWithExecutionMode.put(executionMode, candidateServerWorker);
                        }
                    }
                    BootstrappableJob bootstrappableJob = null;
                    try {
                        bootstrappableJob = this.schedulerApplication.getJobResource().getNotStartedJobForResourcePool(this.model.getId(), true, candidateEngineWithExecutionMode.keySet());
                    }
                    catch (Exception e) {
                        LOGGER.error("Cannot get bootstrappable Job", (Throwable)e);
                    }
                    if (bootstrappableJob == null) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug(String.valueOf(this.model) + " - No jobs are queued to this resource pool");
                        }
                    } else {
                        EngineModel candidateEngine = null;
                        ServerWorker candidateServerWorker = null;
                        ExecutionMode jobExecutionMode = bootstrappableJob.getJobModel().getExecutionMode();
                        candidateEngine = (EngineModel)candidateEngineWithExecutionMode.get(jobExecutionMode);
                        candidateServerWorker = (ServerWorker)candidateServerWorkerWithExecutionMode.get(jobExecutionMode);
                        if (candidateEngine == null && jobExecutionMode.equals((Object)ExecutionMode.AUTOMATE_NATIVE)) {
                            candidateEngine = (EngineModel)candidateEngineWithExecutionMode.get(ExecutionMode.AUTOMATE_NUIX);
                            candidateServerWorker = (ServerWorker)candidateServerWorkerWithExecutionMode.get(ExecutionMode.AUTOMATE_NUIX);
                        }
                        if (candidateEngine != null) {
                            LOGGER.info(String.valueOf(this.model) + " - Bootstrapping " + String.valueOf(bootstrappableJob.getJobModel()) + " to " + String.valueOf(candidateEngine));
                            try {
                                bootstrappableJob.getJobModel().setLastStateChangedDate(Long.valueOf(new DateTime(DateTimeZone.UTC).getMillis()));
                                bootstrappableJob.getJobModel().setEngineId(candidateEngine.getId());
                                this.resolveObjectNames(candidateServerWorker, bootstrappableJob.getJobModel(), candidateEngine);
                                candidateEngine.setWorkerAgentOnly(false);
                                if (!this.getUsingRemoteWorkers()) {
                                    bootstrappableJob.getJobModel().setRemoteWorkersSpec(new RemoteWorkersSpecModel());
                                }
                                candidateServerWorker.bootstrapJob(candidateEngine.getId(), bootstrappableJob);
                            }
                            catch (ServerException e) {
                                LOGGER.error(String.valueOf(this.model) + " Cannot send " + String.valueOf(bootstrappableJob.getJobModel()) + " to " + String.valueOf(candidateEngine), (Throwable)e);
                                this.schedulerApplication.getJobResource().clearJobBootstrapState(bootstrappableJob.getJobModel().getId());
                                this.schedulerApplication.getJobResource().resolveJobNames(bootstrappableJob.getJobModel());
                            }
                        } else if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug(String.valueOf(this.model) + " - Candidate engine is null");
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot scan for server engines", (Throwable)e);
                    if (!LOGGER.isDebugEnabled()) break block24;
                    LOGGER.debug("Cannot scan for server engines", (Throwable)e);
                }
            }
        }
    }
}

