/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.workers;

import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.resources.JobResource;
import com.nuix.automate.utils.models.internal.job.JobDetailsModel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class MemgraphWorker {
    private List<String> activeJobIds = new ArrayList<String>();

    private void refreshActiveJobIds() {
        JobResource jobResource = SchedulerApplication.getInstance().getJobResource();
        HashSet<String> nonFinishedJobIds = new HashSet<String>();
        for (JobDetailsModel nonFinishedJob : jobResource.getNonFinishedJobs()) {
            nonFinishedJobIds.add(nonFinishedJob.getSettings().getId());
        }
        HashSet<String> dissapearedJobIds = new HashSet<String>();
        for (String activeJobId : this.activeJobIds) {
            if (nonFinishedJobIds.contains(activeJobId)) continue;
            dissapearedJobIds.add(activeJobId);
        }
        this.activeJobIds.removeAll(dissapearedJobIds);
    }

    public int getJobsInFront(String jobId) {
        this.refreshActiveJobIds();
        int jobsInFront = 0;
        for (String activeJobId : this.activeJobIds) {
            if (activeJobId.equals(jobId)) {
                return jobsInFront;
            }
            ++jobsInFront;
        }
        this.activeJobIds.add(jobId);
        return this.activeJobIds.size() - 1;
    }

    public void trackFinishedJob(String jobId) {
        this.activeJobIds.remove(jobId);
    }
}

