/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.workers;

import com.nuix.automate.dropwizard.utils.models.UserServiceClient;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.security.oidc.microsoft.MicrosoftOidcUserServiceClient;
import com.nuix.automate.scheduler.security.oidc.microsoft.MicrosoftUserService;
import com.nuix.automate.scheduler.security.thirdparty.PurviewServiceSession;
import com.nuix.automate.scheduler.workers.UserServiceWorker;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.thirdparty.PurviewService;
import com.nuix.automate.utils.models.api.thirdparty.PurviewUserCredential;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyAuthenticationScope;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyService;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyUserCredential;
import com.nuix.automate.utils.models.api.userservice.MicrosoftSharePointSite;
import com.nuix.automate.utils.models.api.userservice.MicrosoftUnifiedGroup;
import com.nuix.automate.utils.models.api.userservice.UserServiceObjectType;
import com.nuix.automate.utils.models.internal.graphapi.Site;
import com.nuix.automate.utils.models.internal.user.UserService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class MicrosoftUserServiceWorker
extends UserServiceWorker {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(MicrosoftUserServiceWorker.class);

    public MicrosoftUserServiceWorker(SchedulerApplication schedulerApplication, MicrosoftUserService userService) {
        super(schedulerApplication, (UserService)userService);
    }

    @Override
    public int synchronizeObjects(UserServiceClient userServiceClient) {
        MicrosoftOidcUserServiceClient microsoftUserServiceClient = (MicrosoftOidcUserServiceClient)userServiceClient;
        int synchronizedObjectsCount = 0;
        try {
            synchronizedObjectsCount += this.synchronizeUnifiedGroups(microsoftUserServiceClient);
        }
        catch (Exception e) {
            LOGGER.error("Could not synchronize " + String.valueOf(this.userService) + " Unified Groups", (Throwable)e);
            this.userService.getStatus().setError(this.iu.getFormattedString("UsersResource.ScheduledQueryError", new Object[]{this.userService.getName(), e}));
        }
        try {
            synchronizedObjectsCount += this.synchronizeSharePointSites(microsoftUserServiceClient);
        }
        catch (Exception e) {
            LOGGER.error("Could not synchronize " + String.valueOf(this.userService) + " SharePoint sites", (Throwable)e);
            this.userService.getStatus().setError(this.iu.getFormattedString("UsersResource.ScheduledQueryError", new Object[]{this.userService.getName(), e}));
        }
        return synchronizedObjectsCount;
    }

    private int synchronizeUnifiedGroups(MicrosoftOidcUserServiceClient microsoftUserServiceClient) throws IOException {
        LOGGER.info("Querying " + String.valueOf(this.userService) + " unified groups");
        long startMs = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
        List<MicrosoftUnifiedGroup> serviceGroups = microsoftUserServiceClient.getUnifiedGroups((MicrosoftUserService)this.userService);
        long endMs = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
        LOGGER.info("Querying " + String.valueOf(this.userService) + " unified groups took " + (endMs - startMs) / 1000L + " s");
        LOGGER.info("Microsoft Authentication Service " + this.userService.getName() + " found " + serviceGroups.size() + " Unified Groups");
        return this.persistUserServiceObjects(UserServiceObjectType.UNIFIED_GROUP, serviceGroups);
    }

    private int synchronizeSharePointSites(MicrosoftOidcUserServiceClient microsoftUserServiceClient) throws IOException {
        List<MicrosoftSharePointSite> serviceSites;
        LOGGER.info("Querying " + String.valueOf(this.userService) + " sharepoint sites");
        long startMs = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
        try {
            serviceSites = microsoftUserServiceClient.getSharePointSites((MicrosoftUserService)this.userService, true);
        }
        catch (IOException e) {
            LOGGER.error("Could not query " + String.valueOf(this.userService) + " sharepoint sites", (Throwable)e);
            PurviewServiceSession purviewServiceSession = this.getFirstThirdPartyServiceSession();
            if (purviewServiceSession != null && purviewServiceSession.getSignedIn()) {
                LOGGER.info("Querying with thirdPartyService " + purviewServiceSession.getServiceId() + " userCredential, signed in as: " + ((PurviewUserCredential)purviewServiceSession.getUserCredential()).getUsername());
                try {
                    serviceSites = new ArrayList<MicrosoftSharePointSite>();
                    for (Site site : purviewServiceSession.getSharePointSites(true)) {
                        MicrosoftSharePointSite sharePointSite = new MicrosoftSharePointSite(site);
                        sharePointSite.setUserServiceId(this.userService.getId());
                        serviceSites.add(sharePointSite);
                    }
                    boolean mockOptionsEnabled = this.schedulerApplication.getConfiguration().getMockOptionsEnabled();
                    if (mockOptionsEnabled) {
                        serviceSites.addAll(microsoftUserServiceClient.buildMockSharePointSites(this.userService.getId(), this.schedulerApplication.getConfiguration().getMockOptionsCount()));
                    }
                }
                catch (Exception ex) {
                    LOGGER.error("Could not query " + String.valueOf(this.userService) + " sharepoint sites with thirdPartyService " + purviewServiceSession.getServiceId() + " userCredential", (Throwable)ex);
                    throw ex;
                }
            }
            throw e;
        }
        long endMs = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
        LOGGER.info("Querying " + String.valueOf(this.userService) + " sharepoint sites took " + (endMs - startMs) / 1000L + " s");
        LOGGER.info("Microsoft Authentication Service " + this.userService.getName() + " found " + serviceSites.size() + " SharePoint sites");
        return this.persistUserServiceObjects(UserServiceObjectType.SHARE_POINT_SITE, serviceSites);
    }

    private PurviewServiceSession getFirstThirdPartyServiceSession() {
        for (ThirdPartyService thirdPartyService : this.schedulerApplication.getThirdPartyServiceResource().getThirdPartyServicesUsingOidcAuthenticationService(this.userService)) {
            if (!Boolean.TRUE.equals(thirdPartyService.getEnabled()) || !(thirdPartyService instanceof PurviewService)) continue;
            if (thirdPartyService.getAuthenticationScope() == ThirdPartyAuthenticationScope.SERVICE) {
                try {
                    return (PurviewServiceSession)this.schedulerApplication.getThirdPartyServiceResource().getThirdPartyServiceSession(thirdPartyService.getId(), this.userService.getId(), true);
                }
                catch (IOException e) {
                    LOGGER.error("Cannot retrieve client", (Throwable)e);
                    continue;
                }
            }
            for (ThirdPartyUserCredential userCredential : this.schedulerApplication.getSchedulerConfigurationDao().getThirdPartyUserCredentials(thirdPartyService.getId(), ThirdPartyAuthenticationScope.USER)) {
                if (!userCredential.getSignedIn()) continue;
                try {
                    return (PurviewServiceSession)this.schedulerApplication.getThirdPartyServiceResource().getThirdPartyServiceSession(thirdPartyService.getId(), userCredential.getUserId(), true);
                }
                catch (IOException e) {
                    LOGGER.error("Cannot retrieve client", (Throwable)e);
                }
            }
        }
        return null;
    }
}

