/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.workers.Proxy;

import com.nuix.automate.dropwizard.utils.resources.VersionResources;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.tus.TusFileUploadService;
import com.nuix.automate.scheduler.tus.upload.UploadId;
import com.nuix.automate.scheduler.tus.upload.UploadInfo;
import com.nuix.automate.scheduler.tus.upload.scheduler.ProxyStorageService;
import com.nuix.automate.scheduler.utils.proxy.ProxyConfiguration;
import com.nuix.automate.utils.api.response.ResponseStatus;
import com.nuix.automate.utils.api.response.TranslationResponseStatus;
import com.nuix.automate.utils.exceptions.ServerException;
import com.nuix.automate.utils.general.DropwizardRestClientFactory;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.user.SystemApiKeyAuthenticationSubmission;
import com.nuix.automate.utils.models.api.user.UserSession;
import com.nuix.automate.utils.models.internal.template.AutomateApplication;
import com.nuix.automate.utils.models.internal.template.AutomateConfiguration;
import com.nuix.automate.utils.security.SecurityUtils;
import com.nuix.automate.utils.security.policies.ApplicationFeatures;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.concurrent.Semaphore;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang.NotImplementedException;

public class ProxyWorker {
    public static final String datasetIdRegex = "[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}";
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ProxyWorker.class);
    private final SchedulerApplication schedulerApplication;
    private ProxyConfiguration proxyConfiguration;
    private final TusFileUploadService tusFileUploadService;
    private Client client;
    private Semaphore pingSemaphore;
    private String authToken;
    private ProxyStorageService proxyStorageService;
    private String automateVersion;
    private final List<String> passThroughHeaderNames = Arrays.asList("Cookie", "Authorization", "If-None-Match", "Tus-Resumable", "Upload-Offset", "Upload-Metadata", "Upload-Checksum", "Upload-Length", "Upload-Expires", "Upload-Defer-Length", "Upload-Concat", "Upload-Location", "Hash-Algorithm", "Content-Type", "X-Forwarded-Authorization", "X-Forwarded-Client-IP", "X-Forwarded-Server-IP", "X-Forwarded-Server-Name", "X-Forwarded-Server-Role");

    public ProxyWorker(SchedulerApplication schedulerApplication) throws GeneralSecurityException {
        this.schedulerApplication = schedulerApplication;
        this.proxyConfiguration = schedulerApplication.getConfiguration().getProxy();
        this.client = DropwizardRestClientFactory.getClientWithWhitelistValidation((String)("Proxy-r" + UidUtils.getRandom()), this.proxyConfiguration.getWhitelistedCertFingerprints(), (AutomateApplication)schedulerApplication, (AutomateConfiguration)schedulerApplication.getConfiguration());
        this.proxyStorageService = new ProxyStorageService(schedulerApplication);
        this.tusFileUploadService = new TusFileUploadService(schedulerApplication).withUploadStorageDao(this.proxyStorageService).withUploadURI("/api/v1/scheduler/resources/dataset/[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}/upload").withThreadLocalCache(true).withUploadExpirationPeriod(schedulerApplication.getConfiguration().getExpireIdleUploadAfter());
        this.pingSemaphore = new Semaphore(1);
        Timer timer = new Timer(true);
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                ProxyWorker.this.run();
            }
        }, 0L, schedulerApplication.getConfiguration().getProxyPingInterval());
    }

    private void pingServer() {
        boolean authenticated = false;
        if (this.authToken == null) {
            SystemApiKeyAuthenticationSubmission systemApiKeyAuthenticationSubmission = new SystemApiKeyAuthenticationSubmission();
            systemApiKeyAuthenticationSubmission.setUsername("Proxy");
            systemApiKeyAuthenticationSubmission.setNonce(SecurityUtils.getSecureRandomSecret());
            String code = this.schedulerApplication.getBearerAuthenticator().getTokenFromApiSecret(systemApiKeyAuthenticationSubmission.getNonce());
            systemApiKeyAuthenticationSubmission.setCode(code);
            try {
                UserSession userSession = this.callApi("/v1/users/internalCode", "POST", systemApiKeyAuthenticationSubmission, new GenericType<UserSession>(){});
                this.authToken = userSession.getToken();
                authenticated = true;
                LOGGER.info("Successfully authenticated to Scheduler as " + userSession.getName());
            }
            catch (ServerException e) {
                LOGGER.error("Cannot authenticate to server", (Throwable)e);
                this.authToken = null;
            }
            if (this.authToken != null) {
                try {
                    this.automateVersion = this.callApi("/v1/version/automate", "GET", new GenericType<String>(){});
                    LOGGER.info("Proxy version: " + VersionResources.getVersion() + "; Automate version: " + this.automateVersion);
                }
                catch (ServerException e) {
                    LOGGER.error("Cannot get automate version", (Throwable)e);
                    this.authToken = null;
                }
            }
        }
        if (this.authToken != null) {
            try {
                Set<ApplicationFeatures> features = this.callApi("/v1/users/features", "GET", new GenericType<Set<ApplicationFeatures>>(){});
                StringBuilder featureString = new StringBuilder();
                for (ApplicationFeatures feature : features) {
                    if (featureString.length() > 0) {
                        featureString.append(", ");
                    }
                    featureString.append(feature);
                }
                if (authenticated) {
                    this.getHashesSettings();
                    LOGGER.info("Features: " + String.valueOf(featureString));
                    LOGGER.info("Hash Algorithms: " + this.schedulerApplication.getConfiguration().getUploadHashAlgorithms());
                }
            }
            catch (ServerException e) {
                LOGGER.error("Cannot get user features", (Throwable)e);
                this.authToken = null;
            }
        }
    }

    public void run() {
        boolean lockAvailable = this.pingSemaphore.tryAcquire();
        if (lockAvailable) {
            Thread pingServerThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        ProxyWorker.this.pingServer();
                    }
                    catch (Throwable t) {
                        LOGGER.error("ping error", t);
                    }
                }
            });
            pingServerThread.setDaemon(true);
            pingServerThread.setName("Proxy Worker - ping");
            pingServerThread.start();
            try {
                pingServerThread.join(this.schedulerApplication.getConfiguration().getEngineTimeout());
                if (pingServerThread.isAlive()) {
                    LOGGER.error("Ping did not complete");
                    LOGGER.warn("Stack trace:");
                    for (StackTraceElement stackTraceElement : pingServerThread.getStackTrace()) {
                        LOGGER.warn("\t" + stackTraceElement.toString());
                    }
                    LOGGER.warn("Interrupting");
                    pingServerThread.interrupt();
                    pingServerThread.join(this.schedulerApplication.getConfiguration().getServerTimeout());
                    if (pingServerThread.isAlive()) {
                        LOGGER.error("Ping thread did not interrupt");
                    }
                }
            }
            catch (InterruptedException e) {
                LOGGER.error("Cannot wait for ping thread to complete", (Throwable)e);
            }
            this.pingSemaphore.release();
        } else {
            LOGGER.warn("Ping lock not available");
        }
    }

    public Response callApi(HttpServletRequest request, String body, MultivaluedMap<String, String> form, UriInfo uriInfo) {
        return this.callApi(request, body, form, uriInfo, true);
    }

    public Response callApi(HttpServletRequest request, String body, MultivaluedMap<String, String> form, UriInfo uriInfo, boolean followRedirects) {
        Response response;
        if (this.authToken == null) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("schedulerNotAccessible")).build();
        }
        String proxyVersion = VersionResources.getVersion();
        if (!proxyVersion.equals(this.automateVersion)) {
            HashMap<String, String> values = new HashMap<String, String>();
            values.put("proxyVersion", proxyVersion);
            values.put("automateVersion", this.automateVersion);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("incompatibleSchedulerVersion", values)).build();
        }
        String url = this.proxyConfiguration.getBaseUrl() + request.getRequestURI();
        if (request.getQueryString() != null) {
            url = url + "?" + request.getQueryString();
        }
        WebTarget webTarget = this.client.target(url);
        String contentType = request.getContentType();
        Invocation.Builder invocationBuilder = contentType != null && !"text/plain".equals(contentType) ? webTarget.request(new String[]{contentType}) : webTarget.request();
        for (String headerName : this.passThroughHeaderNames) {
            String value = request.getHeader(headerName);
            if (value == null) continue;
            invocationBuilder.header(headerName, (Object)value);
        }
        invocationBuilder.header("X-Forwarded-Base-Uri", (Object)uriInfo.getBaseUri().toString().replace("/api/", ""));
        invocationBuilder.property("jersey.config.client.followRedirects", (Object)followRedirects);
        switch (request.getMethod()) {
            case "GET": {
                response = invocationBuilder.get();
                break;
            }
            case "HEAD": {
                response = invocationBuilder.head();
                break;
            }
            case "DELETE": {
                response = invocationBuilder.delete();
                break;
            }
            case "PUT": {
                response = invocationBuilder.put(Entity.json((Object)body));
                break;
            }
            case "POST": {
                if ("application/x-www-form-urlencoded".equals(contentType)) {
                    invocationBuilder = invocationBuilder.accept(new String[]{"*"});
                    response = invocationBuilder.post(Entity.form(form));
                    break;
                }
                if ("text/plain".equals(contentType)) {
                    response = invocationBuilder.post(Entity.text((Object)body));
                    break;
                }
                response = invocationBuilder.post(Entity.json((Object)body));
                break;
            }
            default: {
                response = invocationBuilder.method(request.getMethod(), Entity.json((Object)body));
            }
        }
        if (response.getStatus() != 304) {
            LOGGER.info("Response HTTP/" + response.getStatus());
        }
        return response;
    }

    public UploadInfo getUploadInfo(UploadId id) {
        UploadInfo uploadInfo = null;
        try {
            String uploadInfoSerialization = this.callApi("/v1/scheduler/resources/dataset/proxy/uploadInfoFromId", "POST", id.toString(), new GenericType<String>(){});
            uploadInfo = (UploadInfo)SerializationUtils.fromJson((String)uploadInfoSerialization, UploadInfo.class);
        }
        catch (ServerException e) {
            LOGGER.error("Cannot get upload info", (Throwable)e);
        }
        return uploadInfo;
    }

    private void getHashesSettings() {
        try {
            String hashSettings = this.callApi("/v1/scheduler/resources/dataset/proxy/setting/uploadHashAlgorithms", "GET", new GenericType<String>(){});
            this.schedulerApplication.getConfiguration().setUploadHashAlgorithms(hashSettings);
        }
        catch (ServerException e) {
            LOGGER.error("Cannot get hashes info", (Throwable)e);
        }
    }

    public void updateUploadInfo(UploadInfo uploadInfo) {
        UploadInfo copyUploadInfo = uploadInfo.clone();
        copyUploadInfo.setDigests(null);
        try {
            String string = this.callApi("/v1/scheduler/resources/dataset/proxy/uploadInfo", "PUT", copyUploadInfo, new GenericType<String>(){});
        }
        catch (ServerException e) {
            LOGGER.error("Cannot get upload info", (Throwable)e);
        }
    }

    public <ResponseType, RequestType> ResponseType callApi(String location, String method, RequestType requestData, GenericType<ResponseType> entityType) throws ServerException {
        TreeMap<String, String> additionalHeaders = new TreeMap<String, String>();
        return this.callApi(location, method, requestData, additionalHeaders, entityType);
    }

    public <ResponseType, RequestType> ResponseType callApi(String location, String method, RequestType requestData, Map<String, String> additionalHeaders, GenericType<ResponseType> entityType) throws ServerException {
        try {
            Response response;
            WebTarget webTarget = this.client.target(this.proxyConfiguration.getBaseUrl() + "/api" + location);
            Invocation.Builder invocationBuilder = webTarget.request(new String[]{"application/json"});
            if (this.authToken != null) {
                invocationBuilder = invocationBuilder.header("Authorization", (Object)("Bearer " + this.authToken));
            }
            for (String additionalHeader : additionalHeaders.keySet()) {
                invocationBuilder = invocationBuilder.header(additionalHeader, (Object)additionalHeaders.get(additionalHeader));
            }
            switch (method) {
                case "POST": {
                    response = invocationBuilder.post(Entity.json(requestData));
                    break;
                }
                case "PUT": {
                    response = invocationBuilder.put(Entity.json(requestData));
                    break;
                }
                default: {
                    throw new NotImplementedException("Method " + method + " not implemented in server API with body");
                }
            }
            if (!response.getStatusInfo().getFamily().equals((Object)Response.Status.Family.SUCCESSFUL)) {
                response.bufferEntity();
                String stringTitle = "";
                ResponseStatus responseStatus = new ResponseStatus();
                try {
                    responseStatus = (ResponseStatus)response.readEntity(ResponseStatus.class);
                    if (responseStatus.getMessage() == null || responseStatus.getCode() == 0) {
                        throw new IOException("Response is not ResponseStatusModel");
                    }
                    responseStatus.setRedirectUrl(null);
                }
                catch (Exception e) {
                    responseStatus.setMessage((String)response.readEntity(String.class));
                    responseStatus.setCode(500);
                }
                LOGGER.error(" /api" + location + " responded with HTTP/" + response.getStatus() + " " + responseStatus.getTitle() + " " + responseStatus.getMessage());
                throw new ServerException(responseStatus);
            }
            Object responseData = response.readEntity(entityType);
            return (ResponseType)responseData;
        }
        catch (ServerException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("Cannot query proxy, " + e.getMessage());
            throw new ServerException((ResponseStatus)new TranslationResponseStatus("cannotQueryModel", (Map)new HashMap<String, String>(){
                {
                    this.put("model", "proxy");
                    this.put("exception", e.getLocalizedMessage());
                }
            }));
        }
    }

    public <ResponseType, RequestType> ResponseType callApi(String location, String method, GenericType<ResponseType> entityType) throws ServerException {
        try {
            Response response;
            WebTarget webTarget = this.client.target(this.proxyConfiguration.getBaseUrl() + "/api" + location);
            Invocation.Builder invocationBuilder = webTarget.request(new String[]{"application/json"});
            if (this.authToken != null) {
                invocationBuilder = invocationBuilder.header("Authorization", (Object)("Bearer " + this.authToken));
            }
            switch (method) {
                case "GET": {
                    response = invocationBuilder.get();
                    break;
                }
                case "DELETE": {
                    response = invocationBuilder.delete();
                    break;
                }
                default: {
                    throw new NotImplementedException("Method " + method + " not implemented in server API without body");
                }
            }
            if (response.getStatus() == 401) {
                throw new ServerException((ResponseStatus)new TranslationResponseStatus("couldNotAuthenticateToEngineServer"));
            }
            if (response.getStatus() != 200) {
                response.bufferEntity();
                String stringTitle = "";
                ResponseStatus responseStatus = new ResponseStatus();
                try {
                    responseStatus = (ResponseStatus)response.readEntity(ResponseStatus.class);
                    if (responseStatus.getMessage() == null || responseStatus.getCode() == 0) {
                        throw new IOException("Response is not ResponseStatusModel");
                    }
                    responseStatus.setRedirectUrl(null);
                }
                catch (Exception e) {
                    responseStatus.setMessage((String)response.readEntity(String.class));
                    responseStatus.setCode(500);
                }
                LOGGER.error("proxy /api" + location + " responded with HTTP/" + response.getStatus() + " " + responseStatus.getTitle() + " " + responseStatus.getMessage());
                throw new ServerException(responseStatus);
            }
            Object responseData = response.readEntity(entityType);
            return (ResponseType)responseData;
        }
        catch (ServerException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("Cannot query proxy , " + e.getMessage());
            throw new ServerException((ResponseStatus)new TranslationResponseStatus("cannotQueryModel", (Map)new HashMap<String, String>(){
                {
                    this.put("model", "proxy");
                    this.put("exception", e.getLocalizedMessage());
                }
            }));
        }
    }

    public void processDataSetRequest(String datasetId, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String username = this.getUsernameAllowedDataset(datasetId, request);
        if (username == null) {
            response.setStatus(401);
            response.flushBuffer();
        } else {
            this.tusFileUploadService.process(request, response, username);
        }
    }

    public String getUsernameAllowedDataset(String datasetId, HttpServletRequest request) {
        Response authResponse;
        WebTarget webTarget = this.client.target(this.proxyConfiguration.getBaseUrl() + "/api/v1/scheduler/resources/dataset/proxy/dataset/" + datasetId);
        Invocation.Builder invocationBuilder = webTarget.request(new String[]{"application/json"});
        if (this.authToken != null) {
            invocationBuilder = invocationBuilder.header("Authorization", (Object)request.getHeader("Authorization"));
        }
        if ((authResponse = invocationBuilder.get()).getStatus() == 200) {
            return (String)authResponse.readEntity(String.class);
        }
        return null;
    }

    public String getAuthToken() {
        return this.authToken;
    }

    public ProxyStorageService getProxyStorageService() {
        return this.proxyStorageService;
    }
}

