/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.workers;

import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.security.bearer.OfflineBearerUser;
import com.nuix.automate.scheduler.security.bearer.OfflineUser;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.LocalizableEnumUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.client.Client;
import com.nuix.automate.utils.models.api.client.Matter;
import com.nuix.automate.utils.models.api.dataset.DataRepository;
import com.nuix.automate.utils.models.api.dataset.Dataset;
import com.nuix.automate.utils.models.api.job.Parameter;
import com.nuix.automate.utils.models.api.legalhold.LegalHold;
import com.nuix.automate.utils.models.api.legalhold.LegalHoldParticipation;
import com.nuix.automate.utils.models.api.schedule.EventFilter;
import com.nuix.automate.utils.models.api.schedule.EventTrigger;
import com.nuix.automate.utils.models.api.schedule.Frequency;
import com.nuix.automate.utils.models.api.schedule.Run;
import com.nuix.automate.utils.models.api.schedule.Schedule;
import com.nuix.automate.utils.models.api.schedule.SubmissionMechanism;
import com.nuix.automate.utils.models.api.user.UserAccount;
import com.nuix.automate.utils.models.api.workflowlibrary.Workflow;
import com.nuix.automate.utils.models.api.workflowlibrary.WorkflowLibrary;
import com.nuix.automate.utils.models.internal.dataset.DatasetEvent;
import com.nuix.automate.utils.models.internal.event.EventType;
import com.nuix.automate.utils.models.internal.job.JobDetailsModel;
import com.nuix.automate.utils.models.internal.job.JobEvent;
import com.nuix.automate.utils.models.internal.job.JobModel;
import com.nuix.automate.utils.models.internal.legalhold.LegalHoldEvent;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.LegalHoldCustodian;
import com.nuix.automate.utils.workflow.ScheduleEvent;
import java.time.DayOfWeek;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.ws.rs.core.Response;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class ScheduleWorker
extends TimerTask {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ScheduleWorker.class);
    private InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");
    private SchedulerApplication schedulerApplication;
    private Timer timer;
    private int lastMinuteOfDay = -1;

    public ScheduleWorker(SchedulerApplication schedulerApplication) {
        this.schedulerApplication = schedulerApplication;
        this.timer = new Timer(true);
        this.timer.schedule((TimerTask)this, 0L, schedulerApplication.getConfiguration().getJobWorkerInterval());
    }

    private void handleStagingSchedule(DateTime currentDate, Schedule schedule) {
        long timePassed;
        Run lastRun;
        Long lastRunDate = null;
        ArrayList<Run> runs = new ArrayList<Run>();
        runs.addAll(this.schedulerApplication.getJobsDao().getScheduleRuns(schedule.getId()));
        if (runs.size() > 0 && schedule.getScheduleTrigger().getFrequency().equals((Object)Frequency.ONE_TIME)) {
            return;
        }
        runs.sort(Comparator.comparing(Run::getCreatedDate).reversed());
        if (runs.size() > 0 && (lastRun = (Run)runs.get(0)).getJobId() == null && ExecutionState.ERROR.equals((Object)lastRun.getJobState()) && (timePassed = currentDate.getMillis() - lastRun.getCreatedDate()) > 0L && timePassed < this.schedulerApplication.getConfiguration().getScheduleSystemErrorBackoff()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Schedule " + schedule.getId() + " encountered system errors, backing off for " + this.schedulerApplication.getConfiguration().getScheduleSystemErrorBackoff() + " ms");
            }
            return;
        }
        JobDetailsModel lastJob = null;
        for (Run run : runs) {
            lastJob = this.schedulerApplication.getJobResource().getJobDetailsModel(run.getJobId(), 0);
            lastRunDate = run.getDate();
            if (lastJob == null) {
                lastJob = this.schedulerApplication.getJobsArchiveDao().getJobDetails(run.getJobId());
            }
            if (lastJob == null) continue;
            break;
        }
        long nextScheduleRunDate = schedule.getScheduleTrigger().getStartDate();
        if (lastRunDate == null) {
            lastRunDate = nextScheduleRunDate;
        }
        if (lastJob != null) {
            if (lastJob.getSettings().getInStaging() && lastJob.getSettings().getExecutionState().equals((Object)ExecutionState.NOT_STARTED)) {
                return;
            }
            switch (schedule.getScheduleTrigger().getFrequency()) {
                case ONE_TIME: {
                    return;
                }
                case HOURLY: {
                    while (nextScheduleRunDate < lastRunDate) {
                        nextScheduleRunDate += 3600000L;
                    }
                    for (int i = 1; i < 10000 && (nextScheduleRunDate += 3600000L * schedule.getScheduleTrigger().getRecurEvery()) <= currentDate.getMillis(); ++i) {
                    }
                    if (nextScheduleRunDate != lastRunDate) break;
                    LOGGER.warn("Schedule missed too many events, setting run date to current");
                    nextScheduleRunDate = currentDate.getMillis();
                    break;
                }
                case DAILY: {
                    while (nextScheduleRunDate < lastRunDate) {
                        nextScheduleRunDate += 86400000L;
                    }
                    for (int i = 1; i < 10000 && (nextScheduleRunDate += 86400000L * schedule.getScheduleTrigger().getRecurEvery()) <= currentDate.getMillis(); ++i) {
                    }
                    if (nextScheduleRunDate != lastRunDate) break;
                    LOGGER.warn("Schedule missed too many events, setting run date to current");
                    nextScheduleRunDate = currentDate.getMillis();
                    break;
                }
                case WEEKLY: {
                    while (nextScheduleRunDate < lastRunDate) {
                        nextScheduleRunDate += 86400000L;
                    }
                    for (int i = 0; i < 10000; ++i) {
                        long nextWeekScheduleRunDate = nextScheduleRunDate + (long)i * 1000L * 3600L * 24L * 7L * schedule.getScheduleTrigger().getRecurEvery();
                        boolean match = false;
                        for (int dayDelta = 1; dayDelta <= 7; ++dayDelta) {
                            long dayNextScheduleRunDate = nextWeekScheduleRunDate + 86400000L * (long)dayDelta;
                            if (dayNextScheduleRunDate > currentDate.getMillis()) {
                                DateTime tentativeDate = new DateTime(dayNextScheduleRunDate);
                                for (DayOfWeek dayOfWeek : schedule.getScheduleTrigger().getRecurOnDays()) {
                                    if (tentativeDate.getDayOfWeek() != dayOfWeek.getValue()) continue;
                                    nextScheduleRunDate = dayNextScheduleRunDate;
                                    match = true;
                                    break;
                                }
                                if (match) break;
                            }
                            if (match) break;
                        }
                        if (match) break;
                    }
                    if (nextScheduleRunDate != lastRunDate) break;
                    LOGGER.warn("Schedule missed too many events, setting run date to current");
                    nextScheduleRunDate = currentDate.getMillis();
                }
            }
        }
        if (this.schedulerApplication.getJobResource().getStagingJobsFromSchedule(schedule.getId()) == 0L) {
            this.stageJobFromTimeTrigger(schedule, nextScheduleRunDate);
        }
    }

    private void handleRegularScheduler(DateTime currentDate, Schedule schedule) {
        DateTime startDate = new DateTime((Object)schedule.getScheduleTrigger().getStartDate());
        long currentDay = currentDate.getDayOfYear() + currentDate.getYear() * 365;
        long startDay = startDate.getDayOfYear() + startDate.getYear() * 365;
        long daysPast = currentDay - startDay;
        long daysReminder = daysPast % schedule.getScheduleTrigger().getRecurEvery();
        long weeksDayCount = daysPast % (7L * schedule.getScheduleTrigger().getRecurEvery());
        long hoursPast = (long)(currentDate.getHourOfDay() - startDate.getHourOfDay()) + daysPast * 24L;
        long hoursReminder = hoursPast % schedule.getScheduleTrigger().getRecurEvery();
        switch (schedule.getScheduleTrigger().getFrequency()) {
            case ONE_TIME: {
                if (startDate.getYear() == currentDate.getYear() && startDate.getDayOfYear() == currentDate.getDayOfYear() && startDate.getMinuteOfDay() == currentDate.getMinuteOfDay()) break;
                return;
            }
            case HOURLY: {
                if (currentDate.getMillis() < startDate.getMillis()) {
                    return;
                }
                if (hoursReminder != 0L) {
                    return;
                }
                if (startDate.getMinuteOfHour() == currentDate.getMinuteOfHour()) break;
                return;
            }
            case DAILY: {
                if (currentDate.getMillis() < startDate.getMillis()) {
                    return;
                }
                if (daysReminder != 0L) {
                    return;
                }
                if (startDate.getMinuteOfDay() == currentDate.getMinuteOfDay()) break;
                return;
            }
            case WEEKLY: {
                if (currentDate.getMillis() < startDate.getMillis()) {
                    return;
                }
                if (weeksDayCount >= 7L) {
                    return;
                }
                if (startDate.getMinuteOfDay() != currentDate.getMinuteOfDay()) {
                    return;
                }
                boolean daySelected = false;
                for (DayOfWeek dayOfWeek : schedule.getScheduleTrigger().getRecurOnDays()) {
                    if (dayOfWeek.getValue() != currentDate.getDayOfWeek()) continue;
                    daySelected = true;
                    break;
                }
                if (daySelected) break;
                return;
            }
        }
        LOGGER.info(String.valueOf(schedule) + " matches time trigger " + currentDate.getMillis());
        this.queueJobFromTimeTrigger(schedule);
    }

    private synchronized void evaluateTimeEvent(DateTime currentDate) {
        int minuteOfDay = currentDate.getMinuteOfDay();
        boolean newMinuteOfDay = this.lastMinuteOfDay != minuteOfDay;
        this.lastMinuteOfDay = minuteOfDay;
        for (Schedule schedule : this.schedulerApplication.getScheduleResource().getSchedules()) {
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Testing " + String.valueOf(schedule));
                }
                if (!this.scheduleConditionsMet(schedule) || schedule.getScheduleTrigger() == null) continue;
                if (schedule.getScheduleTrigger().getAddNextJobToStaging()) {
                    this.handleStagingSchedule(currentDate, schedule);
                    continue;
                }
                if (!newMinuteOfDay) continue;
                this.handleRegularScheduler(currentDate, schedule);
            }
            catch (Exception e) {
                LOGGER.error("Cannot evaluate " + String.valueOf(schedule) + " for timer " + currentDate.getMillis(), (Throwable)e);
            }
        }
    }

    public boolean scheduleConditionsMet(Schedule schedule) {
        if (!Boolean.TRUE.equals(schedule.getEnabled())) {
            return false;
        }
        if (schedule.getConditions() != null) {
            long queuedCount;
            if (schedule.getConditions().getExpireAfter() != null && DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis() > schedule.getConditions().getExpireAfter()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.valueOf(schedule) + " expired");
                }
                return false;
            }
            if (schedule.getConditions().getCommenceAfter() != null && DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis() < schedule.getConditions().getCommenceAfter()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.valueOf(schedule) + " not yet commenced");
                }
                return false;
            }
            if (schedule.getConditions().getSkipIfJobsQueued() != null && (queuedCount = this.schedulerApplication.getJobResource().getBacklogJobsFromSchedule(schedule.getId())) >= schedule.getConditions().getSkipIfJobsQueued()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.valueOf(schedule) + " skipping because " + queuedCount + " jobs already queued");
                }
                return false;
            }
            if (schedule.getConditions().getSkipIfJobsRunning() != null && (queuedCount = this.schedulerApplication.getJobResource().getRunningJobsFromSchedule(schedule.getId())) >= schedule.getConditions().getSkipIfJobsRunning()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.valueOf(schedule) + " skipping because " + queuedCount + " jobs already running");
                }
                return false;
            }
        }
        return true;
    }

    public void triggerJobEvent(JobDetailsModel jobDetailsModel, JobEvent event) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Evaluating event " + String.valueOf(event) + " on " + String.valueOf(jobDetailsModel));
        }
        for (Schedule schedule : this.schedulerApplication.getScheduleResource().getSchedules()) {
            try {
                long queuedCount;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Testing " + String.valueOf(schedule));
                }
                if (!this.scheduleConditionsMet(schedule) || schedule.getEventTrigger() == null) continue;
                if (schedule.getEventTrigger().getJobEvents() == null || !schedule.getEventTrigger().getJobEvents().contains(event)) {
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug(String.valueOf(schedule) + " does not apply to event " + String.valueOf(event));
                    continue;
                }
                if (schedule.getEventTrigger().getTriggerFilter() != null) {
                    String jobName;
                    String jobNotes;
                    String errorText;
                    EventFilter filter = schedule.getEventTrigger().getTriggerFilter();
                    Client client = null;
                    Matter matter = null;
                    String matterId = jobDetailsModel.getSettings().getMatterId();
                    if (matterId != null && (matter = this.schedulerApplication.getClientResource().getMatter(matterId)) != null) {
                        client = this.schedulerApplication.getClientResource().getClient(matter.getClientId());
                    }
                    if (!(filter.getClientNameContains() == null || client != null && client.getName().contains(filter.getClientNameContains()))) {
                        if (!LOGGER.isDebugEnabled()) continue;
                        LOGGER.debug(String.valueOf(schedule) + " does not apply to client " + String.valueOf(client));
                        continue;
                    }
                    if (!(filter.getMatterNameContains() == null || matter != null && matter.getName().contains(filter.getMatterNameContains()))) {
                        if (!LOGGER.isDebugEnabled()) continue;
                        LOGGER.debug(String.valueOf(schedule) + " does not apply to matter " + String.valueOf(matter));
                        continue;
                    }
                    WorkflowLibrary workflowLibrary = null;
                    Workflow workflow = null;
                    String workflowId = jobDetailsModel.getSettings().getLibraryWorkflowId();
                    if (workflowId != null && (workflow = this.schedulerApplication.getLibraryResource().getLibraryWorkflow(workflowId)) != null) {
                        workflowLibrary = this.schedulerApplication.getLibraryResource().getWorkflowLibrary(workflow.getLibraryId());
                    }
                    if (!(filter.getLibraryNameContains() == null || workflowLibrary != null && workflowLibrary.getName().contains(filter.getLibraryNameContains()))) {
                        if (!LOGGER.isDebugEnabled()) continue;
                        LOGGER.debug(String.valueOf(schedule) + " does not apply to library " + String.valueOf(workflowLibrary));
                        continue;
                    }
                    if (!(filter.getWorkflowNameContains() == null || workflow != null && workflow.getName().contains(filter.getWorkflowNameContains()))) {
                        if (!LOGGER.isDebugEnabled()) continue;
                        LOGGER.debug(String.valueOf(schedule) + " does not apply to workflow " + String.valueOf(workflow));
                        continue;
                    }
                    if (filter.getErrorTextContains() != null && !(errorText = jobDetailsModel.getSettings().getError()).contains(filter.getErrorTextContains())) {
                        if (!LOGGER.isDebugEnabled()) continue;
                        LOGGER.debug(String.valueOf(schedule) + " does not apply to error " + errorText);
                        continue;
                    }
                    if (!(filter.getJobDescriptionContains() == null || (jobNotes = jobDetailsModel.getSettings().getNotes()) != null && jobNotes.contains(filter.getJobDescriptionContains()))) {
                        if (!LOGGER.isDebugEnabled()) continue;
                        LOGGER.debug(String.valueOf(schedule) + " does not apply to job description");
                        continue;
                    }
                    if (!(filter.getJobNameContains() == null || (jobName = jobDetailsModel.getSettings().getName()) != null && jobName.contains(filter.getJobNameContains()))) {
                        if (!LOGGER.isDebugEnabled()) continue;
                        LOGGER.debug(String.valueOf(schedule) + " does not apply to job name");
                        continue;
                    }
                    if (filter.getPriorityAnyOf() != null && !filter.getPriorityAnyOf().contains(jobDetailsModel.getSettings().getPriority())) {
                        if (!LOGGER.isDebugEnabled()) continue;
                        LOGGER.debug(String.valueOf(schedule) + " does not apply to priority " + String.valueOf(jobDetailsModel.getSettings().getPriority()));
                        continue;
                    }
                    if (filter.getSubmissionMechanisms() != null) {
                        SubmissionMechanism submissionMechanism = jobDetailsModel.getSettings().getScheduleId() == null ? SubmissionMechanism.QUEUED : SubmissionMechanism.SCHEDULED;
                        if (!filter.getSubmissionMechanisms().contains(submissionMechanism)) {
                            if (!LOGGER.isDebugEnabled()) continue;
                            LOGGER.debug(String.valueOf(schedule) + " does not apply to mechanism " + String.valueOf(submissionMechanism));
                            continue;
                        }
                    }
                }
                if (!this.scheduleConditionsMet(schedule)) continue;
                if (jobDetailsModel.getSettings().getScheduleId() != null && jobDetailsModel.getSettings().getScheduleId().equals(schedule.getId()) && (queuedCount = this.schedulerApplication.getJobResource().getBacklogJobsFromSchedule(schedule.getId())) >= this.schedulerApplication.getConfiguration().getJobSchedulingLoopDetection()) {
                    LOGGER.error(String.valueOf(schedule) + " skipping because " + queuedCount + " jobs already queued from the same schedule - potential loop");
                    continue;
                }
                LOGGER.info(String.valueOf(schedule) + " matches " + String.valueOf(jobDetailsModel));
                this.queueJobFromEventTrigger(schedule, jobDetailsModel.getSettings(), event);
            }
            catch (Exception e) {
                LOGGER.error("Cannot evaluate " + String.valueOf(schedule) + " for " + String.valueOf(event) + " on " + String.valueOf(jobDetailsModel), (Throwable)e);
            }
        }
    }

    public void triggerDatasetEvent(Dataset dataset, DatasetEvent event) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Evaluating event " + String.valueOf(event) + " on " + String.valueOf(dataset));
        }
        for (Schedule schedule : this.schedulerApplication.getScheduleResource().getSchedules()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Testing " + String.valueOf(schedule));
            }
            if (!this.scheduleConditionsMet(schedule)) continue;
            EventTrigger eventTrigger = schedule.getEventTrigger();
            if (eventTrigger == null || eventTrigger.getDatasetEvents() == null || !eventTrigger.getDatasetEvents().contains(event)) {
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug(String.valueOf(schedule) + " does not apply to event " + String.valueOf(event));
                continue;
            }
            EventFilter filter = eventTrigger.getTriggerFilter();
            if (filter != null) {
                Client client;
                DataRepository dataRepository = this.schedulerApplication.getDataRepositoryResource().getDataRepository(dataset.getDataRepositoryId());
                Matter matter = this.schedulerApplication.getClientResource().getMatter(dataset.getMatterId());
                if (matter == null || dataRepository == null) {
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug(String.valueOf(schedule) + " does not apply to null matter or data repository");
                    continue;
                }
                String datasetNameContains = filter.getDatasetNameContains();
                if (datasetNameContains != null && !dataset.getName().contains(datasetNameContains)) {
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug(String.valueOf(schedule) + " does not apply to dataset " + String.valueOf(dataset));
                    continue;
                }
                String matterNameContains = filter.getMatterNameContains();
                if (matterNameContains != null && !matter.getName().contains(matterNameContains)) {
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug(String.valueOf(schedule) + " does not apply to matter " + String.valueOf(matter));
                    continue;
                }
                String dataRepositoryNameContains = filter.getDataRepositoryNameContains();
                if (dataRepositoryNameContains != null && !dataRepository.getName().contains(dataRepositoryNameContains)) {
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug(String.valueOf(schedule) + " does not apply to data repository " + String.valueOf(dataRepository));
                    continue;
                }
                String clientNameContains = filter.getClientNameContains();
                if (!(clientNameContains == null || (client = this.schedulerApplication.getClientResource().getClient(matter.getClientId())) != null && client.getName().contains(clientNameContains))) {
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug(String.valueOf(schedule) + " does not apply to client " + String.valueOf(client));
                    continue;
                }
            }
            LOGGER.info(String.valueOf(schedule) + " matches " + String.valueOf(dataset));
            this.queueJobFromDatasetEventTrigger(schedule, dataset, event);
        }
    }

    public void triggerLegalHoldEvent(LegalHoldEvent event, LegalHold legalHold, List<LegalHoldParticipation> affectedCustodians) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Evaluating event " + String.valueOf(event) + " on " + String.valueOf(legalHold));
        }
        for (Schedule schedule : this.schedulerApplication.getScheduleResource().getSchedules()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Testing " + String.valueOf(schedule));
            }
            if (!this.scheduleConditionsMet(schedule)) continue;
            EventTrigger eventTrigger = schedule.getEventTrigger();
            if (eventTrigger == null || eventTrigger.getLegalHoldEvents() == null || !eventTrigger.getLegalHoldEvents().contains(event)) {
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug(String.valueOf(schedule) + " does not apply to event " + String.valueOf(event));
                continue;
            }
            EventFilter filter = eventTrigger.getTriggerFilter();
            if (filter != null) {
                Client client;
                String legalHoldNameContains = filter.getLegalHoldNameContains();
                if (legalHoldNameContains != null && !legalHold.getName().contains(legalHoldNameContains)) {
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug(String.valueOf(schedule) + " does not apply to legal hold " + String.valueOf(legalHold));
                    continue;
                }
                String legalHoldDescriptionContains = filter.getLegalHoldDescriptionContains();
                if (legalHoldDescriptionContains != null && legalHold.getDescription() != null && legalHold.getDescription().contains(legalHoldDescriptionContains)) {
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug(String.valueOf(schedule) + " does not apply to legal hold " + String.valueOf(legalHold));
                    continue;
                }
                Matter matter = this.schedulerApplication.getClientResource().getMatter(legalHold.getMatterId());
                String matterNameContains = filter.getMatterNameContains();
                if (!(matterNameContains == null || matter != null && matter.getName().contains(matterNameContains))) {
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug(String.valueOf(schedule) + " does not apply to matter " + String.valueOf(matter));
                    continue;
                }
                String clientNameContains = filter.getClientNameContains();
                if (!(matter == null || clientNameContains == null || (client = this.schedulerApplication.getClientResource().getClient(matter.getClientId())) != null && client.getName().contains(clientNameContains))) {
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug(String.valueOf(schedule) + " does not apply to client " + String.valueOf(client));
                    continue;
                }
            }
            LOGGER.info(String.valueOf(schedule) + " matches " + String.valueOf(legalHold));
            this.queueJobFromLegalHoldEventTrigger(schedule, event, legalHold, affectedCustodians);
        }
    }

    private void stageJobFromTimeTrigger(Schedule schedule, long runDate) {
        JobModel queueJob = new JobModel();
        Run run = new Run();
        run.setCreatedDate(Long.valueOf(DateTime.now().getMillis()));
        try {
            queueJob.setScheduleId(schedule.getId());
            queueJob.setName(schedule.getName());
            queueJob.setNotes(schedule.getDescription());
            queueJob.setMatterId(schedule.getMatterId());
            queueJob.setLibraryWorkflowId(schedule.getLibraryWorkflowId());
            queueJob.setSessionParameters(schedule.getSessionParameters());
            queueJob.setPriority(schedule.getPriority());
            queueJob.setResourcePoolId(schedule.getResourcePoolId());
            queueJob.setExecutionProfileId(schedule.getExecutionProfileId());
            queueJob.setAutoSubmitOnDate(Long.valueOf(runDate));
            queueJob.setInStaging(true);
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.TRIGGERS_STANDARD);
        }
        catch (Exception e) {
            LOGGER.error("Cannot queue job from schedule", (Throwable)e);
            run.setJobState(ExecutionState.ERROR);
            run.setError((Object)ExceptionUtils.getExceptionPrintableMessage((Throwable)e));
        }
        String description = this.iu.getString("ScheduleResource.SubmissionDescriptionTimer");
        run.setTriggerDescription(description);
        this.queueScheduleRun(schedule, queueJob, run, runDate);
    }

    private void queueJobFromTimeTrigger(Schedule schedule) {
        JobModel queueJob = new JobModel();
        Run run = new Run();
        run.setCreatedDate(Long.valueOf(DateTime.now().getMillis()));
        try {
            queueJob.setScheduleId(schedule.getId());
            queueJob.setName(schedule.getName());
            queueJob.setNotes(schedule.getDescription());
            queueJob.setMatterId(schedule.getMatterId());
            queueJob.setLibraryWorkflowId(schedule.getLibraryWorkflowId());
            queueJob.setSessionParameters(schedule.getSessionParameters());
            queueJob.setPriority(schedule.getPriority());
            queueJob.setResourcePoolId(schedule.getResourcePoolId());
            queueJob.setExecutionProfileId(schedule.getExecutionProfileId());
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.TRIGGERS_STANDARD);
        }
        catch (Exception e) {
            LOGGER.error("Cannot queue job from schedule", (Throwable)e);
            run.setJobState(ExecutionState.ERROR);
            run.setError((Object)ExceptionUtils.getExceptionPrintableMessage((Throwable)e));
        }
        String description = this.iu.getString("ScheduleResource.SubmissionDescriptionTimer");
        run.setTriggerDescription(description);
        long runDate = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
        this.queueScheduleRun(schedule, queueJob, run, runDate);
    }

    private void queueJobFromEventTrigger(Schedule schedule, JobModel triggeringJob, JobEvent event) {
        JobModel queueJob = new JobModel();
        Run run = new Run();
        run.setCreatedDate(Long.valueOf(DateTime.now().getMillis()));
        try {
            queueJob.setScheduleId(schedule.getId());
            queueJob.setName(schedule.getName());
            queueJob.setNotes(schedule.getDescription());
            if (schedule.getSameMatterAsTriggerMatter() != null && schedule.getSameMatterAsTriggerMatter().booleanValue()) {
                queueJob.setMatterId(triggeringJob.getMatterId());
            } else {
                queueJob.setMatterId(schedule.getMatterId());
            }
            if (schedule.getSameWorkflowTemplateAsTriggerMatter() != null && schedule.getSameWorkflowTemplateAsTriggerMatter().booleanValue()) {
                queueJob.setLibraryWorkflowId(triggeringJob.getLibraryWorkflowId());
                queueJob.setSessionParameters(triggeringJob.getSessionParameters());
            } else {
                queueJob.setLibraryWorkflowId(schedule.getLibraryWorkflowId());
                queueJob.setSessionParameters(schedule.getSessionParameters());
            }
            if (queueJob.getSessionParameters() == null) {
                queueJob.setSessionParameters(new ArrayList());
            }
            queueJob.getSessionParameters().removeIf(parameterModel -> parameterModel.getName().equals("{triggering_job_id}"));
            queueJob.getSessionParameters().add(new Parameter("{triggering_job_id}", triggeringJob.getId()));
            if (schedule.getSamePriorityAsTriggerMatter() != null && schedule.getSamePriorityAsTriggerMatter().booleanValue()) {
                queueJob.setPriority(triggeringJob.getPriority());
            } else {
                queueJob.setPriority(schedule.getPriority());
            }
            if (schedule.getSameResourcePoolIdAsTriggerMatter() != null && schedule.getSameResourcePoolIdAsTriggerMatter().booleanValue()) {
                queueJob.setResourcePoolId(triggeringJob.getResourcePoolId());
            } else {
                queueJob.setResourcePoolId(schedule.getResourcePoolId());
            }
            if (schedule.getSameExecutionProfileAsTriggerMatter() != null && schedule.getSameExecutionProfileAsTriggerMatter().booleanValue()) {
                queueJob.setExecutionProfileId(triggeringJob.getExecutionProfileId());
            } else {
                queueJob.setExecutionProfileId(schedule.getExecutionProfileId());
            }
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.TRIGGERS_ADVANCED);
        }
        catch (Exception e) {
            LOGGER.error("Cannot queue job from schedule", (Throwable)e);
            run.setJobState(ExecutionState.ERROR);
            run.setError((Object)ExceptionUtils.getExceptionPrintableMessage((Throwable)e));
        }
        String description = this.iu.getFormattedString("ScheduleResource.SubmissionDescriptionEvent", (Object[])new String[]{LocalizableEnumUtils.getLocalizedString((String)"SchedulerText", (Enum)event), triggeringJob.getName()});
        run.setTriggerDescription(description);
        long runDate = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
        this.queueScheduleRun(schedule, queueJob, run, runDate);
    }

    private void queueJobFromDatasetEventTrigger(Schedule schedule, Dataset dataset, DatasetEvent event) {
        JobModel queueJob = new JobModel();
        Run run = new Run();
        run.setCreatedDate(Long.valueOf(DateTime.now().getMillis()));
        try {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.TRIGGERS_ADVANCED);
            queueJob.setScheduleId(schedule.getId());
            queueJob.setName(schedule.getName());
            queueJob.setNotes(schedule.getDescription());
            if (Boolean.TRUE.equals(schedule.getSameMatterAsTriggerMatter())) {
                queueJob.setMatterId(dataset.getMatterId());
            } else {
                queueJob.setMatterId(schedule.getMatterId());
            }
            queueJob.setLibraryWorkflowId(schedule.getLibraryWorkflowId());
            ArrayList<Parameter> normalizedParameters = new ArrayList<Parameter>();
            for (Parameter parameterModel : schedule.getSessionParameters()) {
                if (parameterModel.getValue().equals("SAME_AS_TRIGGERING_DATASET")) {
                    Parameter datasetParameterModel = new Parameter(parameterModel);
                    datasetParameterModel.setValue(dataset.getId());
                    normalizedParameters.add(datasetParameterModel);
                    continue;
                }
                normalizedParameters.add(parameterModel);
            }
            queueJob.setSessionParameters(normalizedParameters);
            queueJob.setPriority(schedule.getPriority());
            queueJob.setResourcePoolId(schedule.getResourcePoolId());
            queueJob.setExecutionProfileId(schedule.getExecutionProfileId());
        }
        catch (Exception e) {
            LOGGER.error("Cannot queue job from schedule", (Throwable)e);
            run.setJobState(ExecutionState.ERROR);
            run.setError((Object)ExceptionUtils.getExceptionPrintableMessage((Throwable)e));
        }
        run.setTriggerDescription(this.iu.getFormattedString("ScheduleResource.SubmissionDescriptionEvent", (Object[])new String[]{LocalizableEnumUtils.getLocalizedString((String)"SchedulerText", (Enum)event), dataset.getName()}));
        long runDate = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
        this.queueScheduleRun(schedule, queueJob, run, runDate);
    }

    private void queueJobFromLegalHoldEventTrigger(Schedule schedule, LegalHoldEvent event, LegalHold legalHold, List<LegalHoldParticipation> affectedCustodians) {
        JobModel queueJob = new JobModel();
        Run run = new Run();
        run.setCreatedDate(Long.valueOf(DateTime.now().getMillis()));
        try {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.LEGAL_HOLD);
            queueJob.setScheduleId(schedule.getId());
            queueJob.setName(schedule.getName());
            queueJob.setNotes(schedule.getDescription());
            if (schedule.getSameMatterAsTriggerMatter() == Boolean.TRUE) {
                queueJob.setMatterId(legalHold.getMatterId());
            } else {
                queueJob.setMatterId(schedule.getMatterId());
            }
            queueJob.setLibraryWorkflowId(schedule.getLibraryWorkflowId());
            ArrayList<Parameter> normalizedParameters = new ArrayList<Parameter>();
            for (Parameter parameterModel : schedule.getSessionParameters()) {
                if (parameterModel.getValue().equals("SAME_AS_TRIGGERING_LEGAL_HOLD")) {
                    Parameter legalHoldParameterModel = new Parameter(parameterModel);
                    legalHoldParameterModel.setValue(legalHold.getId());
                    normalizedParameters.add(legalHoldParameterModel);
                    continue;
                }
                normalizedParameters.add(parameterModel);
            }
            queueJob.setSessionParameters(normalizedParameters);
            queueJob.setPriority(schedule.getPriority());
            queueJob.setResourcePoolId(schedule.getResourcePoolId());
            queueJob.setExecutionProfileId(schedule.getExecutionProfileId());
            ScheduleEvent legalHoldScheduleEvent = new ScheduleEvent(event.toString(), legalHold.getId(), legalHold.getName());
            if (affectedCustodians != null) {
                for (LegalHoldParticipation custodianParticipation : affectedCustodians) {
                    LegalHoldCustodian legalHoldCustodian = new LegalHoldCustodian();
                    legalHoldCustodian.setUserId(custodianParticipation.getUserId());
                    legalHoldCustodian.setStatus(custodianParticipation.getCustodianState().toString());
                    legalHoldCustodian.setHoldIssuedDate(custodianParticipation.getHoldIssuedDate());
                    legalHoldCustodian.setHoldReleasedDate(custodianParticipation.getHoldReleasedDate());
                    UserAccount custodianUserAccount = this.schedulerApplication.getUserServiceResource().getUser(custodianParticipation.getUserId());
                    if (custodianUserAccount != null) {
                        legalHoldCustodian.setName(custodianUserAccount.getName());
                        legalHoldCustodian.setEmail(custodianUserAccount.getEmail());
                        legalHoldCustodian.setPlatform(custodianUserAccount.getPlatform().toString());
                        legalHoldCustodian.setPlatformId(custodianUserAccount.getUserServiceId());
                        legalHoldCustodian.setAttributes(custodianUserAccount.getAttributes());
                    }
                    legalHoldScheduleEvent.getCustodians().add(legalHoldCustodian);
                }
            }
            queueJob.setScheduleEvent(legalHoldScheduleEvent);
        }
        catch (Exception e) {
            LOGGER.error("Cannot queue job from schedule", (Throwable)e);
            run.setJobState(ExecutionState.ERROR);
            run.setError((Object)ExceptionUtils.getExceptionPrintableMessage((Throwable)e));
        }
        run.setTriggerDescription(this.iu.getFormattedString("ScheduleResource.SubmissionDescriptionEvent", (Object[])new String[]{LocalizableEnumUtils.getLocalizedString((String)"SchedulerText", (Enum)event), legalHold.getName()}));
        long runDate = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
        this.queueScheduleRun(schedule, queueJob, run, runDate);
    }

    private void queueScheduleRun(Schedule schedule, JobModel queueJob, Run run, long runDate) {
        LOGGER.info(String.valueOf(schedule) + " queuing job");
        if (run.getJobState() != ExecutionState.ERROR) {
            try {
                if (schedule.getLastModifiedByUserId() == null) {
                    throw new IllegalStateException("Schedule is missing lastModifiedByUserId property");
                }
                OfflineUser offlineUser = this.schedulerApplication.getSecurityDao().getOfflineUser(schedule.getLastModifiedByUserId());
                OfflineBearerUser offlineBearerUser = new OfflineBearerUser(offlineUser);
                Response response = this.schedulerApplication.getJobResource().addProcessingJob(offlineBearerUser, null, null, queueJob);
                if (response.getStatus() != 200) {
                    LOGGER.error("Cannot queue job from schedule, " + String.valueOf(response));
                    queueJob.setId(null);
                    run.setJobState(ExecutionState.ERROR);
                    run.setError(ExceptionUtils.fromResponse((Response)response));
                }
            }
            catch (Exception e) {
                LOGGER.error("Cannot queue job from schedule", (Throwable)e);
                run.setJobState(ExecutionState.ERROR);
                run.setError((Object)ExceptionUtils.getExceptionPrintableMessage((Throwable)e));
            }
        }
        run.setDate(Long.valueOf(runDate));
        if (run.getJobState() != ExecutionState.ERROR) {
            run.setJobId(queueJob.getId());
        }
        run.setScheduleId(schedule.getId());
        run.setId(UidUtils.getRandom());
        this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.SCHEDULE_TRIGGERED, run, schedule.getLastModifiedBy());
        this.schedulerApplication.getJobsDao().addScheduleRun(run);
    }

    @Override
    public void run() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Scheduler Timer Event");
        }
        this.evaluateTimeEvent(DateTime.now());
    }
}

