/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.workers;

import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.utils.licence.services.Credentials;
import com.nuix.automate.utils.licence.services.EventInfo;
import com.nuix.automate.utils.licence.services.LicenceInfo;
import com.nuix.automate.utils.licence.services.LicenceSession;
import com.nuix.automate.utils.licence.services.Product;
import com.nuix.automate.utils.licence.services.SerializerUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.utilization.DiagnosticLevel;
import com.nuix.automate.utils.utilization.Key;
import com.nuix.automate.utils.utilization.UtilizationRecords;
import com.nuix.automate.utils.utilization.consumption.Consumption;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jdbi.v3.core.statement.StatementException;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class SchedulerLicenceSession
extends LicenceSession {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(SchedulerLicenceSession.class);
    private SerializerUtils serializerUtils;
    private SchedulerApplication schedulerApplication;
    private boolean localSession;
    private boolean loggedUtilizationRecordsWarnings;

    public SchedulerLicenceSession(SchedulerApplication schedulerApplication, Credentials credentials, LicenceInfo licenceInfo, Product product, String productVersion, Key key, DiagnosticLevel diagnosticLevel) {
        super(credentials, licenceInfo, product, productVersion, key, diagnosticLevel);
        this.localSession = credentials == null;
        this.schedulerApplication = schedulerApplication;
        this.serializerUtils = new SerializerUtils();
    }

    protected void handleFailedEventTracking(EventInfo eventInfo, Exception e) {
        if (!this.localSession) {
            LOGGER.warn("Cannot send " + String.valueOf(eventInfo), (Throwable)e);
        }
        try {
            this.schedulerApplication.getSchedulerConfigurationDao().addRampivaSessionEvent(eventInfo);
        }
        catch (StatementException ex) {
            this.schedulerApplication.getSchedulerConfigurationDao().updateRampivaSessionEvent(eventInfo);
        }
    }

    protected void handleFailedConsumptionTracking(Consumption consumption, Exception e) {
        if (!this.localSession) {
            LOGGER.warn("Cannot send " + String.valueOf(consumption), (Throwable)e);
        }
        try {
            this.schedulerApplication.getSchedulerConfigurationDao().addAutomateConsumption(consumption);
        }
        catch (StatementException statementException) {
            // empty catch block
        }
    }

    protected void handleFailedUtilizationTracking(UtilizationRecords utilizationRecords, Exception e) {
        if (!this.localSession) {
            LOGGER.warn("Cannot send " + String.valueOf(utilizationRecords), (Throwable)e);
        }
        try {
            this.schedulerApplication.getSchedulerConfigurationDao().addAutomateUtilizationRecords(utilizationRecords);
        }
        catch (StatementException statementException) {
            // empty catch block
        }
    }

    protected boolean retryTrackingPreviouslyFailedEvents() {
        boolean trackedEvents = false;
        long currentTimestamp = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
        long oldTimestamp = currentTimestamp - 1209600000L;
        long oldSessionsCount = this.schedulerApplication.getSchedulerConfigurationDao().countRampivaSessionEventsOlderThan(oldTimestamp);
        if (oldSessionsCount > 0L) {
            LOGGER.warn("Removing " + oldSessionsCount + " expired EventInfos");
            this.schedulerApplication.getSchedulerConfigurationDao().deleteRampivaSessionEventsOlderThan(oldTimestamp);
        }
        List<EventInfo> eventInfos = this.schedulerApplication.getSchedulerConfigurationDao().getRampivaSessionEvents();
        long invalidEventInfosCount = 0L;
        for (EventInfo eventInfo : eventInfos) {
            if (eventInfo != null) continue;
            ++invalidEventInfosCount;
        }
        if (!this.loggedUtilizationRecordsWarnings && invalidEventInfosCount > 0L) {
            LOGGER.warn("Could not decrypt " + invalidEventInfosCount + " EventInfos");
        }
        for (EventInfo eventInfo : eventInfos) {
            if (eventInfo == null) continue;
            try {
                boolean success = this.tryTrackEvent(eventInfo, false);
                if (!success) continue;
                trackedEvents = true;
                this.schedulerApplication.getSchedulerConfigurationDao().deleteRampivaSessionEvent(eventInfo.getId());
            }
            catch (Exception e) {
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Cannot handle cached Event " + String.valueOf(eventInfo), (Throwable)e);
            }
        }
        long oldConsumptionEvents = this.schedulerApplication.getSchedulerConfigurationDao().countAutomateConsumptionEventsOlderThan(oldTimestamp);
        if (oldConsumptionEvents > 0L) {
            LOGGER.warn("Removing " + oldConsumptionEvents + " expired Consumptions");
            this.schedulerApplication.getSchedulerConfigurationDao().deleteRampivaSessionEventsOlderThan(oldTimestamp);
        }
        List<Consumption> consumptions = this.schedulerApplication.getSchedulerConfigurationDao().getAutomateConsumption();
        long invalidConsumptions = 0L;
        for (Consumption consumption : consumptions) {
            if (consumption != null) continue;
            ++invalidConsumptions;
        }
        if (!this.loggedUtilizationRecordsWarnings && invalidConsumptions > 0L) {
            LOGGER.warn("Could not decrypt " + invalidConsumptions + " Consumptions");
        }
        for (Consumption consumption : consumptions) {
            if (consumption == null) continue;
            try {
                boolean success = this.tryTrackConsumption(consumption, false, true);
                if (!success) continue;
                trackedEvents = true;
                this.schedulerApplication.getSchedulerConfigurationDao().deleteAutomateConsumption(consumption.getId());
            }
            catch (Exception e) {
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Cannot handle cached Consumption " + String.valueOf(consumption), (Throwable)e);
            }
        }
        long oldUtilizationCount = this.schedulerApplication.getSchedulerConfigurationDao().countAutomateUtilizationEventsOlderThan(oldTimestamp);
        if (oldUtilizationCount > 0L) {
            LOGGER.warn("Removing " + oldUtilizationCount + " expired UtilizationRecords");
            this.schedulerApplication.getSchedulerConfigurationDao().deleteAutomateUtilizationEventsOlderThan(oldTimestamp);
        }
        List<UtilizationRecords> utilizationRecords = this.schedulerApplication.getSchedulerConfigurationDao().getAutomateUtilizationRecords();
        long invalidUtilizationRecordsCount = 0L;
        for (UtilizationRecords utilizationRecord : utilizationRecords) {
            if (utilizationRecord != null) continue;
            ++invalidUtilizationRecordsCount;
        }
        if (!this.loggedUtilizationRecordsWarnings && invalidUtilizationRecordsCount > 0L) {
            LOGGER.warn("Could not decrypt " + invalidUtilizationRecordsCount + " UtilizationRecords");
        }
        for (UtilizationRecords utilizationRecord : utilizationRecords) {
            if (utilizationRecord == null) continue;
            try {
                boolean success = this.tryTrackUtilizationRecords(utilizationRecord, false);
                if (!success) continue;
                trackedEvents = true;
                this.schedulerApplication.getSchedulerConfigurationDao().deleteAutomateUtilizationRecords(utilizationRecord.getId());
            }
            catch (Exception e) {
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Cannot handle cached UtilizationRecord " + String.valueOf(utilizationRecord), (Throwable)e);
            }
        }
        this.loggedUtilizationRecordsWarnings = true;
        return trackedEvents;
    }

    public EventInfo getSessionStartEvent() {
        EventInfo eventInfo = super.getSessionStartEvent();
        eventInfo.getProperties().remove("nuixLicenseDetails");
        eventInfo.getProperties().remove("nuixLicenseFingerprint");
        eventInfo.getProperties().remove("nuixLicenseShortName");
        eventInfo.getProperties().remove("nuixWorkersCount");
        return eventInfo;
    }

    protected synchronized void trackEvent(EventInfo eventInfo) throws IOException {
        ArrayList<EventInfo> eventInfos = new ArrayList<EventInfo>();
        eventInfos.add(eventInfo);
        this.schedulerApplication.getSessionUtils().trackSessionUtilization(eventInfos);
        super.trackEvent(eventInfo);
    }

    protected synchronized void trackConsumption(Consumption consumption) throws IOException {
        ArrayList<Consumption> consumptions = new ArrayList<Consumption>();
        consumptions.add(consumption);
        if (!consumption.isRetry()) {
            this.schedulerApplication.getSessionUtils().trackConsumptions(consumptions);
        }
        super.trackConsumption(consumption);
    }
}

