/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.workers;

import com.nuix.automate.dropwizard.utils.resources.VersionResources;
import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.persistance.utilization.UtilizationDao;
import com.nuix.automate.scheduler.resources.ClientResource;
import com.nuix.automate.scheduler.resources.ServerResource;
import com.nuix.automate.scheduler.security.bearer.SystemBearerUser;
import com.nuix.automate.scheduler.utils.TagsUtil;
import com.nuix.automate.utils.api.configuration.NetworkConfiguration;
import com.nuix.automate.utils.api.internal.automatelicense.AutomateLicenceModel;
import com.nuix.automate.utils.api.internal.configuration.VersionedModel;
import com.nuix.automate.utils.api.response.ResponseStatus;
import com.nuix.automate.utils.api.response.State;
import com.nuix.automate.utils.api.response.TranslationResponseStatus;
import com.nuix.automate.utils.exceptions.ServerException;
import com.nuix.automate.utils.exceptions.VersionMismatchException;
import com.nuix.automate.utils.general.DropwizardRestClientFactory;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.OperationMimeTypeStats;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.general.TimestampedString;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.licence.services.EventInfo;
import com.nuix.automate.utils.licence.services.LicenceSession;
import com.nuix.automate.utils.licence.services.Type;
import com.nuix.automate.utils.logging.CircularBufferLog;
import com.nuix.automate.utils.logging.LogHandler;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.engine.Command;
import com.nuix.automate.utils.models.api.engine.EngineCommand;
import com.nuix.automate.utils.models.api.engine.EngineStatus;
import com.nuix.automate.utils.models.api.job.Job;
import com.nuix.automate.utils.models.api.job.JobInfos;
import com.nuix.automate.utils.models.api.job.JobOperationEvent;
import com.nuix.automate.utils.models.api.job.JobOperationMimeTypeStats;
import com.nuix.automate.utils.models.api.job.JobSoftErrors;
import com.nuix.automate.utils.models.api.job.JobUpdate;
import com.nuix.automate.utils.models.api.job.JobWarnings;
import com.nuix.automate.utils.models.api.job.OperationStatus;
import com.nuix.automate.utils.models.api.job.Parameter;
import com.nuix.automate.utils.models.api.securitypolicy.SymmetricKey;
import com.nuix.automate.utils.models.api.server.MaintenanceStatus;
import com.nuix.automate.utils.models.api.server.Server;
import com.nuix.automate.utils.models.api.server.ServerCommand;
import com.nuix.automate.utils.models.api.server.ServerStatus;
import com.nuix.automate.utils.models.api.userdatadir.FileInfo;
import com.nuix.automate.utils.models.api.userdatadir.UserDataDir;
import com.nuix.automate.utils.models.api.workflowlibrary.Workflow;
import com.nuix.automate.utils.models.api.workflowlibrary.WorkflowDynamicUpdate;
import com.nuix.automate.utils.models.internal.engine.EngineModel;
import com.nuix.automate.utils.models.internal.engine.ServerId;
import com.nuix.automate.utils.models.internal.event.EventType;
import com.nuix.automate.utils.models.internal.executionprofile.ExecutionProfileModel;
import com.nuix.automate.utils.models.internal.job.BootstrappableJob;
import com.nuix.automate.utils.models.internal.job.JobDetailsModel;
import com.nuix.automate.utils.models.internal.job.JobEvent;
import com.nuix.automate.utils.models.internal.job.JobModel;
import com.nuix.automate.utils.models.internal.logging.RunningLogEventsModel;
import com.nuix.automate.utils.models.internal.logging.ServerLogEventsModel;
import com.nuix.automate.utils.models.internal.logging.history.HistoryComponentType;
import com.nuix.automate.utils.models.internal.nuixlicensesource.NuixLicenseSourceModel;
import com.nuix.automate.utils.models.internal.resourcepool.ResourcePoolModel;
import com.nuix.automate.utils.models.internal.template.AutomateApplication;
import com.nuix.automate.utils.models.internal.template.AutomateConfiguration;
import com.nuix.automate.utils.nuix.Version;
import com.nuix.automate.utils.utilization.ActivityDetails;
import com.nuix.automate.utils.utilization.ActivityType;
import com.nuix.automate.utils.utilization.DataRepository;
import com.nuix.automate.utils.utilization.DataSet;
import com.nuix.automate.utils.utilization.Engine;
import com.nuix.automate.utils.utilization.ExecutionProfile;
import com.nuix.automate.utils.utilization.Library;
import com.nuix.automate.utils.utilization.Matter;
import com.nuix.automate.utils.utilization.MimeTypeVolume;
import com.nuix.automate.utils.utilization.NuixCase;
import com.nuix.automate.utils.utilization.NuixCaseStat;
import com.nuix.automate.utils.utilization.Operation;
import com.nuix.automate.utils.utilization.OperationSetting;
import com.nuix.automate.utils.utilization.OperationUtilizationModel;
import com.nuix.automate.utils.utilization.RelativityWorkspace;
import com.nuix.automate.utils.utilization.ResourcePool;
import com.nuix.automate.utils.utilization.Session;
import com.nuix.automate.utils.utilization.Transfer;
import com.nuix.automate.utils.utilization.TransferVolume;
import com.nuix.automate.utils.utilization.User;
import com.nuix.automate.utils.utilization.UtilizationRecords;
import com.nuix.automate.utils.utilization.consumption.Consumption;
import com.nuix.automate.utils.workflow.ExecutionState;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.NotImplementedException;
import org.jdbi.v3.core.statement.StatementException;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class ServerWorker
extends TimerTask {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ServerWorker.class);
    private InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");
    private SchedulerApplication schedulerApplication;
    private Server model;
    private ServerResource serverResource;
    private Client client;
    private Client fileUploadClient;
    private Map<String, EngineModel> engineModels;
    private String submittedNuixLicenceLocationsVersion;
    private String submittedRampivaLicenceVersion;
    private String submittedExecutionProfileVersion;
    private String submittedUserDataDirVersion;
    private String submittedNetworkConfigurationVersion;
    private Semaphore pingServerSemaphore;
    private Semaphore manageServerProcessingEventsSemaphore;
    private Semaphore manageServerUtilizationSemaphore;
    private Semaphore manageServerEnginesWorkSemaphore;
    private Semaphore manageServerEventsSemaphore;
    private Semaphore manageExecutionLogsSemaphore;
    private Semaphore manageServerLogsSemaphore;
    private Semaphore managerServerWorkflowChangesSemaphore;
    private Semaphore manageExpiredCachedWorkflowDetailsSemaphore;
    private Map<String, Set<String>> jobSoftErrors;
    private Map<String, Set<String>> jobWarnings;
    private Map<String, Set<String>> jobInfos;
    private Map<String, String> previousEngineErrors;
    private Map<String, String> previousEngineWarnings;
    private LinkedHashSet<String> unsuccessfullRemoteWorkerConfigurations;
    private Map<String, String> engineRunningConfiguration;
    private Set<String> lastSeenLogIds;
    private CircularBufferLog serverTimingLog;
    private long lastSuccessfulPingEpoch;
    private final Semaphore userDataDirSyncSemaphore;
    private static final boolean enableEicarTest = false;
    private static final String eicar = "X5O!P%@AP[4\\PZX54(P^)7CC)7}$EICAR-STANDARD-ANTIVIRUS-TEST-FILE!$H+H*";
    private static final String eicarTestPath = "DEBUG:EICAR";

    public void initializeClient() throws GeneralSecurityException {
        this.client = DropwizardRestClientFactory.getClientWithWhitelistValidation((String)("ServerWorker-r" + UidUtils.getRandom()), (Set)this.model.getWhitelistedCertFingerprints(), (AutomateApplication)this.schedulerApplication, (AutomateConfiguration)this.schedulerApplication.getConfiguration());
        this.fileUploadClient = DropwizardRestClientFactory.getClientWithWhitelistValidation((String)("ServerWorker-FileUpload" + UidUtils.getRandom()), (Set)this.model.getWhitelistedCertFingerprints(), (AutomateApplication)this.schedulerApplication, (AutomateConfiguration)this.schedulerApplication.getConfiguration());
        this.fileUploadClient.property("jersey.config.client.chunkedEncodingSize", (Object)4096);
        this.fileUploadClient.property("jersey.config.client.request.entity.processing", (Object)"CHUNKED");
    }

    public ServerWorker(SchedulerApplication schedulerApplication, ServerResource serverResource, Server model) throws GeneralSecurityException {
        this.schedulerApplication = schedulerApplication;
        this.serverResource = serverResource;
        this.model = model;
        this.initializeClient();
        model.setStatus(ServerStatus.INITIALIZING);
        model.setMaintenanceStatus(MaintenanceStatus.NONE);
        this.pingServerSemaphore = new Semaphore(1);
        this.manageServerProcessingEventsSemaphore = new Semaphore(1);
        this.manageServerUtilizationSemaphore = new Semaphore(1);
        this.manageServerEnginesWorkSemaphore = new Semaphore(1);
        this.manageServerEventsSemaphore = new Semaphore(1);
        this.manageExecutionLogsSemaphore = new Semaphore(1);
        this.manageServerLogsSemaphore = new Semaphore(1);
        this.managerServerWorkflowChangesSemaphore = new Semaphore(1);
        this.manageExpiredCachedWorkflowDetailsSemaphore = new Semaphore(1);
        this.engineModels = new ConcurrentHashMap<String, EngineModel>();
        this.previousEngineErrors = new ConcurrentHashMap<String, String>();
        this.previousEngineWarnings = new ConcurrentHashMap<String, String>();
        this.jobSoftErrors = new HashMap<String, Set<String>>();
        this.jobWarnings = new HashMap<String, Set<String>>();
        this.jobInfos = new HashMap<String, Set<String>>();
        this.unsuccessfullRemoteWorkerConfigurations = new LinkedHashSet();
        this.engineRunningConfiguration = new HashMap<String, String>();
        this.serverTimingLog = new CircularBufferLog(1000);
        this.userDataDirSyncSemaphore = new Semaphore(1);
    }

    public void bootstrapJob(String engineId, BootstrappableJob o) throws ServerException {
        BootstrappableJob bootstrappableJob = new BootstrappableJob(o);
        SymmetricKey symmetricKey = null;
        if (bootstrappableJob.getJobModel().getSessionParametersKeyId() != null) {
            symmetricKey = this.schedulerApplication.getAesEncryptor().decryptKey(bootstrappableJob.getJobModel().getSessionParametersKeyId(), 256);
            for (Parameter sessionParameter : bootstrappableJob.getJobModel().getSessionParameters()) {
                if (!sessionParameter.isProtected() && !sessionParameter.isMasked() || sessionParameter.getValue() == null || sessionParameter.getValue().length() <= 0) continue;
                String decryptedValue = this.schedulerApplication.getAesEncryptor().decrypt(sessionParameter.getName(), symmetricKey, sessionParameter.getValue());
                if (decryptedValue == null) {
                    LOGGER.warn("Cannot decrypt parameter " + sessionParameter.getName());
                    continue;
                }
                sessionParameter.setValue(decryptedValue);
            }
            bootstrappableJob.getJobModel().setSessionParametersKeyId(null);
        }
        if (bootstrappableJob.getJobModel().getStartedDate() == null) {
            bootstrappableJob.getJobModel().setStartedDate(Long.valueOf(new DateTime(DateTimeZone.UTC).getMillis()));
        }
        String jobApiBearerToken = this.schedulerApplication.getBearerAuthenticator().getJobApiBearerToken(o.getJobModel());
        o.getJobModel().setJobApiBearerToken(jobApiBearerToken);
        EngineModel remoteModel = this.callApi("/v1/server/engines/" + engineId + "/job", "POST", bootstrappableJob, new GenericType<EngineModel>(){});
        o.getJobModel().setJobApiBearerToken(null);
        this.reloadEnginesFromServer();
        LOGGER.info(String.valueOf(this.model) + " - Sent " + String.valueOf(bootstrappableJob.getJobModel()) + " to " + String.valueOf(remoteModel));
    }

    public boolean isUserDataDirSyncActive() {
        if (this.userDataDirSyncSemaphore.tryAcquire()) {
            this.userDataDirSyncSemaphore.release();
            return false;
        }
        return true;
    }

    private String getConfiguration(String engineId, JobDetailsModel jobDetailsModel) {
        EngineModel engine = this.engineModels.get(engineId);
        if (engine == null) {
            return null;
        }
        if (engine.getNuixLicenceSourceId() == null) {
            return null;
        }
        NuixLicenseSourceModel nuixLicense = SchedulerApplication.getInstance().getNuixLicenceSourceResource().getNuixLicenceSource(engine.getNuixLicenceSourceId());
        if (nuixLicense == null) {
            return null;
        }
        OperationStatus runningOperation = jobDetailsModel.getSettings().getRunningOperationStatus();
        if (runningOperation == null) {
            return null;
        }
        return UidUtils.fromString((String)(SerializationUtils.toJson((Object)nuixLicense.getVersion()) + "-" + runningOperation.getName())).toString();
    }

    public void joinRemoteJob(String engineId, JobDetailsModel jobDetailsModel) throws ServerException {
        if (this.schedulerApplication.getLicenceUtils().getModuleLicensed(ModuleType.REMOTE_ENGINES)) {
            String configuration;
            Workflow workflow;
            for (OperationStatus operationStatus : jobDetailsModel.getOperations()) {
                if (!operationStatus.getExecutionState().equals((Object)ExecutionState.RUNNING)) continue;
                jobDetailsModel.getSettings().setRunningOperationStatus(operationStatus);
            }
            if (jobDetailsModel.getSettings().getRunningOperationStatus() == null || jobDetailsModel.getSettings().getRunningOperationStatus().getWorkerMemory() == null) {
                return;
            }
            JobModel jobModel = new JobModel(jobDetailsModel.getSettings());
            BootstrappableJob bootstrappableJob = new BootstrappableJob();
            bootstrappableJob.setJobModel(jobModel);
            if (jobModel.getLibraryWorkflowId() != null && (workflow = this.schedulerApplication.getLibraryResource().getLibraryWorkflow(jobModel.getLibraryWorkflowId())) != null) {
                bootstrappableJob.setWorkflowXml(workflow.getOperationsXml());
            }
            if ((configuration = this.getConfiguration(engineId, jobDetailsModel)) == null || !this.unsuccessfullRemoteWorkerConfigurations.contains(configuration)) {
                LOGGER.info("Engine " + engineId + " asked to join remote " + String.valueOf(jobDetailsModel.getSettings()));
                this.engineRunningConfiguration.put(engineId, configuration);
                LOGGER.info("Remote run configuration " + configuration);
                EngineModel remoteModel = this.callApi("/v1/server/engines/" + engineId + "/remoteJob", "POST", bootstrappableJob, new GenericType<EngineModel>(){});
                this.reloadEnginesFromServer();
                LOGGER.info(String.valueOf(this.model) + " - Sent  remote " + String.valueOf(jobModel) + " to " + String.valueOf(remoteModel));
            }
        }
    }

    public ResponseStatus sendCommand(final ServerCommand serverCommand) throws ServerException {
        switch (serverCommand.getCommand()) {
            case EXIT_MAINTENANCE: {
                if (this.model.getMaintenanceStatus() == MaintenanceStatus.NONE) {
                    return new TranslationResponseStatus("cannotExitServerNotInMaintenance");
                }
                this.model.setMaintenanceStatus(MaintenanceStatus.NONE);
                this.resetSubmittedVersions();
                break;
            }
            case ENTER_MAINTENANCE: {
                if (this.model.getMaintenanceStatus() == MaintenanceStatus.ENTERING_MAINTENANCE) {
                    return new TranslationResponseStatus("cannotExitServerAlreadyEnteringMaintenance");
                }
                if (this.model.getMaintenanceStatus() == MaintenanceStatus.UNDER_MAINTENANCE) {
                    return new TranslationResponseStatus("cannotExitServerAlreadyUnderMaintenance");
                }
                this.model.setMaintenanceStatus(MaintenanceStatus.ENTERING_MAINTENANCE);
                break;
            }
            default: {
                return new TranslationResponseStatus("unexpectedCommand", (Map)new HashMap<String, String>(){
                    {
                        this.put("commandModel", serverCommand.getCommand().name());
                    }
                });
            }
        }
        return new TranslationResponseStatus("commandSent");
    }

    private void resetSubmittedVersions() {
        this.submittedNuixLicenceLocationsVersion = null;
        this.submittedRampivaLicenceVersion = null;
        this.submittedExecutionProfileVersion = null;
        this.submittedUserDataDirVersion = null;
    }

    public Server getModel() {
        return this.model;
    }

    public Collection<EngineModel> getEngineModels() {
        return this.engineModels.values();
    }

    private <ResponseType, RequestType> ResponseType callApi(String location, String method, RequestType requestData, GenericType<ResponseType> entityType) throws ServerException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Server " + String.valueOf(this.model) + " " + method + " call to " + location);
        }
        try (Response response = null;){
            Object responseData;
            WebTarget webTarget = this.client.target(this.model.getUrl() + "/api" + location);
            String apiToken = this.schedulerApplication.getBearerAuthenticator().getTokenFromApiSecret(this.model.getId());
            Invocation.Builder invocationBuilder = webTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + apiToken));
            switch (method) {
                case "POST": {
                    response = invocationBuilder.post(Entity.json(requestData));
                    break;
                }
                case "PUT": {
                    response = invocationBuilder.put(Entity.json(requestData));
                    break;
                }
                default: {
                    throw new NotImplementedException("Method " + method + " not implemented in server API with body");
                }
            }
            if (response.getStatus() != 200) {
                response.bufferEntity();
                String stringTitle = "";
                ResponseStatus responseStatus = new ResponseStatus();
                try {
                    responseStatus = (ResponseStatus)response.readEntity(ResponseStatus.class);
                    if (responseStatus.getMessage() == null || responseStatus.getCode() == 0) {
                        throw new IOException("Response is not ResponseStatusModel");
                    }
                    responseStatus.setRedirectUrl(null);
                }
                catch (Exception e) {
                    responseStatus.setMessage((String)response.readEntity(String.class));
                    responseStatus.setCode(500);
                }
                LOGGER.error(FormattingUtils.encodeForLog((String)this.model.toString()) + " /api" + location + " responded with HTTP/" + response.getStatus() + " " + responseStatus.getTitle() + " " + responseStatus.getMessage());
                throw new ServerException(responseStatus);
            }
            Object object = responseData = response.readEntity(entityType);
            return (ResponseType)object;
        }
    }

    public JobModel updateEngineJobSettings(String engineId, String jobId, JobUpdate jobUpdate) throws ServerException {
        JobModel jobModel = this.callApi("/v1/server/engines/" + engineId + "/jobs/" + jobId + "/settings", "PUT", jobUpdate, new GenericType<JobModel>(){});
        return jobModel;
    }

    public JobModel updateEngineJobSettings(String engineId, String jobId, JobModel jobModelRequest) throws ServerException {
        JobModel jobModel = this.callApi("/v1/server/engines/" + engineId + "/jobs/" + jobId + "/settings", "PUT", jobModelRequest, new GenericType<JobModel>(){});
        return jobModel;
    }

    public EngineModel sendEngineCommand(String engineId, EngineCommand engineCommand) throws ServerException {
        EngineModel responseEngineModel = this.callApi("/v1/server/engines/" + engineId + "/command", "PUT", engineCommand, new GenericType<EngineModel>(){});
        this.reloadEnginesFromServer();
        return responseEngineModel;
    }

    public EngineModel updateEngine(String engineId, EngineModel updateRequest) throws ServerException {
        EngineModel updateReponse = this.callApi("/v1/server/engines/" + engineId, "PUT", updateRequest, new GenericType<EngineModel>(){});
        this.reloadEnginesFromServer();
        return updateReponse;
    }

    public EngineModel addEngine(EngineModel engine) throws ServerException {
        EngineModel addedEngine = this.callApi("/v1/server/engines", "POST", engine, new GenericType<EngineModel>(){});
        this.reloadEnginesFromServer();
        return addedEngine;
    }

    public String deleteEngine(String engineId) throws ServerException {
        String response = this.callApi("/v1/server/engines/" + engineId, "DELETE", new GenericType<String>(){});
        this.reloadEnginesFromServer();
        return response;
    }

    public Response getJobFile(String jobId, String fileName) {
        String location = "/v1/server/job/" + jobId + "/file/" + fileName;
        Invocation.Builder invocationBuilder = this.prepareRequest(location);
        Response response = invocationBuilder.get();
        if (response.getStatus() != 200) {
            LOGGER.error(String.valueOf(this.model) + " /api" + location + " responded with HTTP/" + response.getStatus());
        }
        return response;
    }

    private Invocation.Builder prepareRequest(String location) {
        String apiToken = this.schedulerApplication.getBearerAuthenticator().getTokenFromApiSecret(this.model.getId());
        return this.client.target(this.model.getUrl() + "/api" + location).request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + apiToken));
    }

    private <ResponseType, RequestType> ResponseType callApi(String location, String method, GenericType<ResponseType> entityType) throws ServerException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Server " + String.valueOf(this.model) + " " + method + " call to " + location);
        }
        try (Response response = null;){
            Object responseData;
            Invocation.Builder invocationBuilder = this.prepareRequest(location);
            switch (method) {
                case "GET": {
                    response = invocationBuilder.get();
                    break;
                }
                case "DELETE": {
                    response = invocationBuilder.delete();
                    break;
                }
                default: {
                    throw new NotImplementedException("Method " + method + " not implemented in server API without body");
                }
            }
            if (response.getStatus() == 401) {
                throw new ServerException((ResponseStatus)new TranslationResponseStatus("couldNotAuthenticateToEngineServer"));
            }
            if (response.getStatus() != 200) {
                response.bufferEntity();
                ResponseStatus responseStatus = new ResponseStatus();
                try {
                    responseStatus = (ResponseStatus)response.readEntity(ResponseStatus.class);
                    if (responseStatus.getMessage() == null || responseStatus.getCode() == 0) {
                        throw new IOException("Response is not ResponseStatus");
                    }
                    responseStatus.setRedirectUrl(null);
                }
                catch (Exception e) {
                    responseStatus.setMessage((String)response.readEntity(String.class));
                    responseStatus.setCode(500);
                }
                LOGGER.error(String.valueOf(this.model) + " /api" + location + " responded with HTTP/" + response.getStatus() + " " + responseStatus.getTitle() + " " + responseStatus.getMessage());
                throw new ServerException(responseStatus);
            }
            Object object = responseData = response.readEntity(entityType);
            return (ResponseType)object;
        }
    }

    private String renewId() throws ServerException {
        String payload = "";
        String updatedId = this.callApi("/v1/server/config/id", "PUT", payload, new GenericType<String>(){});
        return updatedId;
    }

    private void getVersions(boolean forceRefresh) throws ServerException {
        String version;
        if (forceRefresh || this.model.getVersion() == null) {
            version = this.callApi("/v1/version/automate", "GET", new GenericType<String>(){});
            this.model.setVersion(version);
        }
        if (forceRefresh || this.model.getJavaVersion() == null) {
            version = "";
            try {
                version = this.callApi("/v1/version/java", "GET", new GenericType<String>(){});
                this.model.setJavaVersion(version);
            }
            catch (Exception e) {
                LOGGER.warn("Cannot get server Java version", (Throwable)e);
            }
        }
    }

    private void checkProductVersion(String productVersionString, String productName) throws VersionMismatchException {
        String automateVersionString = VersionResources.class.getPackage().getImplementationVersion();
        Version automateVersion = new Version(automateVersionString);
        String automateVersionMajorMinor = automateVersion.getMajor() + "." + automateVersion.getMinor();
        Version productVersion = new Version(productVersionString);
        String productVersionMajorMinor = productVersion.getMajor() + "." + productVersion.getMinor();
        if (automateVersion.getMajor() != 0 && !automateVersionMajorMinor.equals(productVersionMajorMinor)) {
            throw new VersionMismatchException(this.iu.getFormattedString("Product.Version.Error", new Object[]{productName, productVersionString, automateVersionMajorMinor + ".x"}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initializeServer() {
        LOGGER.info("Initializing server " + this.model.toString());
        try (Response response = null;){
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Getting SSO authentication token");
            }
            WebTarget webTarget = this.client.target(this.model.getUrl() + "/api/v1/server/config/id?schedulerId=" + this.schedulerApplication.getInstanceId());
            Invocation.Builder invocationBuilder = webTarget.request(new String[]{"application/json"});
            response = invocationBuilder.get();
            LOGGER.info("Server returned HTTP/" + response.getStatus() + " during pre-initialization handshake");
            if (response.getStatus() != 200) {
                String responseString;
                block42: {
                    responseString = "";
                    try {
                        responseString = (String)response.readEntity(String.class);
                    }
                    catch (Exception e) {
                        if (!LOGGER.isDebugEnabled()) break block42;
                        LOGGER.debug("Cannot read server response", (Throwable)e);
                    }
                }
                LOGGER.error("Cannot authenticate to server: " + responseString);
                this.model.setVersion(null);
                this.model.setStatus(ServerStatus.ERROR);
                this.resetSubmittedVersions();
                this.model.setError(this.iu.getFormattedString("ServerWorker.CouldNotAuthenticate", (Object)response.getStatus()));
                boolean e = false;
                return e;
            }
            ServerId serverId = (ServerId)response.readEntity(ServerId.class);
            if (serverId.getNonce() == null || serverId.getNonce().length() < 4) {
                throw new SecurityException(this.iu.getString("ServerWorker.CannotAuthenticateEngineServer.InvalidNonce"));
            }
            if (serverId.getId() == null || serverId.getId().length() < 4) {
                throw new SecurityException(this.iu.getString("ServerWorker.CannotAuthenticateEngineServer.InvalidId"));
            }
            String expectedKey = this.schedulerApplication.getBearerAuthenticator().getTokenFromApiSecret(this.schedulerApplication.getInstanceId(), serverId.getNonce());
            if (!expectedKey.equals(serverId.getKey())) {
                throw new SecurityException(this.iu.getString("ServerWorker.CannotAuthenticateEngineServer.EnsureCorrectApiSecret"));
            }
            if (this.model.getId() == null) {
                this.model.setId(serverId.getId());
            }
            if (!this.model.getId().equals(serverId.getId())) {
                throw new IllegalStateException(this.iu.getFormattedString("ServerWorker.IllegalServerId", new Object[]{this.model.getId(), serverId.getId()}));
            }
            this.getVersions(true);
            try {
                this.checkProductVersion(this.model.getVersion(), "Server");
            }
            catch (VersionMismatchException e) {
                this.model.setStatus(ServerStatus.ERROR);
                this.resetSubmittedVersions();
                this.model.setError(e.getMessage());
                this.model.setVersion(null);
                boolean bl = false;
                if (response != null) {
                    response.close();
                }
                return bl;
            }
            if (TagsUtil.hasTag(TagsUtil.CLOUD_INSTANCE_ID, this.model.getTags())) {
                LOGGER.info("Removing all Engines before sending license to Cloud server");
                try {
                    this.removeAllEngines();
                }
                catch (ServerException e) {
                    if (e.getMessage() != null && e.getMessage().contains("cannotDeleteEngineItIn")) {
                        LOGGER.warn("Cannot delete engine", (Throwable)e);
                    }
                    throw e;
                }
            }
            this.sendNuixLicenceSources();
            this.sendExecutionProfiles();
            this.sendNetworkConfiguration();
            boolean e = true;
            return e;
        }
        return false;
    }

    private void sendRampivaLicense() throws ServerException {
        LOGGER.info("Sending " + String.valueOf(this.model) + " Automate License " + this.schedulerApplication.getAutomateLicenceResource().getVersion());
        VersionedModel rampivaLicenseModels = new VersionedModel();
        HashSet<AutomateLicenceModel> sources = new HashSet<AutomateLicenceModel>();
        sources.add(this.schedulerApplication.getAutomateLicenceResource().getRampivaLicence());
        rampivaLicenseModels.setModels(sources);
        rampivaLicenseModels.setVersion(this.schedulerApplication.getAutomateLicenceResource().getVersion());
        this.submittedRampivaLicenceVersion = this.callApi("/v1/server/config/rampivaLicence", "POST", rampivaLicenseModels, new GenericType<String>(){});
    }

    private void syncUserDataDir() throws ServerException {
        LOGGER.info("Syncing " + String.valueOf(this.model) + " User Data Dir " + this.schedulerApplication.getUserDataDirResource().getVersion());
        long startMs = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
        UserDataDir userDataDir = this.schedulerApplication.getUserDataDirResource().getUserDataDir();
        String userDataDirPath = userDataDir != null ? userDataDir.getPath() : null;
        this.callApi("/v1/server/userDataDir/config", "POST", userDataDirPath, new GenericType<Object>(){});
        if (userDataDirPath != null) {
            Map<String, FileInfo> serverUserDataDirFileInfos = this.callApi("/v1/server/userDataDir/files", "GET", new GenericType<Map<String, FileInfo>>(){});
            Map<String, FileInfo> schedulerUserDataDirFileInfos = this.schedulerApplication.getUserDataDirResource().getFileInfos();
            HashSet<String> serverPathsToDelete = new HashSet<String>();
            for (String string : serverUserDataDirFileInfos.keySet()) {
                if (schedulerUserDataDirFileInfos.containsKey(string)) continue;
                FileInfo serverFileInfo = serverUserDataDirFileInfos.get(string);
                LOGGER.info("UserDataDir Server file " + serverFileInfo.getRelativePath() + ", createdTime: " + serverFileInfo.getCreatedTime() + ", lastModifiedTime: " + serverFileInfo.getLastModifiedTime());
                boolean validationSchedulerFileExists = this.schedulerApplication.getUserDataDirResource().validateFileExists(serverFileInfo.getRelativePath());
                LOGGER.info("UserDataDir Scheduler file not found, second check exists: " + validationSchedulerFileExists);
                if (validationSchedulerFileExists) continue;
                serverPathsToDelete.add(string);
            }
            if (!serverPathsToDelete.isEmpty()) {
                this.callApi("/v1/server/userDataDir/files:batchDelete", "POST", serverPathsToDelete, new GenericType<Object>(){});
            }
            ArrayList<String> pathsToUpdate = new ArrayList<String>();
            if (userDataDir != null) {
                for (String relativePath : schedulerUserDataDirFileInfos.keySet()) {
                    FileInfo schedulerFileInfo = schedulerUserDataDirFileInfos.get(relativePath);
                    FileInfo serverFileInfo = serverUserDataDirFileInfos.get(relativePath);
                    if (serverFileInfo != null && schedulerFileInfo.getCreatedTime() == serverFileInfo.getCreatedTime() && schedulerFileInfo.getLastModifiedTime() == serverFileInfo.getLastModifiedTime()) continue;
                    LOGGER.info("UserDataDir Scheduler file " + schedulerFileInfo.getRelativePath() + ", createdTime: " + schedulerFileInfo.getCreatedTime() + ", lastModifiedTime: " + schedulerFileInfo.getLastModifiedTime());
                    if (serverFileInfo != null) {
                        LOGGER.info("UserDataDir Server file " + serverFileInfo.getRelativePath() + ", createdTime: " + serverFileInfo.getCreatedTime() + ", lastModifiedTime: " + serverFileInfo.getLastModifiedTime());
                    } else {
                        LOGGER.info("UserDataDir Server file not found");
                    }
                    pathsToUpdate.add(relativePath);
                }
                if (!pathsToUpdate.isEmpty()) {
                    block4: for (String relativePath : pathsToUpdate) {
                        int attempts = 0;
                        while (attempts++ < 3) {
                            try {
                                FileInfo schedulerFileInfo = schedulerUserDataDirFileInfos.get(relativePath);
                                FileInfo uploadedFileInfo = this.uploadUserDataDirFile(relativePath, schedulerFileInfo);
                                continue block4;
                            }
                            catch (IOException e) {
                                LOGGER.error("Error uploading file: " + relativePath, (Throwable)e);
                            }
                        }
                    }
                }
            }
            long l = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
            long duration = l - startMs;
            LOGGER.info("Finished syncing " + String.valueOf(this.model) + " User Data Dir " + this.schedulerApplication.getUserDataDirResource().getVersion());
            LOGGER.info("Updated " + pathsToUpdate.size() + " and deleted " + serverPathsToDelete.size() + " files, duration: " + duration / 1000L + " s (" + duration + " ms)");
        }
    }

    private FileInfo uploadUserDataDirFile(String relativePath, FileInfo fileInfo) throws IOException {
        if (relativePath.equals(eicarTestPath)) {
            return this.uploadEicarAvTest();
        }
        UserDataDir userDataDir = this.schedulerApplication.getUserDataDirResource().getUserDataDir();
        Path absPath = Paths.get(userDataDir.getPath(), relativePath);
        return this.uploadUserDataDirFile(relativePath, Files.newInputStream(absPath, new OpenOption[0]), fileInfo);
    }

    private FileInfo uploadEicarAvTest() throws IOException {
        return this.uploadUserDataDirFile("eicar.txt", new ByteArrayInputStream(eicar.getBytes(StandardCharsets.UTF_8)), new FileInfo());
    }

    private FileInfo uploadUserDataDirFile(String relativePath, InputStream in, FileInfo fileInfo) throws IOException {
        String apiToken = this.schedulerApplication.getBearerAuthenticator().getTokenFromApiSecret(this.model.getId());
        String location = "/api/v1/server/userDataDir/files?relativePath=" + URLEncoder.encode(relativePath, StandardCharsets.UTF_8) + "&createdTime=" + fileInfo.getCreatedTime() + "&lastModifiedTime=" + fileInfo.getLastModifiedTime();
        try (BufferedInputStream bin = new BufferedInputStream(in);){
            Response response = this.fileUploadClient.target(this.model.getUrl() + location).request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + apiToken)).post(Entity.entity((Object)bin, (MediaType)MediaType.APPLICATION_OCTET_STREAM_TYPE));
            if (response.getStatus() != 200) {
                response.bufferEntity();
                String errorMessage = (String)response.readEntity(String.class);
                LOGGER.error(FormattingUtils.encodeForLog((String)this.model.toString()) + " " + location + " responded with HTTP/" + response.getStatus() + " " + errorMessage);
                throw new IllegalStateException(errorMessage);
            }
            FileInfo fileInfo2 = (FileInfo)response.readEntity(FileInfo.class);
            return fileInfo2;
        }
    }

    public void removeAllEngines() throws ServerException {
        LOGGER.info("Deleting all engines from " + String.valueOf(this.model));
        List<EngineModel> engines = this.callApi("/v1/server/engines", "GET", new GenericType<List<EngineModel>>(){});
        for (EngineModel e : engines) {
            LOGGER.info("Deleting engine from " + String.valueOf(e));
            this.callApi("/v1/server/engines/" + e.getId(), "DELETE", new GenericType<String>(){});
        }
    }

    private void sendNuixLicenceSources() throws ServerException {
        LOGGER.info("Sending " + String.valueOf(this.model) + " Engine License Sources " + this.schedulerApplication.getNuixLicenceSourceResource().getVersion());
        VersionedModel nuixLicenceSourcesModel = new VersionedModel();
        HashSet<NuixLicenseSourceModel> sources = new HashSet<NuixLicenseSourceModel>();
        sources.addAll(this.schedulerApplication.getNuixLicenceSourceResource().getNuixLicenceSources());
        nuixLicenceSourcesModel.setModels(sources);
        nuixLicenceSourcesModel.setVersion(this.schedulerApplication.getNuixLicenceSourceResource().getVersion());
        this.submittedNuixLicenceLocationsVersion = this.callApi("/v1/server/config/nuixLicenceSources", "POST", nuixLicenceSourcesModel, new GenericType<String>(){});
    }

    private void sendExecutionProfiles() throws ServerException {
        LOGGER.info("Sending " + String.valueOf(this.model) + " Execution Profiles " + this.schedulerApplication.getExecutionProfileResource().getVersion());
        VersionedModel executionProfiles = new VersionedModel();
        HashSet<ExecutionProfileModel> sources = new HashSet<ExecutionProfileModel>();
        sources.addAll(this.schedulerApplication.getExecutionProfileResource().getExecutionProfiles());
        executionProfiles.setModels(sources);
        executionProfiles.setVersion(this.schedulerApplication.getExecutionProfileResource().getVersion());
        this.submittedExecutionProfileVersion = this.callApi("/v1/server/config/executionProfiles", "POST", executionProfiles, new GenericType<String>(){});
    }

    private void sendNetworkConfiguration() throws ServerException {
        LOGGER.info("Sending Automate Network Configuration " + this.schedulerApplication.getNetworkConfigurationResource().getVersion());
        VersionedModel networkConfiguration = new VersionedModel();
        HashSet<NetworkConfiguration> sources = new HashSet<NetworkConfiguration>();
        sources.add(NetworkConfiguration.fromSystemProperties());
        networkConfiguration.setModels(sources);
        networkConfiguration.setVersion(this.schedulerApplication.getNetworkConfigurationResource().getVersion());
        this.submittedNetworkConfigurationVersion = this.callApi("/v1/server/config/networkConfiguration", "POST", networkConfiguration, new GenericType<String>(){});
    }

    public void pingServer() {
        String currentError;
        long startMillis = DateTime.now().getMillis();
        this.serverTimingLog.addLog(String.valueOf(this.model) + " Ping Start");
        if (this.schedulerApplication.getAutomateLicenceResource() == null || this.schedulerApplication.getAutomateLicenceResource().getRampivaLicence() == null || this.schedulerApplication.getAutomateLicenceResource().getRampivaLicence().getStatus() == null || this.schedulerApplication.getAutomateLicenceResource().getRampivaLicence().getStatus().getCode().equals((Object)State.ERROR)) {
            return;
        }
        long startTime = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
        if (this.model.getUrl() == null) {
            this.cancel();
        }
        String previousError = "";
        if (this.model.getStatus() == ServerStatus.ERROR) {
            previousError = this.model.getError();
        }
        boolean initSuccessful = false;
        if (this.model.getStatus() == ServerStatus.INITIALIZING || this.model.getStatus() == ServerStatus.ERROR) {
            initSuccessful = this.initializeServer();
        }
        if (this.model.getStatus() == ServerStatus.ERROR && this.model.getId() != null && !(currentError = this.model.getError()).equals(previousError)) {
            Server eventResults = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions((BearerUser)new SystemBearerUser(), this.model);
            this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.ENGINE_SERVER_ERROR, eventResults);
        }
        if (this.model.getStatus() == ServerStatus.INITIALIZED || initSuccessful) {
            this.model.setOnlineLastSeen(Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()));
            try {
                this.getVersions(false);
                String executionId = this.callApi("/v1/server/config/ping?serverId=" + this.schedulerApplication.getSchedulerConfigurationDao().getIds().get(0) + "&enableCentralizedLogging=" + this.schedulerApplication.getConfiguration().getEnableCentralizedLogging(), "GET", new GenericType<String>(){});
                Server existingServer = this.serverResource.getServerWithId(executionId);
                if (existingServer == null || existingServer == this.model) {
                    this.model.setId(executionId);
                } else {
                    LOGGER.warn(String.valueOf(this.model) + " has the same ID as " + String.valueOf(existingServer) + ". Renewing ID");
                    String newId = this.renewId();
                    if (newId != null) {
                        this.model.setId(newId);
                    } else {
                        this.model.setStatus(ServerStatus.ERROR);
                        this.model.setError(this.iu.getFormattedString("ServerWorker.IdExists", (Object)existingServer.getName()));
                        this.resetSubmittedVersions();
                    }
                }
                boolean serverHasNotInitalizedEngine = false;
                if (this.engineModels != null) {
                    for (EngineModel engineModel : this.engineModels.values()) {
                        if (!engineModel.getStatus().equals((Object)EngineStatus.NOT_INITIALIZED)) continue;
                        serverHasNotInitalizedEngine = true;
                        break;
                    }
                }
                if (serverHasNotInitalizedEngine || this.submittedNuixLicenceLocationsVersion == null || !this.schedulerApplication.getNuixLicenceSourceResource().getVersion().equals(this.submittedNuixLicenceLocationsVersion)) {
                    this.sendNuixLicenceSources();
                }
                if (serverHasNotInitalizedEngine || this.submittedRampivaLicenceVersion == null || !this.schedulerApplication.getAutomateLicenceResource().getVersion().equals(this.submittedRampivaLicenceVersion)) {
                    this.sendRampivaLicense();
                }
                if (serverHasNotInitalizedEngine || this.submittedExecutionProfileVersion == null || !this.schedulerApplication.getExecutionProfileResource().getVersion().equals(this.submittedExecutionProfileVersion)) {
                    this.sendExecutionProfiles();
                }
                if (serverHasNotInitalizedEngine || !this.schedulerApplication.getNetworkConfigurationResource().getVersion().equals(this.submittedNetworkConfigurationVersion)) {
                    this.sendNetworkConfiguration();
                }
                String schedulerUserDataDirVersion = this.schedulerApplication.getUserDataDirResource().getVersion();
                if ((serverHasNotInitalizedEngine || !schedulerUserDataDirVersion.equals(this.submittedUserDataDirVersion)) && this.userDataDirSyncSemaphore.tryAcquire()) {
                    this.schedulerApplication.getScheduledExecutorService().submit(() -> {
                        try {
                            this.syncUserDataDir();
                        }
                        catch (Exception e) {
                            LOGGER.error("Error syncing userDataDir", (Throwable)e);
                        }
                        finally {
                            this.submittedUserDataDirVersion = schedulerUserDataDirVersion;
                            this.userDataDirSyncSemaphore.release();
                        }
                    });
                }
                if (initSuccessful) {
                    this.model.setStatus(ServerStatus.INITIALIZED);
                    this.model.setError("");
                }
            }
            catch (ServerException e) {
                String message = e.getLocalizedMessage();
                LOGGER.error("Could not ping server, " + message);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Could not ping server", (Throwable)e);
                }
                this.model.setStatus(ServerStatus.ERROR);
                this.resetSubmittedVersions();
                this.model.setError(this.iu.getFormattedString("ServerWorker.CouldNotPing", (Object)message));
            }
        }
        if (this.model.getStatus() == ServerStatus.ERROR) {
            long age;
            this.resetSubmittedVersions();
            if (this.engineModels != null) {
                this.engineModels.clear();
            }
            if ((age = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis() - this.lastSuccessfulPingEpoch) > this.schedulerApplication.getConfiguration().getServerTimeout() && TagsUtil.hasTag(TagsUtil.AUTO_REGISTER_RESOURCE_POOL_ID, this.model.getTags())) {
                LOGGER.warn("Self-registered server " + this.model.getId() + " disappeared, removing ...");
                this.schedulerApplication.getServerResource().deleteManagedServerInternal(this.model.getId());
            }
            return;
        }
        this.lastSuccessfulPingEpoch = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
        if (!this.schedulerApplication.getInitializing() || this.schedulerApplication.getJobResource() != null && this.schedulerApplication.getScheduleWorker() != null) {
            new Thread(() -> this.manageServerProcessingEvents()).start();
            new Thread(() -> this.manageServerUtilization()).start();
            new Thread(() -> this.manageServerEnginesWork()).start();
            new Thread(() -> this.manageServerEvents()).start();
            new Thread(() -> this.manageExecutionLogs()).start();
            new Thread(() -> this.manageServerLogs()).start();
            new Thread(() -> this.managerServerWorkflowChanges()).start();
            new Thread(() -> this.manageExpiredCachedWorkflowDetails()).start();
        }
        this.serverTimingLog.addLog(String.valueOf(this.model) + " Ping End\t" + (DateTime.now().getMillis() - startMillis));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void manageServerEvents() {
        block11: {
            boolean lockAvailable = this.manageServerEventsSemaphore.tryAcquire();
            if (lockAvailable) {
                try {
                    String encodedId;
                    LicenceSession licenseSession = this.schedulerApplication.getAutomateLicenceResource().getLicenceSession();
                    if (licenseSession == null) break block11;
                    try {
                        List<EventInfo> eventInfos = this.callApi("/v1/server/session", "GET", new GenericType<List<EventInfo>>(){});
                        this.schedulerApplication.getSessionUtils().trackSessionUtilization(eventInfos);
                        for (EventInfo eventInfo : eventInfos) {
                            if (eventInfo.getType().equals((Object)Type.SESSION_START)) {
                                eventInfo.getProperties().put("keyId", this.schedulerApplication.getAutomateLicenceResource().getRampivaLicence().getDiagnosticKeyId());
                            }
                            licenseSession.tryTrackEventAsync(eventInfo);
                            encodedId = new String(Base64.getEncoder().encode(eventInfo.getId().getBytes(StandardCharsets.UTF_8)));
                            this.callApi("/v1/server/session/" + encodedId, "DELETE", new GenericType<String>(){});
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error(String.valueOf(this.model) + " Cannot handle engine rampivaSession", (Throwable)e);
                    }
                    try {
                        List<Consumption> consumptions = this.callApi("/v1/server/consumption", "GET", new GenericType<List<Consumption>>(){});
                        for (Consumption consumption : consumptions) {
                            licenseSession.tryTrackConsumptionAsync(consumption);
                            encodedId = new String(Base64.getEncoder().encode(consumption.getId().getBytes(StandardCharsets.UTF_8)));
                            this.callApi("/v1/server/consumption/" + encodedId, "DELETE", new GenericType<String>(){});
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error(String.valueOf(this.model) + " Cannot handle engine rampivaSession", (Throwable)e);
                    }
                }
                finally {
                    this.manageServerEventsSemaphore.release();
                }
            }
        }
    }

    private void trackUtilizationRecordsDao(UtilizationRecords utilizationRecords) {
        Set users;
        Set workflows;
        Set sessions;
        Set servers;
        Set resourcePools;
        Set operations;
        List nuixCaseStats;
        Set relativityWorkspaces;
        Set nuixCases;
        Set matters;
        Set set;
        Set executionProfiles;
        Set engines;
        Set transferVolumes;
        Set transfers;
        Set dataSets;
        Set dataRepositories;
        UtilizationDao utilizationDao = this.schedulerApplication.getUtilizationDaoV2();
        ClientResource clientResource = this.schedulerApplication.getClientResource();
        Set clients = utilizationRecords.getClients();
        if (clients != null) {
            for (com.nuix.automate.utils.utilization.Client client : clients) {
                if (clientResource.getClient(client.getClientId()) != null) continue;
                utilizationDao.replaceClient(client);
            }
        }
        if ((dataRepositories = utilizationRecords.getDataRepositories()) != null) {
            for (DataRepository dataRepository : dataRepositories) {
                utilizationDao.replaceDataRepository(dataRepository);
            }
        }
        if ((dataSets = utilizationRecords.getDataSets()) != null) {
            for (DataSet dataSet : dataSets) {
                try {
                    utilizationDao.addDataSet(dataSet);
                }
                catch (StatementException statementException) {}
            }
        }
        if ((transfers = utilizationRecords.getTransfers()) != null) {
            for (Transfer transfer : transfers) {
                try {
                    utilizationDao.addTransfer(transfer);
                }
                catch (StatementException statementException) {}
            }
        }
        if ((transferVolumes = utilizationRecords.getTransferVolumes()) != null) {
            for (TransferVolume transferVolume : transferVolumes) {
                try {
                    utilizationDao.addTransferVolume(transferVolume);
                }
                catch (StatementException statementException) {}
            }
        }
        if ((engines = utilizationRecords.getEngines()) != null) {
            for (Engine engine : engines) {
                utilizationDao.replaceEngine(engine);
            }
        }
        if ((executionProfiles = utilizationRecords.getExecutionProfiles()) != null) {
            for (ExecutionProfile executionProfile : executionProfiles) {
                utilizationDao.replaceExecutionProfile(executionProfile);
            }
        }
        Set<Session> overlappingSessions = this.schedulerApplication.getUtilizationResource().getOverlappingSessionIds(utilizationRecords);
        HashSet<String> overlappingSessionIds = new HashSet<String>();
        HashSet<String> overlappingJobIds = new HashSet<String>();
        for (Session session : overlappingSessions) {
            overlappingSessionIds.add(session.getSessionId());
            overlappingJobIds.add(session.getJobId());
        }
        Set jobs = utilizationRecords.getJobs();
        if (jobs != null) {
            for (com.nuix.automate.utils.utilization.Job job : jobs) {
                if (overlappingJobIds.contains(job.getJobId())) {
                    LOGGER.info("Skipping " + job.getJobId() + " due to overlapping session");
                    continue;
                }
                utilizationDao.replaceJob(job);
                ActivityDetails jobSetupActivity = new ActivityDetails();
                jobSetupActivity.setStartEpoch(job.getJobSubmissionEpoch().longValue());
                jobSetupActivity.setLastEpoch(job.getJobSubmissionEpoch() + 1L);
                jobSetupActivity.setMatterId(job.getMatterId());
                jobSetupActivity.setActivityType(ActivityType.JOB_SETUP);
                jobSetupActivity.setUserId(job.getJobSubmittedByUserId());
                jobSetupActivity.setActivityKey(job.getJobId());
                this.schedulerApplication.getUserResource().trackFinishedActivity(jobSetupActivity, true);
            }
        }
        if ((set = utilizationRecords.getLibraries()) != null) {
            for (Library library : set) {
                utilizationDao.replaceLibrary(library);
            }
        }
        if ((matters = utilizationRecords.getMatters()) != null) {
            for (Matter matter : matters) {
                if (clientResource.getMatter(matter.getMatterId()) != null) continue;
                utilizationDao.replaceMatter(matter);
            }
        }
        if ((nuixCases = utilizationRecords.getNuixCases()) != null) {
            for (NuixCase nuixCase : nuixCases) {
                utilizationDao.replaceNuixCase(nuixCase);
            }
        }
        if ((relativityWorkspaces = utilizationRecords.getRelativityWorkspaces()) != null) {
            for (RelativityWorkspace relativityWorkspace : relativityWorkspaces) {
                utilizationDao.replaceRelativityWorkspace(relativityWorkspace);
            }
        }
        if ((nuixCaseStats = utilizationRecords.getNuixCaseStats()) != null) {
            for (NuixCaseStat nuixCaseStat : nuixCaseStats) {
                utilizationDao.replaceNuixCaseStat(nuixCaseStat);
            }
        }
        if ((operations = utilizationRecords.getOperations()) != null) {
            for (Operation operation : operations) {
                List operationSettings;
                MimeTypeVolume mimeTypeVolume22;
                if (overlappingSessionIds.contains(operation.getSessionId())) {
                    LOGGER.info("Skipping " + operation.getOperationId() + " due to overlapping session");
                    continue;
                }
                utilizationDao.replaceOperation(operation);
                List mimeTypeVolumes = operation.getMimeTypeVolumes();
                if (mimeTypeVolumes != null) {
                    for (MimeTypeVolume mimeTypeVolume22 : mimeTypeVolumes) {
                        utilizationDao.replaceMimeTypeVolume(mimeTypeVolume22);
                    }
                }
                if ((operationSettings = operation.getOperationSettings()) == null) continue;
                mimeTypeVolume22 = operationSettings.iterator();
                while (mimeTypeVolume22.hasNext()) {
                    OperationSetting operationSetting = (OperationSetting)mimeTypeVolume22.next();
                    utilizationDao.replaceOperationSettings(operationSetting);
                }
            }
        }
        if ((resourcePools = utilizationRecords.getResourcePools()) != null) {
            for (ResourcePool resourcePool : resourcePools) {
                utilizationDao.replaceResourcePool(resourcePool);
            }
        }
        if ((servers = utilizationRecords.getServers()) != null) {
            for (com.nuix.automate.utils.utilization.Server server : servers) {
                utilizationDao.replaceServer(server);
            }
        }
        if ((sessions = utilizationRecords.getSessions()) != null) {
            for (Session session : sessions) {
                if (overlappingSessionIds.contains(session.getSessionId())) {
                    LOGGER.info("Skipping " + session.getSessionId() + " due to overlapping session");
                    continue;
                }
                session.setLicenseId(this.schedulerApplication.getLicenceUtils().getLicenceInfo().getId());
                utilizationDao.replaceSession(session);
            }
        }
        if ((workflows = utilizationRecords.getWorkflows()) != null) {
            for (com.nuix.automate.utils.utilization.Workflow workflow : workflows) {
                utilizationDao.replaceWorkflow(workflow);
            }
        }
        if ((users = utilizationRecords.getUsers()) != null) {
            for (User user : users) {
                utilizationDao.replaceUser(user);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void managerServerWorkflowChanges() {
        boolean lockAvailable = this.managerServerWorkflowChangesSemaphore.tryAcquire();
        if (lockAvailable) {
            try {
                Map<String, WorkflowDynamicUpdate> events = this.callApi("/v1/server/workflowDynamicUpdate", "GET", new GenericType<Map<String, WorkflowDynamicUpdate>>(){});
                for (Map.Entry<String, WorkflowDynamicUpdate> entry : events.entrySet()) {
                    String eventId = entry.getKey();
                    WorkflowDynamicUpdate event = entry.getValue();
                    LOGGER.info(String.valueOf(this.model) + " Tracking workflowDynamicUpdate ID " + eventId);
                    this.callApi("/v1/server/workflowDynamicUpdate/" + eventId, "DELETE", new GenericType<String>(){});
                    try {
                        try {
                            this.schedulerApplication.getLoggingResource().getActiveLoggingDao().addComponentHistory(event.getWorkflowId(), event.getOriginalVersion(), HistoryComponentType.WORKFLOW_DYNAMIC_UPDATE, event.getWorkflowXml(), event.getUpdateDate());
                        }
                        catch (Exception e) {
                            this.schedulerApplication.getLoggingResource().getActiveLoggingDao().updateComponentHistoryIfNewer(event.getWorkflowId(), event.getOriginalVersion(), HistoryComponentType.WORKFLOW_DYNAMIC_UPDATE, event.getWorkflowXml(), event.getUpdateDate());
                        }
                        try {
                            this.schedulerApplication.getLoggingResource().getActiveLoggingDao().addJobHistory(event.getJobId(), event.getWorkflowId(), event.getOriginalVersion(), event.getUpdateDate());
                        }
                        catch (Exception e) {
                            this.schedulerApplication.getLoggingResource().getActiveLoggingDao().updateJobHistory(event.getJobId(), event.getUpdateDate());
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("Cannot handle history log", (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error(String.valueOf(this.model) + " Cannot handle engine processing events", (Throwable)e);
            }
            finally {
                this.managerServerWorkflowChangesSemaphore.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void manageServerProcessingEvents() {
        boolean lockAvailable = this.manageServerProcessingEventsSemaphore.tryAcquire();
        if (lockAvailable) {
            try {
                Map<String, JobOperationEvent> events = this.callApi("/v1/server/processingEvents", "GET", new GenericType<Map<String, JobOperationEvent>>(){});
                for (Map.Entry<String, JobOperationEvent> entry : events.entrySet()) {
                    String eventId = entry.getKey();
                    JobOperationEvent event = entry.getValue();
                    LOGGER.info(String.valueOf(this.model) + " Tracking processingEvent ID " + eventId);
                    this.callApi("/v1/server/processingEvents/" + eventId, "DELETE", new GenericType<String>(){});
                    SchedulerApplication.getInstance().getWebhookWorker().triggerEvent(event.getEventType(), event.getOperationStatus());
                }
            }
            catch (Exception e) {
                LOGGER.error(String.valueOf(this.model) + " Cannot handle engine processing events", (Throwable)e);
            }
            finally {
                this.manageServerProcessingEventsSemaphore.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void manageServerUtilization() {
        boolean lockAvailable = this.manageServerUtilizationSemaphore.tryAcquire();
        if (lockAvailable) {
            try {
                LicenceSession licenseSession = this.schedulerApplication.getAutomateLicenceResource().getLicenceSession();
                UtilizationDao utilizationDao = this.schedulerApplication.getUtilizationDaoV2();
                UtilizationRecords utilizationRecords = new UtilizationRecords();
                utilizationRecords.setId(UidUtils.getRandom());
                boolean hasUtilizationData = false;
                try {
                    List<OperationUtilizationModel> operationsUtilization = this.callApi("/v1/server/utilization", "GET", new GenericType<List<OperationUtilizationModel>>(){});
                    for (OperationUtilizationModel operationUtilizationModel : operationsUtilization) {
                        RelativityWorkspace relativityWorkspace;
                        LOGGER.info(String.valueOf(this.model) + " Tracking utilization ID " + operationUtilizationModel.getUtilizationId());
                        this.callApi("/v1/server/utilization/" + operationUtilizationModel.getUtilizationId(), "DELETE", new GenericType<String>(){});
                        NuixCase nuixCase = operationUtilizationModel.getNuixCase();
                        if (nuixCase != null) {
                            HashSet<NuixCase> nuixCases = utilizationRecords.getNuixCases();
                            if (nuixCases == null) {
                                nuixCases = new HashSet<NuixCase>();
                                utilizationRecords.setNuixCases(nuixCases);
                            }
                            nuixCases.add(nuixCase);
                            hasUtilizationData = true;
                            utilizationDao.replaceNuixCase(nuixCase);
                        }
                        if ((relativityWorkspace = operationUtilizationModel.getRelativityWorkspace()) != null) {
                            HashSet<RelativityWorkspace> relativityWorkspaces = utilizationRecords.getRelativityWorkspaces();
                            if (relativityWorkspaces == null) {
                                relativityWorkspaces = new HashSet<RelativityWorkspace>();
                                utilizationRecords.setRelativityWorkspaces(relativityWorkspaces);
                            }
                            relativityWorkspaces.add(relativityWorkspace);
                            hasUtilizationData = true;
                            utilizationDao.replaceRelativityWorkspace(relativityWorkspace);
                        }
                        try {
                            HashSet<Operation> operations;
                            List mimeTypes;
                            UtilizationRecords operationUtilizationRecords;
                            Operation operation = operationUtilizationModel.getOperation();
                            utilizationDao.replaceOperation(operation);
                            if (operation.getMimeTypeVolumes() != null) {
                                for (MimeTypeVolume mimeTypeVolume : operation.getMimeTypeVolumes()) {
                                    utilizationDao.replaceMimeTypeVolume(mimeTypeVolume);
                                }
                            }
                            if (operation.getOperationSettings() != null) {
                                for (OperationSetting operationSetting : operation.getOperationSettings()) {
                                    utilizationDao.replaceOperationSettings(operationSetting);
                                }
                            }
                            if ((operationUtilizationRecords = operation.getUtilizationRecords()) != null) {
                                this.trackUtilizationRecordsDao(operationUtilizationRecords);
                            }
                            if ((mimeTypes = operationUtilizationModel.getMimeTypes()) != null) {
                                try {
                                    utilizationDao.addMimeTypes(mimeTypes);
                                }
                                catch (StatementException statementException) {
                                    // empty catch block
                                }
                            }
                            if ((operations = utilizationRecords.getOperations()) == null) {
                                operations = new HashSet<Operation>();
                                utilizationRecords.setOperations(operations);
                            }
                            operations.add(operation);
                            hasUtilizationData = true;
                        }
                        catch (StatementException e) {
                            LOGGER.error("Cannot handle operation " + operationUtilizationModel.getOperation().getOperationId() + " utilization", (Throwable)e);
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.error(String.valueOf(this.model) + " Cannot handle engine utilization", (Throwable)e);
                }
                if (hasUtilizationData) {
                    licenseSession.tryTrackUtilizationRecordsAsync(utilizationRecords);
                }
            }
            finally {
                this.manageServerUtilizationSemaphore.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void manageServerLogs() {
        block11: {
            if (!this.schedulerApplication.getConfiguration().getEnableCentralizedLogging()) {
                return;
            }
            boolean lockAvailable = this.manageServerLogsSemaphore.tryAcquire();
            if (lockAvailable) {
                try {
                    LogHandler handler = LogHandler.getInstance();
                    if (handler == null) break block11;
                    if (this.lastSeenLogIds == null) {
                        this.lastSeenLogIds = new HashSet<String>();
                    }
                    Set<String> currentSeenIds = this.lastSeenLogIds;
                    try {
                        List<ServerLogEventsModel> serverLogEvents = this.callApi("/v1/server/logs", "GET", new GenericType<List<ServerLogEventsModel>>(){});
                        if (serverLogEvents != null) {
                            currentSeenIds = new HashSet<String>();
                            for (ServerLogEventsModel serverLogEvent : serverLogEvents) {
                                if (!this.lastSeenLogIds.contains(serverLogEvent.getId())) {
                                    handler.addLogEvents(serverLogEvent.getLogs());
                                }
                                currentSeenIds.add(serverLogEvent.getId());
                                this.callApi("/v1/server/logs/" + serverLogEvent.getId(), "DELETE", new GenericType<String>(){});
                            }
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error(String.valueOf(this.model) + " cannot handle server logs", (Throwable)e);
                    }
                    this.lastSeenLogIds = currentSeenIds;
                }
                finally {
                    this.manageServerLogsSemaphore.release();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void manageExecutionLogs() {
        boolean lockAvailable = this.manageExecutionLogsSemaphore.tryAcquire();
        if (lockAvailable) {
            try {
                List<ServerLogEventsModel> serverExecutionLogEvents = this.callApi("/v1/server/logs/executionLogs", "GET", new GenericType<List<ServerLogEventsModel>>(){});
                if (serverExecutionLogEvents != null) {
                    for (ServerLogEventsModel serverExecutionLogEvent : serverExecutionLogEvents) {
                        this.schedulerApplication.getJobsDao().addRawJobExecutionLogs(serverExecutionLogEvent.getLogs());
                        this.callApi("/v1/server/logs/" + serverExecutionLogEvent.getId(), "DELETE", new GenericType<String>(){});
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error(String.valueOf(this.model) + " cannot handle execution logs", (Throwable)e);
            }
            finally {
                this.manageExecutionLogsSemaphore.release();
            }
        }
    }

    private void manageOperationMimeTypeStats(EngineModel engineModel) {
        try {
            Iterator<OperationMimeTypeStats> iterator;
            List<OperationMimeTypeStats> operationMimeTypeStats = this.callApi("/v1/server/engines/" + engineModel.getId() + "/operationMimeTypeStats", "GET", new GenericType<List<OperationMimeTypeStats>>(){});
            JobOperationMimeTypeStats processingJobStats = new JobOperationMimeTypeStats();
            String jobId = null;
            if (operationMimeTypeStats != null && operationMimeTypeStats.size() > 0 && (iterator = operationMimeTypeStats.iterator()).hasNext()) {
                OperationMimeTypeStats operationMimeTypeStat = iterator.next();
                jobId = operationMimeTypeStat.getJobId();
            }
            if (jobId != null) {
                processingJobStats.setJobId(jobId);
                processingJobStats.setMimeTypeStats(operationMimeTypeStats);
                if (this.schedulerApplication.getJobsDao().updateJobOperationsMimeTypeStats(processingJobStats) == 0) {
                    this.schedulerApplication.getJobsDao().addJobOperationsMimeTypeStats(processingJobStats);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(String.valueOf(this.model) + " - " + String.valueOf(engineModel) + " Cannot handle operation mime type stats", (Throwable)e);
        }
    }

    private void manageOperationRunningLog(EngineModel engineModel) {
        try {
            RunningLogEventsModel runningLog = this.callApi("/v1/server/engines/" + engineModel.getId() + "/runningLog", "GET", new GenericType<RunningLogEventsModel>(){});
            if (runningLog != null && runningLog.getJobId() != null && runningLog.getRunningLogs() != null) {
                this.schedulerApplication.getJobResource().setJobRunningLog(runningLog.getJobId(), runningLog);
            }
        }
        catch (Exception e) {
            LOGGER.error(String.valueOf(this.model) + " - " + String.valueOf(engineModel) + " Cannot handle operation running log", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void manageExpiredCachedWorkflowDetails() {
        boolean lockAvailable = this.manageExpiredCachedWorkflowDetailsSemaphore.tryAcquire();
        if (lockAvailable) {
            try {
                if (this.model.getStatus() == ServerStatus.INITIALIZED && this.model.getOnlineSince() != null) {
                    long remainingWarmUpMs = this.model.getOnlineSince() + this.schedulerApplication.getConfiguration().getEngineTimeout() - new DateTime(DateTimeZone.UTC).getMillis();
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Server has " + remainingWarmUpMs + " remaining warm-up ms");
                    }
                    if (remainingWarmUpMs <= 0L) {
                        this.schedulerApplication.getJobResource().removeExpiredEntriesForServers(this.model.getId());
                    }
                }
            }
            finally {
                this.manageExpiredCachedWorkflowDetailsSemaphore.release();
            }
        }
    }

    public void reloadEnginesFromServer() throws ServerException {
        try {
            List<EngineModel> result = this.callApi("/v1/server/engines", "GET", new GenericType<List<EngineModel>>(){});
            ConcurrentHashMap<String, EngineModel> newEngineModels = new ConcurrentHashMap<String, EngineModel>();
            for (EngineModel engineModel : result) {
                if (engineModel == null || engineModel.getId() == null) continue;
                newEngineModels.put(engineModel.getId(), engineModel);
            }
            this.engineModels = newEngineModels;
            for (EngineModel newEngine : newEngineModels.values()) {
                com.nuix.automate.utils.models.api.engine.Engine eventResult;
                if (newEngine.getStatus().equals((Object)EngineStatus.ERROR)) {
                    if (newEngine.getError() != null && newEngine.getError().contains(this.iu.getString("RemoteEngine.Error.LicenseDoesNotSupportOperation"))) {
                        LOGGER.info(String.valueOf(newEngine) + " license " + newEngine.getNuixLicenceSourceId() + " cannot be used for remote workers on config " + this.engineRunningConfiguration.get(newEngine.getId()));
                        String runningConfiguration = this.engineRunningConfiguration.get(newEngine.getId());
                        if (runningConfiguration != null) {
                            this.unsuccessfullRemoteWorkerConfigurations.add(runningConfiguration);
                        }
                    }
                    String newErrorMessage = newEngine.getError();
                    String previousErrorMessage = this.previousEngineErrors.get(newEngine.getId());
                    if (previousErrorMessage != null || newErrorMessage == null) continue;
                    this.previousEngineErrors.put(newEngine.getId(), newErrorMessage);
                    eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions((BearerUser)new SystemBearerUser(), newEngine);
                    this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.ENGINE_ERROR, eventResult);
                    continue;
                }
                if (newEngine.getStatus().equals((Object)EngineStatus.WARNING)) {
                    String newWarningMessage = newEngine.getError();
                    String previousWarningMessage = this.previousEngineWarnings.get(newEngine.getId());
                    if (previousWarningMessage != null || newWarningMessage == null) continue;
                    this.previousEngineWarnings.put(newEngine.getId(), newWarningMessage);
                    if (!newWarningMessage.trim().startsWith("Nuix Engine license cannot be acquired")) continue;
                    eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions((BearerUser)new SystemBearerUser(), newEngine);
                    this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.ENGINE_LICENSE_ERROR, eventResult);
                    continue;
                }
                if (newEngine.getStatus().equals((Object)EngineStatus.INITIALIZING) || newEngine.getStatus().equals((Object)EngineStatus.NOT_INITIALIZED)) continue;
                this.previousEngineErrors.remove(newEngine.getId());
                this.previousEngineWarnings.remove(newEngine.getId());
            }
        }
        catch (Exception e) {
            LOGGER.warn("Cannot refresh Engines from server", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void manageServerEnginesWork() {
        long startMillis = DateTime.now().getMillis();
        boolean lockAvailable = this.manageServerEnginesWorkSemaphore.tryAcquire();
        if (lockAvailable) {
            try {
                this.reloadEnginesFromServer();
                this.engineModels.entrySet().parallelStream().forEach(entry -> {
                    block61: {
                        try {
                            EngineCommand engineCommand;
                            EngineCommand engineCommand2;
                            JobDetailsModel localJobDetailsModel;
                            EngineModel engineModel = (EngineModel)entry.getValue();
                            this.serverTimingLog.addLog(String.valueOf(this.model) + " " + String.valueOf(engineModel) + " Start\t" + (DateTime.now().getMillis() - startMillis));
                            if (engineModel == null) break block61;
                            if ((engineModel.getStatus() == EngineStatus.PENDING || engineModel.getStatus() == EngineStatus.INITIALIZING || engineModel.getStatus() == EngineStatus.RUNNING) && engineModel.getWorkerAgentOnly() && engineModel.getRunningJobId() != null) {
                                boolean stopRunning = false;
                                String runningJobId = engineModel.getRunningJobId();
                                localJobDetailsModel = this.schedulerApplication.getJobResource().getJobDetailsModel(runningJobId);
                                if (localJobDetailsModel == null) {
                                    LOGGER.warn(String.valueOf(engineModel) + " running " + runningJobId + " disappeared " + String.valueOf(engineModel));
                                    stopRunning = true;
                                } else if (localJobDetailsModel.getSettings().getExecutionState() != ExecutionState.RUNNING) {
                                    LOGGER.info(String.valueOf(engineModel) + " running " + String.valueOf(localJobDetailsModel) + " changed state to " + localJobDetailsModel.getSettings().getExecutionState().name());
                                    stopRunning = true;
                                } else if (!this.schedulerApplication.getJobResource().jobUsesWorkers(localJobDetailsModel)) {
                                    LOGGER.info(String.valueOf(engineModel) + " running " + String.valueOf(localJobDetailsModel) + " is not running a worker-based operation anymore");
                                    stopRunning = true;
                                } else {
                                    for (OperationStatus operationStatus : localJobDetailsModel.getOperations()) {
                                        if (!operationStatus.getExecutionState().equals((Object)ExecutionState.RUNNING)) continue;
                                        localJobDetailsModel.getSettings().setRunningOperationStatus(operationStatus);
                                    }
                                    String newConfiguration = this.getConfiguration(engineModel.getId(), localJobDetailsModel);
                                    String runningConfiguration = this.engineRunningConfiguration.get(engineModel.getId());
                                    if (!runningConfiguration.equals(newConfiguration)) {
                                        LOGGER.info(String.valueOf(engineModel) + " running " + String.valueOf(localJobDetailsModel) + " changed to a new type of operation");
                                        stopRunning = true;
                                    }
                                }
                                if (stopRunning) {
                                    engineCommand2 = new EngineCommand();
                                    if (engineModel.getStatus() == EngineStatus.PENDING || engineModel.getStatus() == EngineStatus.INITIALIZING) {
                                        engineCommand2.setCommand(Command.SHUTDOWN);
                                        this.serverTimingLog.addLog(String.valueOf(this.model) + " " + String.valueOf(engineModel) + " Call shutdown\t" + (DateTime.now().getMillis() - startMillis));
                                        try {
                                            engineModel = this.callApi("/v1/server/engines/" + engineModel.getId() + "/command", "PUT", engineCommand2, new GenericType<EngineModel>(){});
                                        }
                                        catch (ServerException e) {
                                            LOGGER.error("Cannot send " + String.valueOf(this.model) + " command " + String.valueOf(engineCommand2), (Throwable)e);
                                        }
                                        this.serverTimingLog.addLog(String.valueOf(this.model) + " " + String.valueOf(engineModel) + " Call done\t" + (DateTime.now().getMillis() - startMillis));
                                        entry.setValue(engineModel);
                                    } else if (engineModel.getStatus() == EngineStatus.RUNNING) {
                                        engineCommand2.setCommand(Command.SLEEP);
                                        this.serverTimingLog.addLog(String.valueOf(this.model) + " " + String.valueOf(engineModel) + " Call sleep\t" + (DateTime.now().getMillis() - startMillis));
                                        try {
                                            engineModel = this.callApi("/v1/server/engines/" + engineModel.getId() + "/command", "PUT", engineCommand2, new GenericType<EngineModel>(){});
                                        }
                                        catch (ServerException e) {
                                            LOGGER.error("Cannot send " + String.valueOf(this.model) + " command " + String.valueOf(engineCommand2), (Throwable)e);
                                        }
                                        this.serverTimingLog.addLog(String.valueOf(this.model) + " " + String.valueOf(engineModel) + " Call done\t" + (DateTime.now().getMillis() - startMillis));
                                        entry.setValue(engineModel);
                                    }
                                }
                            }
                            if (!(engineModel.getWorkerAgentOnly() || engineModel.getBootstrappingJobId() == null || engineModel.getStatus() != EngineStatus.PENDING && engineModel.getStatus() != EngineStatus.INITIALIZING)) {
                                boolean cancelBootstrapping = false;
                                String pendingJobId = engineModel.getBootstrappingJobId();
                                localJobDetailsModel = this.schedulerApplication.getJobResource().getJobDetailsModel(pendingJobId);
                                if (localJobDetailsModel == null) {
                                    LOGGER.warn(pendingJobId + " disappeared before " + String.valueOf(engineModel) + " could initialize");
                                    cancelBootstrapping = true;
                                } else if (localJobDetailsModel.getSettings().getExecutionState() != ExecutionState.NOT_STARTED && localJobDetailsModel.getSettings().getExecutionState() != ExecutionState.PAUSED && localJobDetailsModel.getSettings().getExecutionState() != ExecutionState.PENDING) {
                                    LOGGER.warn(String.valueOf(localJobDetailsModel) + " changed state to " + localJobDetailsModel.getSettings().getExecutionState().name() + " before " + String.valueOf(engineModel) + " could initialize");
                                    cancelBootstrapping = true;
                                } else if (!engineModel.getId().equals(localJobDetailsModel.getSettings().getEngineId())) {
                                    LOGGER.warn(String.valueOf(localJobDetailsModel) + " switched to different engine " + localJobDetailsModel.getSettings().getEngineId() + " before " + String.valueOf(engineModel) + " could initialize");
                                    cancelBootstrapping = true;
                                } else {
                                    String currentResourcePoolId = localJobDetailsModel.getSettings().getResourcePoolId();
                                    if (currentResourcePoolId == null) {
                                        LOGGER.warn(String.valueOf(localJobDetailsModel) + " was unassigned from Resource Pool before " + String.valueOf(engineModel) + " could initialize");
                                        cancelBootstrapping = true;
                                    } else {
                                        ResourcePoolModel currentResourcePool = this.schedulerApplication.getResourcePoolResource().getResourcePool(currentResourcePoolId);
                                        if (currentResourcePool == null) {
                                            LOGGER.warn(String.valueOf(localJobDetailsModel) + " was Resource Pool " + currentResourcePoolId + " was deleted before " + String.valueOf(engineModel) + " could initialize");
                                            cancelBootstrapping = true;
                                        } else if (!currentResourcePool.isCloud() && !currentResourcePool.getEngineIds().contains(engineModel.getId())) {
                                            LOGGER.warn(String.valueOf(localJobDetailsModel) + " Resource Pool " + String.valueOf(currentResourcePool) + " had engine removed before " + String.valueOf(engineModel) + " could initialize");
                                            cancelBootstrapping = true;
                                        } else if (!currentResourcePool.getActive().booleanValue()) {
                                            LOGGER.warn(String.valueOf(localJobDetailsModel) + " Resource Pool " + String.valueOf(currentResourcePool) + " was deactivated before " + String.valueOf(engineModel) + " could initialize");
                                            cancelBootstrapping = true;
                                        }
                                    }
                                }
                                if (cancelBootstrapping) {
                                    LOGGER.info("Rebootstrapping " + pendingJobId);
                                    this.schedulerApplication.getJobResource().clearJobBootstrapState(pendingJobId);
                                    engineCommand2 = new EngineCommand();
                                    engineCommand2.setCommand(Command.SHUTDOWN);
                                    LOGGER.info(String.valueOf(this.model) + " " + String.valueOf(engineModel) + ", initializing");
                                    this.serverTimingLog.addLog(String.valueOf(this.model) + " " + String.valueOf(engineModel) + " Call rebootstrapping\t" + (DateTime.now().getMillis() - startMillis));
                                    try {
                                        engineModel = this.callApi("/v1/server/engines/" + engineModel.getId() + "/command", "PUT", engineCommand2, new GenericType<EngineModel>(){});
                                    }
                                    catch (ServerException e) {
                                        LOGGER.error("Cannot send " + String.valueOf(engineCommand2) + " " + String.valueOf(engineCommand2), (Throwable)e);
                                    }
                                    this.serverTimingLog.addLog(String.valueOf(this.model) + " " + String.valueOf(engineModel) + " Call done\t" + (DateTime.now().getMillis() - startMillis));
                                    entry.setValue(engineModel);
                                }
                            }
                            if (!engineModel.getWorkerAgentOnly() && engineModel.getStatus() == EngineStatus.PENDING) {
                                try {
                                    this.serverTimingLog.addLog(String.valueOf(this.model) + " " + String.valueOf(engineModel) + " Get Pending Job Details\t" + (DateTime.now().getMillis() - startMillis));
                                    JobDetailsModel jobDetailsModel = this.callApi("/v1/server/engines/" + engineModel.getId() + "/jobDetails", "GET", new GenericType<JobDetailsModel>(){});
                                    this.serverTimingLog.addLog(String.valueOf(this.model) + " " + String.valueOf(engineModel) + " Get Done\t" + (DateTime.now().getMillis() - startMillis));
                                    if (jobDetailsModel != null && jobDetailsModel.getSettings() != null) {
                                        engineCommand = new EngineCommand();
                                        engineCommand.setCommand(Command.RUN_BOOTSTRAPPED_JOB);
                                        LOGGER.info(String.valueOf(this.model) + " " + String.valueOf(engineModel) + ", running bootstrapped job");
                                        this.serverTimingLog.addLog(String.valueOf(this.model) + " " + String.valueOf(engineModel) + " Run Bootstrapped Job\t" + (DateTime.now().getMillis() - startMillis));
                                        engineModel = this.callApi("/v1/server/engines/" + engineModel.getId() + "/command", "PUT", engineCommand, new GenericType<EngineModel>(){});
                                        this.serverTimingLog.addLog(String.valueOf(this.model) + " " + String.valueOf(engineModel) + " Run Done\t" + (DateTime.now().getMillis() - startMillis));
                                        entry.setValue(engineModel);
                                        this.schedulerApplication.getJobResource().moveJobFromPendingToExecution(jobDetailsModel, "N/A");
                                        jobDetailsModel.getSettings().setEngineId(engineModel.getId());
                                        jobDetailsModel.getSettings().setServerId(engineModel.getServerId());
                                        this.schedulerApplication.getJobResource().putRunningJob(jobDetailsModel);
                                    } else {
                                        engineCommand = new EngineCommand();
                                        engineCommand.setCommand(Command.ABORT);
                                        LOGGER.info(String.valueOf(this.model) + " " + String.valueOf(engineModel) + ", aborting");
                                        this.serverTimingLog.addLog(String.valueOf(this.model) + " " + String.valueOf(engineModel) + " Abort\t" + (DateTime.now().getMillis() - startMillis));
                                        engineModel = this.callApi("/v1/server/engines/" + engineModel.getId() + "/command", "PUT", engineCommand, new GenericType<EngineModel>(){});
                                        this.serverTimingLog.addLog(String.valueOf(this.model) + " " + String.valueOf(engineModel) + " Abort Done\t" + (DateTime.now().getMillis() - startMillis));
                                        entry.setValue(engineModel);
                                    }
                                }
                                catch (ServerException e1) {
                                    LOGGER.error("Cannot handle pending job", (Throwable)e1);
                                }
                            }
                            if (engineModel.getStatus() == EngineStatus.ERROR || engineModel.getStatus() == EngineStatus.WARNING) {
                                try {
                                    String runningJobId = engineModel.getRunningJobId();
                                    if (runningJobId != null) {
                                        if (!engineModel.getWorkerAgentOnly()) {
                                            LOGGER.info(String.valueOf(engineModel) + " cannot bootstrap job " + runningJobId);
                                            this.schedulerApplication.getJobResource().clearJobBootstrapState(runningJobId);
                                        }
                                        engineCommand = new EngineCommand();
                                        engineCommand.setCommand(Command.SHUTDOWN);
                                        LOGGER.info(String.valueOf(this.model) + " " + String.valueOf(engineModel) + ", shutting down");
                                        this.serverTimingLog.addLog(String.valueOf(this.model) + " " + String.valueOf(engineModel) + " Shutdown\t" + (DateTime.now().getMillis() - startMillis));
                                        engineModel = this.callApi("/v1/server/engines/" + engineModel.getId() + "/command", "PUT", engineCommand, new GenericType<EngineModel>(){});
                                        this.serverTimingLog.addLog(String.valueOf(this.model) + " " + String.valueOf(engineModel) + " Shutdown Done\t" + (DateTime.now().getMillis() - startMillis));
                                        entry.setValue(engineModel);
                                    }
                                }
                                catch (ServerException e1) {
                                    this.serverTimingLog.addLog(String.valueOf(this.model) + " " + String.valueOf(engineModel) + " Cannot handle pending job\t" + (DateTime.now().getMillis() - startMillis));
                                    LOGGER.error("Cannot handle pending job", (Throwable)e1);
                                }
                            }
                            if (engineModel.getStatus() == EngineStatus.RUNNING) {
                                try {
                                    if (!engineModel.getWorkerAgentOnly()) {
                                        this.serverTimingLog.addLog(String.valueOf(this.model) + " " + String.valueOf(engineModel) + " Get Running Job Details\t" + (DateTime.now().getMillis() - startMillis));
                                        JobDetailsModel jobDetailsModel = this.callApi("/v1/server/engines/" + engineModel.getId() + "/jobDetails", "GET", new GenericType<JobDetailsModel>(){});
                                        this.serverTimingLog.addLog(String.valueOf(this.model) + " " + String.valueOf(engineModel) + " Get Done\t" + (DateTime.now().getMillis() - startMillis));
                                        if (jobDetailsModel != null) {
                                            this.handleJobWarnings(jobDetailsModel);
                                            jobDetailsModel.getSettings().setEngineId(engineModel.getId());
                                            jobDetailsModel.getSettings().setServerId(engineModel.getServerId());
                                            this.schedulerApplication.getJobResource().putRunningJob(jobDetailsModel);
                                        }
                                        this.manageOperationMimeTypeStats(engineModel);
                                        this.manageOperationRunningLog(engineModel);
                                    }
                                }
                                catch (ServerException e1) {
                                    LOGGER.error("Cannot handle running job", (Throwable)e1);
                                }
                            }
                            if (engineModel.getStatus() == EngineStatus.FINISHED) {
                                LOGGER.info(String.valueOf(this.model) + " " + String.valueOf(engineModel) + " finished running job, getting details");
                                try {
                                    if (!engineModel.getWorkerAgentOnly()) {
                                        LOGGER.info(String.valueOf(this.model) + " " + String.valueOf(engineModel) + " getting finished job details");
                                        this.serverTimingLog.addLog(String.valueOf(this.model) + " " + String.valueOf(engineModel) + " Get Finished Job Details\t" + (DateTime.now().getMillis() - startMillis));
                                        JobDetailsModel workflowDetailsModel = this.callApi("/v1/server/engines/" + engineModel.getId() + "/jobDetails", "GET", new GenericType<JobDetailsModel>(){});
                                        this.serverTimingLog.addLog(String.valueOf(this.model) + " " + String.valueOf(engineModel) + " Get Done\t" + (DateTime.now().getMillis() - startMillis));
                                        if (workflowDetailsModel != null) {
                                            workflowDetailsModel.getSettings().setEngineId(engineModel.getId());
                                            workflowDetailsModel.getSettings().setServerId(engineModel.getServerId());
                                            workflowDetailsModel.getSettings().setLastStateChangedDate(Long.valueOf(new DateTime(DateTimeZone.UTC).getMillis()));
                                            this.manageOperationMimeTypeStats(engineModel);
                                            this.manageOperationRunningLog(engineModel);
                                            if (workflowDetailsModel.getSettings().getExecutionState() == ExecutionState.PAUSED) {
                                                this.schedulerApplication.getJobResource().movePausedJobToStaging(workflowDetailsModel, "N/A");
                                            } else {
                                                this.clearJobWarnings(workflowDetailsModel);
                                                JobModel jobSettings = workflowDetailsModel.getSettings();
                                                if (jobSettings.getError() != null && jobSettings.getError().length() > 0) {
                                                    jobSettings.setExecutionState(ExecutionState.ERROR);
                                                }
                                                if (jobSettings.getExecutionState() == ExecutionState.STOPPING) {
                                                    jobSettings.setExecutionState(ExecutionState.STOPPED);
                                                }
                                                if (jobSettings.getExecutionState() == ExecutionState.FINISHED) {
                                                    this.handledJobOperationsProgressWeight(workflowDetailsModel);
                                                }
                                                this.schedulerApplication.getJobResource().putFinishedJob(workflowDetailsModel, "N/A");
                                            }
                                        }
                                    }
                                    EngineCommand engineCommand3 = new EngineCommand();
                                    engineCommand3.setCommand(Command.SLEEP);
                                    LOGGER.info(String.valueOf(this.model) + " " + String.valueOf(engineModel) + ", switching to sleep mode");
                                    this.serverTimingLog.addLog(String.valueOf(this.model) + " " + String.valueOf(engineModel) + " Sending Sleep\t" + (DateTime.now().getMillis() - startMillis));
                                    engineModel = this.callApi("/v1/server/engines/" + engineModel.getId() + "/command", "PUT", engineCommand3, new GenericType<EngineModel>(){});
                                    this.serverTimingLog.addLog(String.valueOf(this.model) + " " + String.valueOf(engineModel) + " Send Done\t" + (DateTime.now().getMillis() - startMillis));
                                    entry.setValue(engineModel);
                                }
                                catch (ServerException e1) {
                                    LOGGER.error("Cannot handle completed job", (Throwable)e1);
                                }
                            }
                            this.serverTimingLog.addLog(String.valueOf(this.model) + " " + String.valueOf(engineModel) + " End\t" + (DateTime.now().getMillis() - startMillis));
                        }
                        catch (Exception e3) {
                            LOGGER.error("Cannot handle Engine work", (Throwable)e3);
                            this.serverTimingLog.addLog(String.valueOf(this.model) + " Engine Error\t" + (DateTime.now().getMillis() - startMillis));
                        }
                    }
                });
            }
            catch (ServerException e2) {
                LOGGER.error("Cannot handle server work", (Throwable)e2);
                this.serverTimingLog.addLog(String.valueOf(this.model) + " Server Error\t" + (DateTime.now().getMillis() - startMillis));
            }
            finally {
                this.manageServerEnginesWorkSemaphore.release();
            }
        }
    }

    private void handledJobOperationsProgressWeight(JobDetailsModel jobDetailsModel) {
        try {
            ExecutionProfileModel executionProfileModel = this.schedulerApplication.getExecutionProfileResource().getExecutionProfile(jobDetailsModel.getSettings().getExecutionProfileId());
            if (executionProfileModel != null && executionProfileModel.getJobProgressSettings() != null) {
                Double updateWeight = executionProfileModel.getJobProgressSettings().getUpdateOperationsProgressWeightLastRunWeightPercentage();
                if (updateWeight != null) {
                    String workflowId = jobDetailsModel.getSettings().getLibraryWorkflowId();
                    Workflow workflow = this.schedulerApplication.getLibraryResource().getLibraryWorkflow(workflowId);
                    if (workflow != null) {
                        if (jobDetailsModel.getSettings().getSubmittedDate() != null && jobDetailsModel.getSettings().getSubmittedDate() > workflow.getLastModified()) {
                            this.updateWorkflowOperationsWeights(workflowId, jobDetailsModel, updateWeight / 100.0);
                        } else {
                            LOGGER.info("Skip updating operation weights because workflow " + workflowId + " was modified at " + workflow.getLastModified() + " after the job was submitted at " + jobDetailsModel.getSettings().getSubmittedDate());
                        }
                    } else {
                        LOGGER.info("Skip updating operation weights because workflow " + workflowId + " does not exist");
                    }
                } else {
                    LOGGER.info("Skip updating operation weights because execution profile " + executionProfileModel.getId() + " does not have option enabled");
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Cannot handle job operations progress weights update", (Throwable)e);
        }
    }

    private void updateWorkflowOperationsWeights(String workflowId, JobDetailsModel jobDetailsModel, double executionProfileWeight) throws IOException {
        ArrayList<Double> normalizedWeights = new ArrayList<Double>();
        double totalTimeMs = 0.0;
        for (OperationStatus operationStatus : jobDetailsModel.getOperations()) {
            if (operationStatus.getStartedDate() == null || operationStatus.getFinishedDate() == null) continue;
            totalTimeMs += (double)(operationStatus.getFinishedDate() - operationStatus.getStartedDate());
        }
        if (totalTimeMs == 0.0) {
            LOGGER.info("Skip updating operation weights because total time is 0");
            return;
        }
        for (OperationStatus operationStatus : jobDetailsModel.getOperations()) {
            double operationWeight = 1.0;
            if (operationStatus.getFinishedDate() != null && operationStatus.getStartedDate() != null) {
                operationWeight = (double)(operationStatus.getFinishedDate() - operationStatus.getStartedDate()) / totalTimeMs;
                LOGGER.debug("Operation " + operationStatus.getName() + " run time: " + (operationStatus.getFinishedDate() - operationStatus.getStartedDate()) + " of total time: " + totalTimeMs + " total operations: " + jobDetailsModel.getOperations().size() + ", weight: " + (operationWeight *= (double)jobDetailsModel.getOperations().size()));
            } else {
                LOGGER.debug("Operation " + operationStatus.getName() + ", weight: " + operationWeight);
            }
            normalizedWeights.add(operationWeight);
        }
        this.schedulerApplication.getLibraryResource().updateWorkflowWeights(workflowId, normalizedWeights, executionProfileWeight);
    }

    private void handleJobWarnings(JobDetailsModel jobDetailsModel) {
        Job processingJob;
        String jobId = jobDetailsModel.getSettings().getId();
        if (!this.jobWarnings.containsKey(jobId)) {
            this.jobWarnings.put(jobId, new HashSet());
        }
        if (!this.jobSoftErrors.containsKey(jobId)) {
            this.jobSoftErrors.put(jobId, new HashSet());
        }
        if (!this.jobInfos.containsKey(jobId)) {
            this.jobInfos.put(jobId, new HashSet());
        }
        Set<String> previousJobWarnings = this.jobWarnings.get(jobId);
        Set<String> previousJobSoftErrors = this.jobSoftErrors.get(jobId);
        Set<String> previousJobInfos = this.jobInfos.get(jobId);
        LinkedHashSet<Object> currentJobWarnings = new LinkedHashSet<Object>();
        LinkedHashSet<Object> currentJobSoftErrors = new LinkedHashSet<Object>();
        LinkedHashSet<String> currentJobInfos = new LinkedHashSet<String>();
        ArrayList<String> additionalWarningsProperties = new ArrayList<String>();
        ArrayList<String> additionalSoftErrorsProperties = new ArrayList<String>();
        ArrayList<String> additionalInfoProperties = new ArrayList<String>();
        ArrayList<String> resovledWarningsProperties = new ArrayList<String>();
        for (String string : jobDetailsModel.getSettings().getWarnings()) {
            if (previousJobWarnings.contains(string)) continue;
            currentJobWarnings.add(string);
        }
        for (String string : jobDetailsModel.getSettings().getSoftErrors()) {
            if (previousJobSoftErrors.contains(string)) continue;
            currentJobSoftErrors.add(string);
        }
        for (String string : jobDetailsModel.getSettings().getInfos()) {
            if (previousJobInfos.contains(string)) continue;
            currentJobInfos.add(string);
        }
        for (OperationStatus operationStatus : jobDetailsModel.getOperations()) {
            for (String warning : operationStatus.getWarnings()) {
                String warningMessage = operationStatus.getName() + " - " + warning;
                currentJobWarnings.add(warningMessage);
            }
            if (!operationStatus.hasSoftErrors()) continue;
            String softErrorMessage = operationStatus.getName() + " - " + operationStatus.getError();
            currentJobSoftErrors.add(softErrorMessage);
        }
        for (String string : currentJobWarnings) {
            if (previousJobWarnings.contains(string)) continue;
            additionalWarningsProperties.add(string);
            previousJobWarnings.add(string);
        }
        for (String string : currentJobSoftErrors) {
            if (previousJobSoftErrors.contains(string)) continue;
            additionalSoftErrorsProperties.add(string);
            previousJobSoftErrors.add(string);
        }
        for (String string : currentJobInfos) {
            if (previousJobInfos.contains(string)) continue;
            additionalInfoProperties.add(string);
            previousJobInfos.add(string);
        }
        LinkedHashSet<String> resovledWarnings = new LinkedHashSet<String>();
        for (String previousJobWarning : previousJobWarnings) {
            if (currentJobWarnings.contains(previousJobWarning)) continue;
            resovledWarningsProperties.add(previousJobWarning);
            resovledWarnings.add(previousJobWarning);
        }
        previousJobWarnings.removeAll(resovledWarnings);
        if (additionalWarningsProperties.size() > 0) {
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            linkedHashMap.put(this.iu.getString("JobResource.ModificationLabel.Warning"), String.join((CharSequence)"\n", additionalWarningsProperties));
            this.schedulerApplication.getNotificationsHandler().triggerNotificationEvent(jobDetailsModel, JobEvent.JOB_WARNING, null, linkedHashMap);
            this.schedulerApplication.getScheduleWorker().triggerJobEvent(jobDetailsModel, JobEvent.JOB_WARNING);
            processingJob = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions((BearerUser)new SystemBearerUser(), jobDetailsModel.getSettings());
            JobWarnings processingJobWarnings = new JobWarnings();
            processingJobWarnings.setJob(processingJob);
            processingJobWarnings.setWarnings(additionalWarningsProperties);
            SchedulerApplication.getInstance().getWebhookWorker().triggerEvent(EventType.Type.JOB_WARNING, processingJobWarnings);
        }
        if (additionalSoftErrorsProperties.size() > 0) {
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            linkedHashMap.put(this.iu.getString("JobResource.ModificationLabel.SoftError"), String.join((CharSequence)"\n", additionalSoftErrorsProperties));
            this.schedulerApplication.getNotificationsHandler().triggerNotificationEvent(jobDetailsModel, JobEvent.JOB_SOFT_ERROR, null, linkedHashMap);
            this.schedulerApplication.getScheduleWorker().triggerJobEvent(jobDetailsModel, JobEvent.JOB_SOFT_ERROR);
            processingJob = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions((BearerUser)new SystemBearerUser(), jobDetailsModel.getSettings());
            JobSoftErrors processingJobSoftErrors = new JobSoftErrors();
            processingJobSoftErrors.setJob(processingJob);
            processingJobSoftErrors.setSoftErrors(additionalSoftErrorsProperties);
            SchedulerApplication.getInstance().getWebhookWorker().triggerEvent(EventType.Type.JOB_SOFT_ERROR, processingJobSoftErrors);
        }
        if (additionalInfoProperties.size() > 0) {
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            linkedHashMap.put(this.iu.getString("JobResource.ModificationLabel.Info"), String.join((CharSequence)"\n", additionalInfoProperties));
            this.schedulerApplication.getNotificationsHandler().triggerNotificationEvent(jobDetailsModel, JobEvent.JOB_INFO, null, linkedHashMap);
            this.schedulerApplication.getScheduleWorker().triggerJobEvent(jobDetailsModel, JobEvent.JOB_INFO);
            processingJob = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions((BearerUser)new SystemBearerUser(), jobDetailsModel.getSettings());
            JobInfos processingJobInfos = new JobInfos();
            processingJobInfos.setJob(processingJob);
            processingJobInfos.setInfos(additionalInfoProperties);
            SchedulerApplication.getInstance().getWebhookWorker().triggerEvent(EventType.Type.JOB_INFO, processingJobInfos);
        }
        if (resovledWarningsProperties.size() > 0) {
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            linkedHashMap.put(this.iu.getString("JobResource.ModificationLabel.WarningResolved"), String.join((CharSequence)"\n", resovledWarningsProperties));
            this.schedulerApplication.getNotificationsHandler().triggerNotificationEvent(jobDetailsModel, JobEvent.JOB_WARNING_RESOLVED, null, linkedHashMap);
            this.schedulerApplication.getScheduleWorker().triggerJobEvent(jobDetailsModel, JobEvent.JOB_WARNING_RESOLVED);
        }
    }

    private void clearJobWarnings(JobDetailsModel jobDetailsModel) {
        String jobId = jobDetailsModel.getSettings().getId();
        this.jobWarnings.remove(jobId);
        this.jobSoftErrors.remove(jobId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        boolean lockAvailable = this.pingServerSemaphore.tryAcquire();
        if (lockAvailable) {
            try {
                Thread pingServerThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ServerWorker.this.pingServer();
                        }
                        catch (Throwable t) {
                            LOGGER.error(String.valueOf(ServerWorker.this.model) + " ping error", t);
                        }
                    }
                });
                pingServerThread.setDaemon(true);
                pingServerThread.setName("Server Worker - ping");
                pingServerThread.start();
                try {
                    pingServerThread.join(this.schedulerApplication.getConfiguration().getEngineTimeout());
                    if (!pingServerThread.isAlive()) return;
                    LOGGER.error(String.valueOf(this.model) + " ping did not complete");
                    LOGGER.warn(String.valueOf(this.model) + " stack trace:");
                    for (StackTraceElement stackTraceElement : pingServerThread.getStackTrace()) {
                        LOGGER.warn("\t" + stackTraceElement.toString());
                    }
                    LOGGER.warn(String.valueOf(this.model) + " Interrupting");
                    pingServerThread.interrupt();
                    pingServerThread.join(this.schedulerApplication.getConfiguration().getServerTimeout());
                    if (!pingServerThread.isAlive()) return;
                    LOGGER.error(String.valueOf(this.model) + " ping thread did not interrupt");
                    return;
                }
                catch (InterruptedException e) {
                    LOGGER.error(String.valueOf(this.model) + " cannot wait for ping thread to complete", (Throwable)e);
                }
                return;
            }
            finally {
                this.pingServerSemaphore.release();
            }
        } else {
            LOGGER.warn(String.valueOf(this.model) + " ping lock not available");
        }
    }

    public void logServerTimingInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        LOGGER.info("--- Server timing info start");
        ArrayList logs = new ArrayList(this.serverTimingLog.getLog());
        try {
            this.serverTimingLog.clear();
        }
        catch (Exception e) {
            LOGGER.error("Cannot clear server timing info", (Throwable)e);
        }
        for (TimestampedString timestampedString : logs) {
            if (timestampedString == null) continue;
            LOGGER.info(FormattingUtils.dateTimeToInternationalDateTimeMillisString((DateTime)new DateTime(timestampedString.getTimestamp())) + "\t" + timestampedString.getString());
        }
        LOGGER.info("--- Server timing info end");
    }
}

