/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.workers;

import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.SchedulerConfiguration;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.UserDataDirUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.filelibrary.LibraryNuixFileType;
import com.nuix.automate.utils.models.api.userdatadir.FileInfo;
import com.nuix.automate.utils.models.api.userdatadir.UserDataDir;
import com.sun.nio.file.ExtendedWatchEventModifier;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Consumer;
import org.apache.commons.io.FilenameUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class UserDataDirWatcher
implements AutoCloseable {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(UserDataDirWatcher.class);
    private static final InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");
    private final Map<WatchKey, Path> keyToPath;
    private final Map<String, FileInfo> fileInfoMap = new ConcurrentHashMap<String, FileInfo>();
    private final Set<String> fileSkipped = new HashSet<String>();
    private final BlockingQueue<String> updatedPathsQueue;
    private final Consumer<Set<String>> updater;
    private final long debouncePeriod;
    private WatchService watchService;
    private UserDataDir userDataDir;
    private Path userDataDirPath;
    private Thread watchServiceThread;
    private Thread updateTriggerThread;
    private long firstEventUpdate;
    private long lastEventUpdate;
    private Timer scanAtIntervalTimer;

    public UserDataDirWatcher(Consumer<Set<String>> updater) {
        this.keyToPath = new HashMap<WatchKey, Path>();
        this.debouncePeriod = 30000L;
        this.updatedPathsQueue = new LinkedBlockingQueue<String>();
        this.updater = updater;
    }

    public List<FileInfo> getFileInfos() {
        return new ArrayList<FileInfo>(this.fileInfoMap.values());
    }

    public Map<String, FileInfo> getFileInfoMap() {
        return new HashMap<String, FileInfo>(this.fileInfoMap);
    }

    public void start(UserDataDir userDataDir) throws IOException {
        this.close();
        this.watchService = FileSystems.getDefault().newWatchService();
        this.userDataDir = userDataDir;
        this.userDataDirPath = Paths.get(userDataDir.getPath(), new String[0]).toAbsolutePath().normalize();
        userDataDir.setPath(this.userDataDirPath.toString());
        this.registerDirAndFiles(Paths.get(userDataDir.getPath(), new String[0]));
        this.startFileUpdateTriggerThread();
        this.startWatchServiceThread();
        userDataDir.setFileCount(this.fileInfoMap.size());
        userDataDir.setFileSkippedCount(this.fileSkipped.size());
        userDataDir.setLastUpdatedDate(Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()));
        LOGGER.info("WatchService started for: " + userDataDir.getPath());
        long scanInterval = SchedulerApplication.getInstance().getConfiguration().getUserDataDirScanInterval();
        if (scanInterval > 0L) {
            LOGGER.info("UserDataDir - Scan timer started with interval of " + scanInterval + " s");
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    LOGGER.info("UserDataDir - Timer scan for: " + String.valueOf(UserDataDirWatcher.this.userDataDirPath));
                    UserDataDirWatcher.this.trackPathUpdate(UserDataDirWatcher.this.userDataDirPath);
                }
            };
            this.scanAtIntervalTimer = new Timer();
            this.scanAtIntervalTimer.scheduleAtFixedRate(task, 0L, scanInterval * 1000L);
        }
    }

    private void trackPathUpdate(Path path) {
        this.lastEventUpdate = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
        if (this.updatedPathsQueue.isEmpty()) {
            this.firstEventUpdate = this.lastEventUpdate;
        }
        this.updatedPathsQueue.add(path.toAbsolutePath().toString());
    }

    private void startWatchServiceThread() {
        this.watchServiceThread = new Thread(() -> {
            try {
                while (true) {
                    WatchKey key = this.watchService.take();
                    Path dir = (Path)key.watchable();
                    for (WatchEvent<?> event : key.pollEvents()) {
                        WatchEvent.Kind<?> kind = event.kind();
                        if (kind == StandardWatchEventKinds.OVERFLOW) {
                            this.trackPathUpdate(Paths.get(this.userDataDir.getPath(), new String[0]));
                            continue;
                        }
                        WatchEvent<?> ev = event;
                        Path filename = (Path)ev.context();
                        Path filePath = dir.resolve(filename);
                        if (Files.isDirectory(filePath, new LinkOption[0]) && kind == StandardWatchEventKinds.ENTRY_MODIFY) continue;
                        this.trackPathUpdate(filePath);
                    }
                    if (key.reset()) continue;
                    this.keyToPath.remove(key);
                    if (this.keyToPath.isEmpty()) break;
                }
            }
            catch (InterruptedException e) {
                LOGGER.error("WatchService Thread interrupted ", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            catch (ClosedWatchServiceException e) {
                LOGGER.info("WatchService closed for: " + this.userDataDir.getPath());
            }
        });
        this.watchServiceThread.setName("UserDataDir - WatchService Thread");
        this.watchServiceThread.start();
    }

    private void startFileUpdateTriggerThread() {
        if (this.updateTriggerThread != null && this.updateTriggerThread.isAlive()) {
            return;
        }
        this.updateTriggerThread = new Thread(() -> {
            try {
                while (true) {
                    long currentMillis;
                    HashSet<String> updatedPaths = new HashSet<String>();
                    updatedPaths.add(this.updatedPathsQueue.take());
                    do {
                        Thread.sleep(2500L);
                    } while ((currentMillis = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()) - this.lastEventUpdate <= this.debouncePeriod && currentMillis - this.firstEventUpdate <= 30000L);
                    int pathEventsCount = 1 + this.updatedPathsQueue.drainTo(updatedPaths);
                    this.updateFileInfos(updatedPaths);
                    LOGGER.info("Events handled: " + pathEventsCount);
                    LOGGER.info("Paths updated: " + updatedPaths.size());
                    LOGGER.info("Total fileInfos: " + this.fileInfoMap.size());
                    LOGGER.info("Total files skipped: " + this.fileSkipped.size());
                    LOGGER.info("Total registered folders: " + this.keyToPath.size());
                    this.userDataDir.setFileCount(this.fileInfoMap.size());
                    this.userDataDir.setFileSkippedCount(this.fileSkipped.size());
                    this.userDataDir.setLastUpdatedDate(Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()));
                    this.updater.accept(updatedPaths);
                }
            }
            catch (InterruptedException e) {
                LOGGER.error("UpdateTrigger thread interrupted", (Throwable)e);
                Thread.currentThread().interrupt();
                return;
            }
        });
        this.updateTriggerThread.setName("UserDataDir - FileUpdateTrigger Thread");
        this.updateTriggerThread.start();
    }

    private void updateFileInfos(Set<String> updatedPaths) {
        for (String path : updatedPaths) {
            Path absPath = Paths.get(path, new String[0]);
            try {
                if (!Files.exists(absPath, new LinkOption[0])) {
                    Path relativePath = this.userDataDirPath.relativize(absPath);
                    this.fileInfoMap.keySet().removeIf(p -> Paths.get(p, new String[0]).startsWith(relativePath));
                    this.fileSkipped.removeIf(p -> Paths.get(p, new String[0]).startsWith(relativePath));
                    continue;
                }
                if (Files.isDirectory(absPath, new LinkOption[0])) {
                    this.registerDirAndFiles(absPath);
                    continue;
                }
                this.buildOrUpdateFileInfo(absPath);
            }
            catch (Exception e) {
                LOGGER.error("Error handling file: " + path, (Throwable)e);
            }
        }
    }

    private void buildOrUpdateFileInfo(Path path) throws IOException {
        BasicFileAttributes attrs = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
        this.buildOrUpdateFileInfo(path, attrs);
    }

    private void buildOrUpdateFileInfo(Path path, BasicFileAttributes attrs) throws IOException {
        Path relativePath = this.userDataDirPath.relativize(path);
        FileInfo fileInfo = this.fileInfoMap.computeIfAbsent(relativePath.toString(), k -> new FileInfo());
        try {
            int readSize;
            byte[] buffer = new byte[4096];
            try (FileInputStream fileInputStream = new FileInputStream(path.toFile());){
                readSize = fileInputStream.read(buffer);
            }
            if (readSize > 0) {
                byte[] fileBytes = new byte[readSize];
                System.arraycopy(buffer, 0, fileBytes, 0, readSize);
                fileInfo.setFileType(UserDataDirUtils.parseNuixProfileType((Path)relativePath, (byte[])fileBytes));
            } else {
                fileInfo.setFileType(LibraryNuixFileType.CUSTOM_FILE);
            }
            String fileName = LibraryNuixFileType.isNuixProfileType((LibraryNuixFileType)fileInfo.getFileType()) ? UserDataDirUtils.getNuixProfileName((Path)relativePath) : FilenameUtils.getBaseName((String)path.getFileName().toString());
            if (fileName.trim().isEmpty()) {
                fileName = path.getFileName().toString();
            }
            fileInfo.setName(fileName);
            fileInfo.setRelativePath(relativePath.toString());
            fileInfo.setSize(Long.valueOf(attrs.size()));
            fileInfo.setLastModifiedTime(attrs.lastModifiedTime().toMillis());
            fileInfo.setCreatedTime(attrs.creationTime().toMillis());
        }
        catch (Exception e) {
            LOGGER.error("Error handling file: " + String.valueOf(path), (Throwable)e);
            this.fileInfoMap.remove(relativePath.toString());
        }
    }

    private void registerDirAndFiles(Path path) throws IOException {
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                if (attrs.isSymbolicLink() || attrs.isOther()) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                if (!SchedulerConfiguration.getOsWindows() || dir.equals(Paths.get(UserDataDirWatcher.this.userDataDir.getPath(), new String[0]))) {
                    UserDataDirWatcher.this.registerDir(dir);
                }
                return super.preVisitDirectory(dir, attrs);
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                UserDataDirWatcher.this.buildOrUpdateFileInfo(file, attrs);
                return super.visitFile(file, attrs);
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) {
                LOGGER.error("Error handling file: " + String.valueOf(file), (Throwable)exc);
                return FileVisitResult.SKIP_SUBTREE;
            }
        });
    }

    private void registerDir(Path dir) throws IOException {
        if (this.keyToPath.containsValue(dir)) {
            return;
        }
        WatchEvent.Kind[] events = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE};
        WatchKey key = SchedulerConfiguration.getOsWindows() ? dir.register(this.watchService, events, ExtendedWatchEventModifier.FILE_TREE) : dir.register(this.watchService, events);
        this.keyToPath.put(key, dir);
        LOGGER.info("Registered dir: " + String.valueOf(dir.toAbsolutePath()) + " to userDataDir watchService");
    }

    @Override
    public void close() throws IOException {
        this.fileInfoMap.clear();
        this.fileSkipped.clear();
        this.keyToPath.clear();
        if (this.watchService != null) {
            this.watchService.close();
        }
        if (this.watchServiceThread != null) {
            try {
                this.watchServiceThread.join();
            }
            catch (InterruptedException e) {
                LOGGER.error("Interrupted waiting for WatchService Thread");
            }
        }
        if (this.scanAtIntervalTimer != null) {
            this.scanAtIntervalTimer.cancel();
            this.scanAtIntervalTimer = null;
        }
    }
}

