/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.workers;

import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.security.oidc.microsoft.MicrosoftOidcUserServiceClient;
import com.nuix.automate.scheduler.security.oidc.microsoft.OidcMicrosoftBearerUser;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.internal.cache.CachedObject;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class UserImageWorker {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(UserImageWorker.class);
    private SchedulerApplication schedulerApplication;
    private Map<String, CachedObject<byte[]>> userImageCache;
    private String emailPattern = "[^@]+@[^\\.]+\\..+";
    private Pattern emailRegexPattern = Pattern.compile(this.emailPattern);

    public UserImageWorker(SchedulerApplication schedulerApplication) {
        this.schedulerApplication = schedulerApplication;
        this.userImageCache = new ConcurrentHashMap<String, CachedObject<byte[]>>();
    }

    public byte[] getUserImage(BearerUser user, String username) {
        CachedObject cachedImage = this.userImageCache.get(username);
        boolean cacheExpired = false;
        if (cachedImage != null && DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis() > cachedImage.getExpirationMs()) {
            cacheExpired = true;
        }
        if ((cacheExpired || cachedImage == null) && user.getClass().equals(OidcMicrosoftBearerUser.class) && this.emailRegexPattern.matcher(username).matches()) {
            byte[] image = null;
            for (MicrosoftOidcUserServiceClient client : this.schedulerApplication.getUserServiceResource().getEnabledMicrosoftOidcClients()) {
                image = client.getMicrosoftUserImage(username);
                if (image == null) continue;
                cachedImage = new CachedObject();
                cachedImage.setObject((Object)image);
                cachedImage.setExpirationMs(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis() + this.schedulerApplication.getConfiguration().getUserImageCacheKeepAlive());
                break;
            }
            if (image == null) {
                cachedImage = new CachedObject();
                cachedImage.setObject(null);
                cachedImage.setExpirationMs(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis() + this.schedulerApplication.getConfiguration().getUserImageCacheKeepAlive());
            }
            this.userImageCache.put(username, (CachedObject<byte[]>)cachedImage);
        }
        if (cachedImage != null) {
            return (byte[])cachedImage.getObject();
        }
        return null;
    }
}

