/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.engine.commands;

import com.nuix.automate.engine.EngineApplication;
import com.nuix.automate.utils.general.ExceptionUtils;
import io.dropwizard.Application;
import io.dropwizard.Configuration;
import io.dropwizard.cli.EnvironmentCommand;
import io.dropwizard.setup.Environment;
import java.rmi.RemoteException;
import net.sourceforge.argparse4j.inf.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EngineCommand<T extends Configuration>
extends EnvironmentCommand<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EngineCommand.class);
    private final Class<T> configurationClass;

    public EngineCommand(Application<T> application) {
        this(application, "engine", "runs an engine without booting up jetty server");
    }

    protected EngineCommand(Application<T> application, String name, String description) {
        super(application, name, description);
        this.configurationClass = application.getConfigurationClass();
    }

    protected Class<T> getConfigurationClass() {
        return this.configurationClass;
    }

    protected void run(Environment environment, Namespace namespace, T configurationInstance) throws Exception {
        LOGGER.info("Starting Engine " + EngineApplication.getInstance().getConfiguration().getEngineId());
        RemoteException lastException = null;
        for (int i = 0; i < 10; ++i) {
            try {
                EngineApplication.getInstance().configureEngine();
                lastException = null;
                break;
            }
            catch (RemoteException e) {
                lastException = e;
                LOGGER.warn("Cannot connect to RMI Registry," + ExceptionUtils.getExceptionPrintableMessage((Throwable)e));
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        if (lastException != null) {
            LOGGER.error("Cannot connect to RMI Registry" + lastException);
            throw lastException;
        }
    }
}

