/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.engine.workers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.reflect.TypeToken;
import com.nuix.automate.dropwizard.utils.resources.VersionResources;
import com.nuix.automate.engine.EngineApplication;
import com.nuix.automate.engine.EngineConfiguration;
import com.nuix.automate.engine.nuix.EngineFactory;
import com.nuix.automate.engine.nuix.NuixLicenseException;
import com.nuix.automate.engine.utils.ExecutionProfileUtils;
import com.nuix.automate.engine.workers.EngineLicenceSession;
import com.nuix.automate.engine.workers.JobWorker;
import com.nuix.automate.jar.utils.LibraryUtils;
import com.nuix.automate.utils.api.internal.automatelicense.AutomateLicenceModel;
import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.OperationMimeTypeStats;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.licence.exceptions.LicenceValidationException;
import com.nuix.automate.utils.licence.services.EventInfo;
import com.nuix.automate.utils.licence.services.LicenceSession;
import com.nuix.automate.utils.licence.services.Product;
import com.nuix.automate.utils.logging.LogHandler;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.dataset.DataRepository;
import com.nuix.automate.utils.models.api.engine.EngineStatus;
import com.nuix.automate.utils.models.api.filelibrary.FileLibraryFile;
import com.nuix.automate.utils.models.api.job.JobOperationEvent;
import com.nuix.automate.utils.models.api.job.OperationStatus;
import com.nuix.automate.utils.models.api.job.Parameter;
import com.nuix.automate.utils.models.api.nuixlicensesource.RelayType;
import com.nuix.automate.utils.models.api.nuixlicensesource.SourceType;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyService;
import com.nuix.automate.utils.models.api.workflowlibrary.WorkflowDynamicUpdate;
import com.nuix.automate.utils.models.internal.engine.EngineModel;
import com.nuix.automate.utils.models.internal.event.EventType;
import com.nuix.automate.utils.models.internal.executionprofile.ExecutionProfileModel;
import com.nuix.automate.utils.models.internal.job.BootstrappableJob;
import com.nuix.automate.utils.models.internal.job.JobModel;
import com.nuix.automate.utils.models.internal.job.RemoteWorkersSpecModel;
import com.nuix.automate.utils.models.internal.logging.LogEventModel;
import com.nuix.automate.utils.models.internal.logging.RunningLogEventsModel;
import com.nuix.automate.utils.models.internal.nuixlicensesource.NuixLicenseSourceModel;
import com.nuix.automate.utils.nuix.ProfileTypeNuix;
import com.nuix.automate.utils.nuix.Version;
import com.nuix.automate.utils.utilization.DiagnosticLevel;
import com.nuix.automate.utils.utilization.MimeType;
import com.nuix.automate.utils.utilization.MimeTypeVolume;
import com.nuix.automate.utils.utilization.NuixCase;
import com.nuix.automate.utils.utilization.OperationUtilizationModel;
import com.nuix.automate.utils.utilization.RelativityWorkspace;
import com.nuix.automate.utils.utilization.consumption.Consumption;
import com.nuix.automate.utils.workers.EngineStub;
import com.nuix.automate.utils.workflow.DatasetMetadata;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.LinkLog;
import com.nuix.automate.utils.workflow.LogLevel;
import com.nuix.automate.utils.workflow.ParameterSource;
import com.nuix.automate.utils.workflow.Parameters;
import com.nuix.automate.utils.workflow.PreDefinedStaticParameter;
import com.nuix.automate.utils.workflow.SourceParameter;
import com.nuix.automate.utils.workflow.SourceParameterSourceType;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.CloseCaseOperation;
import com.nuix.automate.workflow.core.execution.operations.ConfigureParametersOperation;
import com.nuix.automate.workflow.core.execution.operations.ConfigureRelativityConnectionOperationImplementation;
import com.nuix.automate.workflow.core.execution.operations.DataRepositoryOperation;
import com.nuix.automate.workflow.core.execution.operations.DatasetOperation;
import com.nuix.automate.workflow.core.execution.operations.GeneratePrintedImagesOperation;
import com.nuix.automate.workflow.core.execution.operations.OcrOperation;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.operations.RelativitySetWorkspaceOperationImplementation;
import com.nuix.automate.workflow.core.execution.operations.ScheduleEventOperation;
import com.nuix.automate.workflow.core.execution.operations.ScriptOperation;
import com.nuix.automate.workflow.core.execution.operations.ThirdPartyServiceOperation;
import com.nuix.automate.workflow.core.execution.operations.UseCaseOperation;
import com.nuix.automate.workflow.core.execution.operations.UseCaseOperationImplementation;
import com.nuix.automate.workflow.core.execution.operations.WorkerBasedOperation;
import com.nuix.automate.workflow.core.execution.options.switchlicence.LicenceSourceType;
import com.nuix.automate.workflow.core.execution.workflow.UserCancelledException;
import com.nuix.automate.workflow.core.execution.workflow.Workflow;
import com.nuix.automate.workflow.core.execution.workflow.WorkflowExecution;
import com.nuix.automate.workflow.core.execution.workflow.WorkflowExecutionEvent;
import com.nuix.automate.workflow.core.execution.workflow.WorkflowExecutionListener;
import com.nuix.automate.workflow.core.licence.NuixLicenceFactory;
import com.nuix.automate.workflow.core.licence.UtilizationUtils;
import com.nuix.automate.workflow.core.nuix.ExecutionContext;
import com.nuix.automate.workflow.core.utils.general.OsUtils;
import com.nuix.automate.workflow.core.utils.nuix.NuixCaseUtils;
import com.nuix.script.impl.processor.DefaultWorkerBroker;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import nuix.HistoryEvent;
import nuix.ItemType;
import nuix.ItemTypeUtility;
import nuix.Licence;
import nuix.ProcessingJob;
import nuix.Utilities;
import nuix.WorkerAgent;
import nuix.WorkerAgentStatus;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class Engine
implements com.nuix.automate.workflow.core.execution.workflow.Engine,
EngineStub,
Closeable {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(Engine.class);
    private InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");
    private final int MAX_WORKER_COUNT = 1000;
    private transient Registry registry;
    private EngineApplication engineApplication;
    private EngineConfiguration configuration;
    private EngineModel model;
    private Timer keepAliveTimer;
    private TimerTask keepAliveTimerTask;
    private long lastKeepAlivePing;
    private NuixLicenseSourceModel nuixLicenceSource;
    private ExecutorService executor = Executors.newSingleThreadExecutor();
    private nuix.engine.Engine engine;
    private ExecutionProfileModel executionProfile;
    private List<SourceParameter> sourceParameters;
    private JobModel jobModel;
    private String username;
    private JobWorker currentJobWorker;
    private String message;
    private File lastNuixCaseLocation = null;
    private String lastNuixCaseTimeZone = null;
    private WorkerAgent workerAgent = null;
    private boolean workerAgentOnly;
    private AutomateLicenceModel rampivaLicence;
    private EngineLicenceSession licenceSession;
    private LogHandler logHandler;
    private NuixCase nuixCase;
    private RelativityWorkspace relativityWorkspace;
    private DefaultWorkerBroker workerBroker;
    private RemoteWorkersSpecModel remoteWorkersSpecModel;
    private Set<String> seenRemoteJobs;
    private ExecutionMode engineApplicationExecutionMode = ExecutionMode.AUTOMATE_NUIX;
    private ExecutionMode workflowExecutionMode = ExecutionMode.AUTOMATE_NUIX;
    private Map<String, DatasetMetadata> dataSetsMetadata;
    private Map<String, ThirdPartyService> thirdPartyServices;
    private Map<String, DataRepository> dataRepositories;
    private Map<String, FileLibraryFile> fileLibraryFiles;
    private String workflowXml;
    private List<LogEventModel> executionLogs;
    private final Object logsLock = new Object();
    private Thread shutdownHook = null;
    private Path additionalFilesTempDirectory;
    private boolean abortRequested = false;

    private void evaluateRequiredExecutionMode() {
        EngineApplication.getInstance().getLicenceUtils().setLicenceInfo(this.rampivaLicence.getLicenceInfo());
        this.engineApplicationExecutionMode = this.engineApplication.getConfiguration().getExecutionMode();
        if (this.jobModel != null) {
            try {
                ExecutionContext executionContext = new ExecutionContext(null, null, null, null, null, false, new Parameters(), (com.nuix.automate.workflow.core.execution.workflow.Engine)this);
                WorkflowExecution workflowExecution = new WorkflowExecution(executionContext);
                workflowExecution.openWorkflow(this.workflowXml);
                this.workflowExecutionMode = this.engineApplicationExecutionMode = workflowExecution.getWorkflow().getExecutionMode();
                if (this.engineApplicationExecutionMode == ExecutionMode.AUTOMATE_NATIVE && !EngineApplication.getInstance().getLicenceUtils().getLicenceInfo().getModuleLicensed(ModuleType.AUTOMATE_NATIVE_WORKFLOWS)) {
                    LOGGER.info("Workflow can run in Automate Native mode but license edition does not allow it");
                    this.engineApplicationExecutionMode = ExecutionMode.AUTOMATE_NUIX;
                }
                if (this.engineApplicationExecutionMode == ExecutionMode.AUTOMATE_NUIX && this.model.getSupportedExecutionMode().equals((Object)ExecutionMode.AUTOMATE_NATIVE)) {
                    throw new IllegalStateException(this.iu.getString("Engine.Error.JobRequiresNuix"));
                }
            }
            catch (IOException e) {
                LOGGER.warn("Cannot evaluate execution mode", (Throwable)e);
            }
        }
    }

    public EngineModel configure(EngineModel engineModel, BootstrappableJob bootstrappableJob, AutomateLicenceModel rampivaLicence, NuixLicenseSourceModel nuixLicenceSource, boolean workerAgentOnly) throws RemoteException {
        LOGGER.info("Received Configure Engine command");
        this.model = engineModel;
        this.updateKeepAlive();
        this.username = "Automate";
        this.workerAgentOnly = workerAgentOnly;
        engineModel.setWorkerAgentOnly(workerAgentOnly);
        this.executionProfile = bootstrappableJob.getExecutionProfile();
        this.sourceParameters = bootstrappableJob.getSourceParameters();
        this.jobModel = bootstrappableJob.getJobModel();
        this.dataSetsMetadata = bootstrappableJob.getDataSetsMetadata();
        if (bootstrappableJob.getThirdPartyServicesJson() != null) {
            Type mapType = new TypeToken<Map<String, ThirdPartyService>>(){}.getType();
            this.thirdPartyServices = (Map)SerializationUtils.fromDbJson((String)bootstrappableJob.getThirdPartyServicesJson(), (Type)mapType);
        }
        this.dataRepositories = bootstrappableJob.getDataRepositories();
        this.fileLibraryFiles = bootstrappableJob.getFileLibraryFiles();
        this.workflowXml = bootstrappableJob.getWorkflowXml();
        this.rampivaLicence = rampivaLicence;
        if (this.jobModel != null) {
            this.jobModel.setLastResourcePoolId(null);
            engineModel.setRunningJobId(this.jobModel.getId());
            this.currentJobWorker = new JobWorker(this.jobModel, this.executionProfile, this);
            this.currentJobWorker.getModel().setEngineId(engineModel.getId());
            this.currentJobWorker.getModel().setServerId(engineModel.getServerId());
        } else {
            engineModel.setRunningJobId(null);
        }
        this.seenRemoteJobs = new HashSet<String>();
        this.nuixLicenceSource = nuixLicenceSource;
        this.logHandler = LogHandler.getInstance();
        this.executionLogs = new ArrayList<LogEventModel>();
        this.evaluateRequiredExecutionMode();
        engineModel.setCurrentExecutionMode(this.engineApplicationExecutionMode);
        this.initializeNuixEngine();
        return engineModel;
    }

    public EngineModel updateEngine(EngineModel engineModel, NuixLicenseSourceModel nuixLicenseSource) throws RemoteException {
        LOGGER.info("Received UpdateEngine command");
        this.model.setName(engineModel.getName());
        this.model.setSupportedExecutionMode(engineModel.getSupportedExecutionMode());
        this.model.setTargetNuixWorkers(engineModel.getTargetNuixWorkers());
        this.model.setMinNuixWorkers(engineModel.getMinNuixWorkers());
        this.model.setNuixLicenceSourceId(engineModel.getNuixLicenceSourceId());
        this.model.setPriority(engineModel.getPriority());
        this.model.setExecutionProfileId(engineModel.getExecutionProfileId());
        return this.model;
    }

    public boolean getWorkerAgentOnly() {
        return this.workerAgentOnly;
    }

    private void assertEngineInAllowedState(String action, EngineStatus ... allowedStatuses) throws RemoteException {
        for (EngineStatus allowedStatus : allowedStatuses) {
            if (!this.model.getStatus().equals((Object)allowedStatus)) continue;
            return;
        }
        throw new IllegalStateException(this.iu.getFormattedString("Engine.IllegalAction", new Object[]{action, this.model}));
    }

    private void updateKeepAlive() {
        this.lastKeepAlivePing = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
    }

    public EngineModel ping() throws RemoteException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Server command: ping");
        }
        this.updateKeepAlive();
        this.updateLogHandlerJobId();
        return this.model;
    }

    private void updateLogHandlerJobId() {
        if ((this.model.getRunningJobId() != null || this.model.getBootstrappingJobId() != null) && this.logHandler != null) {
            this.logHandler.setJobId(this.jobModel.getId());
        }
    }

    private void clearModelRunningJob() {
        this.model.setRunningJobId(null);
        this.model.setBootstrappingJobId(null);
        this.model.setLogFile(null);
        this.model.setAcquiredWorkers(null);
        this.model.setNuixLicenceType(null);
        this.model.setNuixVersion(null);
        this.model.setJavaVersion(null);
        this.model.setCurrentExecutionMode(null);
    }

    private void waitForSessionEvents() {
        if (this.currentJobWorker != null) {
            long currentSleep;
            long sleepStep = 1000L;
            long maxSleep = 80000L;
            for (currentSleep = 0L; this.currentJobWorker.getSessionEventCount() > 0L && currentSleep < maxSleep; currentSleep += sleepStep) {
                try {
                    Thread.sleep(sleepStep);
                    continue;
                }
                catch (InterruptedException e) {
                    // empty catch block
                    break;
                }
            }
            if (currentSleep >= maxSleep) {
                LOGGER.warn("Gave up waiting for " + this.currentJobWorker.getSessionEventCount() + " session events to be picked up");
            }
        }
    }

    public EngineModel standby() throws RemoteException {
        LOGGER.info("Received StandBy command");
        this.updateKeepAlive();
        this.assertEngineInAllowedState("Standby", EngineStatus.INITIALIZED);
        this.clearModelRunningJob();
        if (this.licenceSession != null) {
            this.model.setLicenseSessionId(this.licenceSession.getId());
        }
        this.model.setStatus(EngineStatus.STANDBY);
        this.model.setError("");
        this.closeNuixEngine();
        this.waitForSessionEvents();
        this.engineApplication.closeWithDelay(100L, "Received StandBy command");
        return this.model;
    }

    public EngineModel shutdown() {
        LOGGER.info("Received Shutdown command");
        this.updateKeepAlive();
        if (this.licenceSession != null) {
            this.model.setLicenseSessionId(this.licenceSession.getId());
        }
        this.closeNuixEngine();
        this.clearModelRunningJob();
        this.model.setStatus(EngineStatus.ERROR);
        this.waitForSessionEvents();
        this.engineApplication.closeWithDelay(100L, "Received Shutdown command");
        return this.model;
    }

    public EngineModel abort() {
        LOGGER.info("Received Abort command");
        WorkflowExecution stopWorkflowExecution = this.currentJobWorker.getWorkflowExecution();
        Thread abortWorkThread = new Thread(() -> {
            int timeout;
            int timeoutIncrement;
            if (!this.abortRequested) {
                try {
                    this.abortRequested = true;
                    LOGGER.info("Attempting to stop gracefully first");
                    stopWorkflowExecution.stopWorkflow();
                    timeoutIncrement = 100;
                    timeout = 0;
                    while ((long)timeout < this.configuration.getEngineAbortTimeout() && stopWorkflowExecution.isWorkflowRunning().booleanValue()) {
                        Thread.sleep(timeoutIncrement);
                        timeout += timeoutIncrement;
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot stop gracefully", (Throwable)e);
                }
            } else {
                LOGGER.info("Received more than 1 abort requests, skipping attempt at graceful stop");
            }
            timeoutIncrement = 100;
            try {
                LOGGER.info("Attempting to abort");
                stopWorkflowExecution.abortWorkflow();
                for (timeout = 0; timeout < 5000 && stopWorkflowExecution.isWorkflowRunning().booleanValue(); timeout += timeoutIncrement) {
                    Thread.sleep(timeoutIncrement);
                }
            }
            catch (Exception e) {
                LOGGER.warn("Error encountered while aborting", (Throwable)e);
            }
            boolean waitingForActiveEvents = true;
            try {
                while (waitingForActiveEvents) {
                    if (this.currentJobWorker.getWorkflowExecution() == null) {
                        waitingForActiveEvents = false;
                        LOGGER.warn("Workflow execution is null");
                        continue;
                    }
                    if (this.currentJobWorker.getWorkflowExecution().getActiveEventsCount() > 0) {
                        LOGGER.info("Waiting for workflow events to finish ...");
                        Thread.sleep(1000L);
                        continue;
                    }
                    LOGGER.warn("No workflow events to wait for.");
                    waitingForActiveEvents = false;
                }
            }
            catch (Exception e) {
                LOGGER.warn("Error encountered while waiting for events", (Throwable)e);
            }
            stopWorkflowExecution.log(this.iu.getString("Engine.ExecutionAborted"), LogLevel.ERROR);
            this.currentJobWorker.getModel().setExecutionState(ExecutionState.ERROR);
            this.model.setStatus(EngineStatus.FINISHED);
        });
        abortWorkThread.setName("Automate Engine - Abort Job " + this.currentJobWorker.getModel().getId());
        abortWorkThread.start();
        return this.model;
    }

    public EngineModel skipOperation(int operationId) {
        LOGGER.info("Received Skip Operation command");
        WorkflowExecution workflowExecution = this.currentJobWorker.getWorkflowExecution();
        workflowExecution.skipOperation(operationId);
        return this.model;
    }

    public EngineModel stop() {
        LOGGER.info("Received Stop command");
        WorkflowExecution stopWorkflowExecution = this.currentJobWorker.getWorkflowExecution();
        stopWorkflowExecution.stopWorkflow();
        this.currentJobWorker.getModel().setExecutionState(ExecutionState.STOPPING);
        return this.model;
    }

    public EngineModel pauseJob() {
        WorkflowExecution pauseWorkflowExecution = this.currentJobWorker.getWorkflowExecution();
        pauseWorkflowExecution.pauseWorkflow();
        this.currentJobWorker.getModel().setExecutionState(ExecutionState.PAUSING);
        String currentResourcePoolId = this.currentJobWorker.getModel().getResourcePoolId();
        this.currentJobWorker.getModel().setLastResourcePoolId(currentResourcePoolId);
        return this.model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testAvailablePort(Map<String, Object> workerBrokerOptions) throws IOException {
        int portNum;
        Object bindAddress = workerBrokerOptions.get("bindAddress");
        Object port = workerBrokerOptions.get("port");
        if (bindAddress == null) {
            LOGGER.info("Skip testing port availability because bindAddress is " + bindAddress);
            return;
        }
        InetAddress bindAddr = InetAddress.getByName(bindAddress.toString());
        if (port == null) {
            LOGGER.info("Skip testing port availability because port is " + port);
            return;
        }
        try {
            portNum = Integer.parseInt(port.toString());
        }
        catch (NumberFormatException ex) {
            LOGGER.info("Skip testing port availability because port is " + port);
            return;
        }
        LOGGER.info("Testing port availability " + bindAddr + ":" + portNum);
        try (ServerSocket ss = null;){
            ss = new ServerSocket(portNum, 50, bindAddr);
            LOGGER.info("Port is available");
            return;
        }
    }

    private void initializeWorkerBroker() throws IOException {
        if (this.jobModel != null) {
            this.remoteWorkersSpecModel = this.jobModel.getRemoteWorkersSpec();
            if (this.remoteWorkersSpecModel == null || this.remoteWorkersSpecModel.getUseRemoteWorkers()) {
                if (this.workerBroker == null) {
                    this.workerBroker = new DefaultWorkerBroker();
                }
                if (!this.workerBroker.isRunning()) {
                    for (int tryAttempt = 0; tryAttempt < this.engineApplication.getConfiguration().getWorkerBrokerInitAttempts(); ++tryAttempt) {
                        try {
                            Map<String, Object> workerBrokerOptions = this.engineApplication.getWorkerBrokerOptions();
                            LOGGER.info("Starting " + this.model + " Worker Broker " + SerializationUtils.toJson(workerBrokerOptions));
                            this.testAvailablePort(workerBrokerOptions);
                            this.workerBroker.start(workerBrokerOptions);
                            InetSocketAddress address = this.workerBroker.getAddress();
                            RemoteWorkersSpecModel remoteWorkersSpecModel = new RemoteWorkersSpecModel(address.getAddress().getHostAddress(), address.getPort());
                            if (this.jobModel != null) {
                                this.jobModel.setRemoteWorkersSpec(remoteWorkersSpecModel);
                            }
                            LOGGER.info("Started " + this.model + " Worker Broker on IP: " + remoteWorkersSpecModel.getWorkerBrokerIp() + ", port: " + remoteWorkersSpecModel.getWorkerBrokerPort());
                            break;
                        }
                        catch (IOException e) {
                            if (tryAttempt == this.engineApplication.getConfiguration().getWorkerBrokerInitAttempts() - 1) {
                                LOGGER.error("Cannot start Engine Worker Broker", (Throwable)e);
                                this.model.appendErrorLine("Cannot start Engine Worker Broker, " + ExceptionUtils.getExceptionPrintableMessage((Throwable)e));
                                throw new IOException("Cannot start Engine Worker Broker", e);
                            }
                            LOGGER.warn("Cannot start Engine Worker Broker, " + e.getMessage());
                            continue;
                        }
                    }
                }
            } else {
                LOGGER.info("Skipping starting of Worker Broker for " + this.model);
            }
        }
    }

    private void shutdownWorkerBroker() {
        if (this.workerBroker != null && this.workerBroker.isRunning()) {
            try {
                this.workerBroker.stop();
            }
            catch (Exception e) {
                LOGGER.warn("Cannot stop Worker Broker", (Throwable)e);
            }
            this.workerBroker = null;
        }
    }

    private void initializeNuixEngine() {
        this.model.setStatus(EngineStatus.INITIALIZING);
        final Engine rampivaEngine = this;
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - void declaration
             */
            @Override
            public void run() {
                block49: {
                    try {
                        void var9_21;
                        LinkedHashMap executionProfileWorkflowParameters;
                        Engine.this.closeNuixEngine();
                        if (Engine.this.engineApplicationExecutionMode == ExecutionMode.AUTOMATE_NUIX) {
                            int minWorkers = 1;
                            if (Engine.this.model != null) {
                                minWorkers = Engine.this.model.getMinNuixWorkers();
                            }
                            Engine.this.engine = Engine.this.createEngine(Engine.this.username, Engine.this.nuixLicenceSource.getFilter(), Engine.this.nuixLicenceSource.getSourceType(), Engine.this.nuixLicenceSource.getRelayType(), Engine.this.model.getTargetNuixWorkers(), minWorkers, Engine.this.nuixLicenceSource.getServerName(), Engine.this.nuixLicenceSource.getServerPort(), Engine.this.nuixLicenceSource.getUsername(), Engine.this.nuixLicenceSource.getPassword(), Engine.this.nuixLicenceSource.getWhitelistedCertFingerprints());
                            Engine.this.model.setEngineVersion(Engine.this.engine.getVersion());
                            Engine.this.model.setAcquiredWorkers(Engine.this.engine.getLicence().getWorkers());
                            Engine.this.model.setNuixVersion(Engine.this.engine.getVersion());
                        }
                        Engine.this.model.setJavaVersion(System.getProperty("java.vendor") + " " + System.getProperty("java.runtime.version"));
                        Engine.this.model.setCurrentExecutionMode(Engine.this.engineApplicationExecutionMode);
                        Engine.this.model.setError(null);
                        if (Engine.this.engineApplicationExecutionMode == ExecutionMode.AUTOMATE_NUIX) {
                            try {
                                Engine.this.model.setNuixLicenceType(Engine.this.engine.getUtilities().getLicence().getShortName());
                            }
                            catch (Exception e) {
                                LOGGER.warn("Cannot set license details", (Throwable)e);
                                Engine.this.model.setError(e.getLocalizedMessage());
                            }
                        }
                        LOGGER.info(Engine.this.model + " Initialized");
                        if (Engine.this.jobModel == null) {
                            Engine.this.model.setStatus(EngineStatus.INITIALIZED);
                            break block49;
                        }
                        Engine.this.jobModel.getWarnings().clear();
                        Engine.this.jobModel.getSoftErrors().clear();
                        Parameters sessionParameters = new Parameters();
                        for (Object parameterModel : Engine.this.jobModel.getSessionParameters()) {
                            LOGGER.info("Setting Job Submission parameter " + parameterModel.getName());
                            StaticParameter sessionParameter = new StaticParameter((Parameter)parameterModel);
                            sessionParameter.setSource(ParameterSource.JOB_SUBMISSION);
                            sessionParameters.put((com.nuix.automate.utils.workflow.Parameter)sessionParameter);
                        }
                        if (Engine.this.sourceParameters == null) {
                            Engine.this.sourceParameters = new ArrayList();
                        }
                        if ((executionProfileWorkflowParameters = Engine.this.executionProfile.getWorkflowParameters()) != null) {
                            for (String parameterName : executionProfileWorkflowParameters.keySet()) {
                                String parameterValue = (String)executionProfileWorkflowParameters.get(parameterName);
                                Engine.this.sourceParameters.add(new SourceParameter(parameterName, parameterValue, SourceParameterSourceType.EXECUTION_PROFILE));
                            }
                        }
                        HashSet<String> parameterNames = new HashSet<String>();
                        HashMap<String, SourceParameter> matterParameters = new HashMap<String, SourceParameter>();
                        HashMap<String, SourceParameter> clientParameters = new HashMap<String, SourceParameter>();
                        HashMap<String, SourceParameter> clientPoolParameters = new HashMap<String, SourceParameter>();
                        HashMap<String, SourceParameter> executionProfileParameters = new HashMap<String, SourceParameter>();
                        for (SourceParameter sourceParameter : Engine.this.sourceParameters) {
                            parameterNames.add(sourceParameter.getName());
                            switch (sourceParameter.getSourceType()) {
                                case MATTER: {
                                    matterParameters.put(sourceParameter.getName(), sourceParameter);
                                    break;
                                }
                                case CLIENT: {
                                    clientParameters.put(sourceParameter.getName(), sourceParameter);
                                    break;
                                }
                                case CLIENT_POOL: {
                                    clientPoolParameters.put(sourceParameter.getName(), sourceParameter);
                                    break;
                                }
                                case EXECUTION_PROFILE: {
                                    executionProfileParameters.put(sourceParameter.getName(), sourceParameter);
                                    break;
                                }
                            }
                        }
                        for (String string : parameterNames) {
                            SourceParameter usableParameter = null;
                            ArrayList<String> messages = new ArrayList<String>();
                            SourceParameter matterParameter = (SourceParameter)matterParameters.get(string);
                            SourceParameter clientParameter = (SourceParameter)clientParameters.get(string);
                            SourceParameter clientPoolParameter = (SourceParameter)clientPoolParameters.get(string);
                            SourceParameter executionProfileParameter = (SourceParameter)executionProfileParameters.get(string);
                            if (executionProfileParameter != null) {
                                usableParameter = executionProfileParameter;
                            }
                            if (clientPoolParameter != null) {
                                if (usableParameter != null) {
                                    messages.add(Engine.this.iu.getFormattedString("Parameter.Superseded", new Object[]{usableParameter.getSourceType().toString(), string, SourceParameterSourceType.CLIENT_POOL}));
                                }
                                usableParameter = clientPoolParameter;
                            }
                            if (clientParameter != null) {
                                if (usableParameter != null) {
                                    messages.add(Engine.this.iu.getFormattedString("Parameter.Superseded", new Object[]{usableParameter.getSourceType().toString(), string, SourceParameterSourceType.CLIENT}));
                                }
                                usableParameter = clientParameter;
                            }
                            if (matterParameter != null) {
                                if (usableParameter != null) {
                                    messages.add(Engine.this.iu.getFormattedString("Parameter.Superseded", new Object[]{usableParameter.getSourceType().toString(), string, SourceParameterSourceType.MATTER}));
                                }
                                usableParameter = matterParameter;
                            }
                            if (usableParameter == null) continue;
                            usableParameter.setMessages(messages);
                            sessionParameters.put((com.nuix.automate.utils.workflow.Parameter)usableParameter);
                        }
                        List defaultParameters = Engine.this.jobModel.getDefaultParameters();
                        if (defaultParameters != null) {
                            for (Parameter defaultParameter : defaultParameters) {
                                LOGGER.info("Setting Default  " + defaultParameter.getName());
                                PreDefinedStaticParameter parameter = new PreDefinedStaticParameter(defaultParameter.getName(), defaultParameter.getValue(), defaultParameter.getDescription(), defaultParameter.getRegex());
                                parameter.setFriendlyName(defaultParameter.getFriendlyName());
                                parameter.setUserDisplayableValue(defaultParameter.getUserDisplayableValue());
                                parameter.setSource(defaultParameter.getSource());
                                com.nuix.automate.utils.workflow.Parameter existingParameter = sessionParameters.get(parameter.getName());
                                if (existingParameter != null && !existingParameter.getValue().isEmpty()) continue;
                                sessionParameters.put((com.nuix.automate.utils.workflow.Parameter)parameter);
                            }
                        }
                        if (Engine.this.engineApplicationExecutionMode == ExecutionMode.AUTOMATE_NUIX) {
                            ExecutionContext executionContext = new ExecutionContext(null, null, null, Engine.this.engine.getUtilities(), Engine.this.model.getNuixVersion(), false, sessionParameters, (com.nuix.automate.workflow.core.execution.workflow.Engine)rampivaEngine);
                        } else {
                            ExecutionContext executionContext = new ExecutionContext(null, null, null, null, null, false, sessionParameters, (com.nuix.automate.workflow.core.execution.workflow.Engine)rampivaEngine);
                        }
                        var9_21.licenceInfo = Engine.this.rampivaLicence.getLicenceInfo();
                        var9_21.userDataDirPath = Engine.this.configuration.getEngineServerUserDataDirPath();
                        var9_21.setJobFilesDirectory(Engine.this.configuration.getEngineServerJobFilesDirectory());
                        WorkflowExecution workflowExecution = new WorkflowExecution((ExecutionContext)var9_21);
                        if (Engine.this.licenceSession != null) {
                            Engine.this.licenceSession.close();
                            Engine.this.licenceSession = null;
                        }
                        if (Engine.this.engineApplicationExecutionMode == ExecutionMode.AUTOMATE_NUIX) {
                            Engine.this.licenceSession = new EngineLicenceSession(Engine.this.currentJobWorker, Engine.this.rampivaLicence.getLicenceInfo(), var9_21.nuixUtilities.getLicence(), Product.ENGINE, VersionResources.getVersion(), var9_21.nuixVersion.toString(), null, DiagnosticLevel.OPTIONAL);
                        } else {
                            Engine.this.licenceSession = new EngineLicenceSession(Engine.this.currentJobWorker, Engine.this.rampivaLicence.getLicenceInfo(), null, Product.ENGINE, VersionResources.getVersion(), null, null, DiagnosticLevel.OPTIONAL);
                        }
                        try {
                            var9_21.licenceSession = Engine.this.licenceSession;
                        }
                        catch (NoSuchFieldError e) {
                            LOGGER.warn("Cannot set execution license session", (Throwable)e);
                        }
                        Engine.this.licenceSession.startSchedule();
                        if (Engine.this.engineApplicationExecutionMode == ExecutionMode.AUTOMATE_NUIX && !Engine.this.workerAgentOnly) {
                            Engine.this.initializeWorkerBroker();
                        }
                        Engine.this.currentJobWorker.setWorkflowExecution(workflowExecution);
                        Engine.this.initializeworkflowExecutionListener(workflowExecution);
                        if (Engine.this.jobModel.getSavedState() != null) {
                            try {
                                workflowExecution.openWorkflowSavedSate(Engine.this.jobModel.getSavedState());
                            }
                            catch (IOException e) {
                                throw new IllegalStateException(Engine.this.iu.getFormattedString("Engine.CannotReadJobSavedState", (Object)ExceptionUtils.getExceptionPrintableMessage((Throwable)e)));
                            }
                        } else if (Engine.this.workflowXml != null && Engine.this.workflowXml.length() > 0) {
                            LOGGER.info(Engine.this.model + " Parsing workflow XML");
                            try {
                                workflowExecution.openWorkflow(Engine.this.workflowXml);
                            }
                            catch (Exception e) {
                                workflowExecution.log(Engine.this.iu.getFormattedString("Engine.CannotReadWorkflowXml", (Object)ExceptionUtils.getExceptionPrintableMessage((Throwable)e)), LogLevel.ERROR);
                                return;
                            }
                        } else {
                            throw new IllegalStateException(Engine.this.iu.getString("Engine.MissingJobWorkflowXml"));
                        }
                        Engine.this.model.setStatus(EngineStatus.PENDING);
                        if (Engine.this.engineApplicationExecutionMode == ExecutionMode.AUTOMATE_NUIX) {
                            if (Engine.this.workerAgentOnly) {
                                Engine.this.joinWorkerBroker();
                            } else {
                                Engine.this.initializeWorkerBroker();
                            }
                        }
                    }
                    catch (NuixLicenseException ex) {
                        LOGGER.warn(Engine.this.model + " Cannot acquire Nuix License", (Throwable)ex);
                        Engine.this.closeNuixEngine();
                        Engine.this.model.setError(ExceptionUtils.getExceptionPrintableMessage((Throwable)ex));
                        Engine.this.model.setStatus(EngineStatus.WARNING);
                    }
                    catch (Throwable e) {
                        LOGGER.error(Engine.this.model + " Cannot initialize", e);
                        Engine.this.closeNuixEngine();
                        Exception ex = e instanceof Exception ? (Exception)e : new Exception("Cannot initialize Engine", e);
                        Engine.this.model.setError(ExceptionUtils.getExceptionPrintableMessage((Throwable)ex));
                        Engine.this.model.setStatus(EngineStatus.ERROR);
                    }
                }
            }
        });
        thread.setName("Engine Worker - initialize Engine");
        thread.start();
        try {
            LOGGER.info("Waiting " + this.configuration.getEngineTimeout() + " ms for engine to initialize");
            thread.join(this.configuration.getEngineTimeout());
            if (thread.isAlive()) {
                LOGGER.info(this.model + " Initialization did not complete during timeout of " + this.configuration.getEngineTimeout());
                this.model.setError(this.iu.getString("Engine.TimeoutExceeded"));
                this.model.setStatus(EngineStatus.ERROR);
                thread.interrupt();
            }
        }
        catch (InterruptedException e) {
            LOGGER.info(this.model + " Initialization did not complete during timeout of " + this.configuration.getEngineTimeout());
            this.model.setError(this.iu.getString("Engine.TimeoutExceeded"));
            this.model.setStatus(EngineStatus.ERROR);
            thread.interrupt();
        }
    }

    public void closeNuixEngine() {
        this.shutdownWorkerBroker();
        if (this.engine != null) {
            this.closeNuixEngine(this.engine);
        }
        this.engine = null;
    }

    private void closeNuixEngine(nuix.engine.Engine engine) {
        LOGGER.info(this.model + " Shutting down Nuix engine");
        if (engine != null) {
            try {
                if (this.workerAgent != null && this.workerAgent.isRunning()) {
                    this.workerAgent.stop();
                }
            }
            catch (Exception e) {
                LOGGER.warn(this.model + " Cannot shut down Worker Agent", (Throwable)e);
            }
            try {
                this.model.setAcquiredWorkers(null);
                this.model.setNuixLicenceType(null);
                this.model.setNuixVersion(null);
                this.model.setJavaVersion(null);
                this.model.setCurrentExecutionMode(null);
                engine.close();
            }
            catch (Exception e) {
                LOGGER.error(this.model + " Cannot shut down Nuix engine", (Throwable)e);
            }
            if (this.licenceSession != null) {
                this.licenceSession.close();
                this.licenceSession = null;
            }
            if (this.shutdownHook != null) {
                LOGGER.info("Removing shutdown hook to Engine::close");
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
                this.shutdownHook = null;
            }
        }
    }

    public JobModel getRunningJobStatus() {
        this.updateKeepAlive();
        if (this.currentJobWorker == null) {
            return null;
        }
        this.jobModel = this.currentJobWorker.getModel();
        ExecutionState currentExecutionState = this.jobModel.getExecutionState();
        boolean waitingForActiveEvents = true;
        if (this.currentJobWorker.getWorkflowExecution() == null) {
            waitingForActiveEvents = false;
            LOGGER.warn("Workflow execution is null");
        } else if (this.currentJobWorker.getWorkflowExecution().getActiveEventsCount() <= 0) {
            waitingForActiveEvents = false;
        }
        if (currentExecutionState == ExecutionState.ERROR || currentExecutionState == ExecutionState.FINISHED || currentExecutionState == ExecutionState.STOPPED) {
            LOGGER.info(this.model + " Detected completed job with state " + currentExecutionState);
            if (!waitingForActiveEvents) {
                LOGGER.info("No workflow events to wait for.");
                if (currentExecutionState == ExecutionState.FINISHED) {
                    this.currentJobWorker.jobFinished();
                }
                this.model.setStatus(EngineStatus.FINISHED);
            } else {
                if (currentExecutionState == ExecutionState.STOPPED) {
                    this.jobModel.setExecutionState(ExecutionState.STOPPING);
                }
                LOGGER.info("Waiting for " + this.currentJobWorker.getWorkflowExecution().getActiveEventsCount() + " workflow event(s) to finish ...");
            }
        } else if (currentExecutionState == ExecutionState.PAUSED && this.model.getStatus() != EngineStatus.PENDING) {
            LOGGER.info(this.model + " Detected paused job");
            if (!waitingForActiveEvents) {
                this.jobModel.setSavedState(this.currentJobWorker.getWorkflowExecution().saveState(false));
                HashSet<String> updatedParameterNames = new HashSet<String>();
                Parameters parameters = this.currentJobWorker.getWorkflowExecution().getExecutionContext().getAllParameters();
                for (Parameter parameter : this.jobModel.getSessionParameters()) {
                    com.nuix.automate.utils.workflow.Parameter workflowExecutionParameter = parameters.get(parameter.getName());
                    try {
                        String parameterValue = workflowExecutionParameter.getValue();
                        if (parameter.isProtected() || parameter.isMasked()) {
                            parameterValue = workflowExecutionParameter.getProtectedValue();
                        }
                        if (parameterValue != null && !parameter.getValue().equals(parameterValue)) {
                            parameter.setValue(parameterValue);
                        }
                        updatedParameterNames.add(parameter.getName());
                    }
                    catch (Exception e) {
                        LOGGER.error("Cannot update parameter " + parameter.getName(), (Throwable)e);
                    }
                }
                for (com.nuix.automate.utils.workflow.Parameter workflowExecutionParameter : parameters.getParameters()) {
                    if (updatedParameterNames.contains(workflowExecutionParameter.getName())) continue;
                    try {
                        if (!(workflowExecutionParameter instanceof StaticParameter) || workflowExecutionParameter instanceof PreDefinedStaticParameter) continue;
                        Parameter modifiedParameter = new Parameter(workflowExecutionParameter);
                        this.jobModel.getSessionParameters().add(modifiedParameter);
                    }
                    catch (Exception e) {
                        LOGGER.error("Cannot add parameter " + workflowExecutionParameter.getName(), (Throwable)e);
                    }
                }
                this.model.setStatus(EngineStatus.FINISHED);
            } else {
                LOGGER.info("Waiting for workflow events to finish ...");
            }
        }
        this.model.setRunningJobPercentageComplete(Double.valueOf(this.jobModel.getPercentageComplete()));
        return this.jobModel;
    }

    public EngineModel acknowledgeFinishedStatus() throws RemoteException {
        LOGGER.info("Received Acknowledged  Finish Status");
        this.updateKeepAlive();
        if (this.model.getStatus() == EngineStatus.FINISHED) {
            this.model.setStatus(EngineStatus.INITIALIZED);
        }
        return this.model;
    }

    public EngineModel acknowledgeWorkerAgentJobDone() throws RemoteException {
        LOGGER.info("Received Acknowledged Worker Agent Done");
        this.updateKeepAlive();
        if (this.model.getStatus() == EngineStatus.RUNNING && this.model.getWorkerAgentOnly()) {
            this.model.setStatus(EngineStatus.INITIALIZED);
        }
        return this.model;
    }

    public List<OperationStatus> getOperations() throws RemoteException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Server command: getOperations");
        }
        this.updateKeepAlive();
        if (this.currentJobWorker != null) {
            return this.currentJobWorker.getOperations();
        }
        return new ArrayList<OperationStatus>();
    }

    public List<OperationMimeTypeStats> getOperationMimeTypeStats() throws RemoteException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Server command: getOperationMimeTypeStats");
        }
        this.updateKeepAlive();
        return this.currentJobWorker.getOperationMimeTypeStats();
    }

    public RunningLogEventsModel getRunningLog() throws RemoteException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Server command: getRunningLog");
        }
        this.updateKeepAlive();
        return this.currentJobWorker.getRunningLog();
    }

    public EngineModel runBootstrappedJob() throws RemoteException {
        LOGGER.info("Received Run Bootstrapped Job command");
        this.updateKeepAlive();
        if (this.model.getStatus() != EngineStatus.PENDING) {
            throw new RemoteException(this.iu.getFormattedString("Engine.CannotRunBootstrappedJob", (Object)this.model));
        }
        this.runJob(this.jobModel);
        this.model.setStatus(EngineStatus.RUNNING);
        return this.model;
    }

    private boolean isLicenseAllowedOnOperation() {
        if (this.engine.getLicence().getShortName().equals("ediscovery-production")) {
            LOGGER.info("License is eDiscovery Production");
            if (this.jobModel.getRunningOperationStatus() == null) {
                LOGGER.warn("Job does not have currently running operation");
            } else if (this.jobModel.getRunningOperationStatus().getName().equals(new OcrOperation().getOperationName()) || this.jobModel.getRunningOperationStatus().getName().equals(new GeneratePrintedImagesOperation().getOperationName())) {
                LOGGER.info("Operation is OCR, join workers");
                return true;
            }
            LOGGER.info("Operation is " + this.jobModel.getRunningOperationStatus().getName() + ", production workers are not allowed");
            return false;
        }
        return true;
    }

    public EngineModel joinWorkerBroker() throws RemoteException {
        LOGGER.info("Received Join Worker Broker command");
        if (!this.isLicenseAllowedOnOperation()) {
            LOGGER.error(this.iu.getString("RemoteEngine.Error.LicenseDoesNotSupportOperation"));
            throw new LicenceValidationException(this.iu.getString("RemoteEngine.Error.LicenseDoesNotSupportOperation"));
        }
        this.workerAgent = this.engine.getUtilities().getWorkerAgent();
        if (this.workerAgent.isRunning()) {
            this.workerAgent.stop();
        }
        HashMap<String, Serializable> settings = new HashMap<String, Serializable>();
        InetSocketAddress address = new InetSocketAddress(this.jobModel.getRemoteWorkersSpec().getWorkerBrokerIp(), this.jobModel.getRemoteWorkersSpec().getWorkerBrokerPort());
        settings.put("workerBrokerAddress", address);
        settings.put("workerCount", Integer.valueOf(this.getMaxWorkerCount()));
        Integer workerMemory = this.jobModel.getRunningOperationStatus().getWorkerMemory();
        if (workerMemory == null) {
            workerMemory = 2000;
        }
        settings.put("workerMemory", workerMemory);
        try {
            this.workerAgent.start(settings);
            LOGGER.info("Worker Agent is running: " + this.workerAgent.isRunning());
            LOGGER.info("Worker Agent getAddress:" + this.workerAgent.getStatus().getAddress());
            LOGGER.info("Worker Agent getWorkerAgentGuid:" + this.workerAgent.getStatus().getWorkerAgentGuid());
            LOGGER.info("Worker Agent getFreeExportWorkerCount:" + this.workerAgent.getStatus().getFreeExportWorkerCount());
            LOGGER.info("Worker Agent getFreeLoadWorkerCount:" + this.workerAgent.getStatus().getFreeLoadWorkerCount());
            LOGGER.info("Worker Agent getTotalExportWorkerCount:" + this.workerAgent.getStatus().getTotalExportWorkerCount());
            long interval = 30000L;
            LOGGER.info("Starting remote workers log monitoring timer with recurrence of " + interval + " ms");
            TimerTask remoteWorkersLogHandlerTimerTask = new TimerTask(){

                @Override
                public void run() {
                    Engine.this.detectRemoteWorkerLogs();
                }
            };
            Timer remoteWorkersLogHandlerTimer = new Timer(true);
            remoteWorkersLogHandlerTimer.scheduleAtFixedRate(remoteWorkersLogHandlerTimerTask, 0L, interval);
        }
        catch (IOException e) {
            LOGGER.error("Cannot join remote Worker Broker", (Throwable)e);
            throw new RemoteException(this.iu.getFormattedString("Engine.CannotRunBootstrappedJob", (Object)this.model));
        }
        this.model.setRunningJobId(this.jobModel.getId());
        this.model.setStatus(EngineStatus.RUNNING);
        return this.model;
    }

    private void detectRemoteWorkerLogs() {
        block8: {
            if (this.logHandler != null && this.workerAgent != null) {
                try {
                    WorkerAgentStatus status = this.workerAgent.getStatus();
                    if (status == null) break block8;
                    try {
                        List processingJobs = status.getProcessingJobs();
                        if (processingJobs != null) {
                            for (ProcessingJob processingJob : processingJobs) {
                                String processingJobGuid = processingJob.getJobGuid();
                                if (processingJobGuid == null || this.seenRemoteJobs.contains(processingJobGuid)) continue;
                                this.seenRemoteJobs.add(processingJobGuid);
                                this.logHandler.startWorkerWatch(processingJobGuid, this.model);
                            }
                        }
                    }
                    catch (Throwable t) {
                        LOGGER.warn("Cannot get job logs", t);
                    }
                }
                catch (RuntimeException e) {
                    if (e.getClass().getName().equals("nuix.LicenceException")) {
                        LOGGER.warn("Cannot get workers status because the Nuix license is invalid", (Throwable)e);
                    }
                    throw e;
                }
            }
        }
    }

    public Engine(EngineApplication engineApplication) throws RemoteException {
        this.engineApplication = engineApplication;
        this.configuration = engineApplication.getConfiguration();
        this.schedulerKeepAliveTimer();
        LOGGER.info("Getting registry");
        this.registry = LocateRegistry.getRegistry(this.configuration.getServerLocalPort());
        LOGGER.info("Binding Engine " + this.configuration.getEngineId());
        EngineStub engineStub = (EngineStub)UnicastRemoteObject.exportObject((Remote)((Object)this), 0);
        try {
            this.registry.bind(this.configuration.getEngineId(), (Remote)engineStub);
        }
        catch (AlreadyBoundException e) {
            try {
                this.registry.unbind(this.configuration.getEngineId());
                LOGGER.warn("Another engine was previously bound");
                this.shutdown();
            }
            catch (NotBoundException | RemoteException ex) {
                LOGGER.warn("Cannot unbind previously bound engine");
                this.shutdown();
            }
        }
        this.model = new EngineModel();
        this.model.setStatus(EngineStatus.NOT_INITIALIZED);
        this.shutdownHook = new Thread(() -> {
            try {
                this.close();
            }
            catch (Exception e) {
                LOGGER.error("Error in shutdown hook", (Throwable)e);
            }
        });
    }

    @Override
    public void close() {
        LOGGER.info("Received Close command");
        this.closeNuixEngine();
        if (this.keepAliveTimerTask != null) {
            LOGGER.info("Cancelling keep-alive timer");
            this.keepAliveTimerTask.cancel();
        }
        try {
            LOGGER.info("Unbinding RMI");
            this.registry.unbind(this.configuration.getEngineId());
        }
        catch (NotBoundException | RemoteException e) {
            LOGGER.error("Cannot unbind registry", (Throwable)e);
        }
    }

    void keepAliveCheck() {
        long lastPingAge = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis() - this.lastKeepAlivePing;
        if (lastPingAge > 5000L) {
            LOGGER.warn("Did not receive ping in the last " + lastPingAge + " ms. Left " + (this.configuration.getEngineKeepAlive() - lastPingAge) + " ms. Last ping response at " + new DateTime(this.lastKeepAlivePing).toString("HH:mm:ss"));
        }
        if (lastPingAge > this.configuration.getEngineKeepAlive()) {
            LOGGER.error("Did not receive ping in the last " + lastPingAge + " ms. Left " + (this.configuration.getEngineKeepAlive() - lastPingAge) + " ms. Last ping response at " + new DateTime(this.lastKeepAlivePing).toString("HH:mm:ss"));
            this.getRunningJobStatus();
            this.engineApplication.closeWithDelay(100L, "Did not receive ping in the last " + lastPingAge + " ms.");
        }
    }

    void schedulerKeepAliveTimer() {
        this.updateKeepAlive();
        LOGGER.info("Starting keepalive timer with recurrence of " + this.configuration.getEngineKeepAlive() + " ms");
        if (this.keepAliveTimerTask != null) {
            this.keepAliveTimerTask.cancel();
        }
        this.keepAliveTimerTask = new TimerTask(){

            @Override
            public void run() {
                Engine.this.keepAliveCheck();
            }
        };
        this.keepAliveTimer = new Timer(true);
        this.keepAliveTimer.scheduleAtFixedRate(this.keepAliveTimerTask, 0L, this.configuration.getEngineKeepAlive());
    }

    private nuix.engine.Engine createEngine(String username, String filter, SourceType licenceSource, RelayType relayType, Integer workers, Integer minWorkers, String nmsName, Integer nmsPort, String licenceUsername, String licencePassword, Set<String> whitelistedCertificatesFingerprints) throws IOException, NuixLicenseException {
        Version nuixVersion = LibraryUtils.getNuixEngineVersion((String)this.configuration.getNuixEnginePath());
        HashMap<String, String> nuixFlags = new HashMap<String, String>();
        String userDataBaseFlags = "";
        if (this.configuration.getEngineCommandLine() == null || !this.configuration.getEngineCommandLine().contains("-Dnuix.userDataBase")) {
            Path userDataBasePath = Paths.get(this.configuration.getNuixEnginePath(), "user-data");
            if (!Files.exists(userDataBasePath, new LinkOption[0])) {
                LOGGER.info("Creating userDataBase folder " + userDataBasePath);
                Files.createDirectories(userDataBasePath, new FileAttribute[0]);
            }
            LOGGER.info("Using implicit userDataBase: " + userDataBaseFlags);
            nuixFlags.put("nuix.userDataBase", userDataBasePath.toFile().getAbsolutePath());
        }
        if (OsUtils.getOsWindows()) {
            nuixFlags.put("java.library.path", this.configuration.getNuixEnginePath() + "\\bin");
        } else {
            nuixFlags.put("java.library.path", this.configuration.getNuixEnginePath() + "/lib");
        }
        nuix.engine.Engine engine = licenceSource == SourceType.NMS ? EngineFactory.getInstance(this.configuration).createEngineWithNetworkLicence(this.model.getName(), nuixVersion, relayType, filter, nmsName, nmsPort, username, this.configuration.getNuixUserDataDirPaths(), this.configuration.getLog4jConfigurationFile(), licenceUsername, licencePassword, workers, minWorkers, this.configuration.getNuixEnginePath() + "/lib", nuixFlags, licenceSource, whitelistedCertificatesFingerprints) : (licenceSource == SourceType.CLS ? EngineFactory.getInstance(this.configuration).createEngineWithCloudLicence(this.model.getName(), filter, username, this.configuration.getNuixUserDataDirPaths(), this.configuration.getLog4jConfigurationFile(), licenceUsername, licencePassword, workers, minWorkers, this.configuration.getNuixEnginePath() + "/lib", nuixFlags) : EngineFactory.getInstance(this.configuration).createEngineWithDongleLicence(this.model.getName(), nuixVersion, filter, username, this.configuration.getNuixUserDataDirPaths(), this.configuration.getLog4jConfigurationFile(), workers, minWorkers, this.configuration.getNuixEnginePath() + "/lib", nuixFlags));
        String licenceErrorMessage = null;
        String systemInformation = "";
        try {
            Licence nuixLicence = engine.getUtilities().getLicence();
            NuixLicenceFactory licenceFactory = NuixLicenceFactory.getInstance();
            licenceFactory.setNuixLicence(nuixLicence);
            try {
                systemInformation = this.iu.getFormattedString("Engine.SystemInformationId", (Object)SerializationUtils.toJson((Object)licenceFactory.getSoftwareSysIds())) + "\n" + this.iu.getFormattedString("Engine.SystemInformationDetails", (Object)licenceFactory.getSoftwareDetails());
            }
            catch (Exception e) {
                systemInformation = e.getLocalizedMessage();
            }
            if (this.rampivaLicence.getCredentials() == null) {
                LOGGER.info("Validating SysID");
                licenceErrorMessage = licenceFactory.validateSysIds(this.rampivaLicence.getLicenceInfo(), licenceFactory.getSoftwareSysIds());
            }
        }
        catch (Exception e) {
            LOGGER.error("Cannot get engine license information", (Throwable)e);
            try {
                this.closeNuixEngine(engine);
            }
            catch (Exception e2) {
                LOGGER.warn("Cannot close engine", (Throwable)e2);
            }
            throw new IOException(this.iu.getString("Engine.CannotGetEngineLicenceInfo"), e);
        }
        if (engine.getLicence().getWorkers() == null || engine.getLicence().getWorkers() < minWorkers) {
            this.closeNuixEngine(engine);
            throw new NuixLicenseException(this.iu.getFormattedString("EngineFactory.RequestedAcquiredWorkers", new Object[]{minWorkers, engine.getLicence().getWorkers()}));
        }
        if (licenceErrorMessage != null) {
            try {
                this.closeNuixEngine(engine);
            }
            catch (Exception e2) {
                LOGGER.warn("Cannot close engine", (Throwable)e2);
            }
            throw new IOException(this.iu.getFormattedString("Engine.AutomateLicenceError", (Object)licenceErrorMessage) + "\n" + this.iu.getString("Engine.AutomateLicenceErrorContactSupport") + "\n\n" + systemInformation);
        }
        return engine;
    }

    private synchronized List<MimeType> getAllMimeTypes(Utilities nuixUtilities) {
        ArrayList<MimeType> mimeTypeModels = new ArrayList<MimeType>();
        ItemTypeUtility itemTypeUtility = nuixUtilities.getItemTypeUtility();
        for (ItemType itemType : itemTypeUtility.getAllTypes()) {
            MimeType mimeTypeModel = new MimeType();
            mimeTypeModel.setMimeTypeId(itemType.getName());
            mimeTypeModel.setFileType(itemType.getLocalisedName());
            mimeTypeModel.setFileKind(itemType.getKind().getLocalisedName());
            mimeTypeModel.setFilePreferredExtension(itemType.getPreferredExtension());
            mimeTypeModels.add(mimeTypeModel);
        }
        return mimeTypeModels;
    }

    private void initializeworkflowExecutionListener(final WorkflowExecution workflowExecution) {
        final ExecutionContext executionContext = workflowExecution.getExecutionContext();
        workflowExecution.addWorkflowExecutionListener(new WorkflowExecutionListener(){

            public void beforeWorkflowExecutionInitialized(WorkflowExecutionEvent workflowExecutionEvent) {
                try {
                    workflowExecution.getWorkflow().setSaved();
                    executionContext.initializeJobParameters(Engine.this.jobModel, Engine.this.model, Engine.this.executionProfile);
                    ExecutionProfileUtils executionProfileUtils = new ExecutionProfileUtils(Engine.this.executionProfile, Engine.this.fileLibraryFiles, "");
                    try {
                        Map<ProfileTypeNuix, Set<String>> nuixProfiles = executionProfileUtils.getNuixProfileList();
                        try {
                            workflowExecution.setNuixProfiles(nuixProfiles);
                        }
                        catch (Exception e) {
                            LOGGER.error("Cannot set custom Nuix Profiles", (Throwable)e);
                        }
                    }
                    catch (Throwable t) {
                        LOGGER.error("Unable to create list of Nuix profiles", t);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Cannot track job information", (Throwable)e);
                }
            }

            public void workflowExecutionPrerequisiteError(WorkflowExecutionEvent workflowExecutionEvent, String title, String message, String detailedErrorMessage, Exception e) {
                Engine.this.jobModel.setError(message);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void workflowExecutionLog(WorkflowExecutionEvent workflowExecutionEvent, String s, LogLevel logLevel) {
                String message = s;
                LogEventModel executionLogEvent = new LogEventModel(Engine.this.jobModel.getId(), logLevel.name(), DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis(), message.getBytes(StandardCharsets.UTF_8));
                Object object = Engine.this.logsLock;
                synchronized (object) {
                    Engine.this.executionLogs.add(executionLogEvent);
                }
                switch (logLevel) {
                    case INFO: {
                        Engine.this.jobModel.getInfos().add(s);
                        break;
                    }
                    case LINK: {
                        try {
                            LinkLog linkLog = (LinkLog)SerializationUtils.fromJson((String)s, LinkLog.class);
                            Engine.this.jobModel.getLinks().add(linkLog);
                        }
                        catch (Exception e) {
                            LOGGER.error("Cannot deserialize link log", (Throwable)e);
                        }
                        break;
                    }
                    case WARNING: {
                        break;
                    }
                    case ERROR: {
                        Engine.this.jobModel.setError(s);
                        break;
                    }
                }
            }

            public void workflowExecutionInitialized(WorkflowExecutionEvent workflowExecutionEvent) {
            }

            public void workflowExecutionStateChanged(WorkflowExecutionEvent workflowExecutionEvent, ExecutionState executionState) {
                if (executionState == ExecutionState.FINISHED || executionState == ExecutionState.STOPPED || executionState == ExecutionState.ERROR) {
                    try {
                        if (Engine.this.additionalFilesTempDirectory != null && Files.exists(Engine.this.additionalFilesTempDirectory, new LinkOption[0])) {
                            LOGGER.info("Deleting temporary Additional Files folder " + Engine.this.additionalFilesTempDirectory);
                            FileUtils.deleteRecursively((Path)Engine.this.additionalFilesTempDirectory.getParent());
                        }
                    }
                    catch (IOException e) {
                        LOGGER.error("Unable to delete additional files directory", (Throwable)e);
                    }
                }
            }

            public void workflowExecutionProgress(WorkflowExecutionEvent workflowExecutionEvent, int i) {
                String processingJobGuid;
                Operation o;
                if (Engine.this.logHandler != null && Engine.this.logHandler.getWatchingJob() && (o = (Operation)workflowExecution.getWorkflow().getOperations().get(i)) instanceof WorkerBasedOperation && (processingJobGuid = ((WorkerBasedOperation)o).getProcessingJobGuid()) != null) {
                    Engine.this.logHandler.startWorkerWatch(processingJobGuid, Engine.this.model);
                }
            }

            public void beforeOperationStart(WorkflowExecutionEvent workflowExecutionEvent, Operation operation) {
                if (operation.executionPosition == 1) {
                    ExecutionProfileUtils executionProfileUtils = new ExecutionProfileUtils(Engine.this.executionProfile, Engine.this.fileLibraryFiles, "");
                    try {
                        Engine.this.additionalFilesTempDirectory = Paths.get(System.getProperty("java.io.tmpdir"), "Automate", "job-" + UidUtils.getShortId((String)Engine.this.jobModel.getId()), "AdditionalFiles");
                        LOGGER.info("Creating temporary Additional Files folder " + Engine.this.additionalFilesTempDirectory);
                        executionProfileUtils.createAdditionalFiles(workflowExecution, Engine.this.additionalFilesTempDirectory);
                        executionProfileUtils.createFileParameters(workflowExecution, Engine.this.jobModel.getSessionParameters(), Engine.this.additionalFilesTempDirectory);
                    }
                    catch (Exception e) {
                        LOGGER.error("Cannot create additional files", (Throwable)e);
                    }
                }
                if (operation instanceof ConfigureParametersOperation) {
                    ((ConfigureParametersOperation)operation).setLibraryFiles(Engine.this.fileLibraryFiles);
                }
                if (operation instanceof ScriptOperation) {
                    ((ScriptOperation)operation).setLibraryFiles(Engine.this.fileLibraryFiles);
                }
                if (operation instanceof DatasetOperation) {
                    DatasetOperation dataSetOperation = (DatasetOperation)operation;
                    if (Engine.this.dataSetsMetadata != null && Engine.this.dataSetsMetadata.size() > 0) {
                        LOGGER.info("Populating Dataset metadata for " + Engine.this.dataSetsMetadata.size() + " dataset(s)");
                        dataSetOperation.setDatasetsMetadata(Engine.this.dataSetsMetadata);
                    } else {
                        dataSetOperation.setDatasetsMetadata(new HashMap());
                    }
                }
                if (operation instanceof DataRepositoryOperation) {
                    DataRepositoryOperation dataRepositoryOperation = (DataRepositoryOperation)operation;
                    if (Engine.this.dataRepositories != null) {
                        dataRepositoryOperation.setDataRepositories(Engine.this.dataRepositories);
                    } else {
                        dataRepositoryOperation.setDataRepositories(new HashMap());
                    }
                }
                if (operation instanceof ThirdPartyServiceOperation) {
                    ThirdPartyServiceOperation thirdPartyServiceOperation = (ThirdPartyServiceOperation)operation;
                    if (Engine.this.thirdPartyServices != null && !Engine.this.thirdPartyServices.isEmpty()) {
                        LOGGER.info("Populating " + Engine.this.thirdPartyServices.size() + " Third-Party Service(s) for operation: " + operation.getOperationName());
                        thirdPartyServiceOperation.setThirdPartyServices(Engine.this.thirdPartyServices);
                    } else {
                        thirdPartyServiceOperation.setThirdPartyServices(new HashMap());
                    }
                }
                if (operation instanceof ScheduleEventOperation && Engine.this.jobModel.getScheduleEvent() != null) {
                    LOGGER.info("Setting schedule_event for operation: " + operation.getOperationName());
                    ((ScheduleEventOperation)operation).setScheduleEvent(Engine.this.jobModel.getScheduleEvent());
                }
                if (operation instanceof WorkerBasedOperation && Engine.this.logHandler != null) {
                    Engine.this.logHandler.watchJob();
                }
                operation.setRunningLogMaxSize(Engine.this.configuration.getJobRunningLogMaxSize());
                JobOperationEvent processingJobOperationEvent = new JobOperationEvent();
                processingJobOperationEvent.setEventType(EventType.Type.JOB_OPERATION_STARTED);
                processingJobOperationEvent.setOperationStatus(Engine.this.currentJobWorker.operationToOperationStatus(operation, Engine.this.jobModel.getId()));
                Engine.this.currentJobWorker.addProcessingEvent(processingJobOperationEvent);
            }

            public void afterOperationSkipped(WorkflowExecutionEvent workflowExecutionEvent, Operation operation) {
                JobOperationEvent processingJobOperationEvent = new JobOperationEvent();
                processingJobOperationEvent.setEventType(EventType.Type.JOB_OPERATION_SKIPPED);
                processingJobOperationEvent.setOperationStatus(Engine.this.currentJobWorker.operationToOperationStatus(operation, Engine.this.jobModel.getId()));
                Engine.this.currentJobWorker.addProcessingEvent(processingJobOperationEvent);
            }

            public void afterOperationFinish(WorkflowExecutionEvent workflowExecutionEvent, Operation operation, boolean isOperationLast) {
                Workflow workflow;
                com.nuix.automate.utils.utilization.Operation operationUtilization;
                Utilities nuixUtilities;
                Map updatedFileLibraryFiles;
                if (operation instanceof UseCaseOperation) {
                    try {
                        String casePath = executionContext.nuixCase.getLocation().getAbsolutePath();
                        ExecutionProfileUtils executionProfileUtils = new ExecutionProfileUtils(Engine.this.executionProfile, Engine.this.fileLibraryFiles, casePath);
                        executionProfileUtils.createNuixProfiles(workflowExecution);
                    }
                    catch (Exception e) {
                        LOGGER.error("Cannot create case profiles", (Throwable)e);
                    }
                }
                if (operation instanceof ScriptOperation && !(updatedFileLibraryFiles = ((ScriptOperation)operation).getUpdatedLibraryFiles()).isEmpty()) {
                    Engine.this.fileLibraryFiles.putAll(updatedFileLibraryFiles);
                    List newSessionParameters = ((ScriptOperation)operation).getUpdatedParameters();
                    ExecutionProfileUtils executionProfileUtils = new ExecutionProfileUtils(Engine.this.executionProfile, Engine.this.fileLibraryFiles, "");
                    try {
                        Engine.this.additionalFilesTempDirectory = Paths.get(System.getProperty("java.io.tmpdir"), "Automate", "job-" + UidUtils.getShortId((String)Engine.this.jobModel.getId()), "AdditionalFiles");
                        LOGGER.info("Creating temporary Additional Files folder " + Engine.this.additionalFilesTempDirectory);
                        executionProfileUtils.createFileParameters(workflowExecution, newSessionParameters, Engine.this.additionalFilesTempDirectory);
                    }
                    catch (Exception e) {
                        LOGGER.error("Cannot create additional files", (Throwable)e);
                    }
                }
                try {
                    UtilizationUtils.trackSessionVolumes((LicenceSession)Engine.this.licenceSession, (WorkflowExecution)workflowExecution, (WorkflowExecutionEvent)workflowExecutionEvent, (Operation)operation, (boolean)isOperationLast);
                }
                catch (Exception e) {
                    LOGGER.error("Cannot track session volumes", (Throwable)e);
                }
                try {
                    UtilizationUtils.trackConsumption((LicenceSession)Engine.this.licenceSession, (Operation)operation);
                }
                catch (Exception e) {
                    LOGGER.error("Cannot track operation consumption", (Throwable)e);
                }
                Engine.this.currentJobWorker.operationFinished(operation);
                JobOperationEvent processingJobOperationEvent = new JobOperationEvent();
                processingJobOperationEvent.setEventType(EventType.Type.JOB_OPERATION_ENDED);
                processingJobOperationEvent.setOperationStatus(Engine.this.currentJobWorker.operationToOperationStatus(operation, Engine.this.jobModel.getId()));
                Engine.this.currentJobWorker.addProcessingEvent(processingJobOperationEvent);
                OperationUtilizationModel operationUtilizationModel = new OperationUtilizationModel();
                operationUtilizationModel.setUtilizationId(UidUtils.getRandom());
                if (operation.executionPosition == 1 && (nuixUtilities = workflowExecution.getExecutionContext().nuixUtilities) != null) {
                    List mimeTypes = Engine.this.getAllMimeTypes(workflowExecution.getExecutionContext().nuixUtilities);
                    operationUtilizationModel.setMimeTypes(mimeTypes);
                }
                if (operation instanceof UseCaseOperationImplementation || Engine.this.nuixCase == null && workflowExecution.getExecutionContext().nuixCase != null) {
                    Engine.this.nuixCase = new NuixCase();
                    Engine.this.nuixCase.setNuixCaseName(workflowExecution.getExecutionContext().nuixCase.getName());
                    Engine.this.nuixCase.setNuixCaseId(workflowExecution.getExecutionContext().nuixCase.getGuid());
                    Engine.this.nuixCase.setNuixCaseLocation(workflowExecution.getExecutionContext().nuixCase.getLocation().getAbsolutePath());
                    Engine.this.nuixCase.setNuixCaseVersion(NuixCaseUtils.getNuixCaseVersion((String)workflowExecution.getExecutionContext().nuixCase.getLocation().getAbsolutePath()));
                    if (operation instanceof UseCaseOperationImplementation) {
                        UseCaseOperationImplementation useCaseOperation = (UseCaseOperationImplementation)operation;
                        Engine.this.nuixCase.setNuixCaseCreationEpoch(useCaseOperation.getCaseCreationEpoch());
                    } else {
                        HashMap<String, String> historyOptions = new HashMap<String, String>();
                        historyOptions.put("order", "start_date_ascending");
                        try {
                            Iterable history = workflowExecution.getExecutionContext().nuixCase.getHistory(historyOptions);
                            HistoryEvent firstEvent = (HistoryEvent)history.iterator().next();
                            Engine.this.nuixCase.setNuixCaseCreationEpoch(firstEvent.getStartDate().getMillis());
                        }
                        catch (IOException e) {
                            LOGGER.warn("Cannot get Nuix case creation time", (Throwable)e);
                        }
                    }
                    Engine.this.licenceSession.tryTrackNuixCaseAsync(Engine.this.nuixCase);
                    operationUtilizationModel.setNuixCase(Engine.this.nuixCase);
                }
                if (operation instanceof RelativitySetWorkspaceOperationImplementation) {
                    RelativitySetWorkspaceOperationImplementation relativitySetWorkspaceOperation = (RelativitySetWorkspaceOperationImplementation)operation;
                    Engine.this.relativityWorkspace = new RelativityWorkspace();
                    try {
                        Engine.this.relativityWorkspace.setRelativityWorkspaceArtifactId(executionContext.evalParameters("{relativity_workspace_id}", operation));
                    }
                    catch (ParameterException e) {
                        LOGGER.error("Cannot evaluate Relativity Workspace ID");
                    }
                    try {
                        Engine.this.relativityWorkspace.setRelativityWorkspaceName(executionContext.evalParameters("{relativity_workspace_name}", operation));
                    }
                    catch (ParameterException e) {
                        LOGGER.error("Cannot evaluate Relativity Workspace Name");
                    }
                    try {
                        String relativityServiceId = executionContext.evalParameters("{wfn_relativity_instance_id}", operation);
                        Engine.this.relativityWorkspace.setRelativityServiceId(relativityServiceId);
                        Engine.this.licenceSession.setRelativityServiceId(relativityServiceId);
                    }
                    catch (ParameterException e) {
                        LOGGER.error("Cannot evaluate Relativity Service ID");
                    }
                    Engine.this.licenceSession.tryTrackRelativityWorkspaceAsync(Engine.this.relativityWorkspace);
                    operationUtilizationModel.setRelativityWorkspace(Engine.this.relativityWorkspace);
                }
                if (operation instanceof ConfigureRelativityConnectionOperationImplementation) {
                    try {
                        String relativityServiceId = executionContext.evalParameters("{wfn_relativity_instance_id}", operation);
                        Engine.this.licenceSession.setRelativityServiceId(relativityServiceId);
                        Engine.this.licenceSession.tryTrackEventAsync(Engine.this.licenceSession.getPingEvent());
                    }
                    catch (ParameterException e) {
                        LOGGER.error("Cannot evaluate Relativity Service ID");
                    }
                }
                if ((operationUtilization = operation.getOperationUtilization(Engine.this.licenceSession.getId())).getMimeTypeVolumes() != null) {
                    for (MimeTypeVolume mimeTypeVolume : operationUtilization.getMimeTypeVolumes()) {
                        mimeTypeVolume.setOperationId(operationUtilization.getOperationId());
                    }
                }
                if (Engine.this.nuixCase != null) {
                    operationUtilization.setNuixCaseId(Engine.this.nuixCase.getNuixCaseId());
                }
                if (Engine.this.relativityWorkspace != null) {
                    operationUtilization.setRelativityWorkspaceArtifactId(Engine.this.relativityWorkspace.getRelativityWorkspaceArtifactId());
                }
                Engine.this.licenceSession.tryTrackOperationUtilizationAsync(operationUtilization);
                operationUtilizationModel.setOperation(operationUtilization);
                Engine.this.currentJobWorker.addUtilization(operationUtilizationModel);
                if (operation instanceof CloseCaseOperation) {
                    Engine.this.nuixCase = null;
                }
                if ((workflow = workflowExecution.getWorkflow()).getWorkflowModifiedSinceLastSave()) {
                    long executionVersion = ((Operation)workflow.getOperations().get((int)0)).startDateTime.getMillis();
                    WorkflowDynamicUpdate workflowDynamicUpdate = new WorkflowDynamicUpdate();
                    workflowDynamicUpdate.setJobId(Engine.this.jobModel.getId());
                    workflowDynamicUpdate.setWorkflowId(Engine.this.jobModel.getId() + "_d");
                    Long lastModifiedEpoch = workflow.getLastModifiedEpoch();
                    if (lastModifiedEpoch == null) {
                        lastModifiedEpoch = ((Operation)workflow.getOperations().get((int)0)).startDateTime.getMillis();
                    }
                    workflowDynamicUpdate.setUpdateDate(lastModifiedEpoch.longValue());
                    workflowDynamicUpdate.setOriginalVersion(executionVersion);
                    LOGGER.info("Detected workflow change, tracking Dynamic Workflow Update");
                    try {
                        workflow.clearSensitiveValues();
                        String workflowXml = workflow.toXml();
                        workflowDynamicUpdate.setWorkflowXml(workflowXml);
                        Engine.this.currentJobWorker.addWorkflowDynamicUpdate(workflowDynamicUpdate);
                    }
                    catch (IOException e) {
                        LOGGER.error("Cannot serialize workflow", (Throwable)e);
                    }
                    workflow.setSaved();
                }
                if (operation instanceof WorkerBasedOperation && Engine.this.logHandler != null) {
                    Engine.this.logHandler.removeJobWatch();
                }
            }

            public void afterOperationError(WorkflowExecutionEvent workflowExecutionEvent, Operation operation) {
                JobOperationEvent processingJobOperationEvent = new JobOperationEvent();
                processingJobOperationEvent.setOperationStatus(Engine.this.currentJobWorker.operationToOperationStatus(operation, Engine.this.jobModel.getId()));
                if (operation.executionState == ExecutionState.SOFT_ERROR) {
                    processingJobOperationEvent.setEventType(EventType.Type.JOB_OPERATION_SOFT_ERROR);
                } else {
                    processingJobOperationEvent.setEventType(EventType.Type.JOB_OPERATION_ERROR);
                }
                Engine.this.currentJobWorker.addProcessingEvent(processingJobOperationEvent);
                com.nuix.automate.utils.utilization.Operation operationUtilization = operation.getOperationUtilization(Engine.this.licenceSession.getId());
                operationUtilization.setMimeTypeVolumes(null);
                if (Engine.this.nuixCase != null) {
                    operationUtilization.setNuixCaseId(Engine.this.nuixCase.getNuixCaseId());
                }
                Engine.this.licenceSession.tryTrackOperationUtilizationAsync(operationUtilization);
                OperationUtilizationModel operationUtilizationModel = new OperationUtilizationModel();
                operationUtilizationModel.setUtilizationId(UidUtils.getRandom());
                operationUtilizationModel.setOperation(operationUtilization);
                if (operationUtilization.getOperationEndEpoch() == 0L) {
                    operationUtilization.setOperationEndEpoch(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis());
                }
                Engine.this.currentJobWorker.addUtilization(operationUtilizationModel);
                if (operation.executionState == ExecutionState.ERROR && operation instanceof WorkerBasedOperation && Engine.this.logHandler != null) {
                    Engine.this.logHandler.removeJobWatch();
                }
                try {
                    UtilizationUtils.trackConsumption((LicenceSession)Engine.this.licenceSession, (Operation)operation);
                }
                catch (Exception e) {
                    LOGGER.error("Cannot track operation consumption", (Throwable)e);
                }
            }

            public void onOperationWarning(WorkflowExecutionEvent workflowExecutionEvent, Operation operation, String s) {
                JobOperationEvent processingJobOperationEvent = new JobOperationEvent();
                processingJobOperationEvent.setEventType(EventType.Type.JOB_OPERATION_WARNING);
                processingJobOperationEvent.setOperationStatus(Engine.this.currentJobWorker.operationToOperationStatus(operation, Engine.this.jobModel.getId()));
                Engine.this.currentJobWorker.addProcessingEvent(processingJobOperationEvent);
            }

            public void onConfigurationPrompt(WorkflowExecutionEvent workflowExecutionEvent, Operation operation) throws UserCancelledException {
            }

            public void onUseCasePrompt(WorkflowExecutionEvent workflowExecutionEvent, ExecutionContext executionContext2, Operation operation) throws UserCancelledException {
            }
        });
    }

    public void runJob(JobModel jobModel) {
        LOGGER.info(this.model + " Running job " + jobModel);
        this.model.setStatus(EngineStatus.RUNNING);
        jobModel.setBootstrap(false);
        WorkflowExecution workflowExecution = this.currentJobWorker.getWorkflowExecution();
        try {
            workflowExecution.log(this.iu.getFormattedString("Engine.LogFile", (Object)this.model.getLogFile()));
            workflowExecution.log(this.iu.getFormattedString("Engine.ExecutionMode", (Object)this.engineApplicationExecutionMode.toLocalizedString()));
            if (ExecutionMode.AUTOMATE_NATIVE.equals((Object)this.workflowExecutionMode) && ExecutionMode.AUTOMATE_NUIX.equals((Object)this.engineApplicationExecutionMode)) {
                workflowExecution.log(this.iu.getFormattedString("Engine.WorkflowExecutionMode", (Object)this.workflowExecutionMode.toLocalizedString()));
            }
            workflowExecution.runWorkflow(true);
            this.currentJobWorker.getModel().setBootstrap(false);
        }
        catch (Exception e) {
            LOGGER.error("Cannot run job", (Throwable)e);
            jobModel.setError(this.iu.getFormattedString("Engine.CannotRunJob", (Object)ExceptionUtils.getExceptionPrintableMessage((Throwable)e)));
            workflowExecution.log(this.iu.getFormattedString("Engine.CannotRunJob", (Object)ExceptionUtils.getExceptionPrintableMessage((Throwable)e)), LogLevel.ERROR);
        }
    }

    public Future<nuix.engine.Engine> createEngineFuture(String username, String filter, SourceType licenceSource, RelayType relayType, int workers, int minWorkers, String nmsName, int nmsPort, String licenceUsername, String licencePassword, Set<String> whitelistedCertificatesFingerprints) {
        return this.executor.submit(() -> {
            while (true) {
                try {
                    nuix.engine.Engine engine;
                    do {
                        Thread.sleep(1000L);
                    } while ((engine = this.createEngine(username, filter, licenceSource, relayType, workers, minWorkers, nmsName, nmsPort, licenceUsername, licencePassword, whitelistedCertificatesFingerprints)) == null);
                    this.model.setError("");
                    return engine;
                }
                catch (InterruptedException e) {
                    return null;
                }
                catch (Exception e) {
                    this.model.setError(this.iu.getFormattedString("Engine.Retrying", (Object)ExceptionUtils.getExceptionPrintableMessage((Throwable)e)));
                    this.message = this.iu.getFormattedString("Engine.Retrying", (Object)ExceptionUtils.getExceptionPrintableMessage((Throwable)e));
                    LOGGER.warn("Could not acquire licence, retrying", (Throwable)e);
                    continue;
                }
                break;
            }
        });
    }

    public Licence switchLicence(String filter, LicenceSourceType licenceSourceType, int workers, String nmsName, int nmsPort, String username, String password, int timeout) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Server command: switchLicence");
        }
        if (workers == 0 || licenceSourceType == LicenceSourceType.NONE) {
            EngineApplication.getInstance().getLicenceUtils().setLicenceInfo(this.rampivaLicence.getLicenceInfo());
            if (!EngineApplication.getInstance().getLicenceUtils().getLicenceInfo().getModuleLicensed(ModuleType.SCHEDULER_ADVANCED)) {
                WorkflowExecution workflowExecution = this.currentJobWorker.getWorkflowExecution();
                Operation o = (Operation)workflowExecution.getWorkflow().getOperations().get(workflowExecution.getWorkflowExecutionPosition());
                o.addWarning(this.iu.getString("Licence.Error.SwitchingToNoWorkers"));
                workers = -1;
                licenceSourceType = LicenceSourceType.ENGINE_DEFAULT;
            }
        }
        ExecutionContext executionContext = this.currentJobWorker.getWorkflowExecution().getExecutionContext();
        if (executionContext.nuixCase != null) {
            if (this.engine != null) {
                this.lastNuixCaseLocation = executionContext.nuixCase.getLocation();
                LOGGER.info("Closing previous case " + executionContext.nuixCase);
                this.lastNuixCaseTimeZone = executionContext.nuixCase.getInvestigationTimeZone();
                executionContext.nuixCase.close();
            }
        } else {
            this.lastNuixCaseLocation = null;
        }
        LOGGER.info("Closing previous engine " + this.engine);
        if (this.engine != null) {
            this.closeNuixEngine();
        }
        this.model.setEngineVersion("");
        this.model.setAcquiredWorkers(Integer.valueOf(0));
        if (licenceSourceType == LicenceSourceType.NONE) {
            return null;
        }
        int minWorkers = workers;
        if (workers == -1) {
            workers = this.model.getTargetNuixWorkers();
            minWorkers = this.model.getMinNuixWorkers();
            LOGGER.info("Using default worker count " + workers);
        }
        SourceType nuixLicenceSourceType = null;
        RelayType relayType = null;
        switch (licenceSourceType) {
            case NMS: {
                nuixLicenceSourceType = SourceType.NMS;
                break;
            }
            case DONGLE: {
                nuixLicenceSourceType = SourceType.DONGLE;
                break;
            }
            case NONE: {
                nuixLicenceSourceType = SourceType.NONE;
                break;
            }
            case ENGINE_DEFAULT: {
                nuixLicenceSourceType = this.nuixLicenceSource.getSourceType();
                relayType = this.nuixLicenceSource.getRelayType();
                nmsName = this.nuixLicenceSource.getServerName();
                nmsPort = this.nuixLicenceSource.getServerPort() != null ? this.nuixLicenceSource.getServerPort() : 0;
                username = this.nuixLicenceSource.getUsername();
                password = this.nuixLicenceSource.getPassword();
                break;
            }
            case CLS: {
                nuixLicenceSourceType = SourceType.CLS;
                break;
            }
            default: {
                LOGGER.error("Cannot switch to license type " + licenceSourceType);
                this.message = "Unsupported license type " + licenceSourceType;
                this.closeNuixEngine();
                return null;
            }
        }
        LOGGER.info("Attempting to create new engine");
        this.message = this.iu.getString("Engine.SearchingForLicences");
        Future<nuix.engine.Engine> engineFuture = this.createEngineFuture(this.currentJobWorker.getModel().getSubmittedBy(), filter, nuixLicenceSourceType, relayType, workers, minWorkers, nmsName, nmsPort, username, password, this.nuixLicenceSource.getWhitelistedCertFingerprints());
        try {
            nuix.engine.Engine engine = engineFuture.get(timeout, TimeUnit.SECONDS);
            LOGGER.info("Created new engine " + engine);
            this.engine = engine;
            this.model.setEngineVersion(engine.getVersion());
            this.model.setAcquiredWorkers(engine.getLicence().getWorkers());
            try {
                this.model.setNuixLicenceType(engine.getUtilities().getLicence().getShortName());
            }
            catch (Exception e) {
                LOGGER.warn("Cannot set license details", (Throwable)e);
                this.model.setError(e.getLocalizedMessage());
            }
            this.model.setError(null);
            this.model.setStatus(EngineStatus.RUNNING);
            executionContext.nuixUtilities = engine.getUtilities();
            if (this.lastNuixCaseLocation != null) {
                LOGGER.info("Reopening previous case");
                executionContext.nuixCase = engine.getUtilities().getCaseFactory().open(this.lastNuixCaseLocation);
                LOGGER.info("Setting previous timezone");
                executionContext.nuixCase.setInvestigationTimeZone(this.lastNuixCaseTimeZone);
            }
            if (this.licenceSession != null) {
                this.licenceSession.close();
                this.licenceSession = null;
            }
            this.licenceSession = new EngineLicenceSession(this.currentJobWorker, this.rampivaLicence.getLicenceInfo(), executionContext.nuixUtilities.getLicence(), Product.ENGINE, VersionResources.getVersion(), executionContext.nuixVersion.toString(), null, DiagnosticLevel.OPTIONAL);
            try {
                executionContext.licenceSession = this.licenceSession;
            }
            catch (Throwable t) {
                LOGGER.warn("Cannot set execution license session", t);
            }
            this.licenceSession.startSchedule();
            return engine.getLicence();
        }
        catch (InterruptedException e) {
            LOGGER.error("Cannot create engine", (Throwable)e);
            this.message = ExceptionUtils.getExceptionPrintableMessage((Throwable)e);
            this.closeNuixEngine();
        }
        catch (ExecutionException e) {
            LOGGER.error("Cannot create engine", (Throwable)e);
            this.message = ExceptionUtils.getExceptionPrintableMessage((Throwable)e);
            this.closeNuixEngine();
        }
        catch (TimeoutException e) {
            LOGGER.error("Cannot create engine", (Throwable)e);
            this.message = ExceptionUtils.getExceptionPrintableMessage((Throwable)e);
            this.closeNuixEngine();
        }
        catch (IOException e) {
            LOGGER.error("Cannot open case", (Throwable)e);
            this.message = ExceptionUtils.getExceptionPrintableMessage((Throwable)e);
            this.closeNuixEngine();
        }
        engineFuture.cancel(true);
        return null;
    }

    public String getMessage() {
        return this.message;
    }

    public void pause() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Server command: pause");
        }
        this.pauseJob();
    }

    public int getMaxWorkerCount() {
        int acquiredWorkers = this.model.getAcquiredWorkers();
        LOGGER.info("Getting acquiredWorkers: " + acquiredWorkers);
        if (acquiredWorkers <= 0) {
            acquiredWorkers = 1000;
            LOGGER.info("Adjusting acquiredWorkers: " + acquiredWorkers);
        }
        int targetWorkers = this.model.getTargetNuixWorkers();
        LOGGER.info("Getting targetWorkers: " + targetWorkers);
        if (targetWorkers <= 0) {
            targetWorkers = 1000;
            LOGGER.info("Adjusting targetWorkers: " + targetWorkers);
        }
        int workerCount = Math.min(acquiredWorkers, targetWorkers);
        LOGGER.info("Setting workerCount: " + workerCount);
        return workerCount;
    }

    @JsonIgnore
    public String getJobId() {
        if (this.jobModel != null) {
            return this.jobModel.getId();
        }
        return null;
    }

    public List<OperationUtilizationModel> removeUtilizations() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Server command: removeUtilizations");
        }
        if (this.currentJobWorker != null) {
            return this.currentJobWorker.removeUtilizations();
        }
        return new ArrayList<OperationUtilizationModel>();
    }

    public List<Consumption> removeConsumptions() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Server command: removeConsumptions");
        }
        if (this.currentJobWorker != null) {
            return this.currentJobWorker.removeConsumptions();
        }
        return new ArrayList<Consumption>();
    }

    public List<JobOperationEvent> removeProcessingEvents() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Server command: removeProcessingEvents");
        }
        if (this.currentJobWorker != null) {
            return this.currentJobWorker.removeProcessingEvents();
        }
        return new ArrayList<JobOperationEvent>();
    }

    public List<WorkflowDynamicUpdate> removeWorkflowDynamicUpdates() throws RemoteException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Server command: removeWorkflowDynamicUpdates");
        }
        if (this.currentJobWorker != null) {
            return this.currentJobWorker.removeWorkflowDynamicUpdates();
        }
        return new ArrayList<WorkflowDynamicUpdate>();
    }

    public List<EventInfo> removeSessionEventInfos() {
        if (this.currentJobWorker != null) {
            return this.currentJobWorker.removeSessionEventInfos();
        }
        return new ArrayList<EventInfo>();
    }

    public JobModel updateJobModel(JobModel newJobModel) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Server command: updateJobModel");
        }
        return this.currentJobWorker.updateJobModel(newJobModel);
    }

    public List<LogEventModel> getEngineLogs() throws RemoteException {
        if (this.logHandler != null) {
            return this.logHandler.removeComponentLogs();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LogEventModel> getExecutionLogs() throws RemoteException {
        if (this.executionLogs == null) {
            this.executionLogs = new ArrayList<LogEventModel>();
            return this.executionLogs;
        }
        Object object = this.logsLock;
        synchronized (object) {
            ArrayList<LogEventModel> executionLogs = new ArrayList<LogEventModel>(this.executionLogs);
            this.executionLogs = new ArrayList<LogEventModel>();
            return executionLogs;
        }
    }

    public void updateEngineLogModel(boolean useCentralizedLogging) {
        if (this.logHandler != null) {
            this.logHandler.updateLogHandler(useCentralizedLogging);
        }
    }
}

