/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.engine.workers;

import com.nuix.automate.engine.workers.Engine;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.OperationMimeTypeStats;
import com.nuix.automate.utils.licence.services.EventInfo;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.executionprofile.JobTimeoutSettings;
import com.nuix.automate.utils.models.api.job.JobOperationEvent;
import com.nuix.automate.utils.models.api.job.OperationStatus;
import com.nuix.automate.utils.models.api.workflowlibrary.WorkflowDynamicUpdate;
import com.nuix.automate.utils.models.internal.executionprofile.ExecutionProfileModel;
import com.nuix.automate.utils.models.internal.job.JobModel;
import com.nuix.automate.utils.models.internal.job.JobProgress;
import com.nuix.automate.utils.models.internal.logging.RunningLogEventsModel;
import com.nuix.automate.utils.utilization.OperationUtilizationModel;
import com.nuix.automate.utils.utilization.consumption.Consumption;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.LogLevel;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.operations.RemoteWorkerBasedOperation;
import com.nuix.automate.workflow.core.execution.workflow.Workflow;
import com.nuix.automate.workflow.core.execution.workflow.WorkflowExecution;
import com.nuix.automate.workflow.core.execution.workflow.WorkflowRenderer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import org.joda.time.DateTime;

public class JobWorker {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(JobWorker.class);
    private InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");
    private JobModel model;
    private WorkflowExecution workflowExecution;
    private List<OperationUtilizationModel> utilizations;
    private List<Consumption> consumptions;
    private List<JobOperationEvent> jobEvents;
    private List<WorkflowDynamicUpdate> workflowDynamicUpdates;
    private Map<String, EventInfo> sessionEventInfos;
    private ExecutionProfileModel executionProfile;
    private SortedMap<Long, JobProgress> historicalProgresses;
    private TimerTask progressTimeoutTimerTask;
    private Timer progressTimeoutTimer;
    private Engine engine;
    private boolean jobProgressTimeoutWarningTriggered;
    private Operation jobProgressTimeoutWarningTriggeredOnOperation;
    private boolean operationProgressTimeoutWarningTriggered;
    private Operation operationProgressTimeoutWarningTriggeredOnOperation;
    private boolean skipOperationProgressTimeoutWarningTriggered;
    private Operation skipOperationProgressTimeoutWarningTriggeredOnOperation;
    private String jobTransientWarningMessage;
    private String operationTransientWarningMessage;
    private String skipOperationTransientWarningMessage;
    private Integer skippedOperationId;

    public JobWorker(JobModel model, ExecutionProfileModel executionProfile, Engine engine) {
        this.model = model;
        this.executionProfile = executionProfile;
        this.utilizations = new ArrayList<OperationUtilizationModel>();
        this.consumptions = new ArrayList<Consumption>();
        this.jobEvents = new ArrayList<JobOperationEvent>();
        this.workflowDynamicUpdates = new ArrayList<WorkflowDynamicUpdate>();
        this.sessionEventInfos = new HashMap<String, EventInfo>();
        this.historicalProgresses = new TreeMap<Long, JobProgress>();
        this.engine = engine;
        this.initializeProgressTimer();
    }

    public Engine getEngine() {
        return this.engine;
    }

    public static long getMinuteEpoch() {
        long minute = DateTime.now().getMillis() / 1000L / 60L;
        return minute;
    }

    void initializeProgressTimer() {
        double effectiveTimeoutHours;
        JobTimeoutSettings jobTimeoutSettings = this.executionProfile.getJobTimeoutSettings();
        if (jobTimeoutSettings == null) {
            return;
        }
        long interval = 60000L;
        LOGGER.info("Starting progress timer with recurrence of " + interval + " ms");
        this.progressTimeoutTimerTask = new TimerTask(){

            @Override
            public void run() {
                JobWorker.this.trackProgress();
            }
        };
        if (jobTimeoutSettings.getJobProgressTimeoutHours() != null) {
            effectiveTimeoutHours = jobTimeoutSettings.getJobProgressTimeoutHours() / 2.0;
            this.jobTransientWarningMessage = effectiveTimeoutHours == 1.0 ? this.iu.getFormattedString("JobWorker.JobProgressTimeoutWarning1", (Object)jobTimeoutSettings.getJobProgressMinPercentage()) : this.iu.getFormattedString("JobWorker.JobProgressTimeoutWarning2", new Object[]{jobTimeoutSettings.getJobProgressMinPercentage(), effectiveTimeoutHours});
        }
        if (jobTimeoutSettings.getOperationProgressTimeoutHours() != null) {
            effectiveTimeoutHours = jobTimeoutSettings.getOperationProgressTimeoutHours() / 2.0;
            this.operationTransientWarningMessage = effectiveTimeoutHours == 1.0 ? this.iu.getFormattedString("JobWorker.OperationProgressTimeoutWarning1", (Object)jobTimeoutSettings.getOperationProgressMinPercentage()) : this.iu.getFormattedString("JobWorker.OperationProgressTimeoutWarning2", new Object[]{jobTimeoutSettings.getOperationProgressMinPercentage(), effectiveTimeoutHours});
        }
        if (jobTimeoutSettings.getSkipOperationProgressTimeoutHours() != null) {
            effectiveTimeoutHours = jobTimeoutSettings.getSkipOperationProgressTimeoutHours() / 2.0;
            this.skipOperationTransientWarningMessage = effectiveTimeoutHours == 1.0 ? this.iu.getFormattedString("JobWorker.SkipOperationProgressTimeoutWarning1", (Object)jobTimeoutSettings.getSkipOperationProgressMinPercentage()) : this.iu.getFormattedString("JobWorker.SkipOperationProgressTimeoutWarning2", new Object[]{jobTimeoutSettings.getSkipOperationProgressMinPercentage(), "" + effectiveTimeoutHours});
        }
        this.progressTimeoutTimer = new Timer(true);
        this.progressTimeoutTimer.scheduleAtFixedRate(this.progressTimeoutTimerTask, 0L, interval);
    }

    public void operationFinished(Operation o) {
        if (this.operationProgressTimeoutWarningTriggered) {
            this.clearTransientOperationTimeoutWarning();
        }
        if (this.skipOperationProgressTimeoutWarningTriggered && this.skippedOperationId == null) {
            this.clearTransientSkipOperationTimeoutWarning(o);
        }
        this.skippedOperationId = null;
    }

    public synchronized void jobFinished() {
        if (this.jobProgressTimeoutWarningTriggered) {
            this.clearTransientJobTimeoutWarning();
        }
        try {
            if (this.progressTimeoutTimer != null) {
                this.progressTimeoutTimer.cancel();
                this.progressTimeoutTimer.purge();
            }
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Cannot stop timer", (Throwable)e);
            }
            LOGGER.warn("Cannot stop timer, " + ExceptionUtils.getExceptionPrintableMessage((Throwable)e));
        }
    }

    private void clearTransientJobTimeoutWarning() {
        this.jobProgressTimeoutWarningTriggered = false;
        try {
            this.jobProgressTimeoutWarningTriggeredOnOperation.addTransientWarning(this.jobTransientWarningMessage, true);
            this.jobProgressTimeoutWarningTriggeredOnOperation = null;
        }
        catch (Exception e) {
            LOGGER.warn("Cannot log message at operation level");
            try {
                this.workflowExecution.log(this.jobTransientWarningMessage, LogLevel.TRANSIENT_WARNING_RESOLVED);
            }
            catch (Exception ee) {
                LOGGER.warn("Cannot log message at workflow level");
            }
        }
    }

    private void clearTransientOperationTimeoutWarning() {
        this.operationProgressTimeoutWarningTriggered = false;
        try {
            this.operationProgressTimeoutWarningTriggeredOnOperation.addTransientWarning(this.operationTransientWarningMessage, true);
            this.operationProgressTimeoutWarningTriggeredOnOperation = null;
        }
        catch (Exception e) {
            LOGGER.warn("Cannot log message at operation level");
            try {
                this.workflowExecution.log(this.operationTransientWarningMessage, LogLevel.TRANSIENT_WARNING_RESOLVED);
            }
            catch (Exception ee) {
                LOGGER.warn("Cannot log message at workflow level");
            }
        }
    }

    private void clearTransientSkipOperationTimeoutWarning(Operation o) {
        if (o == null || !o.equals(this.skipOperationProgressTimeoutWarningTriggeredOnOperation)) {
            return;
        }
        this.skipOperationProgressTimeoutWarningTriggered = false;
        try {
            this.skipOperationProgressTimeoutWarningTriggeredOnOperation.addTransientWarning(this.skipOperationTransientWarningMessage, true);
            this.skipOperationProgressTimeoutWarningTriggeredOnOperation = null;
        }
        catch (Exception e) {
            LOGGER.warn("Cannot log message at operation level");
            try {
                this.workflowExecution.log(this.skipOperationTransientWarningMessage, LogLevel.TRANSIENT_WARNING_RESOLVED);
            }
            catch (Exception ee) {
                LOGGER.warn("Cannot log message at workflow level");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trackProgress() {
        if (this.engine == null || this.engine.getWorkerAgentOnly()) {
            return;
        }
        JobTimeoutSettings jobTimeoutSettings = this.executionProfile.getJobTimeoutSettings();
        if (jobTimeoutSettings == null) {
            return;
        }
        long lookBackLength = 0L;
        if (jobTimeoutSettings.getJobProgressTimeoutHours() != null && jobTimeoutSettings.getJobProgressTimeoutHours() > 0.0 && jobTimeoutSettings.getJobProgressMinPercentage() != null && jobTimeoutSettings.getJobProgressMinPercentage() > 0.0) {
            lookBackLength = (long)(jobTimeoutSettings.getJobProgressTimeoutHours() * 60.0) + 1L;
        }
        if (jobTimeoutSettings.getOperationProgressMinPercentage() != null && jobTimeoutSettings.getOperationProgressMinPercentage() > 0.0 && jobTimeoutSettings.getOperationProgressTimeoutHours() != null && jobTimeoutSettings.getOperationProgressTimeoutHours() > 0.0) {
            long operationlookBackLength = (long)(jobTimeoutSettings.getOperationProgressTimeoutHours() * 60.0) + 1L;
            lookBackLength = Math.max(lookBackLength, operationlookBackLength);
        }
        if (jobTimeoutSettings.getSkipOperationProgressMinPercentage() != null && jobTimeoutSettings.getSkipOperationProgressMinPercentage() > 0.0 && jobTimeoutSettings.getSkipOperationProgressTimeoutHours() != null && jobTimeoutSettings.getSkipOperationProgressTimeoutHours() > 0.0) {
            long skipOperationlookBackLength = (long)(jobTimeoutSettings.getSkipOperationProgressTimeoutHours() * 60.0) + 1L;
            lookBackLength = Math.max(lookBackLength, skipOperationlookBackLength);
        }
        if (lookBackLength > 0L) {
            long currentMinuteEpoch = JobWorker.getMinuteEpoch();
            boolean executionAborted = false;
            SortedMap<Long, JobProgress> sortedMap = this.historicalProgresses;
            synchronized (sortedMap) {
                Operation o;
                Integer currentOperationId;
                ArrayList<Long> timestamps;
                JobProgress jobProgress;
                block86: {
                    Operation o2;
                    Operation o3;
                    double percentageProgressSince;
                    JobProgress historicalProgress;
                    long minutesPast;
                    double effectiveTimeoutHours;
                    Map.Entry<Long, JobProgress> entry;
                    int operationExecutionPosition = 0;
                    int operationWorkflowPosition = 0;
                    int operationsCount = 0;
                    double operationProgressPercentage = 0.0;
                    double jobProgressPercentage = 0.0;
                    long itemsProcessed = 0L;
                    try {
                        operationWorkflowPosition = this.workflowExecution.getWorkflowExecutionPosition();
                        Operation operation = (Operation)this.workflowExecution.getWorkflow().getOperations().get(operationWorkflowPosition);
                        operationExecutionPosition = operation.executionPosition - 1;
                        operationProgressPercentage = 100.0 * operation.getNormalizedPercentageComplete();
                        operationsCount = this.workflowExecution.getWorkflow().getOperations().size();
                        itemsProcessed = operation.getItemsProcessed();
                    }
                    catch (Exception e) {
                        LOGGER.info("Skipping job progress tracking because Workflow Execution is not yet available");
                    }
                    if (operationsCount > 0) {
                        jobProgressPercentage = this.workflowExecution.getPercentageComplete();
                    }
                    jobProgress = new JobProgress(operationExecutionPosition, operationProgressPercentage, jobProgressPercentage, itemsProcessed);
                    this.historicalProgresses.put(currentMinuteEpoch, jobProgress);
                    long pastThresholdMinuteEpoch = currentMinuteEpoch - lookBackLength;
                    Iterator<Map.Entry<Long, JobProgress>> i = this.historicalProgresses.entrySet().iterator();
                    while (i.hasNext() && (entry = i.next()).getKey() < pastThresholdMinuteEpoch) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Removing past progress at " + entry.getKey() + " < pastThresholdMinuteEpoch (" + pastThresholdMinuteEpoch + ")");
                        }
                        i.remove();
                    }
                    timestamps = new ArrayList<Long>();
                    timestamps.addAll(this.historicalProgresses.keySet());
                    Collections.reverse(timestamps);
                    if (jobTimeoutSettings.getJobProgressTimeoutHours() != null && jobTimeoutSettings.getJobProgressTimeoutHours() > 0.0 && jobTimeoutSettings.getJobProgressMinPercentage() != null && jobTimeoutSettings.getJobProgressMinPercentage() > 0.0) {
                        effectiveTimeoutHours = jobTimeoutSettings.getJobProgressTimeoutHours() / 2.0;
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Checking for at least " + jobTimeoutSettings.getJobProgressMinPercentage() + "% progress for the past " + effectiveTimeoutHours + " hours (" + effectiveTimeoutHours * 60.0 + " minutes)");
                        }
                        boolean jobProgressTimeoutWarning = false;
                        for (Long timestamp : timestamps) {
                            minutesPast = currentMinuteEpoch - timestamp;
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("Testing timestamp " + timestamp + ", " + minutesPast + " minutes in the past");
                            }
                            if (!((double)minutesPast >= effectiveTimeoutHours * 60.0)) continue;
                            historicalProgress = (JobProgress)this.historicalProgresses.get(timestamp);
                            percentageProgressSince = jobProgress.getJobProgressPercentage() - historicalProgress.getJobProgressPercentage();
                            if (percentageProgressSince < jobTimeoutSettings.getJobProgressMinPercentage()) {
                                if (LOGGER.isDebugEnabled()) {
                                    LOGGER.debug("Progress of " + percentageProgressSince + "% is lower than required " + jobTimeoutSettings.getJobProgressMinPercentage() + "% for warnings");
                                }
                                jobProgressTimeoutWarning = true;
                                break;
                            }
                            if (!LOGGER.isDebugEnabled()) break;
                            LOGGER.debug("Progress of " + percentageProgressSince + "% is OK vs required " + jobTimeoutSettings.getJobProgressMinPercentage() + "% for warnings");
                            break;
                        }
                        if (this.jobProgressTimeoutWarningTriggered) {
                            if (!jobProgressTimeoutWarning) {
                                this.jobProgressTimeoutWarningTriggered = false;
                                this.clearTransientJobTimeoutWarning();
                            }
                        } else if (jobProgressTimeoutWarning) {
                            this.jobProgressTimeoutWarningTriggered = true;
                            try {
                                this.jobProgressTimeoutWarningTriggeredOnOperation = o3 = (Operation)this.workflowExecution.getWorkflow().getOperations().get(this.workflowExecution.getWorkflowExecutionPosition());
                                o3.addTransientWarning(this.jobTransientWarningMessage, false);
                            }
                            catch (Exception e) {
                                LOGGER.warn("Cannot log message at operation level");
                                try {
                                    this.workflowExecution.log(this.jobTransientWarningMessage, LogLevel.TRANSIENT_WARNING_TRIGGERED);
                                }
                                catch (Exception ee) {
                                    LOGGER.warn("Cannot log message at workflow level");
                                }
                            }
                        }
                        for (Long timestamp : timestamps) {
                            minutesPast = currentMinuteEpoch - timestamp;
                            if (!((double)minutesPast >= jobTimeoutSettings.getJobProgressTimeoutHours() * 60.0)) continue;
                            historicalProgress = (JobProgress)this.historicalProgresses.get(timestamp);
                            percentageProgressSince = jobProgress.getJobProgressPercentage() - historicalProgress.getJobProgressPercentage();
                            if (!(percentageProgressSince < jobTimeoutSettings.getJobProgressMinPercentage())) break;
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("Progress of " + percentageProgressSince + "% is lower than required " + jobTimeoutSettings.getJobProgressMinPercentage() + "% for errors");
                            }
                            String errorMessage = jobTimeoutSettings.getJobProgressTimeoutHours() == 1.0 ? this.iu.getFormattedString("JobWorker.JobProgressTimeoutError1", (Object)jobTimeoutSettings.getJobProgressMinPercentage()) : this.iu.getFormattedString("JobWorker.JobProgressTimeoutError2", new Object[]{jobTimeoutSettings.getJobProgressMinPercentage(), jobTimeoutSettings.getJobProgressTimeoutHours()});
                            try {
                                o2 = (Operation)this.workflowExecution.getWorkflow().getOperations().get(this.workflowExecution.getWorkflowExecutionPosition());
                                o2.addWarning(errorMessage);
                            }
                            catch (Exception e) {
                                LOGGER.warn("Cannot log message at operation level");
                                try {
                                    this.workflowExecution.log(errorMessage, LogLevel.WARNING);
                                }
                                catch (Exception ee) {
                                    LOGGER.warn("Cannot log message at workflow level");
                                }
                            }
                            executionAborted = true;
                            this.engine.abort();
                            break;
                        }
                    }
                    if (!executionAborted && jobTimeoutSettings.getOperationProgressTimeoutHours() != null && jobTimeoutSettings.getOperationProgressTimeoutHours() > 0.0 && jobTimeoutSettings.getOperationProgressMinPercentage() != null && jobTimeoutSettings.getOperationProgressMinPercentage() > 0.0) {
                        effectiveTimeoutHours = jobTimeoutSettings.getOperationProgressTimeoutHours() / 2.0;
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Checking for at least " + jobTimeoutSettings.getOperationProgressMinPercentage() + "% progress for operation for the past " + effectiveTimeoutHours + " hours (" + effectiveTimeoutHours * 60.0 + " minutes)");
                        }
                        boolean operationProgressTimeoutWarning = false;
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("jobProgress:" + jobProgress);
                        }
                        for (Long timestamp : timestamps) {
                            minutesPast = currentMinuteEpoch - timestamp;
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("Testing timestamp " + timestamp + ", " + minutesPast + " minutes in the past");
                            }
                            if (!((double)minutesPast >= effectiveTimeoutHours * 60.0)) continue;
                            historicalProgress = (JobProgress)this.historicalProgresses.get(timestamp);
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("historicalProgress:" + historicalProgress);
                            }
                            percentageProgressSince = jobProgress.getOperationProgressPercentage() - historicalProgress.getOperationProgressPercentage();
                            if (historicalProgress.getOperationId() == jobProgress.getOperationId() && percentageProgressSince < jobTimeoutSettings.getOperationProgressMinPercentage()) {
                                if (LOGGER.isDebugEnabled()) {
                                    LOGGER.debug("Progress of " + percentageProgressSince + "% is lower than required " + jobTimeoutSettings.getOperationProgressMinPercentage() + "% for warnings");
                                }
                                if (jobProgress.getItemsProcessed() > 0L) {
                                    double estimatedTotalItems = (double)jobProgress.getItemsProcessed() / (jobProgress.getJobProgressPercentage() / 100.0);
                                    double estimatedProgress = (double)(jobProgress.getItemsProcessed() - historicalProgress.getItemsProcessed()) / estimatedTotalItems * 100.0;
                                    if (!(estimatedProgress < jobTimeoutSettings.getOperationProgressMinPercentage())) break;
                                    if (LOGGER.isDebugEnabled()) {
                                        LOGGER.debug("Items processed: " + jobProgress.getItemsProcessed() + ", Historical items processed:" + historicalProgress.getItemsProcessed() + ", Estimated total items" + estimatedTotalItems + " Estimated progress of " + estimatedProgress + "% is lower than required " + jobTimeoutSettings.getOperationProgressMinPercentage() + "% for warnings");
                                    }
                                    operationProgressTimeoutWarning = true;
                                    break;
                                }
                                operationProgressTimeoutWarning = true;
                                break;
                            }
                            if (!LOGGER.isDebugEnabled()) break;
                            LOGGER.debug("Progress of " + percentageProgressSince + "% is OK vs required " + jobTimeoutSettings.getOperationProgressMinPercentage() + "% for warnings");
                            break;
                        }
                        if (this.operationProgressTimeoutWarningTriggered) {
                            if (!operationProgressTimeoutWarning) {
                                this.operationProgressTimeoutWarningTriggered = false;
                                this.clearTransientOperationTimeoutWarning();
                            }
                        } else if (operationProgressTimeoutWarning) {
                            this.operationProgressTimeoutWarningTriggered = true;
                            try {
                                this.operationProgressTimeoutWarningTriggeredOnOperation = o3 = (Operation)this.workflowExecution.getWorkflow().getOperations().get(this.workflowExecution.getWorkflowExecutionPosition());
                                o3.addTransientWarning(this.operationTransientWarningMessage, false);
                            }
                            catch (Exception e) {
                                LOGGER.warn("Cannot log message at operation level");
                                try {
                                    this.workflowExecution.log(this.operationTransientWarningMessage, LogLevel.TRANSIENT_WARNING_TRIGGERED);
                                }
                                catch (Exception ee) {
                                    LOGGER.warn("Cannot log message at workflow level");
                                }
                            }
                        }
                        for (Long timestamp : timestamps) {
                            minutesPast = currentMinuteEpoch - timestamp;
                            if (!((double)minutesPast >= jobTimeoutSettings.getOperationProgressTimeoutHours() * 60.0)) continue;
                            historicalProgress = (JobProgress)this.historicalProgresses.get(timestamp);
                            percentageProgressSince = jobProgress.getOperationProgressPercentage() - historicalProgress.getOperationProgressPercentage();
                            if (historicalProgress.getOperationId() != jobProgress.getOperationId() || !(percentageProgressSince < jobTimeoutSettings.getOperationProgressMinPercentage())) break;
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("Progress of " + percentageProgressSince + "% is lower than required " + jobTimeoutSettings.getOperationProgressMinPercentage() + "% for errors");
                            }
                            if (jobProgress.getItemsProcessed() > 0L) {
                                double estimatedTotalItems = (double)jobProgress.getItemsProcessed() / (jobProgress.getJobProgressPercentage() / 100.0);
                                double estimatedProgress = (double)(jobProgress.getItemsProcessed() - historicalProgress.getItemsProcessed()) / estimatedTotalItems * 100.0;
                                if (!(estimatedProgress < jobTimeoutSettings.getOperationProgressMinPercentage())) break;
                                if (LOGGER.isDebugEnabled()) {
                                    LOGGER.debug("Items processed: " + jobProgress.getItemsProcessed() + ", Historical items processed:" + historicalProgress.getItemsProcessed() + ", Estimated total items" + estimatedTotalItems + " Estimated progress of " + estimatedProgress + "% is lower than required " + jobTimeoutSettings.getOperationProgressMinPercentage() + "% for warnings");
                                }
                            }
                            String errorMessage = jobTimeoutSettings.getOperationProgressTimeoutHours() == 1.0 ? this.iu.getFormattedString("JobWorker.OperationProgressTimeoutError1", (Object)jobTimeoutSettings.getOperationProgressMinPercentage()) : this.iu.getFormattedString("JobWorker.OperationProgressTimeoutError2", new Object[]{jobTimeoutSettings.getOperationProgressMinPercentage(), jobTimeoutSettings.getOperationProgressTimeoutHours()});
                            try {
                                o2 = (Operation)this.workflowExecution.getWorkflow().getOperations().get(this.workflowExecution.getWorkflowExecutionPosition());
                                o2.addWarning(errorMessage);
                            }
                            catch (Exception e) {
                                LOGGER.warn("Cannot log message at operation level");
                                try {
                                    this.workflowExecution.log(errorMessage, LogLevel.WARNING);
                                }
                                catch (Exception ee) {
                                    LOGGER.warn("Cannot log message at workflow level");
                                }
                            }
                            this.engine.abort();
                            break;
                        }
                    }
                    currentOperationId = null;
                    if (this.workflowExecution != null) {
                        currentOperationId = this.workflowExecution.getWorkflowExecutionPosition();
                    }
                    o = null;
                    try {
                        if (this.workflowExecution != null) {
                            o = (Operation)this.workflowExecution.getWorkflow().getOperations().get(this.workflowExecution.getWorkflowExecutionPosition());
                        }
                    }
                    catch (Exception e) {
                        if (!LOGGER.isDebugEnabled()) break block86;
                        LOGGER.debug("Cannot access current operation", (Throwable)e);
                    }
                }
                if (currentOperationId != null && o != null && o.skippable && (this.skippedOperationId == null || !this.skippedOperationId.equals(currentOperationId)) && !executionAborted && jobTimeoutSettings.getSkipOperationProgressTimeoutHours() != null && jobTimeoutSettings.getSkipOperationProgressTimeoutHours() > 0.0 && jobTimeoutSettings.getSkipOperationProgressMinPercentage() != null && jobTimeoutSettings.getSkipOperationProgressMinPercentage() > 0.0) {
                    JobProgress historicalProgress;
                    double effectiveTimeoutHours = jobTimeoutSettings.getSkipOperationProgressTimeoutHours() / 2.0;
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Checking for at least " + jobTimeoutSettings.getSkipOperationProgressMinPercentage() + "% progress for skipOperation for the past " + effectiveTimeoutHours + " hours (" + effectiveTimeoutHours * 60.0 + " minutes)");
                    }
                    boolean skipOperationProgressTimeoutWarning = false;
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("jobProgress:" + jobProgress);
                    }
                    for (Long timestamp : timestamps) {
                        long minutesPast = currentMinuteEpoch - timestamp;
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Testing timestamp " + timestamp + ", " + minutesPast + " minutes in the past");
                        }
                        if (!((double)minutesPast >= effectiveTimeoutHours * 60.0)) continue;
                        historicalProgress = (JobProgress)this.historicalProgresses.get(timestamp);
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("historicalProgress:" + historicalProgress);
                        }
                        double percentageProgressSince = jobProgress.getOperationProgressPercentage() - historicalProgress.getOperationProgressPercentage();
                        if (historicalProgress.getOperationId() == jobProgress.getOperationId() && percentageProgressSince < jobTimeoutSettings.getSkipOperationProgressMinPercentage()) {
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("Progress of " + percentageProgressSince + "% is lower than required " + jobTimeoutSettings.getSkipOperationProgressMinPercentage() + "% for warnings");
                            }
                            skipOperationProgressTimeoutWarning = true;
                            break;
                        }
                        if (!LOGGER.isDebugEnabled()) break;
                        LOGGER.debug("Progress of " + percentageProgressSince + "% is OK vs required " + jobTimeoutSettings.getSkipOperationProgressMinPercentage() + "% for warnings");
                        break;
                    }
                    if (this.skipOperationProgressTimeoutWarningTriggered) {
                        if (!skipOperationProgressTimeoutWarning) {
                            this.skipOperationProgressTimeoutWarningTriggered = false;
                            this.clearTransientSkipOperationTimeoutWarning(o);
                        }
                    } else if (skipOperationProgressTimeoutWarning) {
                        this.skipOperationProgressTimeoutWarningTriggered = true;
                        try {
                            this.skipOperationProgressTimeoutWarningTriggeredOnOperation = o;
                            o.addTransientWarning(this.skipOperationTransientWarningMessage, false);
                        }
                        catch (Exception e) {
                            LOGGER.warn("Cannot log message at skipOperation level");
                            try {
                                this.workflowExecution.log(this.skipOperationTransientWarningMessage, LogLevel.TRANSIENT_WARNING_TRIGGERED);
                            }
                            catch (Exception ee) {
                                LOGGER.warn("Cannot log message at workflow level");
                            }
                        }
                    }
                    for (Long timestamp : timestamps) {
                        long minutesPast = currentMinuteEpoch - timestamp;
                        if (!((double)minutesPast >= jobTimeoutSettings.getSkipOperationProgressTimeoutHours() * 60.0)) continue;
                        historicalProgress = (JobProgress)this.historicalProgresses.get(timestamp);
                        double percentageProgressSince = jobProgress.getOperationProgressPercentage() - historicalProgress.getOperationProgressPercentage();
                        if (historicalProgress.getOperationId() != jobProgress.getOperationId() || !(percentageProgressSince < jobTimeoutSettings.getSkipOperationProgressMinPercentage())) break;
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Progress of " + percentageProgressSince + "% is lower than required " + jobTimeoutSettings.getSkipOperationProgressMinPercentage() + "% for errors");
                        }
                        String errorMessage = jobTimeoutSettings.getSkipOperationProgressTimeoutHours() == 1.0 ? this.iu.getFormattedString("JobWorker.SkipOperationProgressTimeoutError1", (Object)jobTimeoutSettings.getSkipOperationProgressMinPercentage()) : this.iu.getFormattedString("JobWorker.SkipOperationProgressTimeoutError2", new Object[]{jobTimeoutSettings.getSkipOperationProgressMinPercentage(), "" + jobTimeoutSettings.getSkipOperationProgressTimeoutHours()});
                        try {
                            o.addWarning(errorMessage);
                        }
                        catch (Exception e) {
                            LOGGER.warn("Cannot log message at skipOperation level");
                            try {
                                this.workflowExecution.log(errorMessage, LogLevel.WARNING);
                            }
                            catch (Exception ee) {
                                LOGGER.warn("Cannot log message at workflow level");
                            }
                        }
                        this.skippedOperationId = this.workflowExecution.getWorkflowExecutionPosition();
                        this.workflowExecution.skipOperation(this.workflowExecution.getWorkflowExecutionPosition());
                        break;
                    }
                }
            }
        }
    }

    public Workflow getWorkflow() {
        return this.workflowExecution.getWorkflow();
    }

    public List<OperationStatus> getOperations() {
        ArrayList<OperationStatus> operationStatuses = new ArrayList<OperationStatus>();
        if (this.workflowExecution != null && this.workflowExecution.getWorkflow() != null && this.workflowExecution.getWorkflow().getOperations() != null) {
            for (Operation operation : this.workflowExecution.getWorkflow().getOperations()) {
                OperationStatus operationStatus = this.operationToOperationStatus(operation, this.model.getId());
                operationStatuses.add(operationStatus);
            }
        }
        return operationStatuses;
    }

    public List<OperationMimeTypeStats> getOperationMimeTypeStats() {
        ArrayList<OperationMimeTypeStats> operationMimeTypeStats = new ArrayList<OperationMimeTypeStats>();
        if (this.workflowExecution != null && this.workflowExecution.getWorkflow() != null && this.workflowExecution.getWorkflow().getOperations() != null) {
            for (Operation operation : this.workflowExecution.getWorkflow().getOperations()) {
                if (!operation.getUsesWorkers() && (operation.getOperationStats() == null || operation.getOperationStats().getOperationMimeTypeStats() == null || operation.getOperationStats().getOperationMimeTypeStats().size() <= 0)) continue;
                OperationMimeTypeStats operationStats = new OperationMimeTypeStats(operation.getOperationStats());
                operationStats.setOperationIndex(this.workflowExecution.getOperationPosition(operation));
                operationStats.setJobId(this.model.getId());
                operationMimeTypeStats.add(operationStats);
            }
        }
        return operationMimeTypeStats;
    }

    public RunningLogEventsModel getRunningLog() {
        int position;
        List runningLog = new ArrayList();
        int runningLogIndex = -1;
        if (this.workflowExecution != null && this.workflowExecution.getWorkflow() != null && this.workflowExecution.getWorkflow().getOperations() != null && (position = this.workflowExecution.getWorkflowExecutionPosition()) > -1 && position < this.workflowExecution.getWorkflow().getOperations().size() && (((Operation)this.workflowExecution.getWorkflow().getOperations().get(position)).getUsesWorkers() || ((Operation)this.workflowExecution.getWorkflow().getOperations().get(position)).getRunningLog().getLog().size() > 0)) {
            runningLog = ((Operation)this.workflowExecution.getWorkflow().getOperations().get(position)).getRunningLog().getLog();
            runningLogIndex = position;
        }
        RunningLogEventsModel model = new RunningLogEventsModel();
        model.setJobId(this.model.getId());
        model.setRunningLogs(runningLog);
        model.setRunningLogIndex(runningLogIndex);
        return model;
    }

    public WorkflowExecution getWorkflowExecution() {
        return this.workflowExecution;
    }

    public JobModel getModel() {
        if (this.workflowExecution != null) {
            ExecutionState executionState = this.workflowExecution.getExecutionState();
            LinkedHashSet operationWarningMessages = new LinkedHashSet();
            LinkedHashSet<String> operationSoftErrorMessages = new LinkedHashSet<String>();
            LinkedHashMap executionParameterMap = new LinkedHashMap();
            this.model.setExecutionState(executionState);
            this.model.setRunningOperationId(Integer.valueOf(this.workflowExecution.getWorkflowExecutionPosition()));
            Workflow workflow = this.workflowExecution.getWorkflow();
            double percentageComplete = 0.0;
            if (workflow != null) {
                percentageComplete = this.workflowExecution.getPercentageComplete();
                if (workflow.getOperations() != null) {
                    for (Operation operation : workflow.getOperations()) {
                        operationWarningMessages.addAll(operation.getWarningMessages());
                        if (operation.getEncounteredSoftError()) {
                            operationSoftErrorMessages.add(operation.getErrorMessage());
                        }
                        if (operation.getExecutionParameters() == null || operation.getExecutionParameters().getParameters() == null || operation.getExecutionParameters().getParameters().size() <= 0) continue;
                        executionParameterMap.putAll(operation.getExecutionParameters().getParameters());
                    }
                }
            }
            this.model.setExecutionParameters(new ArrayList(executionParameterMap.values()));
            LinkedHashSet<String> workflowUniqueWarningMessages = new LinkedHashSet<String>();
            for (String workflowWarningMessage : this.model.getWarnings()) {
                if (operationWarningMessages.contains(workflowWarningMessage)) continue;
                workflowUniqueWarningMessages.add(workflowWarningMessage);
            }
            ArrayList<String> workflowWarningMessages = new ArrayList<String>();
            workflowWarningMessages.addAll(workflowUniqueWarningMessages);
            this.model.setWarnings(workflowWarningMessages);
            LinkedHashSet<String> workflowUniqueSoftErrorMessages = new LinkedHashSet<String>();
            for (String workflowSoftErrorMessage : this.model.getSoftErrors()) {
                if (operationSoftErrorMessages.contains(workflowSoftErrorMessage)) continue;
                workflowUniqueSoftErrorMessages.add(workflowSoftErrorMessage);
            }
            ArrayList workflowSoftErrors = new ArrayList(workflowUniqueSoftErrorMessages);
            this.model.setSoftErrors(workflowSoftErrors);
            if (executionState == ExecutionState.NOT_STARTED || executionState == ExecutionState.PENDING) {
                percentageComplete = 0.0;
            }
            if (this.model.getExecutionState().equals((Object)ExecutionState.FINISHED)) {
                this.model.setPercentageComplete(100.0);
            } else if (!this.model.getExecutionState().equals((Object)ExecutionState.PAUSED)) {
                this.model.setPercentageComplete(percentageComplete);
            }
        } else {
            this.model.setExecutionState(ExecutionState.NOT_STARTED);
            this.model.setPercentageComplete(0.0);
            if (this.model.getExecutionState().equals((Object)ExecutionState.FINISHED)) {
                this.model.setPercentageComplete(100.0);
            }
        }
        return this.model;
    }

    public void setWorkflowExecution(WorkflowExecution workflowExecution) {
        this.workflowExecution = workflowExecution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OperationUtilizationModel> removeUtilizations() {
        JobWorker jobWorker = this;
        synchronized (jobWorker) {
            ArrayList<OperationUtilizationModel> currentUtilizations = new ArrayList<OperationUtilizationModel>();
            while (this.utilizations.size() > 0) {
                currentUtilizations.add(this.utilizations.remove(0));
            }
            return currentUtilizations;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Consumption> removeConsumptions() {
        JobWorker jobWorker = this;
        synchronized (jobWorker) {
            ArrayList<Consumption> currentConsumption = new ArrayList<Consumption>();
            while (this.consumptions.size() > 0) {
                currentConsumption.add(this.consumptions.remove(0));
            }
            return currentConsumption;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JobOperationEvent> removeProcessingEvents() {
        JobWorker jobWorker = this;
        synchronized (jobWorker) {
            ArrayList<JobOperationEvent> currentProcessingEvents = new ArrayList<JobOperationEvent>();
            while (this.jobEvents.size() > 0) {
                currentProcessingEvents.add(this.jobEvents.remove(0));
            }
            return currentProcessingEvents;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WorkflowDynamicUpdate> removeWorkflowDynamicUpdates() {
        JobWorker jobWorker = this;
        synchronized (jobWorker) {
            ArrayList<WorkflowDynamicUpdate> currentWorkflowDynamicUpdates = new ArrayList<WorkflowDynamicUpdate>();
            while (this.workflowDynamicUpdates.size() > 0) {
                currentWorkflowDynamicUpdates.add(this.workflowDynamicUpdates.remove(0));
            }
            return currentWorkflowDynamicUpdates;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<EventInfo> removeSessionEventInfos() {
        JobWorker jobWorker = this;
        synchronized (jobWorker) {
            ArrayList<EventInfo> currentEventInfos = new ArrayList<EventInfo>();
            currentEventInfos.addAll(this.sessionEventInfos.values());
            this.sessionEventInfos.clear();
            return currentEventInfos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSessionEventInfo(EventInfo eventInfo) {
        JobWorker jobWorker = this;
        synchronized (jobWorker) {
            this.sessionEventInfos.put(eventInfo.getId(), eventInfo);
        }
    }

    public long getSessionEventCount() {
        if (this.sessionEventInfos == null) {
            return 0L;
        }
        return this.sessionEventInfos.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUtilization(OperationUtilizationModel operationUtilizationModel) {
        JobWorker jobWorker = this;
        synchronized (jobWorker) {
            this.utilizations.add(operationUtilizationModel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConsumption(Consumption consumption) {
        JobWorker jobWorker = this;
        synchronized (jobWorker) {
            this.consumptions.add(consumption);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProcessingEvent(JobOperationEvent processingJobOperationEvent) {
        JobWorker jobWorker = this;
        synchronized (jobWorker) {
            this.jobEvents.add(processingJobOperationEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWorkflowDynamicUpdate(WorkflowDynamicUpdate workflowDynamicUpdate) {
        JobWorker jobWorker = this;
        synchronized (jobWorker) {
            this.workflowDynamicUpdates.add(workflowDynamicUpdate);
        }
    }

    public OperationStatus operationToOperationStatus(Operation operation, String jobId) {
        OperationStatus o = new OperationStatus();
        o.setJobId(jobId);
        o.setExecutionState(operation.executionState);
        o.setOperationAlias(operation.getOperationAlias());
        o.setName(operation.getOperationName());
        o.setNotes(operation.notes);
        o.setUsesWorkers(operation.getUsesWorkers());
        if (operation instanceof RemoteWorkerBasedOperation) {
            o.setWorkerMemory(((RemoteWorkerBasedOperation)operation).getWorkerMemory());
            o.setAddedWorkerCount(((RemoteWorkerBasedOperation)operation).getAddedWorkerCount());
            o.setMaximumWorkerCount(Integer.valueOf(operation.getExecutionContext().workflowBrokerWorkersCount));
        }
        try {
            o.setEta(Long.valueOf(operation.getEta().getMillis()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            o.setStartedDate(Long.valueOf(operation.startDateTime.getMillis()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            o.setFinishedDate(Long.valueOf(operation.finishedDateTime.getMillis()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        o.setExecutionPosition(operation.executionPosition);
        o.setWorkflowPosition(operation.workflowPosition);
        o.setWarnings(new ArrayList(operation.getWarningMessages()));
        o.setError(operation.getErrorMessage());
        o.setPercentageComplete(operation.getNormalizedPercentageComplete() * 100.0);
        if (operation.finishedRunning()) {
            o.setProgressText(operation.getPrintableStatus());
        } else if (operation.executionState == ExecutionState.NOT_STARTED) {
            o.setProgressText("");
        } else {
            o.setProgressText(operation.getPrintableStatus());
        }
        o.setProcessingSpeedText(operation.getPrintableProcessingSpeed());
        o.setAuditedSize(operation.getAuditedSize());
        List options = WorkflowRenderer.getOperationPrintableOptions((Operation)operation, (boolean)false, (boolean)false);
        o.setOptions(options);
        o.setSkippable(operation.skippable);
        return o;
    }

    public JobModel updateJobModel(JobModel newJobModel) {
        if (newJobModel.getConfidential() != null) {
            this.model.setConfidential(newJobModel.getConfidential());
        }
        if (newJobModel.getResourcePoolId() != null) {
            this.model.setResourcePoolId(newJobModel.getResourcePoolId());
            this.model.setResourcePoolName("");
        }
        if (newJobModel.getExecutionProfileId() != null) {
            this.model.setExecutionProfileId(newJobModel.getResourcePoolId());
            this.model.setExecutionProfileName("");
        }
        if (newJobModel.getPriority() != null) {
            this.model.setPriority(newJobModel.getPriority());
        }
        return this.model;
    }
}

