/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.graph.playbook;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.nuix.graph.playbook.Playbook;
import com.nuix.graph.playbook.Settings;
import com.nuix.graph.playbook.engine.EngineAnalysisExecutionContext;
import com.nuix.graph.playbook.engine.EngineStats;
import com.nuix.graph.playbook.engine.ProcessingCallback;
import com.nuix.graph.playbook.engine.ProxyFactory;
import com.nuix.graph.playbook.engine.RuleExecutor;
import com.nuix.graph.playbook.engine.entities.SourceNode;
import com.nuix.graph.playbook.loader.MemGraphLoader;
import com.nuix.graph.playbook.loader.MemGraphStore;
import com.nuix.graph.playbook.nodes.EnginePlaybookNode;
import com.nuix.graph.playbook.script.PrecompiledScriptEvaluator;
import java.io.Closeable;
import java.io.File;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import nuix.Case;
import nuix.Item;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.neo4j.driver.Session;
import org.neo4j.driver.exceptions.ServiceUnavailableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphEngine
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(GraphEngine.class);
    private static final RejectedExecutionHandler BLOCK_EXECUTION_HANDLER = new BlockExecutionHandler();
    private final Driver driver;
    private final Session session;
    private final MemGraphLoader memGraphLoader;
    private final RuleExecutor ruleExecutor;
    private final ScriptEngine scriptEngine;
    private final LinkedBlockingQueue<Runnable> poolQueue;
    private final ExecutorService executorService;
    private final Settings settings;
    private final AtomicInteger itemsProcessed = new AtomicInteger();
    private final AtomicInteger itemsFailed = new AtomicInteger();
    private final AtomicInteger totalItems = new AtomicInteger();
    private boolean closed;

    public static GraphEngine load(String uri, String user, String password, String playbookFile) {
        return GraphEngine.load(uri, user, password, playbookFile, Settings.builder().build());
    }

    public static GraphEngine load(String uri, String user, String password, String playbookFile, Settings settings) {
        Driver driver = GraphDatabase.driver((String)uri, (AuthToken)AuthTokens.basic((String)user, (String)password));
        try {
            driver.verifyConnectivity();
        }
        catch (ServiceUnavailableException e) {
            log.error("Unable to connect to Neo4j", e);
            driver.close();
            throw e;
        }
        return GraphEngine.load(driver, driver.session(), playbookFile, settings);
    }

    @VisibleForTesting
    static GraphEngine load(Driver driver, Session session, String playbookFile) {
        return GraphEngine.load(driver, session, playbookFile, Settings.builder().build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    static GraphEngine load(Driver driver, Session session, String playbookFile, Settings settings) {
        ScriptEngine scriptEngine;
        Playbook playbook = Playbook.loadFrom(new File(playbookFile));
        EnginePlaybookNode enginePlaybookNode = playbook.loadEnginePlaybook();
        String oldNashornValue = System.getProperty("nashorn.args");
        try {
            System.setProperty("nashorn.args", "--language=es6");
            ScriptEngineManager factory = new ScriptEngineManager();
            scriptEngine = factory.getEngineByName("JavaScript");
            if (!settings.isDisableContextCache()) {
                scriptEngine = new PrecompiledScriptEvaluator(scriptEngine);
            }
        }
        finally {
            Optional.ofNullable(oldNashornValue).ifPresentOrElse(value -> System.setProperty("nashorn.args", value), () -> System.clearProperty("nashorn.args"));
        }
        MemGraphStore memGraphStore = new MemGraphStore(session, settings);
        MemGraphLoader memGraphLoader = new MemGraphLoader(session, enginePlaybookNode.getRunBeforeLoad(), enginePlaybookNode.getRunAfterLoad(), memGraphStore, settings);
        LinkedBlockingQueue<Runnable> poolQueue = new LinkedBlockingQueue<Runnable>(settings.getIncomingQueueSize());
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(settings.getProducerThreads(), settings.getProducerThreads(), 0L, TimeUnit.MILLISECONDS, poolQueue, new ThreadFactoryBuilder().setNameFormat(settings.getRulesExecutorThreadGroupName() + "-%d").build(), BLOCK_EXECUTION_HANDLER);
        return new GraphEngine(driver, session, memGraphLoader, new RuleExecutor(enginePlaybookNode.getRules(), settings), scriptEngine, poolQueue, threadPoolExecutor, settings);
    }

    public void process(Case caze) {
        this.process(caze, (List<Item>)ImmutableList.of((Object)ProxyFactory.withUnavailableObjectPlaybookException(Item.class)));
    }

    public void process(Case caze, ProcessingCallback callback) {
        this.process(caze, (List<Item>)ImmutableList.of((Object)ProxyFactory.withUnavailableObjectPlaybookException(Item.class)), callback);
    }

    public void process(Case caze, List<Item> items) {
        this.process(caze, items, ProcessingCallback.NoOp.INSTANCE);
    }

    public void process(Case caze, List<Item> items, ProcessingCallback callback) {
        if (this.closed) {
            throw new IllegalStateException("Engine is already closed");
        }
        this.totalItems.addAndGet(items.size());
        EngineAnalysisExecutionContext executionContext = new EngineAnalysisExecutionContext(caze, Optional.empty(), this.scriptEngine, this.settings);
        for (Item item : items) {
            if (this.closed) {
                return;
            }
            EngineAnalysisExecutionContext itemContext = executionContext.withItem(item);
            this.process(itemContext, callback);
        }
    }

    private void process(EngineAnalysisExecutionContext executionContext, ProcessingCallback callback) {
        if (this.closed) {
            return;
        }
        this.executorService.submit(() -> this.processAsync(executionContext, callback));
    }

    private void processAsync(EngineAnalysisExecutionContext executionContext, ProcessingCallback callback) {
        if (this.closed) {
            return;
        }
        Item item = executionContext.getItem();
        Case caze = executionContext.getCaze();
        callback.beforeItemProcessed(item, executionContext);
        try {
            List<SourceNode> sourceNodes = this.ruleExecutor.evaluate(executionContext);
            this.memGraphLoader.loadNodes(sourceNodes);
            callback.afterItemProcessed(item, executionContext, sourceNodes);
        }
        catch (Throwable e) {
            log.error("Unable to process item {} in case {}", item, caze, e);
            callback.itemException(item, executionContext, new RuntimeException("Unable to process item", e));
            this.itemsFailed.incrementAndGet();
        }
        this.itemsProcessed.incrementAndGet();
    }

    public EngineStats getEngineStats() {
        return new EngineStats(this.poolQueue.size(), this.memGraphLoader.getQueueSize(), this.memGraphLoader.isLoading(), this.memGraphLoader.getCacheSize(), this.itemsProcessed.get(), this.itemsFailed.get(), this.totalItems.get(), this.memGraphLoader.getTotalNodesCommitted(), this.memGraphLoader.getTotalEdgesCommitted(), this.memGraphLoader.getPendingEdgesCount(), this.memGraphLoader.getPendingNodesCount());
    }

    public void abort() {
        log.warn("Aborting load");
        this.closed = true;
        this.memGraphLoader.abort();
        this.executorService.shutdownNow();
        this.poolQueue.clear();
        this.session.close();
        this.driver.close();
        log.warn("Engine execution was aborted");
    }

    @Override
    public void close() {
        if (this.closed || this.executorService.isShutdown()) {
            log.warn("Engine is already closed");
            return;
        }
        log.debug("Shutting down RulesProcessor");
        this.executorService.shutdown();
        for (int i = 0; i < this.settings.getRulesExecutionTimeout(); ++i) {
            if (this.executorService.awaitTermination(Math.max(this.settings.getRulesExecutionTimeout() / 10, 1), TimeUnit.MINUTES)) {
                this.closed = true;
                break;
            }
            log.debug("Waiting for RulesProcessor to finish processing");
        }
        if (!this.closed) {
            log.warn("RulesProcessor did not terminate in a timely manner");
            this.closed = true;
        }
        log.debug("Waiting for MemGraphLoader to finish processing");
        this.memGraphLoader.close();
        this.session.close();
        this.driver.close();
        log.debug("GraphEngine has been shutdown");
    }

    private GraphEngine(Driver driver, Session session, MemGraphLoader memGraphLoader, RuleExecutor ruleExecutor, ScriptEngine scriptEngine, LinkedBlockingQueue<Runnable> poolQueue, ExecutorService executorService, Settings settings) {
        this.driver = driver;
        this.session = session;
        this.memGraphLoader = memGraphLoader;
        this.ruleExecutor = ruleExecutor;
        this.scriptEngine = scriptEngine;
        this.poolQueue = poolQueue;
        this.executorService = executorService;
        this.settings = settings;
    }

    private static class BlockExecutionHandler
    implements RejectedExecutionHandler {
        private BlockExecutionHandler() {
        }

        @Override
        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor executor) {
            executor.getQueue().put(runnable);
        }
    }
}

