/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.graph.playbook;

public class Settings {
    public static final Settings DEFAULT = Settings.builder().build();
    private final int producerThreads;
    private final int loaderQueueSize;
    private final int transactionSize;
    private final int incomingQueueSize;
    private final int rulesExecutionTimeout;
    private final String rulesExecutorThreadGroupName;
    private final String graphLoaderThreadName;
    private final int committedOperationsCacheSize;
    private final int expressionWarningThreshold;
    private final int ruleWarningThreshold;
    private final int rulesWarningThreshold;
    private final boolean disableContextCache;
    private final int heartbeatCallbackRate;

    private static int $default$producerThreads() {
        return Math.min(Math.max(Runtime.getRuntime().availableProcessors() / 2, 1), 4);
    }

    private static int $default$loaderQueueSize() {
        return 10000;
    }

    private static int $default$transactionSize() {
        return 1000;
    }

    private static int $default$incomingQueueSize() {
        return Math.min(Math.max(Runtime.getRuntime().availableProcessors() / 2, 1), 4);
    }

    private static int $default$rulesExecutionTimeout() {
        return 5;
    }

    private static String $default$rulesExecutorThreadGroupName() {
        return "playbook-rules-executor";
    }

    private static String $default$graphLoaderThreadName() {
        return "playbook-graph-loader";
    }

    private static int $default$committedOperationsCacheSize() {
        return 500000;
    }

    private static int $default$expressionWarningThreshold() {
        return 500;
    }

    private static int $default$ruleWarningThreshold() {
        return 1000;
    }

    private static int $default$rulesWarningThreshold() {
        return 2000;
    }

    private static boolean $default$disableContextCache() {
        return false;
    }

    private static int $default$heartbeatCallbackRate() {
        return 0;
    }

    Settings(int producerThreads, int loaderQueueSize, int transactionSize, int incomingQueueSize, int rulesExecutionTimeout, String rulesExecutorThreadGroupName, String graphLoaderThreadName, int committedOperationsCacheSize, int expressionWarningThreshold, int ruleWarningThreshold, int rulesWarningThreshold, boolean disableContextCache, int heartbeatCallbackRate) {
        this.producerThreads = producerThreads;
        this.loaderQueueSize = loaderQueueSize;
        this.transactionSize = transactionSize;
        this.incomingQueueSize = incomingQueueSize;
        this.rulesExecutionTimeout = rulesExecutionTimeout;
        this.rulesExecutorThreadGroupName = rulesExecutorThreadGroupName;
        this.graphLoaderThreadName = graphLoaderThreadName;
        this.committedOperationsCacheSize = committedOperationsCacheSize;
        this.expressionWarningThreshold = expressionWarningThreshold;
        this.ruleWarningThreshold = ruleWarningThreshold;
        this.rulesWarningThreshold = rulesWarningThreshold;
        this.disableContextCache = disableContextCache;
        this.heartbeatCallbackRate = heartbeatCallbackRate;
    }

    public static SettingsBuilder builder() {
        return new SettingsBuilder();
    }

    public int getProducerThreads() {
        return this.producerThreads;
    }

    public int getLoaderQueueSize() {
        return this.loaderQueueSize;
    }

    public int getTransactionSize() {
        return this.transactionSize;
    }

    public int getIncomingQueueSize() {
        return this.incomingQueueSize;
    }

    public int getRulesExecutionTimeout() {
        return this.rulesExecutionTimeout;
    }

    public String getRulesExecutorThreadGroupName() {
        return this.rulesExecutorThreadGroupName;
    }

    public String getGraphLoaderThreadName() {
        return this.graphLoaderThreadName;
    }

    public int getCommittedOperationsCacheSize() {
        return this.committedOperationsCacheSize;
    }

    public int getExpressionWarningThreshold() {
        return this.expressionWarningThreshold;
    }

    public int getRuleWarningThreshold() {
        return this.ruleWarningThreshold;
    }

    public int getRulesWarningThreshold() {
        return this.rulesWarningThreshold;
    }

    public boolean isDisableContextCache() {
        return this.disableContextCache;
    }

    public int getHeartbeatCallbackRate() {
        return this.heartbeatCallbackRate;
    }

    public String toString() {
        return "Settings(producerThreads=" + this.getProducerThreads() + ", loaderQueueSize=" + this.getLoaderQueueSize() + ", transactionSize=" + this.getTransactionSize() + ", incomingQueueSize=" + this.getIncomingQueueSize() + ", rulesExecutionTimeout=" + this.getRulesExecutionTimeout() + ", rulesExecutorThreadGroupName=" + this.getRulesExecutorThreadGroupName() + ", graphLoaderThreadName=" + this.getGraphLoaderThreadName() + ", committedOperationsCacheSize=" + this.getCommittedOperationsCacheSize() + ", expressionWarningThreshold=" + this.getExpressionWarningThreshold() + ", ruleWarningThreshold=" + this.getRuleWarningThreshold() + ", rulesWarningThreshold=" + this.getRulesWarningThreshold() + ", disableContextCache=" + this.isDisableContextCache() + ", heartbeatCallbackRate=" + this.getHeartbeatCallbackRate() + ")";
    }

    public static class SettingsBuilder {
        private boolean producerThreads$set;
        private int producerThreads$value;
        private boolean loaderQueueSize$set;
        private int loaderQueueSize$value;
        private boolean transactionSize$set;
        private int transactionSize$value;
        private boolean incomingQueueSize$set;
        private int incomingQueueSize$value;
        private boolean rulesExecutionTimeout$set;
        private int rulesExecutionTimeout$value;
        private boolean rulesExecutorThreadGroupName$set;
        private String rulesExecutorThreadGroupName$value;
        private boolean graphLoaderThreadName$set;
        private String graphLoaderThreadName$value;
        private boolean committedOperationsCacheSize$set;
        private int committedOperationsCacheSize$value;
        private boolean expressionWarningThreshold$set;
        private int expressionWarningThreshold$value;
        private boolean ruleWarningThreshold$set;
        private int ruleWarningThreshold$value;
        private boolean rulesWarningThreshold$set;
        private int rulesWarningThreshold$value;
        private boolean disableContextCache$set;
        private boolean disableContextCache$value;
        private boolean heartbeatCallbackRate$set;
        private int heartbeatCallbackRate$value;

        SettingsBuilder() {
        }

        public SettingsBuilder producerThreads(int producerThreads) {
            this.producerThreads$value = producerThreads;
            this.producerThreads$set = true;
            return this;
        }

        public SettingsBuilder loaderQueueSize(int loaderQueueSize) {
            this.loaderQueueSize$value = loaderQueueSize;
            this.loaderQueueSize$set = true;
            return this;
        }

        public SettingsBuilder transactionSize(int transactionSize) {
            this.transactionSize$value = transactionSize;
            this.transactionSize$set = true;
            return this;
        }

        public SettingsBuilder incomingQueueSize(int incomingQueueSize) {
            this.incomingQueueSize$value = incomingQueueSize;
            this.incomingQueueSize$set = true;
            return this;
        }

        public SettingsBuilder rulesExecutionTimeout(int rulesExecutionTimeout) {
            this.rulesExecutionTimeout$value = rulesExecutionTimeout;
            this.rulesExecutionTimeout$set = true;
            return this;
        }

        public SettingsBuilder rulesExecutorThreadGroupName(String rulesExecutorThreadGroupName) {
            this.rulesExecutorThreadGroupName$value = rulesExecutorThreadGroupName;
            this.rulesExecutorThreadGroupName$set = true;
            return this;
        }

        public SettingsBuilder graphLoaderThreadName(String graphLoaderThreadName) {
            this.graphLoaderThreadName$value = graphLoaderThreadName;
            this.graphLoaderThreadName$set = true;
            return this;
        }

        public SettingsBuilder committedOperationsCacheSize(int committedOperationsCacheSize) {
            this.committedOperationsCacheSize$value = committedOperationsCacheSize;
            this.committedOperationsCacheSize$set = true;
            return this;
        }

        public SettingsBuilder expressionWarningThreshold(int expressionWarningThreshold) {
            this.expressionWarningThreshold$value = expressionWarningThreshold;
            this.expressionWarningThreshold$set = true;
            return this;
        }

        public SettingsBuilder ruleWarningThreshold(int ruleWarningThreshold) {
            this.ruleWarningThreshold$value = ruleWarningThreshold;
            this.ruleWarningThreshold$set = true;
            return this;
        }

        public SettingsBuilder rulesWarningThreshold(int rulesWarningThreshold) {
            this.rulesWarningThreshold$value = rulesWarningThreshold;
            this.rulesWarningThreshold$set = true;
            return this;
        }

        public SettingsBuilder disableContextCache(boolean disableContextCache) {
            this.disableContextCache$value = disableContextCache;
            this.disableContextCache$set = true;
            return this;
        }

        public SettingsBuilder heartbeatCallbackRate(int heartbeatCallbackRate) {
            this.heartbeatCallbackRate$value = heartbeatCallbackRate;
            this.heartbeatCallbackRate$set = true;
            return this;
        }

        public Settings build() {
            int producerThreads$value = this.producerThreads$value;
            if (!this.producerThreads$set) {
                producerThreads$value = Settings.$default$producerThreads();
            }
            int loaderQueueSize$value = this.loaderQueueSize$value;
            if (!this.loaderQueueSize$set) {
                loaderQueueSize$value = Settings.$default$loaderQueueSize();
            }
            int transactionSize$value = this.transactionSize$value;
            if (!this.transactionSize$set) {
                transactionSize$value = Settings.$default$transactionSize();
            }
            int incomingQueueSize$value = this.incomingQueueSize$value;
            if (!this.incomingQueueSize$set) {
                incomingQueueSize$value = Settings.$default$incomingQueueSize();
            }
            int rulesExecutionTimeout$value = this.rulesExecutionTimeout$value;
            if (!this.rulesExecutionTimeout$set) {
                rulesExecutionTimeout$value = Settings.$default$rulesExecutionTimeout();
            }
            String rulesExecutorThreadGroupName$value = this.rulesExecutorThreadGroupName$value;
            if (!this.rulesExecutorThreadGroupName$set) {
                rulesExecutorThreadGroupName$value = Settings.$default$rulesExecutorThreadGroupName();
            }
            String graphLoaderThreadName$value = this.graphLoaderThreadName$value;
            if (!this.graphLoaderThreadName$set) {
                graphLoaderThreadName$value = Settings.$default$graphLoaderThreadName();
            }
            int committedOperationsCacheSize$value = this.committedOperationsCacheSize$value;
            if (!this.committedOperationsCacheSize$set) {
                committedOperationsCacheSize$value = Settings.$default$committedOperationsCacheSize();
            }
            int expressionWarningThreshold$value = this.expressionWarningThreshold$value;
            if (!this.expressionWarningThreshold$set) {
                expressionWarningThreshold$value = Settings.$default$expressionWarningThreshold();
            }
            int ruleWarningThreshold$value = this.ruleWarningThreshold$value;
            if (!this.ruleWarningThreshold$set) {
                ruleWarningThreshold$value = Settings.$default$ruleWarningThreshold();
            }
            int rulesWarningThreshold$value = this.rulesWarningThreshold$value;
            if (!this.rulesWarningThreshold$set) {
                rulesWarningThreshold$value = Settings.$default$rulesWarningThreshold();
            }
            boolean disableContextCache$value = this.disableContextCache$value;
            if (!this.disableContextCache$set) {
                disableContextCache$value = Settings.$default$disableContextCache();
            }
            int heartbeatCallbackRate$value = this.heartbeatCallbackRate$value;
            if (!this.heartbeatCallbackRate$set) {
                heartbeatCallbackRate$value = Settings.$default$heartbeatCallbackRate();
            }
            return new Settings(producerThreads$value, loaderQueueSize$value, transactionSize$value, incomingQueueSize$value, rulesExecutionTimeout$value, rulesExecutorThreadGroupName$value, graphLoaderThreadName$value, committedOperationsCacheSize$value, expressionWarningThreshold$value, ruleWarningThreshold$value, rulesWarningThreshold$value, disableContextCache$value, heartbeatCallbackRate$value);
        }

        public String toString() {
            return "Settings.SettingsBuilder(producerThreads$value=" + this.producerThreads$value + ", loaderQueueSize$value=" + this.loaderQueueSize$value + ", transactionSize$value=" + this.transactionSize$value + ", incomingQueueSize$value=" + this.incomingQueueSize$value + ", rulesExecutionTimeout$value=" + this.rulesExecutionTimeout$value + ", rulesExecutorThreadGroupName$value=" + this.rulesExecutorThreadGroupName$value + ", graphLoaderThreadName$value=" + this.graphLoaderThreadName$value + ", committedOperationsCacheSize$value=" + this.committedOperationsCacheSize$value + ", expressionWarningThreshold$value=" + this.expressionWarningThreshold$value + ", ruleWarningThreshold$value=" + this.ruleWarningThreshold$value + ", rulesWarningThreshold$value=" + this.rulesWarningThreshold$value + ", disableContextCache$value=" + this.disableContextCache$value + ", heartbeatCallbackRate$value=" + this.heartbeatCallbackRate$value + ")";
        }
    }
}

