/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.graph.playbook.engine;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.nuix.graph.playbook.Settings;
import com.nuix.graph.playbook.ThresholdWarning;
import com.nuix.graph.playbook.engine.ExecutionContext;
import com.nuix.graph.playbook.engine.ProxyFactory;
import com.nuix.graph.playbook.engine.virtualfields.ItemWithVirtualFields;
import com.nuix.graph.playbook.engine.virtualfields.VirtualFields;
import com.nuix.graph.playbook.nodes.PlaybookValidationException;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.SimpleScriptContext;
import nuix.Case;
import nuix.Item;
import nuix.ItemKind;
import nuix.ItemTreeNode;
import nuix.ItemType;
import org.apache.commons.beanutils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EngineAnalysisExecutionContext
implements ExecutionContext {
    private static final Logger log = LoggerFactory.getLogger(EngineAnalysisExecutionContext.class);
    private final Case caze;
    private final Optional<ItemWithVirtualFields> item;
    private final ScriptEngine scriptEngine;
    private final Map<String, Callable<?>> evaluators;
    private final Settings settings;
    private final Map<String, Object> cache;
    private final ConcurrentMap<String, Object> globalVariables;
    private SimpleScriptContext scriptContext;

    public EngineAnalysisExecutionContext(Case caze, Item item, ScriptEngine scriptEngine, Settings settings) {
        this(caze, Optional.ofNullable(item), scriptEngine, settings);
    }

    public EngineAnalysisExecutionContext(Case caze, Optional<? extends Item> item, ScriptEngine scriptEngine, Settings settings) {
        this(caze, item, (Map<String, Callable<?>>)ImmutableMap.of(), (Map<String, Object>)ImmutableMap.of(), (ConcurrentMap<String, Object>)new ConcurrentHashMap<String, Object>(), scriptEngine, settings);
    }

    private EngineAnalysisExecutionContext(Case caze, Optional<? extends Item> item, Map<String, Callable<?>> additionalEvaluators, Map<String, Object> cache, ConcurrentMap<String, Object> globalVariables, ScriptEngine scriptEngine, Settings settings) {
        this.caze = (Case)this.maybeDecorate(caze);
        this.item = item.map(e -> (ItemWithVirtualFields)this.maybeDecorate(e));
        this.cache = new HashMap<String, Object>(cache);
        this.globalVariables = globalVariables;
        this.scriptEngine = scriptEngine;
        this.settings = settings;
        this.evaluators = new HashMap();
        this.initEvaluators(additionalEvaluators);
    }

    private ScriptContext getOrCreateScriptContext() {
        if (this.scriptContext == null) {
            this.initScriptContext();
        }
        return this.scriptContext;
    }

    private void initScriptContext() {
        this.scriptContext = new SimpleScriptContext();
        this.scriptContext.setAttribute("ctx", this, 100);
        this.scriptContext.setAttribute("item", this.item.get(), 100);
        this.scriptContext.setAttribute("caze", this.caze, 100);
        this.scriptContext.setAttribute("currentCase", this.caze, 100);
        Optional.ofNullable(this.evaluators.get("it")).ifPresent(it -> {
            try {
                this.scriptContext.setAttribute("it", this.maybeDecorate(it.call()), 100);
            }
            catch (Exception e) {
                log.error("Unable to evaluate `it`", e);
                throw new PlaybookValidationException("Unable to evaluate it");
            }
        });
        Optional.ofNullable(this.evaluators.get("source")).ifPresent(it -> {
            try {
                this.scriptContext.setAttribute("source", this.maybeDecorate(it.call()), 100);
            }
            catch (Exception e) {
                log.error("Unable to evaluate `source`", e);
                throw new PlaybookValidationException("Unable to evaluate source");
            }
        });
        Optional.ofNullable(this.evaluators.get("target")).ifPresent(it -> {
            try {
                this.scriptContext.setAttribute("target", this.maybeDecorate(it.call()), 100);
            }
            catch (Exception e) {
                log.error("Unable to evaluate `target`", e);
                throw new PlaybookValidationException("Unable to evaluate it");
            }
        });
    }

    private void initEvaluators(Map<String, Callable<?>> additionalEvaluators) {
        this.evaluators.put("caze", () -> this.caze);
        this.evaluators.put("currentCase", () -> this.caze);
        this.evaluators.put("item", this.item::get);
        this.evaluators.put("it", this.item::get);
        this.evaluators.put("parent", () -> this.item.map(ItemTreeNode::getParent).orElse(null));
        this.evaluators.put("topLevel", () -> this.item.map(Item::getTopLevelItem).orElse(null));
        this.evaluators.putAll(additionalEvaluators);
    }

    @Override
    public <T> T evaluate(String expression) {
        Object cached = this.cache.get(expression);
        if (cached != null) {
            if (log.isDebugEnabled()) {
                log.debug("Using cached value for expression [{}]", (Object)expression);
            }
            return (T)cached;
        }
        Object result = ThresholdWarning.warnIfExceedsThreshold(() -> this.evaluateInternal(expression), this.settings.getExpressionWarningThreshold(), (Supplier<String>)((Supplier)() -> expression));
        if (!this.settings.isDisableContextCache()) {
            this.cache.put(expression, result);
        }
        return (T)this.maybeConvertToString(result);
    }

    private Object maybeConvertToString(Object o) {
        if (o instanceof ItemKind) {
            return ((ItemKind)o).getName();
        }
        if (o instanceof ItemType) {
            return ((ItemType)o).getName();
        }
        return o;
    }

    private <T> T evaluateInternal(String expression) {
        Object result;
        if (log.isDebugEnabled()) {
            log.debug("Evaluating expression [{}]", (Object)expression);
        }
        if (expression.startsWith("${") && expression.endsWith("}")) {
            return this.evaluateScript(expression.substring(2, expression.length() - 1));
        }
        Callable<?> callable = this.evaluators.get(expression);
        if (callable == null) {
            Map.Entry<String, String> objectExpression = this.breakNextObject(expression);
            if (objectExpression == null) {
                if (log.isDebugEnabled()) {
                    log.debug("Couldn't extract object from expression [{}]", (Object)expression);
                }
                result = this.evaluateScript(expression);
            } else {
                Object object = this.evaluators.getOrDefault(objectExpression.getKey(), () -> null).call();
                if (object == null) {
                    if (log.isDebugEnabled()) {
                        log.debug("Couldn't find object in context [{}]", (Object)objectExpression.getKey());
                    }
                    result = this.evaluateScript(expression);
                } else {
                    result = this.maybeEvaluateObjectExpression(object, objectExpression.getValue());
                }
            }
        } else {
            result = callable.call();
        }
        if (log.isDebugEnabled()) {
            log.debug("Evaluated expression [{}] with result [{}]", (Object)expression, result);
        }
        return (T)result;
    }

    private <T> T evaluateScript(String script) {
        if (log.isDebugEnabled()) {
            log.debug("Evaluating script [{}]", (Object)script);
        }
        Object result = this.scriptEngine.eval(script, this.getOrCreateScriptContext());
        if (log.isDebugEnabled()) {
            log.debug("Evaluated script [{}] with result [{}]", (Object)script, result);
        }
        return (T)result;
    }

    private Map.Entry<String, String> breakNextObject(String expression) {
        int endIndex = expression.indexOf(46);
        if (endIndex < 1) {
            return null;
        }
        String object = expression.substring(0, endIndex);
        String subExpression = expression.substring(object.length() + 1);
        if (object.trim().isEmpty() || subExpression.isEmpty()) {
            return null;
        }
        return new AbstractMap.SimpleEntry<String, String>(object, subExpression);
    }

    protected <T> T maybeEvaluateObjectExpression(Object o, String expression) {
        if (o == null) {
            return null;
        }
        if (o instanceof ItemWithVirtualFields) {
            return this.getItemField((ItemWithVirtualFields)o, expression);
        }
        if (o instanceof Map) {
            return this.getMapField((Map)o, expression);
        }
        return this.getViaReflection(o, expression);
    }

    private <T> T getViaReflection(Object o, String expression) {
        try {
            Object propertyName;
            if (expression.startsWith("get") && expression.endsWith("()")) {
                propertyName = expression.substring(3, expression.length() - 2);
                propertyName = ((String)propertyName).substring(0, 1).toLowerCase() + ((String)propertyName).substring(1);
            } else {
                propertyName = expression;
            }
            return (T)PropertyUtils.getProperty(o, (String)propertyName);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new PlaybookValidationException("I don't know how to evaluate " + o.getClass().getName() + "." + expression);
        }
    }

    private <T> T getCaseField(Case caze, String field) {
        if (caze == null) {
            return null;
        }
        switch (field) {
            case "guid": {
                return (T)caze.getGuid();
            }
            case "name": {
                return (T)caze.getName();
            }
            case "tags": 
            case "allTags": {
                return (T)caze.getAllTags();
            }
            case "entityTypes": {
                return (T)caze.getAllEntityTypes();
            }
        }
        T result = this.evaluateScript("caze." + field);
        if (log.isDebugEnabled()) {
            log.debug("Using reflection to evaluate " + field + " resulted in " + result);
        }
        return result;
    }

    private <T> T getItemField(Item item, String field) {
        switch (field) {
            case "kind": {
                return (T)item.getKind().getName();
            }
            case "type": {
                return (T)item.getType().getName();
            }
        }
        Map.Entry<String, String> objectExpression = this.breakNextObject(field);
        if (objectExpression != null && objectExpression.getKey().equals("comm")) {
            return this.maybeEvaluateObjectExpression(item.getCommunication(), objectExpression.getValue());
        }
        return this.getViaReflection(item, field);
    }

    private <T> T getMapField(Map<String, ?> map, String field) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        return (T)map.get(field);
    }

    @Override
    public EngineAnalysisExecutionContext withNewVar(String varName, Object varValue) {
        Object currentVarValue;
        if (!this.settings.isDisableContextCache() && this.evaluators.containsKey(varName) && Objects.equals(currentVarValue = this.evaluateInternal(varName), varValue)) {
            if (log.isDebugEnabled()) {
                log.debug("Var [{}] already has value [{}], skipping to save memory", (Object)varName, varValue);
            }
            return this;
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.evaluators.forEach((key, value) -> {
            if (!key.equals(varName)) {
                builder.put(key, value);
            }
        });
        builder.put((Object)varName, () -> varValue);
        return new EngineAnalysisExecutionContext(this.caze, (Optional<? extends Item>)this.item, (Map<String, Callable<?>>)builder.build(), this.settings.isDisableContextCache() ? Maps.filterKeys(this.cache, key -> !key.contains(varName)) : ImmutableMap.of(), this.globalVariables, this.scriptEngine, this.settings);
    }

    @Override
    public ConcurrentMap<String, Object> getGlobal() {
        return this.globalVariables;
    }

    public EngineAnalysisExecutionContext withItem(Item item) {
        return new EngineAnalysisExecutionContext(this.caze, (Optional<? extends Item>)Optional.ofNullable(item).map(e -> (ItemWithVirtualFields)this.maybeDecorate(item)), (Map<String, Callable<?>>)ImmutableMap.of(), (Map<String, Object>)ImmutableMap.of(), this.globalVariables, this.scriptEngine, this.settings);
    }

    private Object maybeDecorate(Object object) {
        Object result = VirtualFields.withVirtualFields(object, this.caze);
        return ProxyFactory.withCachedGetters(result);
    }

    public Item getItem() {
        return this.item.orElse(null);
    }

    public Case getCaze() {
        return this.caze;
    }
}

