/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.graph.playbook.engine;

import com.nuix.graph.playbook.nodes.PlaybookValidationException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class ProxyFactory {
    public static Object withCachedGetters(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof WithCachedGetters) {
            return object;
        }
        Class<?>[] interfaces = object.getClass().getInterfaces();
        if (Arrays.stream(interfaces).noneMatch(e -> e.getPackageName().contains("nuix"))) {
            return object;
        }
        Class[] newInterfaces = new Class[interfaces.length + 1];
        System.arraycopy(interfaces, 0, newInterfaces, 0, interfaces.length);
        newInterfaces[interfaces.length] = WithCachedGetters.class;
        return Proxy.newProxyInstance(DefaultCachedGettersProxy.class.getClassLoader(), newInterfaces, (InvocationHandler)new DefaultCachedGettersProxy(object));
    }

    public static <T> T withUnavailableObjectPlaybookException(Class<T> clazz) {
        return (T)Proxy.newProxyInstance(DefaultCachedGettersProxy.class.getClassLoader(), new Class[]{clazz}, (InvocationHandler)new PlaybookExceptionProxy());
    }

    public static interface WithCachedGetters {
    }

    static class DefaultCachedGettersProxy
    implements InvocationHandler,
    WithCachedGetters {
        private final Object delegate;
        private final Map<String, Object> cachedGetters = new HashMap<String, Object>();

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().startsWith("get") && method.getParameterCount() == 0) {
                String name = method.getName().substring(3);
                if (this.cachedGetters.containsKey(name)) {
                    return this.cachedGetters.get(name);
                }
                Object result = method.invoke(this.delegate, args);
                this.cachedGetters.put(name, result);
                return result;
            }
            return method.invoke(this.delegate, args);
        }

        public DefaultCachedGettersProxy(Object delegate) {
            this.delegate = delegate;
        }
    }

    static class PlaybookExceptionProxy
    implements InvocationHandler {
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            if ("equals".equals(method.getName())) {
                return false;
            }
            if ("hashCode".equals(method.getName())) {
                return 0;
            }
            if ("toString".equals(method.getName())) {
                return "Unavailable object";
            }
            throw new PlaybookValidationException("This object is not available in the playbook context");
        }
    }
}

