/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.graph.playbook.engine;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.nuix.graph.playbook.Settings;
import com.nuix.graph.playbook.ThresholdWarning;
import com.nuix.graph.playbook.engine.ExecutionContext;
import com.nuix.graph.playbook.engine.entities.Edge;
import com.nuix.graph.playbook.engine.entities.Node;
import com.nuix.graph.playbook.engine.entities.SourceNode;
import com.nuix.graph.playbook.nodes.EdgeNode;
import com.nuix.graph.playbook.nodes.FilterNode;
import com.nuix.graph.playbook.nodes.LoadableNode;
import com.nuix.graph.playbook.nodes.NodeNode;
import com.nuix.graph.playbook.nodes.PlaybookValidationException;
import com.nuix.graph.playbook.nodes.RuleNode;
import com.nuix.graph.playbook.nodes.TargetNode;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleExecutor {
    private static final Logger log = LoggerFactory.getLogger(RuleExecutor.class);
    private static final Gson GSON = new Gson();
    private final List<RuleNode> rules;
    private final Settings settings;

    public List<SourceNode> evaluate(ExecutionContext executionContext) {
        return ThresholdWarning.warnIfExceedsThreshold(() -> this.evaluateInternal(executionContext), this.settings.getRulesWarningThreshold(), (Supplier<String>)((Supplier)() -> this.rules.stream().map(RuleNode::getDescription).collect(Collectors.joining(", "))));
    }

    protected List<SourceNode> evaluateInternal(ExecutionContext executionContext) {
        return this.rules.stream().peek(e -> Optional.ofNullable(Strings.trimToNull((String)e.getDescription())).filter(ignore -> log.isDebugEnabled()).ifPresent(d -> log.info("Executing rule: {}", d))).flatMap(e -> this.evaluateRule(executionContext, (RuleNode)e).stream()).filter(Objects::nonNull).collect(Collectors.toUnmodifiableList());
    }

    protected List<SourceNode> evaluateRule(ExecutionContext executionContext, RuleNode rule) {
        return ThresholdWarning.warnIfExceedsThreshold(() -> this.evaluateRuleInternal(executionContext, rule), this.settings.getRuleWarningThreshold(), (Supplier<String>)((Supplier)rule::getDescription));
    }

    protected List<SourceNode> evaluateRuleInternal(ExecutionContext executionContext, RuleNode rule) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Map.Entry<Node, Object> entry : this.maybeEvaluateManyNodes(executionContext, rule.getSource())) {
            Node source = entry.getKey();
            if (source == null) continue;
            executionContext = executionContext.withNewVar("source", entry.getValue());
            List<Edge> edges = this.evaluateTargets(executionContext, rule.getTargets());
            builder.add((Object)new SourceNode(source.getId(), source.getLabel(), source.getFields(), edges));
        }
        return builder.build();
    }

    @VisibleForTesting
    protected String toCamelCase(String text) {
        return Stream.of(text.split("[\\W_]+")).map(s -> s.substring(0, 1).toUpperCase() + s.substring(1).toLowerCase()).collect(Collectors.joining());
    }

    @VisibleForTesting
    protected String toCapitalisedSnakeCase(String text) {
        return Stream.of(text.split("[\\W_]+")).map(String::toUpperCase).collect(Collectors.joining("_"));
    }

    private List<Map.Entry<Node, Object>> maybeEvaluateManyNodes(ExecutionContext executionContext, LoadableNode loadableNode) {
        ImmutableList.Builder builder = ImmutableList.builder();
        Object nodeContext = loadableNode.getContext().evaluate(executionContext);
        if (nodeContext == null) {
            if (log.isDebugEnabled()) {
                log.debug("Node context evaluated to null for node {}, so it will not be evaluated", (Object)loadableNode);
            }
        } else if (nodeContext instanceof Collection) {
            for (Object nodeContextIt : (Collection)nodeContext) {
                builder.add(new AbstractMap.SimpleEntry(this.evaluateLoadableNode(executionContext.withIt(nodeContextIt), loadableNode), nodeContextIt));
            }
        } else {
            builder.add(new AbstractMap.SimpleEntry<Node, Object>(this.evaluateLoadableNode(executionContext.withIt(nodeContext), loadableNode), nodeContext));
        }
        return builder.build();
    }

    private Node evaluateLoadableNode(ExecutionContext executionContext, LoadableNode loadableNode) {
        if (!this.shouldCreate(executionContext, loadableNode)) {
            if (log.isDebugEnabled()) {
                log.debug("Will not create source node {} because the filters evaluated to false:\n", (Object)loadableNode.getFilters());
            }
            return null;
        }
        NodeNode nodeNode = loadableNode.getNode();
        Map<String, Object> evaluatedFields = nodeNode.getFields().stream().map(e -> new AbstractMap.SimpleEntry<String, Object>(e.getKey(), e.getValue().evaluate(executionContext))).filter(e -> Objects.nonNull(e.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        this.validatePropertyTypes(evaluatedFields);
        String id = (String)evaluatedFields.get("id");
        if (id == null) {
            throw new PlaybookValidationException("Null id for node:\n" + nodeNode);
        }
        String label = (String)evaluatedFields.get("label");
        if (label == null) {
            throw new PlaybookValidationException("Null label for node:\n" + nodeNode);
        }
        ImmutableSet ignoredFields = ImmutableSet.of((Object)"id", (Object)"label");
        return new Node(id, this.toCamelCase(label), Maps.filterKeys(evaluatedFields, e -> !ignoredFields.contains(e)));
    }

    protected boolean shouldCreate(ExecutionContext executionContext, LoadableNode loadableNode) {
        List<FilterNode> filters = loadableNode.getFilters();
        return filters == null || filters.stream().map(FilterNode::getExpression).allMatch(e -> e.evaluate(executionContext));
    }

    protected List<Edge> evaluateTargets(ExecutionContext executionContext, List<TargetNode> targets) {
        return targets.stream().flatMap(e -> this.evaluateTargetsAndEdges(executionContext, (TargetNode)e).stream()).filter(Objects::nonNull).collect(Collectors.toUnmodifiableList());
    }

    protected List<Edge> evaluateTargetsAndEdges(ExecutionContext executionContext, TargetNode target) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Map.Entry<Node, Object> entry : this.maybeEvaluateManyNodes(executionContext, target.getTarget())) {
            if (entry.getKey() == null) continue;
            executionContext = executionContext.withNewVar("target", entry.getValue());
            builder.add((Object)this.evaluateEdge(executionContext, target.getEdge(), entry.getKey()));
        }
        return builder.build();
    }

    protected Edge evaluateEdge(ExecutionContext executionContext, EdgeNode edgeNode, Node target) {
        Map<String, Object> evaluatedFields = edgeNode.getFields().stream().map(e -> new AbstractMap.SimpleEntry<String, Object>(e.getKey(), e.getValue().evaluate(executionContext))).filter(e -> Objects.nonNull(e.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        this.validatePropertyTypes(evaluatedFields);
        String label = (String)evaluatedFields.get("label");
        if (label == null) {
            throw new PlaybookValidationException("Null label for edge " + edgeNode);
        }
        return new Edge(this.toCapitalisedSnakeCase(label), Maps.filterKeys(evaluatedFields, e -> !e.equals("label")), target, edgeNode.isReverse());
    }

    private void validatePropertyTypes(Map<String, Object> properties) {
        boolean hasError = false;
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            try {
                GSON.toJson(entry.getValue());
            }
            catch (JsonIOException e) {
                log.error("Property {} has value {}, which is not supported by MemGraph", (Object)entry.getKey(), entry.getValue());
                hasError = true;
            }
        }
        if (hasError) {
            throw new IllegalArgumentException("Properties have unsupported value types");
        }
    }

    public RuleExecutor(List<RuleNode> rules, Settings settings) {
        this.rules = rules;
        this.settings = settings;
    }
}

