/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.graph.playbook.engine.virtualfields;

import com.google.common.collect.ImmutableList;
import com.nuix.graph.playbook.engine.virtualfields.CommunicationWithVirtualFields;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import nuix.Address;
import nuix.Communication;
import org.joda.time.DateTime;

public class DefaultCommunicationWithVirtualFields
implements CommunicationWithVirtualFields {
    private final Communication communication;

    @Override
    public List<Address> getAllAddresses() {
        return ImmutableList.builder().addAll(this.getFrom()).addAll(this.getTo()).addAll(this.getCc()).addAll(this.getBcc()).addAll(this.getDelegates()).build();
    }

    @Override
    public DateTime getDate() {
        return this.getDateTime();
    }

    @Nullable
    public DateTime getDateTime() {
        return this.communication == null ? null : this.communication.getDateTime();
    }

    public List<Address> getFrom() {
        return Optional.ofNullable(this.communication).map(Communication::getFrom).orElse((List)ImmutableList.of());
    }

    public List<Address> getTo() {
        return Optional.ofNullable(this.communication).map(Communication::getTo).orElse((List)ImmutableList.of());
    }

    public List<Address> getCc() {
        return Optional.ofNullable(this.communication).map(Communication::getCc).orElse((List)ImmutableList.of());
    }

    public List<Address> getBcc() {
        return Optional.ofNullable(this.communication).map(Communication::getBcc).orElse((List)ImmutableList.of());
    }

    public List<Address> getDelegates() {
        return Optional.ofNullable(this.communication).map(Communication::getDelegates).orElse((List)ImmutableList.of());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CommunicationWithVirtualFields)) {
            return false;
        }
        CommunicationWithVirtualFields that = (CommunicationWithVirtualFields)o;
        return this.communication.equals(that.getCommunication());
    }

    public DefaultCommunicationWithVirtualFields(Communication communication) {
        this.communication = communication;
    }

    @Override
    public Communication getCommunication() {
        return this.communication;
    }
}

