/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.graph.playbook.expressions;

import com.nuix.graph.playbook.engine.ExecutionContext;
import com.nuix.graph.playbook.expressions.FieldExpression;
import com.nuix.graph.playbook.expressions.FilterExpression;
import java.util.regex.Pattern;

public class RegexMatchExpression
extends FieldExpression
implements FilterExpression {
    private final Pattern regex;
    private final boolean negate;

    public RegexMatchExpression(String field, String regex, boolean negate) {
        super(field);
        this.regex = Pattern.compile(regex);
        this.negate = negate;
    }

    @Override
    public Boolean evaluate(ExecutionContext executionContext) {
        Object fieldValue = super.evaluate(executionContext);
        if (fieldValue == null) {
            return this.negate;
        }
        boolean matches = this.regex.matcher(String.valueOf(fieldValue)).matches();
        return this.negate != matches;
    }

    @Override
    public String toString() {
        return "RegexMatchExpression(regex=" + this.regex + ", negate=" + this.isNegate() + ")";
    }

    public boolean isNegate() {
        return this.negate;
    }
}

