/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.graph.playbook.expressions;

import com.nuix.graph.playbook.engine.ExecutionContext;
import com.nuix.graph.playbook.expressions.FieldExpression;
import com.nuix.graph.playbook.expressions.FilterExpression;

public class TruthyExpression
extends FieldExpression
implements FilterExpression {
    public TruthyExpression(String field) {
        super(field);
    }

    @Override
    public Boolean evaluate(ExecutionContext executionContext) {
        Object fieldValue = super.evaluate(executionContext);
        if (fieldValue == null) {
            return false;
        }
        if (fieldValue instanceof Boolean) {
            return (Boolean)fieldValue;
        }
        if (fieldValue instanceof String) {
            return !((String)fieldValue).isEmpty();
        }
        if (fieldValue instanceof Iterable) {
            return ((Iterable)fieldValue).iterator().hasNext();
        }
        if (fieldValue instanceof Number) {
            return ((Number)fieldValue).doubleValue() != 0.0;
        }
        return true;
    }

    @Override
    public String toString() {
        return "TruthyExpression()";
    }
}

