/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.graph.playbook.nodes;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableList;
import com.nuix.graph.playbook.nodes.AbstractNode;
import com.nuix.graph.playbook.nodes.FieldNode;
import com.nuix.graph.playbook.nodes.PlaybookValidationException;
import java.util.Iterator;
import java.util.List;

public class EdgeNode
extends AbstractNode {
    private List<FieldNode> fields;
    private boolean reverse;

    @Override
    protected EdgeNode load(JsonNode jsonNode) throws PlaybookValidationException {
        this.reverse = Boolean.parseBoolean(jsonNode.path("reverse").asText("false"));
        ImmutableList.Builder fieldsBuilder = ImmutableList.builder();
        Iterator it = jsonNode.findValue("fields").elements();
        while (it.hasNext()) {
            JsonNode fieldNode = (JsonNode)it.next();
            fieldsBuilder.add((Object)new FieldNode().load(fieldNode));
        }
        this.fields = fieldsBuilder.build();
        return this;
    }

    public List<FieldNode> getFields() {
        return this.fields;
    }

    public boolean isReverse() {
        return this.reverse;
    }

    public String toString() {
        return "EdgeNode(fields=" + this.getFields() + ", reverse=" + this.isReverse() + ")";
    }
}

