/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.graph.playbook.nodes;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableList;
import com.nuix.graph.playbook.nodes.AbstractNode;
import com.nuix.graph.playbook.nodes.FieldNode;
import com.nuix.graph.playbook.nodes.NodeNode;
import com.nuix.graph.playbook.nodes.PlaybookValidationException;
import com.nuix.graph.playbook.nodes.RuleNode;
import com.nuix.graph.playbook.nodes.TargetNode;
import com.nuix.graph.playbook.nodes.TemplateNode;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class EnginePlaybookNode
extends AbstractNode {
    private List<TemplateNode> templates;
    private List<RuleNode> rules;
    private List<String> runBeforeLoad;
    private List<String> runAfterLoad;

    public static EnginePlaybookNode loadFromFile(File file) throws IOException, PlaybookValidationException {
        return EnginePlaybookNode.loadFromNode(MAPPER.readTree(file));
    }

    public static EnginePlaybookNode loadFromNode(JsonNode jsonNode) throws PlaybookValidationException {
        return new EnginePlaybookNode().load(jsonNode);
    }

    public static EnginePlaybookNode loadFromString(String jsonNode) throws PlaybookValidationException, JsonProcessingException {
        return new EnginePlaybookNode().load(MAPPER.readTree(jsonNode));
    }

    @Override
    protected EnginePlaybookNode load(JsonNode jsonNode) throws PlaybookValidationException {
        this.runBeforeLoad = Optional.ofNullable(jsonNode.findValue("runBeforeLoad")).map(JsonNode::elements).stream().flatMap(e -> StreamSupport.stream(Spliterators.spliteratorUnknownSize(e, 16), false)).map(JsonNode::asText).collect(Collectors.toList());
        this.runAfterLoad = Optional.ofNullable(jsonNode.findValue("runAfterLoad")).map(JsonNode::elements).stream().flatMap(e -> StreamSupport.stream(Spliterators.spliteratorUnknownSize(e, 16), false)).map(JsonNode::asText).collect(Collectors.toList());
        ImmutableList.Builder templatesBuilder = ImmutableList.builder();
        JsonNode templates = jsonNode.findValue("templates");
        if (templates != null) {
            Iterator it = templates.elements();
            while (it.hasNext()) {
                JsonNode templateNode = (JsonNode)it.next();
                templatesBuilder.add((Object)new TemplateNode().load(templateNode));
            }
        }
        this.templates = templatesBuilder.build();
        ImmutableList.Builder rulesBuilder = ImmutableList.builder();
        Iterator it = jsonNode.findValue("rules").elements();
        while (it.hasNext()) {
            JsonNode ruleNode = (JsonNode)it.next();
            rulesBuilder.add((Object)new RuleNode().load(ruleNode));
        }
        this.rules = rulesBuilder.build();
        this.applyTemplates();
        return this;
    }

    private void applyTemplates() {
        Map<String, TemplateNode> templates = this.templates.stream().collect(Collectors.toMap(TemplateNode::getName, Functions.identity()));
        for (TemplateNode template : templates.values()) {
            template.getNode().applyTemplate(templates);
        }
        for (RuleNode rule : this.rules) {
            rule.getSource().getNode().applyTemplate(templates);
            this.validateNode(rule.getSource().getNode());
            for (TargetNode target : rule.getTargets()) {
                target.getTarget().getNode().applyTemplate(templates);
                this.validateNode(target.getTarget().getNode());
            }
        }
    }

    private void validateNode(NodeNode node) {
        ArrayList requiredFields = new ArrayList(ImmutableList.of((Object)"id", (Object)"label"));
        for (FieldNode field : node.getFields()) {
            requiredFields.remove(field.getKey());
        }
        if (!requiredFields.isEmpty()) {
            throw new PlaybookValidationException("Node would not create required fields:\n" + requiredFields);
        }
    }

    public List<TemplateNode> getTemplates() {
        return this.templates;
    }

    public List<RuleNode> getRules() {
        return this.rules;
    }

    public List<String> getRunBeforeLoad() {
        return this.runBeforeLoad;
    }

    public List<String> getRunAfterLoad() {
        return this.runAfterLoad;
    }

    public String toString() {
        return "EnginePlaybookNode(templates=" + this.getTemplates() + ", rules=" + this.getRules() + ", runBeforeLoad=" + this.getRunBeforeLoad() + ", runAfterLoad=" + this.getRunAfterLoad() + ")";
    }
}

