/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.graph.playbook.nodes;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableList;
import com.nuix.graph.playbook.nodes.AbstractNode;
import com.nuix.graph.playbook.nodes.LoadableNode;
import com.nuix.graph.playbook.nodes.PlaybookValidationException;
import com.nuix.graph.playbook.nodes.TargetNode;
import java.util.Iterator;
import java.util.List;

public class RuleNode
extends AbstractNode {
    private String description;
    private LoadableNode source;
    private List<TargetNode> targets;

    @Override
    protected RuleNode load(JsonNode jsonNode) throws PlaybookValidationException {
        this.description = jsonNode.path("description").asText("");
        this.source = new LoadableNode().load(jsonNode.path("source"));
        ImmutableList.Builder targetsBuilder = ImmutableList.builder();
        JsonNode targets = jsonNode.findValue("targets");
        if (targets != null) {
            Iterator it = targets.elements();
            while (it.hasNext()) {
                JsonNode targetNode = (JsonNode)it.next();
                targetsBuilder.add((Object)new TargetNode().load(targetNode));
            }
        }
        this.targets = targetsBuilder.build();
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public LoadableNode getSource() {
        return this.source;
    }

    public List<TargetNode> getTargets() {
        return this.targets;
    }

    public String toString() {
        return "RuleNode(description=" + this.getDescription() + ", source=" + this.getSource() + ", targets=" + this.getTargets() + ")";
    }
}

