/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.engine.rust;

import ai.djl.Device;
import ai.djl.Model;
import ai.djl.engine.Engine;
import ai.djl.engine.EngineException;
import ai.djl.engine.rust.RsModel;
import ai.djl.engine.rust.RsNDManager;
import ai.djl.engine.rust.RustLibrary;
import ai.djl.huggingface.tokenizers.jni.LibUtils;
import ai.djl.ndarray.NDManager;

public final class RsEngine
extends Engine {
    public static final String ENGINE_NAME = "Rust";
    static final int RANK = 4;

    private RsEngine() {
    }

    static Engine newInstance() {
        try {
            LibUtils.checkStatus();
            return new RsEngine();
        }
        catch (EngineException e) {
            throw e;
        }
        catch (Throwable t2) {
            throw new EngineException("Failed to load Rust native library", t2);
        }
    }

    @Override
    public Engine getAlternativeEngine() {
        return null;
    }

    @Override
    public String getEngineName() {
        return ENGINE_NAME;
    }

    @Override
    public int getRank() {
        return 4;
    }

    @Override
    public String getVersion() {
        return Engine.getDjlVersion();
    }

    @Override
    public boolean hasCapability(String capability) {
        if ("MKL".equals(capability)) {
            return true;
        }
        if ("CUDA".equals(capability)) {
            return RustLibrary.isCudaAvailable();
        }
        return false;
    }

    @Override
    public Model newModel(String name, Device device) {
        return new RsModel(name, device);
    }

    @Override
    public NDManager newBaseManager() {
        return RsNDManager.getSystemManager().newSubManager();
    }

    @Override
    public NDManager newBaseManager(Device device) {
        return RsNDManager.getSystemManager().newSubManager(device);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        sb.append(this.getEngineName()).append(':').append(this.getVersion()).append(", ");
        sb.append(this.getEngineName()).append(':').append(this.getVersion()).append(", capabilities: [\n\tMKL");
        if (this.hasCapability("CUDA")) {
            sb.append(",\n\t").append("CUDA");
        }
        sb.append(']');
        return sb.toString();
    }
}

